
var winobj = getNeProperty(self); 
var upTable = null;
var belowTable = null;
var btnRightArr = new Array();
var QueueMode = new Object();
QueueMode["0"] = "SP";
QueueMode["1"] = "WRQ";
QueueMode["2"] = "WRR";

/**
 *      
 */
function init()
{
	initButton();
	initTable();
	if(btnRightArr.querybtn.right)
	{
    	queryPortResource();
    }
}

/**
 *      
 */
function initTable()
{
  upTable = new SortTable();
  upTable.setSingleChoiceFlg(true);
  upTable.setImage("../../../../../images/");
  createTableHead(upTable, window.tableconf[0]);
  upTable.setOnRowSelectHandler(tableSelectHandler);
  $("portListTable").appendChild(upTable.getTable());
  
  belowTable = new SortTable();
  belowTable.setImage("../../../../../images/");
  createTableHead(belowTable, window.tableconf[1]);
  belowTable.setOnCellEditHandler(cellEditHandler);
  
  belowTable.element.oncontextmenu = popupMenuHandler;//           
  $("shapingInfoTable").appendChild(belowTable.getTable());

  onresize();
}

/**
 *      
 */
function initButton()
{
	$("portListText").appendChild(document.createTextNode(RESOURCE["portlisttitle"]));
	$("shapingInfoText").appendChild(document.createTextNode(RESOURCE["portqueuetitle"]));
	
	$("querybtn").value = RESOURCE["query"];
	$("applybtn").value = RESOURCE["applybutton"];
	$("applybtn").disabled = true;
	
	btnRightArr.querybtn = new BtnRightObj("querybtn",TECMDCODE_GET_PORT_QUEUE_INFO);    
	btnRightArr.applybtn = new BtnRightObj("applybtn",TECMDCODE_SET_PORT_QUEUE_INFO);
	
	getRightInfo(winobj, btnRightArr);
	$("querybtn").disabled = !btnRightArr.querybtn.right;
}

/**
 *       
 * @param param
 */
function cellEditHandler(/*Object*/param)
{
	if(param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		$("applybtn").disabled = !btnRightArr.applybtn.right;
	}
}

/**
 *        
 * @param params     
 */
function tableSelectHandler(/*Array*/params)
{
	var selectedRows = upTable.getSelectedRows();
	if(selectedRows.length == 0)
	{
		belowTable.clearTableData();
	}
	else
	{
		queryData();
	}
}

/**
 *         
 */
function queryPortResource()
{
	var xml = createQueryPortResourceXML();
    var URL = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_PORT_QUEUE_INFO_RES +"&nmUser=" + winobj["nmUser"];
    loadXMLdoc(URL, "POST", false, queryPortResourceCallBack, null, "inputdata=" + xml);
}


/**
 *        XML
 */
function createQueryPortResourceXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = new tagElement("row-params");
    var param = new tagElement("param","neid",winobj["neid"]);
    row.appendChild(param);
    param = new tagElement("param","slotid",winobj["slotid"]);
    row.appendChild(param);
    param = new tagElement("param","isLogFlag","0");
    row.appendChild(param);
    business.appendChild(row);
    root.getRoot().appendChild(business);
    return root.toString();
}

/**
 *           
 * @param doc
 */
function queryPortResourceCallBack(/*XMLDOM*/doc)
{
	var data = EncapsulateData(doc);
	var lastSelected = [];
	for(var i = 0,len = upTable.getDataRowLength();i < len;i++)
	{
		if (upTable.getRowSelFlag(i))
		{
			lastSelected[lastSelected.length] = upTable.getCellStoreValue(i, "portid","portid");
		}
	}
	upTable.clearTableData();
	createTableBody(upTable,window.tableconf[0],data,RESOURCE);
	for(var i = 0; i < upTable.getDataRowLength(); i++)
	{
	  	var storevalue = upTable.getCellStoreValue(i, "portid","portid");
	  	if(lastSelected.contains(storevalue))
	  	{
	  		upTable.setRowSelect(i);
	  	}
	}
	showQueryErrDlg(data);
	if(upTable.getSelectedRows().length == 0 && upTable.getDataRowLength() > 0)
	{
		upTable.setRowSelect(0);
	}
	queryData();
}

/**
 *           xml  
 * @param portID
 * @param portname
 * @return    xml  
 */
function createQueryXML(/*String*/portID,/*String*/portname)
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = new tagElement("row-params");

	var thirdlevel = new tagElement("param","neid",winobj["neid"]);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","slotid",winobj["slotid"]);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","boardname",winobj["subrackname"] + "-" + getSlotIDFromSlot(winobj["slotid"]) + "-" + winobj["boardname"]);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","port",portID);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","portname",portname);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param","portqueid","0");
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

/**
 *        
 */
function queryData()
{
	var selectedRows = upTable.getSelectedRows();
	if(!btnRightArr.querybtn.right || selectedRows.length == 0)
	{
		return;
	}
	var portID = upTable.getCellStoreValue(selectedRows[0],"portid","portid");
	var portname = upTable.getCellStoreValue(selectedRows[0],"portname","portname");
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	var xml = createQueryXML(portID,portname);//  xml  
	var queryUrl = "../../../../../neExlorerServlet?sfid="+TECMDCODE_GET_PORT_QUEUE_INFO+"&nmUser=" + winobj["nmUser"];
	loadXMLdoc(queryUrl,"POST",true,queryHandleBack,null,"inputdata="+xml);//    
}

/**
 *   shaping     
 * @param doc        
 */
function queryHandleBack(/*XMLDOM*/doc)
{
	var queryResult = EncapsulateData(doc);//deal with the data.
	belowTable.clearTableData();
	createTableBody(belowTable,window.tableconf[1],queryResult,RESOURCE);
	showQueryErrDlg(queryResult);
	$("querybtn").disabled = !btnRightArr.querybtn.right;
}

/**
 *        XML
 * return XML
 */
function createModifyXML()
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	
	for(var i = 0,len = belowTable.getDataRowLength(); i < len; i++)
	{
		if(!belowTable.getModify(i))
		{
			continue;
		}
		var secondlevel = new tagElement("row-params");
		var thirdlevel = new tagElement("param","neid",winobj["neid"]);
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param","slotid",winobj["slotid"]);
		secondlevel.appendChild(thirdlevel);	

		thirdlevel = new tagElement("param","boardname",winobj["subrackname"] + "-" + getSlotIDFromSlot(winobj["slotid"]) + "-" + winobj["boardname"]);
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param","port",upTable.getCellStoreValue(upTable.getSelectedRows()[0],"portid","portid"));
		secondlevel.appendChild(thirdlevel);		

		thirdlevel = new tagElement("param","portname",upTable.getCellStoreValue(upTable.getSelectedRows()[0],"portname","portname"));
		secondlevel.appendChild(thirdlevel);

		thirdlevel = new tagElement("param","portqueid",belowTable.getCellStoreValue(i,"portqueid","portqueid"));
		secondlevel.appendChild(thirdlevel);
				
		if(belowTable.getCellModify(i,"mode") || belowTable.getCellModify(i,"weight"))
		{
			thirdlevel = new tagElement("param","mode",belowTable.getCellStoreValue(i,"mode","mode"));
			secondlevel.appendChild(thirdlevel);
			
			thirdlevel = new tagElement("param","weight",belowTable.getCellStoreValue(i,"weight","weight"));
			secondlevel.appendChild(thirdlevel);
		}
		firstlevel.appendChild(secondlevel);
	}
	if(0 == firstlevel.childNodes.length)
	{
		return null;
	}
	root.getRoot().appendChild(firstlevel);
	return root.toString();	
}

/**
 *          
 */
function modify()
{
	var xml = createModifyXML();
	if(xml == null)
	{
		$("applybtn").disabled = true;
		return;
	}
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	var modifyUrl = "../../../../../neExlorerServlet?sfid="+TECMDCODE_SET_PORT_QUEUE_INFO+"&nmUser=" + winobj["nmUser"];
	loadXMLdoc(modifyUrl,"POST",true,modifyCallBack,null,"inputdata="+xml);//    	
}

/**
 *          
 */
function modifyCallBack(/*XMLDOM*/doc)
{
	var modifyResult = EncapsulateData(doc);
	$("querybtn").disabled = !btnRightArr.querybtn.right;
	refreshTableState(belowTable,window.tableconf[1],modifyResult);
	showQueryErrDlg(modifyResult);
	if(modifyResult.getSErrorCode() != OPERATION_SUCCESS)
	{
		$("applybtn").disabled =!btnRightArr.applybtn.right;	
	}
}

/**
 *            
 */
function showQueryErrDlg(result)
{
	var errArr = [];
	errArr[0] = "nename";
	errArr[1] = "slotid";
	errArr[2] = "boardname";
	openErrPage("../../../../../page/", result.getError(), errArr);
}

/**
 *      
 */  
window.onresize=function()
{
	var Height = getComponetHeight($("tableDiv"), 120);
	upTable.setBodyHeight(Height/2 +"px");
	belowTable.setBodyHeight(Height/2 +"px");
}
