var BOARD_EGSH = "1557";
var BOARD_TBE = "1067";
var BOARD_LEM24 = "2109";
var BOARD_LEX4 = "2110";
var BOARD_LEM18 = "2272";
var BOARD_TEM28 = "2292";
var BOARD_LEG16 = "3005";

function isLagerBoard()
{
	return (boardType == BOARD_TBE || boardType == BOARD_EGSH || boardType == BOARD_LEM24 
           			|| boardType == BOARD_LEX4 || boardType == BOARD_LEM18 || boardType == BOARD_TEM28 || boardType == BOARD_LEG16)
}

function getVlanRange(vlantext)
{
    var cvlanRange = new Array();
    var cvlanText = vlantext;
    if ("" == cvlanText || "-" == cvlanText)
    {
    	  return null;
    }
    var str = cvlanText.split(",");
    for(var i = 0, len = str.length ; i < len; i++)
    {
        var b=str[i].indexOf("-")!=-1;
        if(b)
        {
            var range=str[i].split("-");
            var rangeStart=parseInt(range[0]);
            var rangeEnd=parseInt(range[1]);
           for(var j=rangeStart; j<=rangeEnd;j++)
           {
                cvlanRange.push(""+j);
           }
        }
        else
        {
            cvlanRange.push(str[i]);
        }
    }
    return cvlanRange;
}

function chkVlan(obj,evt)
{
	  var code = evt.charCode;
	  var ch = String.fromCharCode(code);
	  if(code == 8 || code == 46 || code == 37 || code == 39)
    {
    	  return true;   //DEL   
    }

    if(!restrict(obj, evt, "0123456789,-"))
    {
        return false;
    }
    if(!isVlan(obj,evt))
    {
        return false;
    }
    return true;
}

/*
               
 */
function isVlan(obj,evt)
{
	var key,keychar;
    var code = evt.charCode;
	keychar = String.fromCharCode(code); 
    var text = obj.value + keychar;
    if(!text || "-" == text)
    {
        return true;
    }
    var str=text.split(",");
    
    var limitHigh = 4094;
    if(isLagerBoard())
    {
        limitHigh = 4095;
    }
    var limitLow = 1;
    for(var i=0; i<str.length; i++)
    {
        var b=str[i].indexOf("-") != -1;
        if(b)
        {
            var range = str[i].split("-");
            var rangeStart = parseInt(range[0]);
            var rangeEnd = parseInt(range[1]);

            if((rangeStart>limitHigh) || (rangeEnd>limitHigh)
                ||(rangeStart<limitLow) ||(rangeEnd<limitLow))
            {
       	        if(isLagerBoard())
                {
       	            alert(RESOURCE["numberLimit1"]);
       	        }
       	        else
       	        {
       	            alert(RESOURCE["numberLimit"]);
       	        }
                return false;
            }
        }
        else
        {
           if(parseInt(str[i])>limitHigh || parseInt(str[i])<limitLow)
           {
           	if(isLagerBoard())
                {
       	            alert(RESOURCE["numberLimit1"]);
       	        } else {
       	            alert(RESOURCE["numberLimit"]);
       	        }
                return false;
           }
        }
    }
    return true;
}


/*
               
 */
function isValidateSrcVlan(evt)
{
	evt = evt?evt:window.event;
	evt = EventUtil.formatEvent(evt);
    var text = evt.target.value;
    if(!text)
    {
        return;
    }    
    if(!isValidateVlan(evt.target))
    {
        return;
    }
}

/*
               
 */
function isValidateVlan(obj)
{         
    var text = obj.value;
    if(!text)
    {
        alert(RESOURCE["not_empty"]);
        obj.focus();
        return false;
    }
    if("-" == text)
    {
        alert(RESOURCE["vlanFormat"]);
        obj.value = "";
        obj.focus();
        return false;
    }
    var str=text.split(",");
    var pattern1=new RegExp("^\\d+$","i");
    var pattern2=new RegExp("^\\d+-\\d+$","i");

    for(var i=0; i<str.length; i++)
    {        
        var b=str[i].indexOf("-")!=-1;
        if(b)
        {
            if( !pattern2.test(str[i]))
            {    
            	alert(RESOURCE["vlanFormat"]);
        		obj.focus();
                return false;
            }
        }
        else
        {
            if(!pattern1.test(str[i]))
            {
            	alert(RESOURCE["vlanFormat"]);
        		obj.focus();
                return false;
            }
         }
    }
    var limitHigh = 4094;
    if(isLagerBoard())
    {
        limitHigh = 4095;
    }
    var limitLow = 1;
    for(var i=0; i<str.length; i++)
    {
        var b=str[i].indexOf("-")!=-1;
        if(b)
        {
            var range=str[i].split("-");
            var rangeStart=parseInt(range[0]);
            var rangeEnd=parseInt(range[1]);
    
            if((rangeStart>limitHigh) || (rangeEnd>limitHigh)
                ||(rangeStart<limitLow) ||(rangeEnd<limitLow))
            {
                if(isLagerBoard())
                {
       	            alert(RESOURCE["numberLimit1"]);
       	        }
       	        else
       	        {
       	            alert(RESOURCE["numberLimit"]);
       	        }
       	        obj.focus();
                return false;
            }
            if (rangeEnd <rangeStart)
            {
            	alert(RESOURCE["startEnd"]);
        		obj.focus();
                return false;
            }
        }
        else
        {
           if(parseInt(str[i])>limitHigh || parseInt(str[i])<limitLow)
           {
                if(isLagerBoard())
                {
       	            alert(RESOURCE["numberLimit1"]);
       	        }
       	        else
       	        {
       	            alert(RESOURCE["numberLimit"]);
       	        }
        		obj.focus();
                return false;
           }
        }
    }
    return true;
}

function vlanObject_onkeypress(evt)
{
	evt = evt?evt:window.event;
	evt = EventUtil.formatEvent(evt);
    var code = evt.charCode;
    var codeValue = String.fromCharCode(code);	 
    var index = digitalTag_getPos(this);   
    var lastValue1 = evt.target.value;
    var thisValue1 = evt.target.value.substring(0,index) + codeValue + evt.target.value.substring(index);
    var rep1 = /-/gi;
    var value1 = thisValue1.replace(rep1,",");
    var values1 = value1.split(",");
    for(i = 0; i < values1.length; i++)
    {        		 		 
    	  if(0 == values1[i].indexOf("0"))
      	  {	    		
      	  	  evt.target.value = lastValue1;
      	  	  return false;	    		 
      	  }
    }
    var bol1 = chkVlan(evt.target, evt); 	
    if(bol1)
    {
    	  lastValue1 = thisValue1;
    }
    return bol1;
}
