/**
 *  Mac Swap Looop       js  
 *   :    00221658
 *   : 2013-08-01
 */
 
var winurlobj = getNeProperty(self);
var win = getParentWindow();

var btnRight = null;

var ct = null;

document.title = RESOURCE["createmacswaploop"];

/**
 *      
 */
function initPage()
{
    initTable();
    initButton();
    initPort();
}

/**
 *     ,           1          
 */
function checkText(obj, min, max, decimalCount)
{
	min += "";
	max += "";

	obj.style.imeMode = "disabled";

	obj.onpaste = function()
	{
	}

	obj.onblur = function()
	{ 
		if(obj.value == "")
	       {
		    return;
	        }
		blurValidate(obj, min, max, decimalCount);
		if((typeof obj.doAfterBlur)=="function")
		{
			obj.doAfterBlur();
		}
	}

	obj.onkeypress = function()
	{	
		var evt= EventUtil.getEvent();
		return digitalCheck(obj, min, max, decimalCount, null, evt);
	}
}
/**
 *      
 */
function initTable()
{
    ct = new CTable();
    
    ct.addHead(RESOURCE["ATTR"],RESOURCE["VALUE"]);
    
    var cTableAtom = null;
    
    var cTableAtomEle = null;
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element; 
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
        initRPLPort();
    }
    ct.addAttrRow("importPortId", RESOURCE["importPort"], cTableAtom); 
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;     
    checkText(cTableAtomEle, CTRL_VLAN_MIN, CTRL_VLAN_MAX);
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("vlanid", RESOURCE["vlan"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element; 
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("loopPortId", RESOURCE["loopPort"], cTableAtom); 
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.value = DES_MAC_ADDR_DEFALT_VALUE; 
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
    }
    checkMACFormat(cTableAtomEle);
    ct.addAttrRow("srcMacAddr", RESOURCE["srcMacAddr"], cTableAtom); 
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.value = DES_MAC_ADDR_DEFALT_VALUE; 
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
    }
    checkMACFormat(cTableAtomEle);
    ct.addAttrRow("desMacAddr", RESOURCE["desMacAddr"], cTableAtom); 
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;    
    checkText(cTableAtomEle, OVER_TIME_MIN, OVER_TIME_MAX);
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("overtime", RESOURCE["overtime"], cTableAtom); 
    
    $("macswaploopTableDiv").appendChild(ct.getTable());
}

/**
 *      
 */
function initButton()
{
	$("okbtn").value =  RESOURCE["okbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	$("cancelbtn").value = RESOURCE["cancelbutton"];
}

/**
 *        
 */
function initPort()
{
    getPortList();
}

/**
 *   macswaploop
 */
function createmacswaploop(okFlag)
{
    if (okFlag && $("applybtn").disabled)
    {
        xcloseDialog();
        return;
    }
    else
    {
        var overtime = ct.getAttrValue("overtime");
        var vlanid = ct.getAttrValue("vlanid");    
        var srcMacAddr = ct.getAttrValue("srcMacAddr");
        var desMacAddr = ct.getAttrValue("desMacAddr");  
        var importPortId = ct.getAttrValue("importPortId");
        var loopPortId = ct.getAttrValue("loopPortId");  
      
        if(loopPortId == importPortId)
        {
        	alert(RESOURCE["wrongPort"]);
            return;
        }
        if(srcMacAddr == desMacAddr)
        {
        	alert(RESOURCE["wrongMac"]);
            return;
        }
        
        setBtnDisabled(true);
        
        var xml = createmacswaploopXML();
        
        var sfid = TECMDCODE_NE_MACSWAPLOOP_CRT_ENTITY;
        
        var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];
    
       loadXMLdoc(URL, "POST", false, createmacswaploopBack, okFlag, "inputdata=" + xml);
    
    }
}

/**
 *     macswaploop XML  
 */
function createmacswaploopXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var importPortId = ct.getAttrValue("importPortId");
    var vlanidLog = ct.getAttrValue("vlanid");
    var loopPortId = ct.getAttrValue("loopPortId");
    var srcMacAddrValue = ct.getAttrValue("srcMacAddr");
    var srcMacAddr = neMacAddr(srcMacAddrValue);
    var desMacAddrValue = ct.getAttrValue("desMacAddr");
    var desMacAddr = neMacAddr(desMacAddrValue);
    var overtimeLog = ct.getAttrValue("overtime");
    var vlanid = vlanidLog;
    var overtime = overtimeLog;
    if ("" == vlanid)
    { 
    	vlanid=CTRL_VLAN_ALL;
    }   
    if ("" == overtime)
    { 
    	overtime=OVER_TIME_OTHER;
    } 

    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", winurlobj["slotid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "importPortId");
    param.setAttribute("value", importPortId);
    row.appendChild(param);     
    
    var importPortIdElement = ct.getAtom("importPortId").element;
    var importPortIdLog = importPortIdElement.options[importPortIdElement.selectedIndex].text;
    param = new tagElement("param");
    param.setAttribute("name", "importPortIdLog");
    param.setAttribute("value", importPortIdLog);
    row.appendChild(param); 
    
    param = new tagElement("param");
    param.setAttribute("name", "srcMacAddr");
    param.setAttribute("value", srcMacAddr);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "srcMacAddrLog");
    param.setAttribute("value", srcMacAddrValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "desMacAddr");
    param.setAttribute("value", desMacAddr);
    row.appendChild(param);  
    
    param = new tagElement("param");
    param.setAttribute("name", "desMacAddrLog");
    param.setAttribute("value", desMacAddrValue);
    row.appendChild(param);  
    
    param = new tagElement("param");
    param.setAttribute("name", "vlanid");
    param.setAttribute("value", vlanid);
    row.appendChild(param);
    
    if ("" != vlanidLog)
    {
        param = new tagElement("param");
        param.setAttribute("name", "vlanidLog");
        param.setAttribute("value", vlanidLog);
        row.appendChild(param);
    }
    
    param = new tagElement("param");
    param.setAttribute("name", "loopPortId");
    param.setAttribute("value", loopPortId);
    row.appendChild(param);
    
    var loopPortIdElement = ct.getAtom("loopPortId").element;
    var loopPortIdLog = loopPortIdElement.options[loopPortIdElement.selectedIndex].text;
    param = new tagElement("param");
    param.setAttribute("name", "loopPortIdLog");
    param.setAttribute("value", loopPortIdLog);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "overtime");
    param.setAttribute("value", overtime);
    row.appendChild(param);    
    
    if ("" != overtimeLog)
    {
    	param = new tagElement("param");
        param.setAttribute("name", "overtimeLog");
        param.setAttribute("value", overtimeLog);
        row.appendChild(param);  
    }
       
    business.appendChild(row);
    root.getRoot().appendChild(business);
        
    return root.toString();
}

/**
 *   macswaploop
 */

function createmacswaploopBack(doc, okFlag)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
        setBtnDisabled(false);
    }
    else
    {
        $("okbtn").disabled = false;
        $("cancelbtn").disabled = false;
        $("applybtn").disabled = true;
        fillTableData(data);
        if (okFlag)
        {
            xcloseDialog();
        }
    }
}

/**
 *         
 * @param data:      
 * @return  
 */
function fillTableData(data)
{ 
    win.querymacswaploop();  
}

/**
 *       
 */
function getPortList(portFlag)
{
    setBtnDisabled(true);
    
    var xml = getPortListXML();
    
    var sfid = TECMDCODE_ERPS_GET_PORT_LIST;
    
    var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", false, getPortListBack, portFlag, "inputdata=" + xml);

}

/**
 *        XML
 */
function getPortListXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    
    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", winurlobj["slotid"]);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *           
 */
function getPortListBack(doc, portFlag)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    var portid = null;
    var portname = null;
    var portAtom = null;
    
    if (OPERATE_SUCCESS == smallErrorCode)
    {
        for (var i = 0, len = data.getDataRowLength(); i < len; i ++)
        {
            portid = data.getDataRowParam(i, "portid", "portid");
            portname = data.getDataRowParam(i, "portname", "portname");
            
            if (null != arguments[1])
            {
                portAtom = ct.getAtom(portFlag);
                portAtom.addOption(portname, portid);
            }
            else
            {
                portAtom = ct.getAtom("importPortId");
                portAtom.addOption(portname, portid);
                
                portAtom = ct.getAtom("loopPortId");
                portAtom.addOption(portname, portid);
            }
        }
    }
    
    setBtnDisabled(false);
}


/**
 *     
 */
function doCancel()
{
    xcloseDialog();
}

/**
 *         
 */
function setBtnDisabled(flag)
{
    $("okbtn").disabled = flag;
    $("applybtn").disabled = flag;
    $("cancelbtn").disabled = flag
}

/**
 *        
 */
function showErrorDialog(data, errArr)
{
    var errorArray = null;
    if (null == errArr)
    {
        errorArray = new Array();
        errorArray.push("nename");
        errorArray.push("slotid");
        errorArray.push("boardname");     
    }
    else
    {
        errorArray = errArr;
    }
    openErrPage("../../../../../page/", data.getError(), errorArray); 
}
