/**
 *  MAC SWAP LOOP     js  
 *   :    00221658
 *   : 2013-08-01
 */
var winurlobj = getNeProperty(self);

var btnRight = null;

var st = null;

/**
 *      
 */
function initPage()
{
	initTable();
    initButton();
    
    if (btnRight.querybtn.right)
    {
        querymacswaploop(); 
    }
    else
    {
    	$("querybtn").disabled = true;
    	$("deletebtn").disabled = true;
    	$("createbtn").disabled = true;
    }
}

/**
 *       
 */
function initTable()
{
    st = new SortTable();
    
    st.setImage("../../../../../images/");
    
    st.setBodyHeight(300);  
    
    st.setSingleChoiceFlg(true);

    createTableHead(st, window.tableconf[0]);
    
    st.setOnRowSelectHandler(rowSelectHandler);

    
    $("macswaploopListTableDiv").appendChild(st.getTable()); 
}

/**
 *      
 */
function initButton()
{
	$("querybtn").value =  RESOURCE["querybutton"];
	$("createbtn").value = RESOURCE["newbutton"];
	$("deletebtn").value = RESOURCE["deletebutton"];
	
	getAllBtnRight();
}

/**
 *         
 */
function getAllBtnRight()
{
    btnRight = new Object;
    
    btnRight.querybtn = new BtnRightObj("querybtn", TECMDCODE_NE_MACSWAPLOOP_GET_ENTITY);    
    btnRight.createbtn = new BtnRightObj("createbtn", TECMDCODE_NE_MACSWAPLOOP_CRT_ENTITY);
    btnRight.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_NE_MACSWAPLOOP_DEL_ENTITY);
    
    getRightInfo(winurlobj, btnRight);      
    
    initrightbtn(btnRight);
}

/**
 *   macswaploop  
 */
function querymacswaploop()
{
    if(!btnRight.querybtn.right)
    {
        alert(RESOURCE["RightUnvalid"]);
        return;
    }
    setBtnDisabled();
    
    var xml = querymacswaploopXML();
    
    var sfid = TECMDCODE_NE_MACSWAPLOOP_GET_ENTITY;
    
    var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", false, querymacswaploopBack, null, "inputdata=" + xml);

}

/**
 *     macswaploop XML  
 */
function querymacswaploopXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
 
    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", winurlobj["slotid"]);
    row.appendChild(param);   

    param = new tagElement("param");
    param.setAttribute("name", "importPortId");
    param.setAttribute("value", "0");// 0      
    row.appendChild(param);
    
    business.appendChild(row);
    
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *   macswaploop    
 */
function querymacswaploopBack(doc)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
        setBtnStatusOnRowSelect();
    }
    else
    {
        st.clearTableData();
        for (var i = 0; i < data.getDataRowLength(); i++) 
        {
            var row = data.rows[i];
            if (CTRL_VLAN_ALL == row["vlanid"].value) 
            {
                row["vlanid"].value = "-";
            }           
            if (OVER_TIME_OTHER == row["overtime"].value) 
            {
                row["overtime"].value = "-";
            }
        }      
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        
        adjustToCurrSortStatus();  
        if (0 == st.getSelectedRowCount() && 0 != st.getDataRowLength())
        {
        	st.setRowSelect(0);
            rowSelectHandler();
        }
        else
        {
            setBtnStatusOnRowSelect();
        }   
    }
    
}

/**
 *          
 */
function adjustToCurrSortStatus()
{
    if(!st.element.colsArray.selectedId)
    {
  	   st.element.colsArray.selectedId = "importPortId";
  	   st.element.colsArray.imgflag = 1;
    }
    
    var td = st.element.headRow.element.cols[st.element.colsArray.selectedId].element; 
    st.sortRows(td, st.element.colsArray.imgflag);
}

/**
 *        
 */
function rowSelectHandler(param)
{
	var selectedRows = st.getSelectedRows();
	if (0 == selectedRows.length)
	{
		$("querybtn").disabled = !btnRight.querybtn.right;
		$("createbtn").disabled = !btnRight.createbtn.right;
		$("deletebtn").disabled = true;
	}
	else
	{
		$("querybtn").disabled = !btnRight.querybtn.right;
	
		$("createbtn").disabled = !btnRight.createbtn.right;
		$("deletebtn").disabled = !btnRight.deletebtn.right;
	}

}

/**
 *   macswaploop
 */
function deletemacswaploop()
{
    if(!btnRight.deletebtn.right)
    {
        alert(RESOURCE["RightUnvalid"]);
        return;
    }
    
    var selectedRows = st.getSelectedRows();
    
	if (0 == selectedRows.length)
	{
	    alert(RESOURCE["ID_SELECT"]);
		return;
	}
	
	if (!confirm(RESOURCE["ID_DELSURE"]))
	{
		return;
	}
	
	var rowid = selectedRows[0];
	var importPortId = st.getCellStoreValue(rowid, "importPortId", "importPortId");
	var srcMacAddr = st.getCellStoreValue(rowid, "srcMacAddr", "srcMacAddr");
	var desMacAddr = st.getCellStoreValue(rowid, "desMacAddr", "desMacAddr");
	var vlanid = st.getCellStoreValue(rowid, "vlanid", "vlanid");
    setBtnDisabled();
    if ("-" == vlanid)
    { 
    	vlanid=CTRL_VLAN_ALL;
    }   
    var xml = deletemacswaploopXML(importPortId,srcMacAddr,desMacAddr,vlanid);
    
    var sfid = TECMDCODE_NE_MACSWAPLOOP_DEL_ENTITY;
    
    var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", false, deletemacswaploopBack, rowid, "inputdata=" + xml);
}

/**
 *     macswaploop XML  
 */
function deletemacswaploopXML(importPortId,srcMacAddr,desMacAddr,vlanid)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null; 

    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", winurlobj["slotid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "importPortId");
    param.setAttribute("value", importPortId);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "srcMacAddr");
    param.setAttribute("value", srcMacAddr);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "desMacAddr");
    param.setAttribute("value", desMacAddr);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "vlanid");
    param.setAttribute("value", vlanid);
    row.appendChild(param);
    business.appendChild(row);
    
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *   macswaploop     
 */
function deletemacswaploopBack(doc, rowid)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
    }
    else
    {
    	querymacswaploop();           
    }    
    setBtnStatusOnRowSelect();
}

/**
 *     macswaploop   
 */
function createmacswaploop()
{ 
    setBtnDisabled();
    var URL = "../macswaploop/macswaploopcreate.html?neid=" + winurlobj["neid"] + "&nmUser=" + winurlobj["nmUser"] + "&slotid=" + winurlobj["slotid"];
    xshowModalDialog(URL, RESOURCE["createmacswaploop"], 500, 260, "../../../../../images/");
    setBtnStatusOnRowSelect();
}

/**
 *        
 */
function showErrorDialog(data, errArr)
{
    var errorArray = null;
    if (null == errArr)
    {
        errorArray = new Array();
        errorArray.push("nename");
        errorArray.push("slotid");
        errorArray.push("boardname");     
    }
    else
    {
        errorArray = errArr;
    }
    
    openErrPage("../../../../../page/", data.getError(), errorArray); 
}

/**
 *              
 */
window.onresize=function()
{
    st.setBodyHeight(getTableHeight($("stDiv"), st) * 0.9 + "px");
}


/**
 *       
 */
function setBtnDisabled()
{
	$("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;   
}

/**
 *              
 */
function setBtnStatusOnRowSelect()
{
	var selectedRows = st.getSelectedRows();
	if (0 == selectedRows.length)
	{
		$("querybtn").disabled = !btnRight.querybtn.right;
		$("createbtn").disabled = !btnRight.createbtn.right;
		$("deletebtn").disabled = true;
	}
	else
	{
		$("querybtn").disabled = !btnRight.querybtn.right;
		$("createbtn").disabled = !btnRight.createbtn.right;
		$("deletebtn").disabled = !btnRight.deletebtn.right;
	}
}
