var OPERATE_SUCCESS = 0;

var OPERATE_PART_SUCCESS = 1;

var OPERATE_FAIL = 2;


var CTRL_VLAN_MIN = "1";//   
var CTRL_VLAN_MAX = "4095";//   
var CTRL_VLAN_ALL = "65535";//  VLAN

var OVER_TIME_MIN = 60;//   
var OVER_TIME_MAX = 2880;//   
var OVER_TIME_OTHER = 65535;//  

var PORT_ID_UNVALID = 65535;

var VCTRUNK_FLAG = 32768;

var DES_MAC_ADDR_DEFALT_VALUE = "00-00-00-00-00-00";


/**********************************
 *       convertMsg   
 *                                
***********************************/
function convertMsg(resobj,	cvtobj,	cvtvalue)
{
	if("function" == typeof cvtobj)
	{
	    return cvtobj(cvtvalue);
	}
	
	if(cvtvalue == "-")
	{
      return cvtvalue;
	}
	return resobj[cvtobj[cvtvalue]];
}

/**********************************
 *Mac   convert                 
***********************************/
function convertMacAddr(macAddrStr)
{
	var showMACStr = "";
    for(var i = 0, len = 12; i < len;)
    {
        if(showMACStr != "")
        {
            showMACStr += "-";
        }
        showMACStr += macAddrStr.substring(i, i + 2);
        i += 2; 
    }
    return showMACStr;
}

/**********************************
 * Mac                        
***********************************/
function neMacAddr(macAddrStr)
{
	var macStr = "";
    for(var i = 0, len = 17; i < len; i += 3)
    {
        macStr += macAddrStr.substring(i, i + 2);
    }
    return macStr;
}

/**
 *     ID       
 */
function convertPort(portid)
{
    if (null == portid)
    {
        return;
    }
    var portName = null;
    if (portid > VCTRUNK_FLAG)
    {
        if (portid == PORT_ID_UNVALID)
        {
            portName = "-";
        }
        else
        {
            portName = "VCTRUNK" + (portid - VCTRUNK_FLAG);
        }
    }
    else
    {
       portName = "PORT" + portid;
    }
    return portName;
}
