
var winobj = parseURLStr(self);          //  URL   
var neid = winobj.neid;                  //  ID
var nmUser = winobj.nmUser;              //  
var slotid = winobj.slotid;              //  ID
var boardname = winobj.boardname;        //    

var btnRightArr = new Object();          //      
var portTable = null;                    //    Table
var macTable = null;                     //Mac    Table

var OPRSUCC = 0;                         //    
var OPRPSUCC = 1;                        //      
var OPRFAIL = 2;                         //    
var VCTRUNK_BASIC = 32768;               //VCTUNK     


/**
 *        
 */
function init()
{
    initTitle();
    initPortTable();
    initMacTable();
    initRightData();
    if (btnRightArr.queryBtn.right)
    {
        queryPortList();

    }
}

/**
 *          
 */
function initPortTable()
{
    portTable = new SortTable();
    portTable.setImage("../../../../../images/");
    createTableHead(portTable, window.tableconf[0]);
    portTable.setBodyHeight(getTableHeight($("porttable"),portTable)*0.45+"px");
    
    var hc=portTable.getHeadCell("portname");
    portTable.setHCAttribute(hc,1,0,compareUserLevel);
    portTable.setSingleChoiceFlg(true);
    portTable.setOnRowSelectHandler(rowSelectHandler_PortTable);

    $("porttable").appendChild(portTable.getTable()); 
}

function compareUserLevel(str1,str2)
{
    var str1s = str1.match(/\D+|\d+/g);
    var str2s = str2.match(/\D+|\d+/g);
    
    if(str1s.length != 2 || str2s.length != 2)
    {
        return compare(str1,str2);
    }
    
    if(str1s[0] == str2s[0])
    {
        return compare(parseInt(str1s[1]),parseInt(str2s[1]));
    }
    else
    {
        return compare(str1s[0],str2s[0]);
    }
}

/**
 *            
 *@param bl:      
 */
function disabledAllBtn(bl)
{
    if(bl)
    {
		$("queryBtn").disabled = bl ;
		$("addBtn").disabled = bl;
		$("deleteBtn").disabled = bl;
    }
    else
    {
		$("queryBtn").disabled = !btnRightArr.queryBtn.right;
		$("addBtn").disabled = !btnRightArr.addBtn.right;
		$("deleteBtn").disabled = !btnRightArr.deleteBtn.right;
    }
}

/**
 *             
 *@param row:      
 */
function rowSelectHandler_PortTable(row)
{
    if(row.length >= 1)
    {
        $("queryBtn").disabled = !btnRightArr.queryBtn.right;
        $("addBtn").disabled = !btnRightArr.addBtn.right;
		queryMacList();
    }
    else
    {
        $("queryBtn").disabled = true;
        $("addBtn").disabled = true;
        macTable.clearTableData();
    }
}

/**
 *    Mac      
 */
function initMacTable()
{
    macTable = new SortTable();
    macTable.setImage("../../../../../images/");
    createTableHead(macTable, window.tableconf[1]);
    macTable.setBodyHeight(getTableHeight($("mactable"),macTable)*0.3+"px");
    macTable.setOnRowSelectHandler(rowSelectHandler_MacTable);
    $("mactable").appendChild(macTable.getTable()); 
}

/**
 * Mac            
 *@param row:      
 */
function rowSelectHandler_MacTable(row)
{
    if(row.length >= 1)
    {
        $("deleteBtn").disabled = !btnRightArr.deleteBtn.right;
    }
    else
    {
        $("deleteBtn").disabled = true;
    }
}

/**
 *               
 */
function initTitle()
{
	$("portlist").innerText = RESOURCE["topLabel"];
	$("maclist").innerText = RESOURCE["bottomLabel"];
	
	$("queryBtn").value = RESOURCE["query"];
	$("addBtn").value = RESOURCE["newbutton"];
	$("deleteBtn").value = RESOURCE["deletebutton"];
}

/**
 *       
 */
function initRightData()
{
	btnRightArr.queryBtn = new BtnRightObj("queryBtn", TECMDCODE_GET_ETH_MACFORBID);
    btnRightArr.addBtn = new BtnRightObj("addBtn", TECMDCODE_ADD_ETH_MACFORBID);
    btnRightArr.deleteBtn = new BtnRightObj("deleteBtn", TECMDCODE_DEL_ETH_MACFORBID);
     
    sendRightInfo(btnRightArr);
    
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
    $("addBtn").disabled = !btnRightArr.addBtn.right;
}

/**
 *           XML 
 */
function createRightXML()
{
	var root = new inputxml("datainterface");//Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel=null;;
	var thirdlevel=null;
	
    for(var btnrightobj in btnRightArr)
	{
		secondlevel = new tagElement("row-params"); //bean         	
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","btnID");
		thirdlevel.setAttribute("value",btnRightArr[btnrightobj].btnId);
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");	
		thirdlevel.setAttribute("name","sfid");
		thirdlevel.setAttribute("value",btnRightArr[btnrightobj].sfid);
		secondlevel.appendChild(thirdlevel);
		
		firstlevel.appendChild(secondlevel);
	}
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

/**
 *       
 */
function sendRightInfo()
{
	var url = "../../../../../securityServlet?neID=" + neid + "&nmUser=" + nmUser;
	loadXMLdoc(url, "POST", false, rightHandleBack, null, "inputdata=" + createRightXML());
}

/**
 *           
 */
function rightHandleBack(doc)
{
	var data = EncapsulateData(doc);
	for(var i = 0; i < data.getDataRowLength(); i++)  //       
    {
		var right = data.getDataRowParam(i,"right");
    	
      	if(0 == right)
		{
			btnRightArr[data.getDataRowParam(i,"btnID")].right = false;
		}
		else
		{
			btnRightArr[data.getDataRowParam(i,"btnID")].right = true;
		}
    }
}

/**
 *         XML
 */
function createQueryPortListXML()
{
	var root = new inputxml("datainterface");      
  	var firstlevel = new tagElement("bussiness-params");
  			
	var secondlevel = new tagElement("row-params");
    var thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "neid");
   	thirdlevel.setAttribute("value", neid);
   	secondlevel.appendChild(thirdlevel);   	
   	
    thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "slotid");
   	thirdlevel.setAttribute("value", slotid);
   	secondlevel.appendChild(thirdlevel);
   		
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);	
	return root.toString();
}

/**
 *   Mac  
 */
function queryPortList()
{
    disabledAllBtn(true);
    var xmldata = createQueryPortListXML();          
    var url="../../../../../neExlorerServlet?sfid="+TECMDCODE_GET_ETH_MACFORBID_AVAILPORT+"&flag=0&nmUser="+nmUser;
    loadXMLdoc(url,"POST", true, QueryPortBackHandler, null, "inputdata="+xmldata);
}

/** 
 *            
 *@param doc:      XML
 */
function QueryPortBackHandler(doc)
{
    var queryData = EncapsulateData(doc);
    
    portTable.clearTableData(); 
    if (OPRPSUCC == queryData.getError().getGlobleECode() || OPRSUCC == queryData.getError().getGlobleECode()) 
    { 
		createTableBody(portTable,window.tableconf[0],queryData,RESOURCE);
		portTable.sortRows(portTable.getHeadCell("portname").element,1);
		   	$("queryBtn").disabled = true;
		$("deleteBtn").disabled = true;
        if(portTable.getDataRowLength() > 0)
        {
            portTable.setRowSelect(0);
            queryMacList();
        }
    }
    else
    {
    	$("queryBtn").disabled = true;
    	$("addBtn").disabled = true;
		$("deleteBtn").disabled = true;
    }
    showErrorDialog(queryData);
}

/**
 *         
 *@param data:        
 *@param macflg:   Mac       
 */
function showErrorDialog(data,macflg)
{
    var errArr = [];//                   neid slotid
	errArr.push("nename");
	errArr.push("slotid");
	errArr.push("boardname");
	if(macflg)
	{
		errArr.push("portname");
		var error = data.getError()
		
		for(var i = 0;i < error.getRowErrLength();i++)
		{
			if(error.rowErrors[i].errorObj.portname)
			{
				error.rowErrors[i].errorObj.portname = getPortName(error.rowErrors[i].errorObj.port)
			}
		}
	}
	openErrPage("../../../../../page/", data.getError(), errArr);//         
}

/**
 *         port   Mac       XML
 *@param port:      
 */
function createQueryMacListXML(port)
{
	var root = new inputxml("datainterface");      
  	var firstlevel = new tagElement("bussiness-params");
    
	var secondlevel = new tagElement("row-params");
    var thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "neid");
   	thirdlevel.setAttribute("value", neid);
   	secondlevel.appendChild(thirdlevel);   	
   	
    thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "slotid");
   	thirdlevel.setAttribute("value", slotid);
   	secondlevel.appendChild(thirdlevel);
   	
    thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "port");
   	thirdlevel.setAttribute("value", port[0]);
   	secondlevel.appendChild(thirdlevel);
   	
    thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "board");
   	thirdlevel.setAttribute("value", boardname);
   	secondlevel.appendChild(thirdlevel);
   	
    thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "portname");
   	thirdlevel.setAttribute("value", port[1]);
   	secondlevel.appendChild(thirdlevel);
   		
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);	
	return root.toString();
}

/**
 *          Mac    
 *@param blSys:      
 */
function queryMacList(blSys)
{
	var port = getSelectPort();
	if(port.length == 0)
	{
	    return;
	}
	disabledAllBtn(true);
    var xmldata = createQueryMacListXML(port);
    var url="../../../../../neExlorerServlet?sfid="+TECMDCODE_GET_ETH_MACFORBID+"&flag=0&nmUser="+nmUser;
    var blSendMode = true;
    if(typeof(blSys) != "undefined" && blSys)
    {
        blSendMode = false;
    }
    loadXMLdoc(url,"POST", blSendMode, QueryMacBackHandler, null, "inputdata="+xmldata);
}

/**
 *     Mac         
 *@param doc:      XML
 */
function QueryMacBackHandler(doc)
{
    var queryData = EncapsulateData(doc);
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
    $("addBtn").disabled = !btnRightArr.addBtn.right;
    macTable.clearTableData(); 
    if (OPRPSUCC == queryData.getError().getGlobleECode() || OPRSUCC == queryData.getError().getGlobleECode()) 
    { 
		createTableBody(macTable,window.tableconf[1],queryData,RESOURCE);
    }
    showErrorDialog(queryData,true);
}

/**
 *                             
 */
function getSelectPort()
{
    var selectPort = [];
	var selectPortRow = portTable.getSelectedRows();
	if(selectPortRow.length != 0)
	{
	    selectPort[0] = portTable.getCellStoreValue(selectPortRow[selectPortRow.length - 1],"port", "port");
	    selectPort[1] = portTable.getCellStoreValue(selectPortRow[selectPortRow.length - 1],"portname", "portname");
	}
	return selectPort;
}

/**
 *                             
 */
function getSelectMac()
{
    var selectMac = "";
	var selectPortRow = macTable.getSelectedRows();
	if(selectPortRow.length != 0)
	{
	    selectMac = macTable.getCellStoreValue(selectPortRow[selectPortRow.length - 1],"macforbid", "macforbid");
	}
	return selectMac;
}

/**
 *     Mac    
 */
function showAddMacFilter()
{
    var selectPortRow = portTable.getSelectedRows();

	if(selectPortRow.length > 0)
	{
	    xshowModalDialog('addmac.html', RESOURCE["addMacForbid"], 300, 120, '../../../../../images/');//      VLAN  
	}
	else
	{
	    alert(RESOURCE["stSelect"]);
	}
}

/**
 *     Mac     XML
 */
function createDeleteMacXML(port,mac)
{
	var root = new inputxml("datainterface");      
  	var firstlevel = new tagElement("bussiness-params");
    
    var selectMacRows = macTable.getSelectedRows();
    for(var i = 0;i < selectMacRows.length;i++)
    {  
		var secondlevel = new tagElement("row-params");
		var thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "neid");
   		thirdlevel.setAttribute("value", neid);
   		secondlevel.appendChild(thirdlevel);   	
	   	
		thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "slotid");
   		thirdlevel.setAttribute("value", slotid);
   		secondlevel.appendChild(thirdlevel);
	   	
   		var port = getSelectPort();
		thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "port");
   		thirdlevel.setAttribute("value", port[0]);
   		secondlevel.appendChild(thirdlevel);
	   	
   		var mac = macTable.getCellStoreValue(selectMacRows[i],"macforbid", "macforbid");
		thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "macforbid");
   		thirdlevel.setAttribute("value", resumeMacAddrStr(mac));
   		secondlevel.appendChild(thirdlevel);
	   	
		thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "macaddress");
   		thirdlevel.setAttribute("value", mac);
   		secondlevel.appendChild(thirdlevel);
	   	
		thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "board");
   		thirdlevel.setAttribute("value", boardname);
   		secondlevel.appendChild(thirdlevel);
	   	
		thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "portname");
   		thirdlevel.setAttribute("value", port[1]);
   		secondlevel.appendChild(thirdlevel);
	   	
		firstlevel.appendChild(secondlevel);
	}
	root.getRoot().appendChild(firstlevel);	
	return root.toString();
}

/**
 *   Mac  
 */
function deleteMacFilter()
{
	var portSelectRow = portTable.getSelectedRows();
	if(portSelectRow.length <= 0)
	{
	    alert(RESOURCE["stSelect"]);
	    return;
	}
	var macSelectRow = macTable.getSelectedRows();
	if(macSelectRow.length <= 0)
	{
	    alert(RESOURCE["btSelect"]);
	    return;
	}
	disabledAllBtn(true);
    var xmldata = createDeleteMacXML();
     
    var url="../../../../../neExlorerServlet?sfid="+TECMDCODE_DEL_ETH_MACFORBID+"&flag=0&nmUser="+nmUser;
    loadXMLdoc(url,"POST", true, DeleteMacBackHandler, null, "inputdata="+xmldata);
    
}

/**
 *   Mac      
 * @param doc:     
 */
function DeleteMacBackHandler(doc)
{
    var data = EncapsulateData(doc);

    if (OPRPSUCC == data.getError().getGlobleECode() || OPRSUCC == data.getError().getGlobleECode()) 
    {
        $("queryBtn").disabled = !btnRightArr.queryBtn.right;
		$("addBtn").disabled = !btnRightArr.addBtn.right;
		queryMacList();
    }
    else
    {
        disabledAllBtn(false);
    }
    showErrorDialog(data,true);
}

/**
 *   Mac         - 
 * @param macAddrStr:    Mac   
 */
function convertMacAddr(macAddrStr)
{
	var showMACStr = "";
    for(var i = 0, len = 12; i < len;)
    {
        if(showMACStr != "")
        {
            showMACStr += "-";
        }
        showMACStr += macAddrStr.substring(i, i+2);
        i += 2; 
    }
    return showMACStr;
}

/**
 *  Mac             "-"  
 * @param mac:    Mac
 */
function resumeMacAddrStr(mac)
{
    var macaddrArr = mac.split("-");
    var macaddrStr = "";
    for(var j = 0, len = macaddrArr.length; j < len; j++)
    {
        macaddrStr += macaddrArr[j];
    }
    return macaddrStr
}

/**
 *   common.js               
 * @param res:     obj     /   key:     
 * @return String      
 */
function convertMsg(res,obj,key)
{
	if("function" == (typeof obj))	
	{
		return obj(key);
	}
	else //       
	{
		if(null == obj)
		{
			return key;
		}
		var resValue = obj[key];
		if(null == resValue)
		{
			resValue = key;
		}		
		return resValue;
	}
}

/**
 *   portid         
 * @param portid:    portid
 */
function getPortName(portid)
{
    var portname = portid;
    if(parseInt(portid) > VCTRUNK_BASIC)
    {
        portname = "VCTRUNK"+(portid - VCTRUNK_BASIC);
    }
    else
    {
        portname = "PORT" + portid;
    }
    return portname;
}

/**
 *                      
 */
window.onresize = function()
{
    portTable.setBodyHeight(getTableHeight($("porttable"),portTable)*0.45+"px");
    macTable.setBodyHeight(getTableHeight($("mactable"),macTable)*0.3+"px");
}
