var win = getParentWindow();
var neobj = getNeProperty(self);

var parentWinurlobj = win.winurlobj;
var neType = parentWinurlobj["neType"];
var neid = parentWinurlobj["neid"];
var slotid = parentWinurlobj["slotid"];
var boardType = parentWinurlobj["boardType"];

var southportList = new Array();
var mainportList = new Array();

var selectedMainPort = null;
var selectedAggrNO = null;
var selectMcspID = null;

var oldRvtMode = null;
var oldRvtTime = null;
var oldSouthPort = new Array();


if(neobj["createOrModify"] == "modify")
{
	document.title = RESOURCE["modifyMCLAG"];
}
else
{
	document.title = RESOURCE["createMCLAG"];
}

var createOrModify = neobj["createOrModify"];
function initPage()
{
	$("leftButton").disabled = true;
	$("rightButton").disabled = true;
	
	if(win.resource.getDataRowLength() > 0 )
	{  
		if(null != win.resource.getDataRowOptions(0, "southPort"))
		{
			southportList = win.resource.getDataRowOptions(0, "southPort");	
		}
		if(null != win.resource.getDataRowOptions(0, "mainPort"))
		{
			mainportList = win.resource.getDataRowOptions(0, "mainPort");	
		}		
	}		

	
	if(createOrModify == "modify")
	{
		initModify();
	}
	else
	{
		initCreate();		
	}
	
    $("okbtn").value=RESOURCE["okbutton"];
	$("cancelbtn").value=RESOURCE["cancelbutton"];
	$("applybtn").value=RESOURCE["applybutton"];
}

function initModify()
{
	var selectRows = win.stup.getSelectedRows();
	var index = selectRows[0];
	
	$("rvtMode").options.length = 0;
	$("rvtMode").options[$("rvtMode").options.length] = new Option(rvtMode[0], 0);
	$("rvtMode").options[$("rvtMode").options.length] = new Option(rvtMode[1], 1);
	$("rvtMode").onchange = function()
	{
		rvtModeOnchange(this.value);
	}
	
	selectedAggrNO = win.stup.getCellStoreValue(index,"aggregationNO","aggregationNO");	
		
	var mainPortStr = win.stup.getCellShow(index,"mainPort").element.innerText;
	
	var remoteMainPort = win.stup.getCellStoreValue(index,"remoteMainPort","remoteMainPort");
	var remoteMainPortStr = win.stup.getCellShow(index,"remoteMainPort").element.innerText;
	
	var protocolPathID = win.stup.getCellStoreValue(index,"protocolPathID","protocolPathID");
	
	var protectType = win.stup.getCellStoreValue(index,"protectType","protectType");	
	var protectTypeStr = win.stup.getCellShow(index,"protectType").element.innerText;
	
	var curRvtMode = win.stup.getCellStoreValue(index,"rvtMode","rvtMode");
	var rvtModeStr = win.stup.getCellShow(index,"rvtMode").element.innerText;
	var rvtTime = win.stup.getCellStoreValue(index,"rvtTime","rvtTime");	
	
	$("mainPort").value = mainPortStr;	
	$("remoteMainPort").options[$("remoteMainPort").options.length] = new Option(remoteMainPortStr, remoteMainPort);
	$("remoteMainPort").value = remoteMainPort;
	$("protocolPathID").value = protocolPathID;
	$("protectType").options[$("protectType").options.length] = new Option(protectTypeStr, protectType);
	$("protectType").value = protectType;
	
	$("rvtMode").options.value = curRvtMode;
	$("rvtTime").value = rvtTime;
	
	oldRvtMode = curRvtMode;
	oldRvtTime = rvtTime;
	
	$("availablePort").options.length = 0;
	$("selectedPort").options.length = 0;
	
	
	for(var i = 0, len = southportList.length;i < len; i++)
	{					
	  $("availablePort").options[$("availablePort").options.length] = new Option(getPortName(southportList[i]), southportList[i]);		
	}
	
	var southPort = win.stup.getCellStoreValue(index, "southPort", "southPort");
	if(southPort != null)
	{
		var ports = southPort.split(",");		
		for(var j=0,len=ports.length;j<len;j++)
		{
			oldSouthPort[oldSouthPort.length] = ports[j];
			$("selectedPort").options[$("selectedPort").options.length] = new Option(getPortName(ports[j]), ports[j]);
		}
	}
				
	$("mainPort").disabled = true;
	$("btnSelectLocal").disabled = true;	
	$("remoteMainPort").disabled = true;
	$("protocolPathID").disabled = true;
	$("btnSelectProtocol").disabled = true;
	$("protectType").disabled = true;
	
	$("applybtn") .style.display = "none";
}

/**
 *       
 */
function enableRightbtn()
{
	for(var i=0,len=$("availablePort").options.length;i<len;i++)
	{
		if ($("availablePort").options[i].selected)
		{
			$("rightButton").disabled = false;
			break;
		}
	}
}

/**
 *       
 */
function enableLeftbtn()
{
	for(var i=0,len=$("selectedPort").options.length;i<len;i++)
	{
		if ($("selectedPort").options[i].selected)
		{
			$("leftButton").disabled = false;
			break;
		}
	}
}

/**
 *   
 */
function right()
{
	var availablePort = $("availablePort").options;
	var selectedPort = $("selectedPort").options;
	for(var i=availablePort.length-1;i>=0;i--)
	{
		if(availablePort[i].selected)
		{
			selectedPort[selectedPort.length] = new Option(availablePort[i].text,availablePort[i].value);
			availablePort[i] = null;
		}
	}
	
	sortSlecctedPort();
	$("rightButton").disabled = true;
	if ($("applybtn").disabled)
	{
		$("applybtn").disabled = false;
	}
}

/**
 * 
 */
function sortSlecctedPort()
{
	var selectedPort = $("selectedPort").options;
	var temp = [];
	for(var i=0,len=selectedPort.length;i<len;i++)
	{
		temp[temp.length] = selectedPort[i];
	}
	
	selectedPort.length = 0;
	temp.sort(compare);
	
	for(var i=0,len=temp.length;i<len;i++)
	{
		selectedPort[selectedPort.length] = temp[i];
	}
}

/**
 *   
 */
function left()
{
	var availablePort = $("availablePort").options;
	var selectedPort = $("selectedPort").options;
	
	for(var i=selectedPort.length-1;i>=0;i--)
	{
		if(selectedPort[i].selected)
		{
			availablePort[availablePort.length] = new Option(selectedPort[i].text,selectedPort[i].value);
			selectedPort[i] = null;
		}
	}
	sortAvailablePort();
	$("leftButton").disabled = true;
	if ($("applybtn").disabled)
	{
		$("applybtn").disabled = false;
	}
}

function sortAvailablePort()
{
	var availablePort = $("availablePort").options;
	var temp = [];
	for(var i=0,len=availablePort.length;i<len;i++)
	{
		temp[temp.length] = availablePort[i];
	}
	
	availablePort.length = 0;
	temp.sort(compare);
	
	for(var i=0,len=temp.length;i<len;i++)
	{
		if(!ContainOption(availablePort, temp[i]))
		{
		  availablePort[availablePort.length] = temp[i];
		}
	}
}

function ContainOption(options, option)
{
	var isContain = false;
	for(var i=0,len=options.length;i<len;i++)
	{
		if(options[i].value == option.value)
		{
			isContain = true;
			break;
		}
	}
	return isContain;
}

/**
 *   
 */
function compare(option1,option2)
{
	return option1.value-option2.value;
}


/**
 *     
 */
function initCreate()
{
	for(var i = 0, len = mainportList.length;i < len; i++)
	{					
	  $("remoteMainPort").options[$("remoteMainPort").options.length] = new Option(getPortName(mainportList[i]), mainportList[i]);		
	}
	
	$("protectType").options.length = 0;
	$("protectType").options[$("protectType").options.length] = new Option(protectType[1], 1);
	
	$("rvtMode").options.length = 0;
	$("rvtMode").options[$("rvtMode").options.length] = new Option(rvtMode[0], 0);
	$("rvtMode").options[$("rvtMode").options.length] = new Option(rvtMode[1], 1);
	$("rvtMode").onchange = function()
	{
		rvtModeOnchange(this.value);
	}
	$("rvtMode").options.value = 1;
	$("rvtTime").value = 0;
	$("rvtTime").focus();
	checkText($("rvtTime"), "0", "10");	
	
	for(var i = 0, len = southportList.length;i < len; i++)
	{					
	  $("availablePort").options[$("availablePort").options.length] = new Option(getPortName(southportList[i]), southportList[i]);		
	}
	$("mainPort").value = "";
	$("protocolPathID").value = "";
	$("mainPort").readOnly = true;	
	$("btnSelectLocal").disabled = false;	
	$("remoteMainPort").disabled = false;
	$("protocolPathID").readOnly = true;
	$("btnSelectProtocol").disabled = false;
	$("applybtn") .style.display = "";
	
}

function selectLocalLag()
{
	xshowModalDialog("lagselect.html", RESOURCE["lagselect"], 650, 300, "../../../../../../images/");

}


function selectProtocol()
{
	xshowModalDialog("mcspselect.html", RESOURCE["mcspselect"], 650, 300, "../../../../../../images/");

}

/**
 *       
 */
function rvtModeOnchange(value)
{
	if(value == 0)
	{
		$("rvtTime").value = 0;
		$("rvtTime").disabled = true;
	}
	else
	{		
		$("rvtTime").disabled = false;
	}
}

/**
 *     
 */
function sendInfo(elem)
{

	if(createOrModify == "create")
	{
		sendCreateInfo(elem)
	}
	else
	{
		sendModifyInfo(elem)
	}
    
}

/**
 *     
 */
function sendCreateInfo(elem)
{
	if( $("mainPort").value == "")
    {
        alert(RESOURCE["MCLAG_INPUT_MAINPORT"]);	
        return;
    }
	
	if($("protocolPathID").value == "")
    {
        alert(RESOURCE["MCLAG_INPUT_PROTOCOLPATH"]);	
        return;
    }
    
    if($("remoteMainPort").length == 0)
    {
    	xcloseDialog();
    }
    
    if (!confirm(RESOURCE["MCLAG_CONFIRM"])) 
	{
		return;
	}
    
    var okOrApply = "";
    if(elem.id == "okbtn")
    {
    	okOrApply = "ok"
    }
    else
    {
    	okOrApply = "apply";
    }
    
    var xml = createXML();
    var URL = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_CREATE_MCLAG+"&nmUser="+win["nmUser"];
    loadXMLdoc(URL,"POST",true,createCallBack,okOrApply,"inputdata="+xml);
}

/**
 *       
 */
function sendModifyInfo(elem)
{	var okOrApply = "";
    if(elem.id == "okbtn")
    {
    	okOrApply = "ok";
    }
    else
    {
    	okOrApply = "apply";
    }
	var xml = createModifyXML();
	var URL = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_MODIFY_MCLAG+"&nmUser="+win["nmUser"];
    loadXMLdoc(URL,"POST",true,modifyCallBack,okOrApply,"inputdata="+xml);
}


function createModifyXML()
{
    var di =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");  
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","slotid");
    param.setAttribute("value",slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","aggregationNO");
    param.setAttribute("value",selectedAggrNO);
    row.appendChild(param);    
   
    
    param = new tagElement("param");
    param.setAttribute("name","remoteMainPort");
    param.setAttribute("value",$("remoteMainPort").value);
    row.appendChild(param); 
    
    param = new tagElement("param");
    param.setAttribute("name","protocolPathID");
    param.setAttribute("value",$("protocolPathID").value);
    row.appendChild(param); 
    
    if(oldRvtMode != $("rvtMode").value || oldRvtTime != $("rvtTime").value)
    {
    	   param = new tagElement("param");
    	    param.setAttribute("name","rvtMode");
    	    param.setAttribute("value",$("rvtMode").value);
    	    row.appendChild(param); 
    	    
    	    param = new tagElement("param");
    	    param.setAttribute("name","rvtTime");
    	    param.setAttribute("value",$("rvtTime").value);
    	    row.appendChild(param); 
    	    
    }
    
    if(isSouthPortChanged())
    {  
	    param = new tagElement("param");
	    param.setAttribute("name","southPortNum");
	    param.setAttribute("value",$("selectedPort").options.length);
	    row.appendChild(param); 
	    
	    param = new tagElement("param");
	    param.setAttribute("name","subCardId");
	    param.setAttribute("value","255");
	    row.appendChild(param);    
	    
	    var list = new Array();
	    for (var i = 0, m = $("selectedPort").options.length;  i < m; i++)
	    {    	
	    	list[list.length] = $("selectedPort").options[i].value;    	
	    }    
	    param = new tagElement("param");
	    param.setAttribute("name","southPort");
	    param.setAttribute("value",linkPortId(list));
	    row.appendChild(param);   
    }
  
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *            
 * @returns {Boolean}
 */
function isSouthPortChanged()
{
	var isChanged = false;
	if($("selectedPort").options.length != oldSouthPort.length)
	{
		return true;
	}
	for(var i = 0, len = oldSouthPort.length; i < len; i++)
	{
		if($("selectedPort").options[i].value != oldSouthPort[i])
		{
			isChanged = true;
			break;
		}
	}
	return isChanged;
}

/**
 *                    
 *                       4      
 * @param list
 * @returns {String}
 */
function linkPortId(list)
{
	var selectedPort = "";
    for (var i = 0, m = list.length; i < m; i++)
    {
    	var hex = tenToHex(parseInt(list[i]));
    	for (var j = 0, n = 4 - hex.length; j < n; j++)
    	{
    		hex = "0" + hex;
    	}
    	selectedPort += hex;
    }
    return selectedPort;
}

/**
 *            ID
 */
function getSelectedPort()
{
	var selectedPorts = "";
	for(var i=0,len=$("selectedPort").options.length;i<len;i++)
	{
		selectedPorts += $("selectedPort").options[i].value;
		selectedPorts += ",";
	}
	return selectedPorts.substring(0, selectedPorts.length - 1);
}
/**
 *            
 */
function getSelectedPortName()
{
	var selectedPorts = "";
	for(var i=0,len=$("selectedPort").options.length;i<len;i++)
	{
		selectedPorts += $("selectedPort").options[i].innerText;
		selectedPorts += ",";
	}
	return selectedPorts.substring(0, selectedPorts.length - 1);
}

/**
 *    xml
 */
function createXML()
{
    var di =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");  
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","slotid");
    param.setAttribute("value",slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","aggregationNO");
    param.setAttribute("value",selectedAggrNO);
    row.appendChild(param);    
   
    
    param = new tagElement("param");
    param.setAttribute("name","remoteMainPort");
    param.setAttribute("value",$("remoteMainPort").value);
    row.appendChild(param); 
    
    param = new tagElement("param");
    param.setAttribute("name","protocolPathID");
    param.setAttribute("value",$("protocolPathID").value);
    row.appendChild(param); 
    
    param = new tagElement("param");
    param.setAttribute("name","protectType");
    param.setAttribute("value",$("protectType").value);
    row.appendChild(param); 
    
    param = new tagElement("param");
    param.setAttribute("name","rvtMode");
    param.setAttribute("value",$("rvtMode").value);
    row.appendChild(param); 
    
    param = new tagElement("param");
    param.setAttribute("name","rvtTime");
    param.setAttribute("value",$("rvtTime").value);
    row.appendChild(param); 
    
    if($("selectedPort").length != 0)
    {    
	    param = new tagElement("param");
	    param.setAttribute("name","southPortNum");
	    param.setAttribute("value",$("selectedPort").length);
	    row.appendChild(param); 
	    
	    param = new tagElement("param");
	    param.setAttribute("name","subCardId");
	    param.setAttribute("value","255");
	    row.appendChild(param);    
	    
	    var list = new Array();
	    for (var i = 0, m = $("selectedPort").options.length;  i < m; i++)
	    {    	
	    	list[list.length] = $("selectedPort").options[i].value;    	
	    }  
	    
	    param = new tagElement("param");
	    param.setAttribute("name","southPort");
	    param.setAttribute("value",linkPortId(list));
	    row.appendChild(param);  
    }
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *          
 */
function createCallBack(doc, okOrApply)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1)
    {
    	win.sendQueryInfo();      	
    	   
    	if(okOrApply == "apply")
    	{
    	    $("applybtn").disabled = true;    	   
    		var sIndex = $("remoteMainPort").options.selectedIndex;
    		$("remoteMainPort").options.remove(sIndex);
    		$("remoteMainPort").options.selectedIndex = 0;
    		
    		if(data.getSErrorCode() == 0 )
    	    {
    			refreshSouthPortUI();
    	    }    		
    		if(data.getSErrorCode() == 1)
    		{    var changePort = true;
    			var oError = data.getError();
	    		for(var i = 0; i < data.getBErrLength(); i++)
	    		{	
	    			if(null != oError.getRowKey(i, "southPort") && "" != oError.getRowKey(i, "southPort"))
	    			{
	    				changePort = false;
	    			}
	    			if(changePort)
	    			{
	    				refreshSouthPortUI();
	    			}
	    		}	    		
	    	}     		
    	}
    	else
    	{
    		xcloseDialog();
    	}
    }
}

function refreshSouthPortUI()
{
	for (var i = 0, m = $("selectedPort").options.length; i < m; i++)
	{
		var portid = $("selectedPort").options[i].value;
		southportList.remove(portid);   			
	}  
	$("selectedPort").options.length = 0; 
}

/**
 *          
 */
function modifyCallBack(doc, okOrApply)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    var st = win.stup;
	var index = st.getSelectedRows()[0];  
    if (data.getSErrorCode() == 0 )
    {	
    	
    	st.setCellValue(st.getCell(index, "southPort"), "southPort", getSelectedPort()); 		
		st.getCellShow(index, "southPort").element.innerText = getSelectedPortName();
		st.setCellValue(st.getCell(index, "rvtMode"), "rvtMode", $("rvtMode").value);
		st.getCellShow(index, "rvtMode").element.innerText = rvtMode[$("rvtMode").value]; 		
		st.setCellValue(st.getCell(index, "rvtTime"), "rvtTime", $("rvtTime").value);
		st.getCellShow(index, "rvtTime").element.innerText = $("rvtTime").value; 
		if(okOrApply == "ok")
		{
			xcloseDialog();
		}
		else
		{
		    $("applybtn").disabled = true;
		} 
    }    
	else if(data.getSErrorCode() == 1)
	{
		var changeRtv = true;
		var changePort = true;
		var oError = data.getError();
		for(var i = 0; i < data.getBErrLength(); i++)
		{
			if(null != oError.getRowKey(i, "rvtMode"))
			{
				changeRtv = false;
			}
			
			if(null != oError.getRowKey(i, "southPort") && "" != oError.getRowKey(i, "southPort"))
			{
				changePort = false;
			}
		}
		if (changePort)
		{ 
			st.setCellValue(st.getCell(index, "southPort"), "southPort", getSelectedPort()); 		
			st.getCellShow(index, "southPort").element.innerText = getSelectedPortName();
		}		
		
		if (changeRtv)
		{			
			st.setCellValue(st.getCell(index, "rvtMode"), "rvtMode", $("rvtMode").value);
			st.getCellShow(index, "rvtMode").element.innerText = rvtMode[$("rvtMode").value]; 
			
			st.setCellValue(st.getCell(index, "rvtTime"), "rvtTime", $("rvtTime").value);
			st.getCellShow(index, "rvtTime").element.innerText = $("rvtTime").value; 
		}	
		
	}
}

function showErrorDialog(data)
{
	var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";
    openErrPage("../../../../../../page/", data.getError(), errArr); 
}
