 //global variable
var obj = getNeProperty(self);
var parIndex = parseInt(obj.parIndex, 10);
var parObj = getParentWindow();
var neid = parObj.neid;
var slotId = parObj.slotId;
var boardName = parObj.boardName;
var PORT_NUM_MAX = 10;
if (parObj.boardType == 1067)
{
	PORT_NUM_MAX = 25;
}
else if(parObj.boardType == 1557)
{
	PORT_NUM_MAX = 40;
}
else if (parObj.boardType == 2110)
{	
	PORT_NUM_MAX = 8;
}
else if (parObj.boardType == 2272)
{	
	PORT_NUM_MAX = 20;
}
else if (parObj.boardType == 2217)
{	
	PORT_NUM_MAX = 36;
}

PORT_NUM_MAX = parseInt(getValueByConfigModel(neid, slotId, 'TE_FUNC_CFG_ETH_IGMP', 'IGMP_STATICBDCAST_SUPPORT_PORTNUM_CUSTOM', PORT_NUM_MAX));

var selectedVbList = null;
var ct;

var MIN_MAC_ID = 0x01005E000100;
var MAX_MAC_ID = 0x01005E7FFFFF;

window.onload = function()
{
	initTable();
	initData();
	initPortSelect();
	initButton();
}

function initPortSelect()
{
	selectedVbList = [];
	if (parIndex >= 0)
	{
		var vbid = parObj.st0.getCellStoreValue(parIndex, "vbid", "vbid");
		var vlanid = parObj.st0.getCellStoreValue(parIndex, "vlanid", "vlanid");
		var mac = parObj.st0.getCellStoreValue(parIndex, "mac", "mac");
		selectedVbList = parObj.getSnoopingObj(vbid, vlanid,mac).portList;
	}
	
	while($("rightport").options.length > 0)
	{
	    $("rightport").remove(0);
	}
	
	var rightPortOption = $("rightport").options;
	for(var i = 0,size = selectedVbList.length; i < size; i++)
	{
		rightPortOption[rightPortOption.length] = new Option(selectedVbList[i] - 28672,selectedVbList[i]);
	}
	
	while($("leftport").options.length > 0)
	{
	    $("leftport").remove(0);
	}
	var leftPortOption = $("leftport").options;
	for(var i = 1; i <= PORT_NUM_MAX; i++)//       
	{
		if(!selectedVbList.contains(i + 28672))
		{
			leftPortOption[leftPortOption.length] = new Option(i, i + 28672);	
		}			
	}	
}

function initTable()
{	
	ct = new CTable(); 
	ct.addHead(RESOURCE["ATTRIBUTE"],RESOURCE["VALUE"]);
	$("ctable").appendChild(ct.getTable());
	
	var atom = new Atom("select");
	atom.setValue("");
	atom.element.disabled = (parIndex >= 0);
	ct.addAttrRow("vbid", "VB ID", atom);
	
	var atom = new Atom("select");
	atom.setValue("");
	ct.addAttrRow("vlanid", "VLAN ID", atom);
	
	var atom = new Atom("text");
	atom.setValue("01-00-5E-00-01-00");
	checkMACAddEvent(atom.element);
	ct.addAttrRow("mac", RESOURCE["mac"], atom);
}

function initData()
{
	var vbOpt = ct.getAtom("vbid").element;
	var vlanOpt = ct.getAtom("vlanid").element;
	if(parIndex >= 0)
	{
		var vbid = parObj.st0.getCellStoreValue(parIndex, "vbid","vbid");
		vbOpt.options[vbOpt.options.length] = new Option(vbid, vbid);
		var vlanid = parObj.st0.getCellStoreValue(parIndex, "vlanid","vlanid");
		if (parseInt(vlanid) == 0xfffe)
		{
			vlanOpt.options[vlanOpt.options.length] = new Option("-", vlanid);
		}
		else
		{
			vlanOpt.options[vlanOpt.options.length] = new Option(vlanid, vlanid);
		}
		vlanOpt.disabled = true;
		var macAddr = parObj.st0.getCellStoreValue(parIndex, "mac","mac");
		ct.getAtom("mac").setValue(convertMAC(macAddr));
		ct.getAtom("mac").element.disabled = true;
	}
	else
	{
		var res = parObj.resource;
		var vbid = res.getDataRowParam(0, "vbid");
		vbOpt.options[vbOpt.options.length] = new Option(vbid, vbid);
		if (res.getDataRowLength() == 1)
		{
			var vlanid = res.getDataRowParam(0, "vlanid");
			if (parseInt(vlanid) == 0xfffe || parseInt(vlanid) == 0xffff)
			{
				vlanOpt.options[vlanOpt.options.length] = new Option("-", vlanid);
				vlanOpt.disabled = true;
				return;
			}
		}
		for (var i = 0, m = res.getDataRowLength(); i < m; i++)
		{
			var vlanid = res.getDataRowParam(i, "vlanid");
			vlanOpt.options[vlanOpt.options.length] = new Option(vlanid, vlanid);
		}
	}
}

function initButton()
{
	$("okbtn").value = RESOURCE["okbtn"];
	$("cancelbtn").value = RESOURCE["cancelbtn"];
	$("applybtn").value = RESOURCE["applybtn"];
}

function confirm(flag)
{
	if (parIndex >= 0)
	{
		doModify(flag);
	}
	else
	{
		doCreate(flag);
	}
}

function doCreate(flag)
{
	if (!checkSubmit(ct.getAtom("mac").getValue()))
	{
		return;
	}
	
	var xmldata = createNewXml();
	var urlstr = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_IP_STATICIGMP_CREATE+"&nmUser="+obj["nmUser"];
	loadXMLdoc(urlstr, "POST", false, callBackNew, flag, "inputdata="+xmldata);
}

function createNewXml()
{
	var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var vbid = ct.getAttrValue("vbid");
    var vlanid = parseInt(ct.getAttrValue("vlanid"));
    var mac = ct.getAttrValue("mac");
    var portList = "";
    var portStr = "";
    var portNum = 0;
    var rightPortOption = $("rightport").options;
    for (var i = 0, len = rightPortOption.length; i < len; i++)
    {    
    	portStr += "LP" + (rightPortOption[i].value - 28672) + ",";
		portList += tenToHex(rightPortOption[i].value);
		portNum++;
	}
	if (portNum == 0)
	{
		portStr = "FFFF,";
		portList = "FFFF";
	}
	var keys = new Array("neid", "slotid", "board", "vbid", "vlanid", "macStr", "mac", "portnum", "portStr", "portlist");
	var vals = new Array(neid, slotId, slotId+"-"+boardName, vbid, vlanid, mac, convertHex(mac), portNum, portStr.substring(0, portStr.length-1), portList);
    business.appendChild(createRow(keys, vals));
    
    root.getRoot().appendChild(business);
    return root.toString();
}

function callBackNew(doc, flag)
{
	var data = EncapsulateData(doc);
	if (data.getSErrorCode() == 0 )
	{
		parObj.staticBroadcastQuery();	
		if (flag)
		{
			xcloseDialog();
		}
	}
	showErrorDialog(data);
}

function doModify(flag)
{	
	var xmldata = createModifyXml();
	if (xmldata == null)
	{
		alert(RESOURCE["noModify"]);
		return;
	}
	var urlstr = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_IP_STATICIGMP_MODIFY+"&nmUser="+obj["nmUser"];
	loadXMLdoc(urlstr, "POST", false, callbackModify, flag, "inputdata="+xmldata);
}

function createModifyXml()
{
	var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var vbid = ct.getAttrValue("vbid");
    var vlanid = ct.getAttrValue("vlanid");
    var mac = ct.getAttrValue("mac");
    var addportList = "";
    var portStr = "";
    var addnum = 0;
    var rightPortOption = $("rightport").options;
    for (var i = 0, len = rightPortOption.length; i < len; i++)
    {    	
    	if (!selectedVbList.contains(rightPortOption[i].value))
    	{
    		addportList += tenToHex(rightPortOption[i].value);
			addnum ++;
    	}
    	portStr += "LP" + (rightPortOption[i].value - 28672) + ",";
	}	
	
	var delportList = "";
	var delnum = 0;
	var leftPortOption = $("leftport").options;
	for (var i = 0, len = leftPortOption.length; i < len; i++)
    {    	
		if(selectedVbList.contains(leftPortOption[i].value))
    	{
			delportList += tenToHex(leftPortOption[i].value);
			delnum++;
		}
	}

	if (addnum > 0 && delnum > 0)
	{
		var keys = new Array("neid", "slotid", "board", "vbid", "vlanid", "macStr", "mac", "addnum", "addport", "delnum", "delport", "portStr");
		var vals = new Array(neid, slotId, slotId+"-"+boardName, vbid, vlanid, mac, convertHex(mac), addnum, addportList, delnum, delportList, portStr.substring(0, portStr.length - 1));
		business.appendChild(createRow(keys, vals));
    }
    else if (addnum > 0 && delnum <= 0)
    {
    	var keys = new Array("neid", "slotid", "board", "vbid", "vlanid", "macStr", "mac", "addnum", "addport", "portStr");
		var vals = new Array(neid, slotId, slotId+"-"+boardName, vbid, vlanid, mac, convertHex(mac), addnum, addportList, portStr.substring(0, portStr.length - 1));
		business.appendChild(createRow(keys, vals));
    }
    else if (addnum <= 0 && delnum > 0)
    {
    	var keys = new Array("neid", "slotid", "board", "vbid", "vlanid", "macStr", "mac", "delnum", "delport", "portStr");
		var vals = new Array(neid, slotId, slotId+"-"+boardName, vbid, vlanid, mac, convertHex(mac), delnum, delportList, portStr.substring(0, portStr.length - 1));
		business.appendChild(createRow(keys, vals));
    }
    else
    {
    	return;
    }
    
    root.getRoot().appendChild(business);
    return root.toString();
} 

function callbackModify(doc, flag)
{
	var data = EncapsulateData(doc);
	if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1)
	{
		parObj.staticBroadcastQuery();		
		initPortSelect();
		if (data.getSErrorCode() == 0 && flag)
		{
			xcloseDialog();
		}	
	}
	showErrorDialog(data);
}

function checkSubmit(macStr)
{
    var pattern = /^[a-f,A-F,0-9][a-f,A-F,0-9]-[a-f,A-F,0-9][a-f,A-F,0-9]-[a-f,A-F,0-9][a-f,A-F,0-9]-[a-f,A-F,0-9][a-f,A-F,0-9]-[a-f,A-F,0-9][a-f,A-F,0-9]-[a-f,A-F,0-9][a-f,A-F,0-9]$/;
   	var checker = pattern.test(macStr);
   	if(!checker)
   	{
       	alert(RESOURCE["format"]);
       	return false;
   	}
   	else
   	{
   		var macArr = macStr.toUpperCase().split("-");
		var mac = hexToTen(macArr[0] + macArr[1] + macArr[2] + macArr[3] + macArr[4] +macArr[5]);
		if (mac < MIN_MAC_ID || mac > MAX_MAC_ID)
		{
			alert(RESOURCE["macrange"]);
			return false;
		}
   	}	
	return true;
}

function selectToLeft()
{
   selectTo($("rightport"), $("leftport"));  
}

function selectToRight()
{
   selectTo($("leftport"), $("rightport"));
}   

function selectTo(field1, field2)
{
	if (field1.options.selectedIndex < 0)
	{
		return;
	}
	var value = new Array();
	var text = new Array();
	var selectedValue = new Array();
	for(var i = field1.options.length - 1; i >= 0; i--)
	{
		if(field1.options[i].selected)
		{
			value[value.length] = field1.options[i].value;
			text[text.length] = field1.options[i].text;
			field1.remove(i);
		}
	}
	
	for(var n = field2.options.length - 1, m = 0; n >= 0; n--)
	{
		if (field2.options[n].selected)
		{
		    selectedValue[m++] = field2.options[n].value;
		}
		value[value.length] = field2.options[n].value;
		text[text.length] = field2.options[n].text;
		field2.remove(n);
	}

	value = value.sort(compareNum);
	text = text.sort(compareNum);
				
	for(k = 0; k < value.length; k++)
	{
		var oOption = document.createElement("OPTION");
		oOption.text = text[k];
		oOption.value = value[k];
		    
		for (t = 0; t < selectedValue.length; t++)
		{
		    if (value[k] == selectedValue[t])
		    {
		    	oOption.selected = "selected";
		    } 
		}		    
		field2.options.add(oOption);
	}	
}
