 //global variable
var parentWin = getParentWindow().parent
var parObj = getNeProperty(parentWin);
var neID = parObj.neid;
var slotID = parObj.slotid;
var PORT_NUM_MAX = 20;
var boardType = parObj.boardType;

if (boardType == 2109)
{
	PORT_NUM_MAX = 26;
}
else if (boardType == 2292)
{
	PORT_NUM_MAX = 44;
}
else if (boardType == 2110)
{
	PORT_NUM_MAX = 6;
}

var ct;

window.onload = function()
{
	initCTable();
	initPortSelect();
	initButton();
}

function initPortSelect()
{
	$("rightport").options.length = 0;
	$("leftport").options.length = 0;
	
	var leftPortOption = $("leftport").options;
	for(var i = 1; i <= PORT_NUM_MAX; i++)//       
	{
	    leftPortOption[leftPortOption.length] = new Option(i, i + 28672);				
	}	
}

function initCTable()
{	
	ct = new CTable(); 
	ct.addHead(RESOURCE["ATTRIBUTE"],RESOURCE["VALUE"]);
	$("ctable").appendChild(ct.getTable());
	
	var atom = new Atom("text");
	atom.setValue('1');
	atom.element.disabled = true;
	ct.addAttrRow("vbid", "VB ID", atom);
	
	var atom = new Atom("select");
	ct.addAttrRow("vlanid", "VLAN ID", atom);
	
	initVlanID();
}

function initButton()
{
	$("okbtn").value = RESOURCE["okbtn"];
	$("okbtn").disabled = true;
	$("cancelbtn").value = RESOURCE["cancelbtn"];
	$("applybtn").value = RESOURCE["applybtn"];
	$("applybtn").disabled = true;
}

function doCreate(flag)
{
    var vlanElement = ct.getAtom("vlanid").element;
    if(vlanElement.options.length <= 0)
    {
        alert(RESOURCE["novlan"]);
        return;
    }
        
        
    var xmldata = createNewXml();
    var urlstr = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_ADD_STATICMULTICAST_ROUTEPORT+"&nmUser="+parObj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callBackNew, flag, "inputdata="+xmldata);
}

function createNewXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var vbid = ct.getAttrValue("vbid");
    var vlanid = parseInt(ct.getAttrValue("vlanid"));
    var portList = "";
    var portStr = "";
    var portNum = 0;
    var rightPortOption = $("rightport").options;
    for (var i = 0, len = rightPortOption.length; i < len; i++)
    {    
    	portStr += "LP" + (rightPortOption[i].value - 28672) + ",";
	portList += tenToHex(rightPortOption[i].value);
	portNum++;
    }
    
    var keys = new Array("neid", "slotid", "vbid", "vlanid", "portnum", "portStr", "portlist");
    var vals = new Array(neID, slotID, vbid, vlanid, portNum, portStr.substring(0, portStr.length-1), portList);
    business.appendChild(createRow(keys, vals));
    
    root.getRoot().appendChild(business);
    return root.toString();
}

function callBackNew(doc, flag)
{
	var data = EncapsulateData(doc);
	if (data.getSErrorCode() == 0 )
	{
		getParentWindow().query();	
		if (flag)
		{
			xcloseDialog();
		}
	}
	showErrorDialog(data);
}

function selectToLeft()
{
    selectTo($("rightport"), $("leftport"));  
    refreshBtnStatus();
}

function selectToRight()
{
   selectTo($("leftport"), $("rightport"));
   refreshBtnStatus();
}   

function refreshBtnStatus()
{        
    if($('rightport').options.length <= 0)
    {
        $("okbtn").disabled = true;
        $("applybtn").disabled = true;
    } else {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
    }
}

function selectTo(field1, field2)
{
	if (field1.options.selectedIndex < 0)
	{
		return;
	}
	var value = new Array();
	var text = new Array();
	var selectedValue = new Array();
	for(var i = field1.options.length - 1; i >= 0; i--)
	{
		if(field1.options[i].selected)
		{
			value[value.length] = field1.options[i].value;
			text[text.length] = field1.options[i].text;
			field1.remove(i);
		}
	}
	
	for(var n = field2.options.length - 1, m = 0; n >= 0; n--)
	{
		if (field2.options[n].selected)
		{
		    selectedValue[m++] = field2.options[n].value;
		}
		value[value.length] = field2.options[n].value;
		text[text.length] = field2.options[n].text;
		field2.remove(n);
	}

	value = value.sort(compareNum);
	text = text.sort(compareNum);
				
	for(k = 0; k < value.length; k++)
	{
		var oOption = document.createElement("OPTION");
		oOption.text = text[k];
		oOption.value = value[k];
		    
		for (t = 0; t < selectedValue.length; t++)
		{
		    if (value[k] == selectedValue[t])
		    {
		    	oOption.selected = "selected";
		    } 
		}		    
		field2.options.add(oOption);
	}	
}

function createRow(keyParams, valParams)
{
    var row = new tagElement("row-params");
    var param;
    
    for (var i=0; i<keyParams.length; i++)
    {
        param = new tagElement("param");    
	param.setAttribute("name", keyParams[i]);
	param.setAttribute("value", valParams[i]);
	row.appendChild(param);
    }
    
    return row;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";  
    openErrPage("../../../../../../page/", data.getError(), errArr);
    errArr = null;
}

function initVlanID()
{
	var xmldata = createQueryXml();
	var urlstr = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_IP_STATICIGMP_GET_VALIDRESOURCE+"&nmUser="+parObj["nmUser"];
	loadXMLdoc(urlstr, "POST", false, callbackQueryRes, null, "inputdata="+xmldata);	
}

function createQueryXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    
    var keys = new Array("neid", "slotid", "vbid", "vlanid");
    var vals = new Array(neID, slotID, "0", "-1");
    
    business.appendChild(createRow(keys, vals));
    root.getRoot().appendChild(business);
    return root.toString();
}


function callbackQueryRes(doc)
{
    var data = EncapsulateData(doc);

    if (data.getDataRowLength() == 1)
    {
    	var vlanid = data.getDataRowParam(0, "vlanid");
    	if (parseInt(vlanid) == 0xfffe || parseInt(vlanid) == 0xffff)
    	{
    		return;
    	}
    }
    
    var vlanOpt = ct.getAtom("vlanid").element;
    for (var i = 0, m = data.getDataRowLength(); i < m; i++)
    {
    	var vlanid = data.getDataRowParam(i, "vlanid");
    	vlanOpt.options[vlanOpt.options.length] = new Option(vlanid, vlanid);
    }
}
