 /************
 *     
*************/
var VBNAME_LEN = 16;//vb         16  
var VCTRUNC_FLG = 32768;
var VBPORT_FLG = 28672;

var vbTypeConvert = new Object();
vbTypeConvert[1] = "802.1q";
vbTypeConvert[2] = "802.1d";
vbTypeConvert[3] = "802.1ad";

var vbModeConvert = new Object();
vbModeConvert[1] = "vbmode1";
vbModeConvert[2] = "vbmode2";
vbModeConvert[3] = "vbmode3";
vbModeConvert[4] = "vbmode4";

var vbLearnModeConvert = new Object();
vbLearnModeConvert[1] = "SVL";
vbLearnModeConvert[2] = "IVL";

var portTypeArr = new Object();
portTypeArr[2] = "UNI";
portTypeArr[5] = "C-Aware";
portTypeArr[6] = "S-Aware";

var hubAttrConvert = new Object();
hubAttrConvert[0] = "Hub";
hubAttrConvert[1] = "Spoke";

var portEnabled = new Object();
portEnabled[0] = "ID_DISABLE2";
portEnabled[1] = "ID_ENABLE";

var Direction = new Object();
Direction[4] = "bidirectional";

var oldStatus = new Object();
oldStatus[0] = "staticStatus";
oldStatus[1] = "dynamic";

var boundPothLevel = new Object();
boundPothLevel[1] = "VC4-xv";
boundPothLevel[2] = "VC3-xv";
boundPothLevel[3] = "VC12-xv";
boundPothLevel[33] = "VC4-xc";
boundPothLevel[34] = "VC3-xc";
boundPothLevel[129] = "GE";//ODUG    

var boundPathDirection = new Object();
boundPathDirection[0] = "bidirectional";

var href = window.location.href;

var board 
if(href.indexOf("spladdvlan.html") > 0 ||href.indexOf("spladdvlanunicast.html") > 0 || href.indexOf("managevlan.html") > 0 || href.indexOf("addvlanunicast.html") > 0)
{
   
    board = parseInt(win.parent.mainPageUrl.boardType);

}

/**********************
 * portArr      
***********************/
function comparison_portNo(portObj1, portObj2)
{
    var value1 = parseInt(portObj1.portNo);
    var value2 = parseInt(portObj2.portNo);
    if(value1 < value2)
    {
        return -1;
    }
    else if(value1 > value2)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

/*********************************************
 *   VLAN id
 *     1 3-6       1 3 4 5 6
**********************************************/
function getVlanIdArr(vlanStr)
{
    var vlanArr = vlanStr.split(",");
    var tempArr = new Array();
    var resultVlanArr = new Array();
    var len = 0;
    for(var i = 0, arrlen = vlanArr.length; i < arrlen; i++)
    {
        if(-1 == vlanArr[i].indexOf("-"))
        {
            resultVlanArr[resultVlanArr.length] = vlanArr[i];
            continue;
        }
        tempArr = vlanArr[i].split("-");
        resultVlanArr[resultVlanArr.length] = tempArr[0];
        len = parseInt(tempArr[1]) - parseInt(tempArr[0]);
        for(var j = 0; j < len; j++)
        {
            resultVlanArr[resultVlanArr.length] = parseInt(resultVlanArr[resultVlanArr.length - 1]) + 1;
        }
    }
    return resultVlanArr;
}

/*****************************************
 *       vb         
 *        
 *      1,3,4,5       1 3-6                 
******************************************/
function getVlanIdStr(cvtvalue)
{
    var vlanidArr = cvtvalue.split(",");
    var vlanidStr = vlanidArr[0];
    var tempvlanid = vlanidStr;
    for(var i = 1, len = vlanidArr.length; i < len; i++)
    {
        if(parseInt(vlanidArr[i]) - parseInt(tempvlanid) > 1)
        {
            
            if(vlanidStr.substring(vlanidStr.length - 1) == "-")
            {
                vlanidStr += tempvlanid;
            }
            tempvlanid = vlanidArr[i];
            vlanidStr += "," + tempvlanid;
        }
        else if(parseInt(vlanidArr[i]) - parseInt(tempvlanid) == 1)
        {
            tempvlanid = vlanidArr[i];
            if(vlanidStr.substring(vlanidStr.length - 1) != "-")
            {
                vlanidStr += "-";
            }
        }
    }
    if(vlanidStr.substring(vlanidStr.length - 1) == "-")
    {
        vlanidStr += tempvlanid;
    }
    return vlanidStr;
}

/**********************************
 *       convertMsg   
 *                                
***********************************/
function convertMsg(resobj,	cvtobj,	cvtvalue)
{
		if("function" == typeof cvtobj)
		{
		    return cvtobj(cvtvalue);
		}
		if(cvtvalue == "-")
		{
	      return cvtvalue;
		}
		return resobj[cvtobj[cvtvalue]];
}

/*
               
 */
function isValidateSrcCVlan()
{
    var text = $("vlanid");
    if(!text)
    {
        return;
    }    
    if(!isValidateVlan("srcCVlan"))
    {
        return;
    }
}

/*
               
 */
function isValidateVlan(Vlan)
{         
    var text = $("vlanid").value;
    if(!text)
    {
        alert(RESOURCE["vlanidempty"]);
        return false;
    }
    if("-" == text)
    {
        alert(RESOURCE["vlanFormat"]);
        return false;
    }
    var str=text.split(",");
    var pattern1=new RegExp("^\\d+$","i");
    var pattern2=new RegExp("^\\d+-\\d+$","i");

    for(var i=0; i<str.length; i++)
    {        
        var b=str[i].indexOf("-")!=-1;
        if(b)
        {
            if( !pattern2.test(str[i]))
            {    
            	  alert(RESOURCE["vlanFormat"]);
                return false;
            }
        }
        else
        {
            if(!pattern1.test(str[i]))
            {
            	  alert(RESOURCE["vlanFormat"]);
                return false;
            }
         }
    }
    var limitHigh = 4094;
    
    if(board == "1067")
    {
        limitHigh = 4095;
    }
    
    var limitLow = 1;
    for(var i=0; i<str.length; i++)
    {
        var b=str[i].indexOf("-")!=-1;
        if(b)
        {
            var range=str[i].split("-");
            var rangeStart=parseInt(range[0]);
            var rangeEnd=parseInt(range[1]);
    
            if((rangeStart>limitHigh) || (rangeEnd>limitHigh)
                ||(rangeStart<limitLow) ||(rangeEnd<limitLow))
            {
                if(board == "1067")
                {
       	            alert(RESOURCE["numberLimit1"]);
       	        } else {
       	            alert(RESOURCE["numberLimit"]);
       	        }
                return false;
            }
            if (rangeEnd <rangeStart)
            {
            	  alert(RESOURCE["startEnd"]);
                return false;
            }
        }
        else
        {
           if(parseInt(str[i])>limitHigh || parseInt(str[i])<limitLow)
           {
           
                if(board == "1067")
                {
       	            alert(RESOURCE["numberLimit1"]);
       	        } else {
       	            alert(RESOURCE["numberLimit"]);
       	        }
                return false;
           }
        }
    }
    return true;
}

function chkCVlan(obj,event,Vlan)
{
	  var code = (event.keyCode!=0?event.keyCode:event.charCode);
	  var ch = String.fromCharCode(code);
	  if(code == 8 || code == 46 || code == 37 || code == 39)
    {
    	  return true;   //DEL   
    }

	  if ($("applybtn") && $("applybtn").disabled)
	  {
	  	  $("applybtn").disabled = false;
	  }
    if(!restrict(obj, event, "0123456789,-"))
    {
        return false;
    }
    if(!isCVlan(Vlan))
    {
        return false;
    }
    return true;
}

/*
               
 */
function isCVlan(Vlan)
{
	  var key,keychar;   
    if(window.event)
    {
       key = window.event.keyCode;
    }  
    keychar = String.fromCharCode(key);  
    var code = (event.keyCode!=0?event.keyCode:event.charCode);
	  keychar = String.fromCharCode(code); 
    var text = $("vlanid").value + keychar;
    if(!text || "-" == text)
    {
        return true;
    }
    var str=text.split(",");
    
    var limitHigh = 4094;
    
    if(board == "1067")
    {
        limitHigh = 4095;
    }
    
    var limitLow = 1;
    for(var i=0; i<str.length; i++)
    {
        var b=str[i].indexOf("-") != -1;
        if(b)
        {
            var range = str[i].split("-");
            var rangeStart = parseInt(range[0]);
            var rangeEnd = parseInt(range[1]);

            if((rangeStart>limitHigh) || (rangeEnd>limitHigh)
                ||(rangeStart<limitLow) ||(rangeEnd<limitLow))
            {
       	        if(board == "1067")
                {
       	            alert(RESOURCE["numberLimit1"]);
       	        } else {
       	            alert(RESOURCE["numberLimit"]);
       	        }
                return false;
            }
        }
        else
        {
           if(parseInt(str[i])>limitHigh || parseInt(str[i])<limitLow)
           {
           	if(board == "1067")
                {
       	            alert(RESOURCE["numberLimit1"]);
       	        } else {
       	            alert(RESOURCE["numberLimit"]);
       	        }
                return false;
           }
        }
    }
    return true;
}

/****************************
 * MAC                           
*****************************/
function checkMACFormat(obj)
{
	  obj.style.imeMode = "disabled";
	  obj.maxLength = "17";
	  
	  obj.onpaste = returnFalse;
    
    obj.onkeypress = function()
    {
        return validateMACAddr(obj);    	
    }
}

/**********************
 * MAC                        
***********************/
function validateMACAddr(obj)
{
	  var code=(event.keyCode!=0?event.keyCode:event.charCode);

    var ch = String.fromCharCode(code);
	
	  if(code == 13)
	  {
	  	  return false;
    }
    
    if (code == 8 || code == 127)
    {
    	  return false;
    }
    
    if(event.ctrlKey)
    {
        if(ch == 'X' || ch == 'C' || ch == 'A')
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    	
	  if (code == 45)
	  {
	  	  return true;
	  }
	
	  if(code < 48 || (code > 57 && code < 65) || (code > 70 && code < 97) || code > 102)
	  {
	  	  return false;
	  }    
	
    var value = obj.value;					
    pos = digitalTag_getPos(obj);
	  if(pos <= 16)
	  {
	  	  var ach = value.substring(pos, pos + 1);
	  	  if(ach == "-")
	  	  {
	  	  	  if(isIE)
	  	  	  {
	  	  	  	  var rng = document.selection.createRange();					
	  	  	  	  if(selectionLen(obj) > 0)
	  	  	  	  {
	  	  	  	  	rng.moveEnd('character', -(selectionLen(obj) - 2));
	  	  	  	  	rng.text = "-" + ch;
	  	  	  	  	rng.select();						
	  	  	  	  }
	  	  	  	  else
	  	  	  	  {
	      	  	  		rng.moveEnd('character', 1);
	      	  	  		rng.text = "-";
	      	  	  }
	  	  	  }
	  	  	  else
	  	  	  {
	  	  	  	  obj.selectionStart = pos + 1;
	  	  	  }
	  	  }
	  	  else
	  	  {
	  	  	  var newVal = "";
	  	  	  newVal = value.substring(0, pos) + ch + value.substring(pos + 1);
	  	  	  if (isIE)
	  	  	  {
	  	  	  	  var rng = document.selection.createRange();					
	  	  	  	  if (selectionLen(obj) > 0)
	  	  	  	  {
	  	  	  	  	  rng.moveEnd('character', -(selectionLen(obj) - 1));
	  	  	  	  	  rng.text = "";
	  	  	  	  	  rng.select();						
	  	  	  	  }
	  	  	  	  else
	  	  	  	  {
	      	  	  		rng.moveEnd('character',1);
	      	  	  		rng.text = "";
	      	  	  }		
	  	  	  }
	  	  	  else
	  	  	  {
	  	  	  	  var newVal = value.substring(0,pos) + ch + value.substring(pos + 1);
	  	  	  	  obj.value = newVal;
	  	  	  	  obj.selectionEnd = pos + 1;
	  	  	  }
	  	  }
	  }
}

function blurFormat(obj)
{
	var pattern = /^[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]$/;
   	var checker = pattern.test(obj.value);
   	if(!checker)
   	{
       	alert(RESOURCE["format"]);
       	obj.value = "00-00-00-00-00-01";
       	obj.focus();
       	return false;
   	}
   	else
   	{
       	if(obj.value == "00-00-00-00-00-00")
       	{
       	    alert(RESOURCE["macaddrerror0"]);
       	    return false;
       	}
       	var val = obj.value.substring(1, 2);
       	var pattern0 = /^[a-f,A-Z]$/;
       	if(pattern0.test(val))
       	{
       	    switch(val.toLowerCase())
       	    {
       	        case "a": val = 10;
       	                  break;
       	        case "b": val = 11;
       	                  break;
       	        case "c": val = 12;
       	                  break;
       	        case "d": val = 13;
       	                  break;
       	        case "e": val = 14;
       	                  break;
       	        case "f": val = 15;
       	                  break;
       	        default:;
       	    }
       	}

       	if(parseInt(val) % 2 != 0)
       	{
       	    alert(RESOURCE["macaddrerror1"]);
       	    return false;   
       	}
       	return true;
   	}
}

var isActive = new Object();
isActive["0"] = "inactive";
isActive["1"] = "active";
isActive["255"] = "nullStatus";

/*****************************************                                               
 *                  
 * c00104334 2011-10-09 U2000V1R6C00   
******************************************/
function disableCellEdit(tableObj, cellObj)
{
    tableObj.setCellIsEdit(cellObj, 0);
    cellObj.ondblclick = null;
}
