/**
 *          
 */
function initLeftCTable()
{
    leftCTable = new CTable();
    
    var cTableAtom = null;
    
    var cTableAtomEle = null;
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element; 
    textCheckWithStepLen(cTableAtomEle, HOLDOFF_TIME_MIN, HOLDOFF_TIME_MAX, HOLDOFF_TIME_STEP_LEN);

    EventUtil.addEventHandler(cTableAtomEle, "blur", changeHoldoffTime);
    function changeHoldoffTime()
    {
        setModifyFlag("holdoffTime");
        if (erpsListTable.getDataRowLength() > 0)
        {
            $("applybtn").disabled = false;
        }
    }
    leftCTable.addAttrRow("holdoffTime", RESOURCE["holdoffTime"], cTableAtom); 
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element; 
    textCheckWithStepLen(cTableAtomEle, GUARD_TIME_MIN, GUARD_TIME_MAX, GUARD_TIME_STEP_LEN);
    EventUtil.addEventHandler(cTableAtomEle, "blur", changeGuardTime);
    function changeGuardTime()
    {
        setModifyFlag("guardTime");
        if (erpsListTable.getDataRowLength() > 0)
        {
            $("applybtn").disabled = false;
        }
    }
    leftCTable.addAttrRow("guardTime", RESOURCE["guardTime"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    for (var i = 0, len = ENTITY_MAX_COUNT; i < len; i ++)
    {
        cTableAtom.addOption(i, i);
    }
    cTableAtomEle = cTableAtom.element; 
    cTableAtomEle.onchange = function()
    {
        setModifyFlag("entityLevel");
        if (erpsListTable.getDataRowLength() > 0)
        {
            $("applybtn").disabled = false;
        }
    }
    leftCTable.addAttrRow("entityLevel", RESOURCE["entityLevel"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    for (var i = 0, len = ERPS_RB.length; i < len; i ++)
    {
        cTableAtom.addOption(ERPS_RB[i], i);
    }
    cTableAtomEle = cTableAtom.element; 
    setSelectDisabled(cTableAtomEle);
    leftCTable.addAttrRow("erpsRB", RESOURCE["erpsRB"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    for (var i = 0, len = ERPS_FSM_STATE.length; i < len; i ++)
    {
        cTableAtom.addOption(ERPS_FSM_STATE[i], i);
    }
    cTableAtomEle = cTableAtom.element; 
    setSelectDisabled(cTableAtomEle);
    leftCTable.addAttrRow("erpsFSMstate", RESOURCE["erpsFSMstate"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    cTableAtom.addOption(RESOURCE["block"], 1);
    cTableAtom.addOption(RESOURCE["unblock"], 2);
    cTableAtomEle = cTableAtom.element;
    setSelectDisabled(cTableAtomEle);
    leftCTable.addAttrRow("eportstate", RESOURCE["eportstate"], cTableAtom);
    
    $("leftCTableDiv").appendChild(leftCTable.getTable());
}

/**
 *          
 */
function initRightCTable()
{
    rightCTable = new CTable();
    
    var cTableAtom = null;
    
    var cTableAtomEle = null;
    
    cTableAtom = new Atom("select");
    cTableAtom.addOption("05:00", 5);
    cTableAtom.addOption("06:00", 6);
    cTableAtom.addOption("07:00", 7);
    cTableAtom.addOption("08:00", 8);
    cTableAtom.addOption("09:00", 9);
    cTableAtom.addOption("10:00", 10);
    cTableAtom.addOption("11:00", 11);
    cTableAtom.addOption("12:00", 12);
    cTableAtomEle = cTableAtom.element; 

    EventUtil.addEventHandler(cTableAtomEle, "change", changeWtrTime);
    function changeWtrTime()
    {
        setModifyFlag("wtrTime");
        if (erpsListTable.getDataRowLength() > 0)
        {
            $("applybtn").disabled = false;
        }
    }
    rightCTable.addAttrRow("wtrTime", RESOURCE["wtrTime"], cTableAtom); 
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element; 
    if (winurlobj["neType"] == 67)
    {
    	checkText(cTableAtomEle, "1", "10");
    }
    else
    {
        checkText(cTableAtomEle, SEND_INTERVAL_MIN, SEND_INTERVAL_MAX);
    }
    EventUtil.addEventHandler(cTableAtomEle, "blur", changeSendInterval);
    function changeSendInterval()
    {
        setModifyFlag("sendInterval");
        if (erpsListTable.getDataRowLength() > 0)
        {
            $("applybtn").disabled = false;
        }
    }

    rightCTable.addAttrRow("sendInterval",  RESOURCE["sendInterval"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    for (var i = 1, len = LAST_REQ_ERPS.length; i < len; i ++)
    {
        cTableAtom.addOption(LAST_REQ_ERPS[i], i);
    }
    cTableAtomEle = cTableAtom.element; 
    setSelectDisabled(cTableAtomEle);
    rightCTable.addAttrRow("lastReqERPS", RESOURCE["lastReqERPS"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    for (var i = 0, len = ERPS_DNF.length; i < len; i ++)
    {
        cTableAtom.addOption(ERPS_DNF[i], i);
    }
    cTableAtomEle = cTableAtom.element; 
    setSelectDisabled(cTableAtomEle);
    rightCTable.addAttrRow("erpsDNF", RESOURCE["erpsDNF"], cTableAtom); 
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element; 
    setSelectDisabled(cTableAtomEle);
    rightCTable.addAttrRow("reqNodeAddr", RESOURCE["reqNodeAddr"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    cTableAtom.addOption(RESOURCE["block"], 1);
    cTableAtom.addOption(RESOURCE["unblock"], 2);
    cTableAtomEle = cTableAtom.element;
    setSelectDisabled(cTableAtomEle);
    rightCTable.addAttrRow("wportstate", RESOURCE["wportstate"], cTableAtom);
    
    $("rightCTableDiv").appendChild(rightCTable.getTable());
}
/**
 *   ERPS    
 */
function queryERPSDetail(erpsid,isRPLOwnerFlag)
{
    if(!btnRight.querybtn.right)
    {
        alert(RESOURCE["RightUnvalid"]);
        return;
    }
    setBtnDisabled();
    
    var xml = queryERPSDetailXML(erpsid,isRPLOwnerFlag);
    
    var sfid = TECMDCODE_ERPS_GET_ENTITY_DETAIL_PORTSTATE;
    
    var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", true, queryERPSDetailBack, null, "inputdata=" + xml);
}
/**
 *   ERPS         
 */
function queryERPSDetailBack(doc)
{
    var holdoffTime = null;
    var wtrTime = null;
    var guardTime = null;
    var entityLevel = null;
    var sendInterval = null;
    var lastReqERPS = null;
    var erpsRB = null;
    var erpsDNF = null;
    var erpsFSMstate = null;
    var reqNodeAddr = null; 
    var eportstate = null;
    var wportstate = null;
    
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
    }

    if (0 != data.getDataRowLength())
    {
        holdoffTime = data.getDataRowParam(0, "holdoffTime");
        wtrTime = data.getDataRowParam(0, "wtrTime");
        guardTime = data.getDataRowParam(0, "guardTime");
        entityLevel = data.getDataRowParam(0, "entityLevel");
        sendInterval = data.getDataRowParam(0, "sendInterval");
        lastReqERPS = data.getDataRowParam(0, "lastReqERPS");
        erpsRB = data.getDataRowParam(0, "erpsRB");
        erpsDNF = data.getDataRowParam(0, "erpsDNF");
        erpsFSMstate = data.getDataRowParam(0, "erpsFSMstate");
        reqNodeAddr = data.getDataRowParam(0, "reqNodeAddr");
        eportstate = data.getDataRowParam(0, "eportstate");
        wportstate = data.getDataRowParam(0, "wportstate");
        
        leftCTable.setAttrValue("holdoffTime", holdoffTime);
        leftCTable.setAttrValue("guardTime", guardTime);
        leftCTable.setAttrValue("entityLevel", entityLevel);
        leftCTable.setAttrValue("erpsRB", erpsRB);
        leftCTable.setAttrValue("erpsFSMstate", erpsFSMstate);
        leftCTable.setAttrValue("eportstate", eportstate);
        
        rightCTable.setAttrValue("wtrTime", wtrTime);
        rightCTable.setAttrValue("sendInterval", sendInterval);
        rightCTable.setAttrValue("lastReqERPS", lastReqERPS);
        rightCTable.setAttrValue("erpsDNF", erpsDNF);
        rightCTable.setAttrValue("reqNodeAddr", convertMacAddr(reqNodeAddr));
        rightCTable.setAttrValue("wportstate", wportstate);
    }
        
    setBtnStatusOnRowSelect();
    
    for (var i = 0, len = erpsListTable.getDataRowLength(); i < len; i ++)
    {
        if (erpsListTable.getModify(i))
        {
            $("applybtn").disabled = false;
            break;
        }
    }
}
