/**
 *       js  
 *   :     00104334
 *   : 2009-01-14
 */
var winurlobj = getNeProperty(self);

var btnRight = null;

var erpsListTable = null;

var leftCTable = null;

var rightCTable = null;

var modifyFlagArray = [];

var selectedRowid = -1;
/**
 *      
 */
function initPage()
{
    initTopSortTable();
    initLeftCTable();
    initRightCTable();
    initButton();
    
    if (btnRight.querybtn.right)
    {
        queryERPS(); 
    }
    else
    {
    	$("querybtn").disabled = true;
    	$("applybtn").disabled = true;
    	$("deletebtn").disabled = true;
    	$("createbtn").disabled = true;
    }
}

/**
 *       
 */
function initTopSortTable()
{
    erpsListTable = new SortTable();
    
    erpsListTable.setImage("../../../../../images/");
    
    erpsListTable.setBodyHeight(300);  
    
    erpsListTable.setSingleChoiceFlg(true);

    createTableHead(erpsListTable, window.tableconf[0]);
    
    erpsListTable.setOnRowSelectHandler(rowSelectHandler);

    erpsListTable.setOnCellEditHandler(cellEditHandler);
    
    $("erpsListTableDiv").appendChild(erpsListTable.getTable()); 
}

/**
 *          
 */
function initLeftCTable()
{
    leftCTable = new CTable();
    
    var cTableAtom = null;
    
    var cTableAtomEle = null;
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element; 
    textCheckWithStepLen(cTableAtomEle, HOLDOFF_TIME_MIN, HOLDOFF_TIME_MAX, HOLDOFF_TIME_STEP_LEN);

    EventUtil.addEventHandler(cTableAtomEle, "blur", changeHoldoffTime);
    function changeHoldoffTime()
    {
        setModifyFlag("holdoffTime");
        if (erpsListTable.getDataRowLength() > 0)
        {
            $("applybtn").disabled = false;
        }
    }
    leftCTable.addAttrRow("holdoffTime", RESOURCE["holdoffTime"], cTableAtom); 
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element; 
    textCheckWithStepLen(cTableAtomEle, GUARD_TIME_MIN, GUARD_TIME_MAX, GUARD_TIME_STEP_LEN);
    EventUtil.addEventHandler(cTableAtomEle, "blur", changeGuardTime);
    function changeGuardTime()
    {
        setModifyFlag("guardTime");
        if (erpsListTable.getDataRowLength() > 0)
        {
            $("applybtn").disabled = false;
        }
    }
    leftCTable.addAttrRow("guardTime", RESOURCE["guardTime"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    for (var i = 0, len = ENTITY_MAX_COUNT; i < len; i ++)
    {
        cTableAtom.addOption(i, i);
    }
    cTableAtomEle = cTableAtom.element; 
    cTableAtomEle.onchange = function()
    {
        setModifyFlag("entityLevel");
        if (erpsListTable.getDataRowLength() > 0)
        {
            $("applybtn").disabled = false;
        }
    }
    leftCTable.addAttrRow("entityLevel", RESOURCE["entityLevel"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    for (var i = 0, len = ERPS_RB.length; i < len; i ++)
    {
        cTableAtom.addOption(ERPS_RB[i], i);
    }
    cTableAtomEle = cTableAtom.element; 
    setSelectDisabled(cTableAtomEle);
    leftCTable.addAttrRow("erpsRB", RESOURCE["erpsRB"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    for (var i = 0, len = ERPS_FSM_STATE.length; i < len; i ++)
    {
        cTableAtom.addOption(ERPS_FSM_STATE[i], i);
    }
    cTableAtomEle = cTableAtom.element; 
    setSelectDisabled(cTableAtomEle);
    leftCTable.addAttrRow("erpsFSMstate", RESOURCE["erpsFSMstate"], cTableAtom); 
    
    $("leftCTableDiv").appendChild(leftCTable.getTable());
}

/**
 *          
 */
function initRightCTable()
{
    rightCTable = new CTable();
    
    var cTableAtom = null;
    
    var cTableAtomEle = null;
    
    cTableAtom = new Atom("select");
    cTableAtom.addOption("05:00", 5);
    cTableAtom.addOption("06:00", 6);
    cTableAtom.addOption("07:00", 7);
    cTableAtom.addOption("08:00", 8);
    cTableAtom.addOption("09:00", 9);
    cTableAtom.addOption("10:00", 10);
    cTableAtom.addOption("11:00", 11);
    cTableAtom.addOption("12:00", 12);
    cTableAtomEle = cTableAtom.element; 
    EventUtil.addEventHandler(cTableAtomEle, "change", changeWtrTime);
    function changeWtrTime()
    {
        setModifyFlag("wtrTime");
        if (erpsListTable.getDataRowLength() > 0)
        {
            $("applybtn").disabled = false;
        }
    }
    rightCTable.addAttrRow("wtrTime", RESOURCE["wtrTime"], cTableAtom); 
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element; 
    if (winurlobj["neType"] == 67)
    {
    	checkText(cTableAtomEle, "1", "10");
    }
    else
    {
        checkText(cTableAtomEle, SEND_INTERVAL_MIN, SEND_INTERVAL_MAX);
    }
    EventUtil.addEventHandler(cTableAtomEle, "blur", changeSendInterval);
    function changeSendInterval()
    {
        setModifyFlag("sendInterval");
        if (erpsListTable.getDataRowLength() > 0)
        {
            $("applybtn").disabled = false;
        }
    }

    rightCTable.addAttrRow("sendInterval",  RESOURCE["sendInterval"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    for (var i = 1, len = LAST_REQ_ERPS.length; i < len; i ++)
    {
        cTableAtom.addOption(LAST_REQ_ERPS[i], i);
    }
    cTableAtomEle = cTableAtom.element; 
    setSelectDisabled(cTableAtomEle);
    rightCTable.addAttrRow("lastReqERPS", RESOURCE["lastReqERPS"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    for (var i = 0, len = ERPS_DNF.length; i < len; i ++)
    {
        cTableAtom.addOption(ERPS_DNF[i], i);
    }
    cTableAtomEle = cTableAtom.element; 
    setSelectDisabled(cTableAtomEle);
    rightCTable.addAttrRow("erpsDNF", RESOURCE["erpsDNF"], cTableAtom); 
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element; 
    setSelectDisabled(cTableAtomEle);
    rightCTable.addAttrRow("reqNodeAddr", RESOURCE["reqNodeAddr"], cTableAtom); 
    
    $("rightCTableDiv").appendChild(rightCTable.getTable());
}

/**
 *      
 */
function initButton()
{
	$("querybtn").value =  RESOURCE["querybutton"];
	$("createbtn").value = RESOURCE["newbutton"];
	$("deletebtn").value = RESOURCE["deletebutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	$("printbtn").value = RESOURCE["printbutton"];
	
	$("querybtn").onclick = queryERPS;
	$("createbtn").onclick = createERPS;
	$("deletebtn").onclick = deleteERPS;
	$("applybtn").onclick = modifyERPS;
	$("printbtn").onclick = doPrint;
	
	$("applybtn").disabled = true;
	
	getAllBtnRight();
}

/**
 *         
 */
function getAllBtnRight()
{
    btnRight = new Object;
    
    btnRight.querybtn = new BtnRightObj("querybtn", TECMDCODE_ERPS_GET_ENTITY);    
    btnRight.createbtn = new BtnRightObj("createbtn", TECMDCODE_ERPS_CRT_ENTITY);
    btnRight.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_ERPS_DEL_ENTITY);
    btnRight.applybtn = new BtnRightObj("applybtn", TECMDCODE_ERPS_MODIFY_ENTITY);
    btnRight.printbtn = new BtnRightObj("printbtn", TECMDCODE_ERPS_GET_ENTITY);
    
    getRightInfo(winurlobj, btnRight);      
    
    initrightbtn(btnRight);
}

/**
 *   ERPS  
 */
function queryERPS()
{
    if(!btnRight.querybtn.right)
    {
        alert(RESOURCE["RightUnvalid"]);
        return;
    }
    setBtnDisabled();
    
    var xml = queryERPSXML();
    
    var sfid = TECMDCODE_ERPS_GET_ENTITY;
    
    var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", false, queryERPSBack, null, "inputdata=" + xml);

}

/**
 *     ERPS XML  
 */
function queryERPSXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var AID = "";
    var ntfcncde = null;
    var almtype = null;
    var almmsg = "";
    var defaultstate = "";
    
    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", winurlobj["slotid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "erpsid");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    business.appendChild(row);
    
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *   ERPS    
 */
function queryERPSBack(doc)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    var btnIDArr = null;
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
    }
    else
    {
        erpsListTable.clearTableData();
        
        createTableBody(erpsListTable, window.tableconf[0], data, RESOURCE);
        
        adjustToCurrSortStatus();  
    }

    if (0 == erpsListTable.getSelectedRowCount() && 0 != erpsListTable.getDataRowLength())
    {
		if(-1 == selectedRowid)
		{
			erpsListTable.setRowSelect(0);
		}
		else
		{
			erpsListTable.setRowSelect(selectedRowid);
		}
        
        rowSelectHandler();
    }
    else
    {
        setBtnStatusOnRowSelect();
    }  
    
    queryERPSDetailForRefresh(); 
}

/**
 *          
 */
function adjustToCurrSortStatus()
{
    if(!erpsListTable.element.colsArray.selectedId)
    {
  	   erpsListTable.element.colsArray.selectedId = "erpsid";
  	   erpsListTable.element.colsArray.imgflag = 1;
    }
    
    var td = erpsListTable.element.headRow.element.cols[erpsListTable.element.colsArray.selectedId].element; 
    erpsListTable.sortRows(td, erpsListTable.element.colsArray.imgflag);
}

/**
 *              
 */
function cellEditHandler(param)
{
	var cell = null;
	
	if (param.colid == "ctrlVlan")
	{
		cell = erpsListTable.getCell(param.rowindex, "ctrlVlan");	
		textCheck(cell.element.editElement.element, CTRL_VLAN_MIN, CTRL_VLAN_MAX);
		$("applybtn").disabled = false;
	}
}

var selectedErpsid = -1;
/**
 *        
 */
function rowSelectHandler(param)
{
	var updateDetail = false;
	if("undefined" == typeof(param))
	{
		updateDetail = true;
	}
    clearModifyFlag();
    setBtnStatusOnRowSelect();
    var selectedRows = erpsListTable.getSelectedRows();
    $("selrows").innerHTML = selectedRows.length;
	$("totalrows").innerHTML = erpsListTable.getDataRowLength();   
	
    if (0 == selectedRows.length)
    {
    	selectedErpsid = -1;
        clearERPSDetail();
        return;
    }
    var rowid = selectedRows[0];
	selectedRowid = rowid;
    var erpsid = erpsListTable.getCellStoreValue(rowid, "erpsid", "erpsid");
    if(updateDetail || selectedErpsid != erpsid)
    {
    	selectedErpsid = erpsid;
	    clearERPSDetail();
	    var isRPLOwnerFlag = erpsListTable.getCellStoreValue(rowid, "isRPLOwnerFlag", "isRPLOwnerFlag");
	    queryERPSDetail(erpsid,isRPLOwnerFlag);
  	}
}

/**
 *         
 */
function clearERPSDetail()
{
    leftCTable.setAttrValue("holdoffTime", "");
    leftCTable.setAttrValue("guardTime", "");
    leftCTable.setAttrValue("entityLevel", "");
    leftCTable.setAttrValue("erpsRB", "");
    leftCTable.setAttrValue("erpsFSMstate", "");
    
    rightCTable.setAttrValue("wtrTime", "");
    rightCTable.setAttrValue("sendInterval", "");
    rightCTable.setAttrValue("lastReqERPS", "");
    rightCTable.setAttrValue("erpsDNF", "");
    rightCTable.setAttrValue("reqNodeAddr", "");
}

/**
 *   ERPS    
 */
function queryERPSDetail(erpsid,isRPLOwnerFlag)
{
    if(!btnRight.querybtn.right)
    {
        alert(RESOURCE["RightUnvalid"]);
        return;
    }
    setBtnDisabled();
    
    var xml = queryERPSDetailXML(erpsid,isRPLOwnerFlag);
    
    var sfid = TECMDCODE_ERPS_GET_ENTITY_DETAIL;
    
    var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", true, queryERPSDetailBack, null, "inputdata=" + xml);
    
}

/**
 *     ERPS    XML  
 */
function queryERPSDetailXML(erpsid,isRPLOwnerFlag)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var AID = "";
    var ntfcncde = null;
    var almtype = null;
    var almmsg = "";
    var defaultstate = "";
    
    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", winurlobj["slotid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "erpsid");
    param.setAttribute("value", erpsid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "isRPLOwnerFlag");
    param.setAttribute("value", isRPLOwnerFlag);
    row.appendChild(param);
    
    business.appendChild(row);
    
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *   ERPS         
 */
function queryERPSDetailBack(doc)
{
    var holdoffTime = null;
    var wtrTime = null;
    var guardTime = null;
    var entityLevel = null;
    var sendInterval = null;
    var lastReqERPS = null;
    var erpsRB = null;
    var erpsDNF = null;
    var erpsFSMstate = null;
    var reqNodeAddr = null; 
    
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
    }
        if (0 != data.getDataRowLength())
        {
            holdoffTime = data.getDataRowParam(0, "holdoffTime");
            wtrTime = data.getDataRowParam(0, "wtrTime");
            guardTime = data.getDataRowParam(0, "guardTime");
            entityLevel = data.getDataRowParam(0, "entityLevel");
            sendInterval = data.getDataRowParam(0, "sendInterval");
            lastReqERPS = data.getDataRowParam(0, "lastReqERPS");
            erpsRB = data.getDataRowParam(0, "erpsRB");
            erpsDNF = data.getDataRowParam(0, "erpsDNF");
            erpsFSMstate = data.getDataRowParam(0, "erpsFSMstate");
            reqNodeAddr = data.getDataRowParam(0, "reqNodeAddr");
            
            leftCTable.setAttrValue("holdoffTime", holdoffTime);
            leftCTable.setAttrValue("guardTime", guardTime);
            leftCTable.setAttrValue("entityLevel", entityLevel);
            leftCTable.setAttrValue("erpsRB", erpsRB);
            leftCTable.setAttrValue("erpsFSMstate", erpsFSMstate);
            
            rightCTable.setAttrValue("wtrTime", wtrTime);
            rightCTable.setAttrValue("sendInterval", sendInterval);
            rightCTable.setAttrValue("lastReqERPS", lastReqERPS);
            rightCTable.setAttrValue("erpsDNF", erpsDNF);
            rightCTable.setAttrValue("reqNodeAddr", convertMacAddr(reqNodeAddr));
        }
    setBtnStatusOnRowSelect();
    
    for (var i = 0, len = erpsListTable.getDataRowLength(); i < len; i ++)
    {
        if (erpsListTable.getModify(i))
        {
            $("applybtn").disabled = false;
            break;
        }
    }
}

/**
 *   ERPS  
 */
function modifyERPS()
{
    if(!btnRight.applybtn.right)
    {
        alert(RESOURCE["RightUnvalid"]);
        return;
    }
    setBtnDisabled();
    
    var xml = modifyERPSXML();
    
    var sfid = TECMDCODE_ERPS_MODIFY_ENTITY;
    
    var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", false, modifyERPSBack, null, "inputdata=" + xml);
    
}

/**
 *     ERPS   XML  
 */
function modifyERPSXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var AID = "";
    var ntfcncde = null;
    var almtype = null;
    var almmsg = "";
    var defaultstate = "";
    var selectedRows = erpsListTable.getSelectedRows();
    var cellModifyFlag = false;
        
    for (var i = 0, len = erpsListTable.getDataRowLength(); i < len; i ++)
    {
        if (i != selectedRows[0] && !erpsListTable.getModify(i))
        {
            continue;
        }
        
        row = new tagElement("row-params");
    
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winurlobj["neid"]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", winurlobj["slotid"]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "erpsid");
        param.setAttribute("value", erpsListTable.getCellStoreValue(i, "erpsid", "erpsid"));
        row.appendChild(param);
        
        cellModifyFlag = erpsListTable.getModify(i, "ctrlVlan");
        if (cellModifyFlag && 0 != selectedRows.length )
        {
            param = new tagElement("param");
            param.setAttribute("name", "ctrlVlan");
            param.setAttribute("value", erpsListTable.getCellStoreValue(i, "ctrlVlan", "ctrlVlan"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "desMacAddr");
            param.setAttribute("value", erpsListTable.getCellStoreValue(i, "desMacAddr", "desMacAddr"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "desMacAddrLog");
            param.setAttribute("value", erpsListTable.getCellShow(i, "desMacAddr").getValue());
            row.appendChild(param);
        }
        
        if (i == selectedRows[0])
        {
            if (modifyFlagArray["holdoffTime"])
            {
                param = new tagElement("param");
                param.setAttribute("name", "holdoffTime");
                param.setAttribute("value", leftCTable.getAttrValue("holdoffTime"));
                row.appendChild(param);
            }
            
            if (modifyFlagArray["guardTime"])
            {
                param = new tagElement("param");
                param.setAttribute("name", "guardTime");
                param.setAttribute("value", leftCTable.getAttrValue("guardTime"));
                row.appendChild(param);
            }
            
            if (modifyFlagArray["wtrTime"])
            {
                param = new tagElement("param");
                param.setAttribute("name", "wtrTime");
                param.setAttribute("value", rightCTable.getAttrValue("wtrTime"));
                row.appendChild(param);
            }

            if ( modifyFlagArray["sendInterval"] || modifyFlagArray["entityLevel"] )
            {
                param = new tagElement("param");
                param.setAttribute("name", "sendInterval");
                param.setAttribute("value", rightCTable.getAttrValue("sendInterval"));
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "entityLevel");
                param.setAttribute("value", leftCTable.getAttrValue("entityLevel"));
                row.appendChild(param);
            }

        }

        business.appendChild(row);
    }
    
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *   ERPS     
 */
function modifyERPSBack(doc)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
        $("applybtn").disabled = true;
    }
    else
    {
        refreshTableState(erpsListTable, window.tableconf[0], data);
    }
    setBtnStatusOnRowSelect();
}

/**
 *   ERPS
 */
function deleteERPS()
{
    if(!btnRight.deletebtn.right)
    {
        alert(RESOURCE["RightUnvalid"]);
        return;
    }
    
    var selectedRows = erpsListTable.getSelectedRows();
    
	if (0 == selectedRows.length)
	{
	    alert(RESOURCE["ID_SELECT"]);
		return;
	}
	
	if (!confirm(RESOURCE["ID_DELSURE"]))
	{
		return;
	}
	
	var rowid = selectedRows[0];
	var erpsid = erpsListTable.getCellStoreValue(rowid, "erpsid", "erpsid");
    setBtnDisabled();
    
    var xml = deleteERPSXML(erpsid);
    
    var sfid = TECMDCODE_ERPS_DEL_ENTITY;
    
    var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", false, deleteERPSBack, rowid, "inputdata=" + xml);
    
}

/**
 *     ERPS XML  
 */
function deleteERPSXML(erpsid)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var AID = "";
    var ntfcncde = null;
    var almtype = null;
    var almmsg = "";
    var defaultstate = "";
    
    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", winurlobj["slotid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "erpsid");
    param.setAttribute("value", erpsid);
    row.appendChild(param);
    
    business.appendChild(row);
    
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *   ERPS     
 */
function deleteERPSBack(doc, rowid)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
    }
    else
    {
        erpsListTable.deleteRow(rowid);
        erpsListTable.adjustDataRows();
        
        if (0 < erpsListTable.getDataRowLength())
        {
            erpsListTable.setRowSelect(0);
        }
        rowSelectHandler();
    }
    setBtnStatusOnRowSelect();
}

/**
 *     ERPS   
 */
function createERPS()
{
    var applybtnStatus = $("applybtn").disabled;
    setBtnDisabled();
    var URL = "../erps/erpscreate.html?neid=" + winurlobj["neid"] + "&nmUser=" + winurlobj["nmUser"] + "&slotid=" + winurlobj["slotid"];
    xshowModalDialog(URL, RESOURCE["createERPS"], 500, 260, "../../../../../images/");
    setBtnStatusOnRowSelect();
    $("applybtn").disabled = applybtnStatus;
}

/**
 *   
 */
function doPrint()
{
    openPrintPage("../../../../../page/", RESOURCE["erpsMgr"], "erpsListTable", true, winurlobj["nmUserName"]);
}

/**
 *        
 */
function showErrorDialog(data, errArr)
{
    var errorArray = null;
    if (null == errArr)
    {
        errorArray = new Array();
        errorArray.push("nename");
        errorArray.push("slotid");
        errorArray.push("boardname");
        errorArray.push("erpsid");

    }
    else
    {
        errorArray = errArr;
    }
    
    openErrPage("../../../../../page/", data.getError(), errorArray); 
}

/**
 *              
 */
window.onresize=function()
{
    erpsListTable.setBodyHeight(getTableHeight($("erpsListTableDiv"), erpsListTable) * 0.9 + "px");
}

/**
 *              
 */
function setModifyFlag(objName)
{
    modifyFlagArray[objName] = true;
}

/**
 *              
 */
function clearModifyFlag()
{
    modifyFlagArray["holdoffTime"] = false;
    modifyFlagArray["guardTime"] = false;
    modifyFlagArray["entityLevel"] = false;
    modifyFlagArray["wtrTime"] = false;
    modifyFlagArray["sendInterval"] = false;
}

/**
 *       
 */
function setBtnDisabled()
{
	$("querybtn").disabled = true;
    $("printbtn").disabled = true;
    $("createbtn").disabled = true;
    $("applybtn").disabled = true;
    $("deletebtn").disabled = true;
    
    var atom = leftCTable.getAtom("holdoffTime");
    setSelectDisabled(atom.element)
    
    atom = leftCTable.getAtom("guardTime");
    setSelectDisabled(atom.element)
    
    atom = leftCTable.getAtom("entityLevel");
    setSelectDisabled(atom.element)

    atom = rightCTable.getAtom("wtrTime");
    setSelectDisabled(atom.element)
    
    atom = rightCTable.getAtom("sendInterval");
    setSelectDisabled(atom.element)
}

/**
 *              
 */
function setBtnStatusOnRowSelect()
{
    var selectedRows = erpsListTable.getSelectedRows();
    if (0 == selectedRows.length)
    {
        $("querybtn").disabled = !btnRight.querybtn.right;
        $("printbtn").disabled = !btnRight.printbtn.right;
        
        $("createbtn").disabled = !btnRight.createbtn.right;
        $("deletebtn").disabled = true;
    }
    else
    {
        $("querybtn").disabled = !btnRight.querybtn.right;
        $("printbtn").disabled = !btnRight.printbtn.right;
        
        $("createbtn").disabled = !btnRight.createbtn.right;
        $("deletebtn").disabled = !btnRight.deletebtn.right;
    }
    if (0 >= selectedRows.length) 
	{
    	setSelectDisabled(leftCTable.getAtom("holdoffTime").element);
    	setSelectDisabled(leftCTable.getAtom("guardTime").element);
    	setSelectDisabled(leftCTable.getAtom("entityLevel").element);
    	setSelectDisabled(rightCTable.getAtom("sendInterval").element);
    	setSelectDisabled(rightCTable.getAtom("wtrTime").element);
	}
	else 
	{
		var atom = leftCTable.getAtom("holdoffTime");
		setSelectEnabled(atom.element);
		
		atom = leftCTable.getAtom("guardTime");
		setSelectEnabled(atom.element);
		
		atom = leftCTable.getAtom("entityLevel");
		setSelectEnabled(atom.element);
		
		atom = rightCTable.getAtom("sendInterval");
		setSelectEnabled(atom.element);
		
		var isRPLOwnerFlag = null;
		atom = rightCTable.getAtom("wtrTime");
		if (0 != selectedRows.length) 
		{
			isRPLOwnerFlag = erpsListTable.getCellStoreValue(selectedRows[0], "isRPLOwnerFlag", "isRPLOwnerFlag");
			if (RPL_OWNER_FLAG_VALUE[0] == isRPLOwnerFlag) 
			{
				atom.element.value = "-";
				setSelectDisabled(atom.element);
			}
			else 
			{
				setSelectEnabled(atom.element);
			}
		}
		else 
		{
			setSelectEnabled(atom.element);
		}
	}
}

/**
 *   wtrTime     
 */
function setWtrTimeStatus()
{
    var selectedRows = erpsListTable.getSelectedRows();
    var isRPLOwnerFlag = erpsListTable.getCellStoreValue(selectedRows[0], "isRPLOwnerFlag", "isRPLOwnerFlag");
    if (RPL_OWNER_FLAG_VALUE[0] == isRPLOwnerFlag)
    {
        var atom = rightCTable.getAtom("wtrTime");
        atom.element.value="-";
        setSelectDisabled(atom.element);        
    }
}

/*
remove sorttable after page unload
user may override this function
*/
window.onunload=function()
{
    if(typeof(erpsListTable)!='undefined' && erpsListTable instanceof SortTable)
    {
		clearSortTable(erpsListTable);
	}
}

/**
 *   ERPS    
 */
function queryERPSDetailForRefresh()
{
    var xml = queryERPSDetailXMLForRefresh();
    
    if (null == xml)
    {
    	return;
    }
    
    var sfid = TECMDCODE_ERPS_GET_ENTITY_DETAIL;
    
    var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", true, queryERPSDetailBackForRefresh, null, "inputdata=" + xml);
}

/**
 *   ERPS         
 */
function queryERPSDetailBackForRefresh(doc)
{
}

/**
 *     ERPS    XML  
 */
function queryERPSDetailXMLForRefresh(erpsidCreate)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var AID = "";
    var ntfcncde = null;
    var almtype = null;
    var almmsg = "";
    var defaultstate = "";
    
    var isFondCreate = false;
    for (var i = 0, len = erpsListTable.getDataRowLength(); i < len; i ++)
    {
    	var erpsid = erpsListTable.getCellStoreValue(i, "erpsid", "erpsid");
    	
    	if (null != erpsidCreate)
    	{
    		if (erpsid != erpsidCreate)
    		{
    			continue;
    		}
    		else
    	  {
    	  	isFondCreate = true;
    		}
    	}
    	
    	var isRPLOwnerFlag = erpsListTable.getCellStoreValue(i, "isRPLOwnerFlag", "isRPLOwnerFlag");
    	
    	row = new tagElement("row-params");
    
	    param = new tagElement("param");
	    param.setAttribute("name", "neid");
	    param.setAttribute("value", winurlobj["neid"]);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "slotid");
	    param.setAttribute("value", winurlobj["slotid"]);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "erpsid");
	    param.setAttribute("value", erpsid);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "isRPLOwnerFlag");
	    param.setAttribute("value", isRPLOwnerFlag);
	    row.appendChild(param);
    
    	business.appendChild(row);
    }
    
    root.getRoot().appendChild(business);
    
    if ((null != erpsidCreate) && !isFondCreate)
    {
    	return null;
    }
    else
    {
    	return root.toString();
    }
}
/**
 * Firefox   Select              
 *       
 * @param obj
 * @return
 */
function setSelectDisabled(obj)
{
	obj.disabled = true;
	obj.style.color = "#6D6D6D";
}

/**
 * Firefox   Select              
 *       
 * @param obj
 * @return
 */
function setSelectEnabled(obj)
{
	obj.disabled = false;
	obj.style.color = "";
}
