
var winurlobj = getNeProperty(self);
var win = getParentWindow();

var btnRight = null;

var elpsTable = null;

var WorkMDList = [];
var ProtectMDList = [];

var parentWindowSelectObject = null;

document.title = RESOURCE["setElpsOAM"];

var INVALID_MD_ID = "4294967295";

/**
 *      
 */
function initPage()
{
	parentWindowSelectObject = win.getElpsSelectedObject();
	
	initButton();

    initTable();
    
    initOAM();
}

/**
 *      
 */
function initTable()
{
    elpsTable = new CTable();
    
    elpsTable.addHead(RESOURCE["ATTR"],RESOURCE["VALUE"]);
    
    addELPSIDAttr(elpsTable);
    
    addWorkPortAttr(elpsTable);
    
    addProtectPortAttr(elpsTable);
    
    $("elpsTableDiv").appendChild(elpsTable.getTable());
    
    
}

/**
 *   ELPSID   
 * @param table
 **/
function addELPSIDAttr(/*CTable*/table)
{
    var cTableAtom = new Atom("text");
    cTableAtom.setValue(parentWindowSelectObject.elpsid);
    cTableAtom.element.disabled = true; 
    table.addAttrRow("elpsid", RESOURCE["elpsid"], cTableAtom); 
}

/**
 *          
 * @param table
 **/
function addWorkPortAttr(/*CTable*/table)
{
    var cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element; 
    cTableAtomEle.onchange = function()
    {
    	var md = getMDFromList(WorkMDList,this.value);
    	mdOnchange("w",md);
    	resumeBtnStatus();
    }
    table.addAttrRow("wmd", RESOURCE["workMD"], cTableAtom);
    
    cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element; 
    cTableAtomEle.onchange = function()
    {
    	var md = getMDFromList(ProtectMDList,elpsTable.getAttrValue("wmd"));
    	var ma = getMAFromList(md.malist,this.value);
    	maOnChange("w",ma);
    	resumeBtnStatus();
    }
    table.addAttrRow("wma", RESOURCE["workMA"], cTableAtom);
    
    cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element; 
    cTableAtomEle.onchange = resumeBtnStatus;
    table.addAttrRow("wmpid", RESOURCE["workMPID"], cTableAtom);  
}

/**
 *          
 * @param table
 **/
function addProtectPortAttr(/*CTable*/table)
{
    cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element; 
    cTableAtomEle.onchange = function()
    {
    	var md = getMDFromList(ProtectMDList,this.value);
    	mdOnchange("p",md);
    	
    	resumeBtnStatus();
    }
    table.addAttrRow("pmd", RESOURCE["protectMD"], cTableAtom);
    
    cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element; 
    cTableAtomEle.onchange = function()
    {
    	var md = getMDFromList(ProtectMDList,elpsTable.getAttrValue("pmd"));
    	var ma = getMAFromList(md.malist,this.value);
    	maOnChange("p",ma);
    	resumeBtnStatus();
    }
    table.addAttrRow("pma", RESOURCE["protectMA"], cTableAtom);
    
    cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element; 
    cTableAtomEle.onchange = resumeBtnStatus;
    table.addAttrRow("pmpid", RESOURCE["protectMPID"], cTableAtom);  
}

/**
 * md      
 * @param profix
 * @param md
 */
function mdOnchange(/*String*/profix,/*String*/md)
{
	var elm = elpsTable.getAtom(profix + "ma").element;
	elm.options.length = 0;

	var maList = md.malist;

	for(var i = 0, len = maList.length; i < len; i++)
	{
		elm.options.add(new Option(maList[i].maname,maList[i].maid));
	}

	maOnChange(profix,maList[0]);
}

/**
 * Ma      
 * @param profix
 * @param md
 */
function maOnChange(/*String*/profix,/*String*/ma)
{
	var elm = elpsTable.getAtom(profix + "mpid").element;
	elm.options.length = 0;
	var mplist = ma.mplist;
	for(var i = 0, len = mplist.length; i < len; i++)
	{
		elm.options.add(new Option(convertMPID(mplist[i]),mplist[i]));
	}
	
}

/**
 *   MD   List 
 * @param mdlist
 * @param mdid
 */
function getMDFromList(/*Array*/mdlist,/*String*/mdid)
{
	for(var i = 0,len = mdlist.length;i < len;i++)
	{
		if(mdlist[i].mdid == mdid)
		{
			return mdlist[i];
		}
	}
	return null;
}

/**
 *   MA   List 
 * @param mdlist
 * @param mdid
 */
function getMAFromList(/*Array*/malist,/*String*/maid)
{
	for(var i = 0,len = malist.length;i < len;i++)
	{
		if(malist[i].maid == maid)
		{
			return malist[i];
		}
	}
	return null;
}

/**
 *       
 */
function resumeBtnStatus()
{
	$("okbtn").disabled = false;
    $("applybtn").disabled = false;
}

/**
 *      
 */
function initButton()
{
	$("okbtn").value =  RESOURCE["okbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	$("cancelbtn").value = RESOURCE["cancelbutton"];
	$("applybtn").disabled = true;
}

/**
 *      OAM  
 */
function initOAM()
{
    getAvailableResList();
}

/**
 *   ERPS
 */
function setELPSOAM(/*boolean*/okFlag)
{
    if (okFlag && $("applybtn").disabled)
    {
        xcloseDialog();
        return;
    }
    else
    {
    	if(elpsTable.getAttrValue("wmd") == ""
    		|| elpsTable.getAttrValue("pmd") == "")
    	{
    		alert(RESOURCE["inputwrong"]);
    		return;
    	}
    	if(elpsTable.getAttrValue("wmd") != elpsTable.getAttrValue("pmd") 
    		&& (INVALID_MD_ID == elpsTable.getAttrValue("wmd") 
    		|| INVALID_MD_ID == elpsTable.getAttrValue("pmd")))
    	{
    		alert(RESOURCE["oamnotsame"]);
    		return;
    	}
    	parentWindowSelectObject = win.getElpsSelectedObject();
        setBtnDisabled(true);
        var xml = createSetELPSOAMXML();
        if(xml == null)
        {
        	if(okFlag)
        	{
        		xcloseDialog();
        	}
        	setBtnDisabled(false);
        	$("applybtn").disabled = true;
        	return;
        }

        var URL = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_ELPS_OAM +"&nmUser=" + winurlobj["nmUser"];
       	loadXMLdoc(URL, "POST", false, createSetELPSOAMBack, okFlag, "inputdata=" + xml);
    }
}

/**
 *     ERPS XML  
 */
function createSetELPSOAMXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    
    var wmd = elpsTable.getAttrValue("wmd");
    var wma = elpsTable.getAttrValue("wma");
    var wmep = elpsTable.getAttrValue("wmpid");
    
    var pmd = elpsTable.getAttrValue("pmd");
    var pma = elpsTable.getAttrValue("pma");
    var pmep = elpsTable.getAttrValue("pmpid");
    if(parentWindowSelectObject.wmd == wmd
    	&& parentWindowSelectObject.wma == wma
    	&& parentWindowSelectObject.wmpid == wmep
    	&& parentWindowSelectObject.pmd == pmd
    	&& parentWindowSelectObject.pma == pma
    	&& parentWindowSelectObject.pmpid == pmep)
    {
    	return null;
    }
    
    row = new tagElement("row-params");
    row.appendChild(new tagElement("param","neid",winurlobj["neid"]));
    row.appendChild(new tagElement("param","slotid",winurlobj["slotid"]));
    row.appendChild(new tagElement("param","boardname",win.currentBoardName));
    row.appendChild(new tagElement("param","groupid",elpsTable.getAttrValue("elpsid")));

    row.appendChild(new tagElement("param","wmd",wmd));
    var elm = elpsTable.getAtom("wmd").element;
    row.appendChild(new tagElement("param","wmdname",elm.options[elm.selectedIndex].text));
    row.appendChild(new tagElement("param","wma",wma));
    elm = elpsTable.getAtom("wma").element;
    row.appendChild(new tagElement("param","wmaname",elm.options[elm.selectedIndex].text));
    row.appendChild(new tagElement("param","wmep",wmep));
    elm = elpsTable.getAtom("wmpid").element;
    row.appendChild(new tagElement("param","wmepname",elm.options[elm.selectedIndex].text));
    
    row.appendChild(new tagElement("param","pmd",pmd));
    var elm = elpsTable.getAtom("pmd").element;
    row.appendChild(new tagElement("param","pmdname",elm.options[elm.selectedIndex].text));
    row.appendChild(new tagElement("param","pma",pma));
    elm = elpsTable.getAtom("pma").element;
    row.appendChild(new tagElement("param","pmaname",elm.options[elm.selectedIndex].text));
    row.appendChild(new tagElement("param","pmep",pmep));
    elm = elpsTable.getAtom("pmpid").element;
    row.appendChild(new tagElement("param","pmepname",elm.options[elm.selectedIndex].text));
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *   ERPS
 * @param doc
 * @param okFlag
 */
function createSetELPSOAMBack(/*XMLDOM*/doc, /*boolean*/okFlag)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATION_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
        setBtnDisabled(false);
    }
    else
    {
        win.forceQueryElpsOAM();
        $("okbtn").disabled = false;
        $("cancelbtn").disabled = false;
        $("applybtn").disabled = true;
        if (okFlag)
        {
            xcloseDialog();
            return;
        }
    }
}

/**
 *       
 */
function getAvailableResList()
{
    setBtnDisabled(true); 

    var xml = getAvailableResXML();
   	var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_GET_ELPS_OAM_RES+ "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", false, getAvailableResBack, null, "inputdata=" + xml);
}
/**
 *        XML
 */
function getAvailableResXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    
    row = new tagElement("row-params");
    param = new tagElement("param","neid",winurlobj["neid"]);
    row.appendChild(param);
    param = new tagElement("param","slotid",winurlobj["slotid"]);
    row.appendChild(param);
    param = new tagElement("param","wportid",parentWindowSelectObject.wportid);
    row.appendChild(param);
    param = new tagElement("param","wvlanid",parentWindowSelectObject.wvlanid);
    row.appendChild(param);
    
    param = new tagElement("param","pportid",parentWindowSelectObject.pportid);
    row.appendChild(param);
    param = new tagElement("param","pvlanid",parentWindowSelectObject.pvlanid);
    row.appendChild(param);
    
    business.appendChild(row);
    
    root.getRoot().appendChild(business);
    return root.toString();
}
/**
 *   MD,MA   
 * @param doc
 */
function getAvailableResBack(/*XMLDOM*/doc)
{
	WorkMDList= [{mdid:0xFFFFFFFF,mdname:"/",malist:[{maid:0xFFFFFFFF,maname:"/",mplist:["FFFFFFFF"]}]}];
	ProtectMDList = [{mdid:0xFFFFFFFF,mdname:"/",malist:[{maid:0xFFFFFFFF,maname:"/",mplist:["FFFFFFFF"]}]}];
	var data = EncapsulateData(doc);
	
	var wmdAtom = elpsTable.getAtom("wmd");
	var pmdAtom = elpsTable.getAtom("pmd");
	wmdAtom.addOption(WorkMDList[0].mdname,WorkMDList[0].mdid);
	pmdAtom.addOption(ProtectMDList[0].mdname,ProtectMDList[0].mdid);
	var wmaAtom = elpsTable.getAtom("wma");
	wmaAtom.addOption(WorkMDList[0].malist[0].maname,WorkMDList[0].malist[0].maid);
	var pmaAtom = elpsTable.getAtom("pma");
	pmaAtom.addOption(ProtectMDList[0].malist[0].maname,ProtectMDList[0].malist[0].maid);
	var wmpAtom = elpsTable.getAtom("wmpid");
	wmpAtom.addOption(convertMPID(WorkMDList[0].malist[0].mplist[0]),WorkMDList[0].malist[0].mplist[0]);
	var pmpAtom = elpsTable.getAtom("pmpid");
	pmpAtom.addOption(convertMPID(ProtectMDList[0].malist[0].mplist[0]),ProtectMDList[0].malist[0].mplist[0]);
	
	for(var i=0,size=data.getDataRowLength();i<size;i++)
	{
		var portid = data.getDataRowParam(i,"port");
		var vlanid = data.getDataRowParam(i,"vlanid");
		var mdid = data.getDataRowParam(i,"mdid");
		var mdname = data.getDataRowParam(i,"mdname");
		var maid = data.getDataRowParam(i,"maid");
		var maname = data.getDataRowParam(i,"maname");
		var mpid = data.getDataRowParam(i,"mpid");
		if(parentWindowSelectObject.wportid == portid 
			&& parentWindowSelectObject.wvlanid == vlanid)
		{
			wmdAtom.addOption(mdname,mdid);
			WorkMDList.push({mdid:mdid,mdname:mdname,malist:[{maid:maid,maname:maname,mplist:[mpid]}]});
		}
		if(parentWindowSelectObject.pportid == portid 
			&& parentWindowSelectObject.pvlanid == vlanid)
		{
			pmdAtom.addOption(mdname,mdid);
			ProtectMDList.push({mdid:mdid,mdname:mdname,malist:[{maid:maid,maname:maname,mplist:[mpid]}]});
		}
	}

	wmdAtom.setValue(parentWindowSelectObject.wmd);
	var md = getMDFromList(WorkMDList,elpsTable.getAttrValue("wmd"));
	mdOnchange("w",md);
	wmaAtom.setValue(parentWindowSelectObject.wma);
	var ma = getMAFromList(md.malist,elpsTable.getAttrValue("wma"));
	maOnChange("w",ma);
	wmpAtom.setValue(parentWindowSelectObject.wmpid);
	
	
	pmdAtom.setValue(parentWindowSelectObject.pmd);
	md = getMDFromList(ProtectMDList,elpsTable.getAttrValue("pmd"));
	mdOnchange("p",md);
	pmaAtom.setValue(parentWindowSelectObject.pma);
	ma = getMAFromList(md.malist,elpsTable.getAttrValue("pma"));
	maOnChange("p",ma);
	pmpAtom.setValue(parentWindowSelectObject.pmpid);
	
	setBtnDisabled(false); 
	var errArr = [];
	errArr[0] = "slotid";
	errArr[1] = "boardname";
	showErrorDialog(data, errArr);
}

/**
 *   MPID,          
 * @param mpid
 */
function convertMPID(/*String*/mpid)
{
	return win.convertMPID(mpid);
}


/**
 *     
 */
function doCancel()
{
    xcloseDialog();
}

/**
 *         
 * @param flag
 */
function setBtnDisabled(/*boolean*/flag)
{
    $("okbtn").disabled = flag;
    $("cancelbtn").disabled = flag
}

/**
 *        
 * @param data
 */
function showErrorDialog(/*Datainterface*/data)
{
    var errorArray = new Array();
    errorArray.push("nename");
    errorArray.push("slotid");
    errorArray.push("boardname");
    errorArray.push("groupid");
    openErrPage("../../../../../page/", data.getError(), errorArray); 
}
