
var winurlobj = getNeProperty(self);
var win = getParentWindow();

var btnRight = null;

var elpsTable = null;

document.title = RESOURCE["createELPS"];

/**
 *      
 */
function initPage()
{
	initButton();

    initTable();
    
    initPort();
}

/**
 *      
 */
function initTable()
{
    elpsTable = new CTable();
    
    elpsTable.addHead(RESOURCE["ATTR"],RESOURCE["VALUE"]);
    
    addELPSIDAttr(elpsTable);
    
    addELPSTypetAttr(elpsTable);
    
    addWorkPortAttr(elpsTable);
    
    addProtectPortAttr(elpsTable);
    
    addRevTimeAttr(elpsTable);
    
    addDelayTimeAttr(elpsTable);
    
    addAPSChannelAttr(elpsTable);

    addSwitchDirectionAttr(elpsTable);
    
    addRevModeAttr(elpsTable);
    
    $("elpsTableDiv").appendChild(elpsTable.getTable());
    elpstypeChange();
}

/**
 *   ELPSID   
 **/
function addELPSIDAttr(/*CTable*/table)
{
    var cTableAtom = new Atom("text");
    cTableAtom.setValue(win.getElpsAvailableID());
    var cTableAtomEle = cTableAtom.element; 
    checkText(cTableAtomEle, ELPS_ID_MIN, ELPS_ID_MAX);
    cTableAtomEle.onchange = resumeBtnStatus;
    table.addAttrRow("elpsid", RESOURCE["elpsid"], cTableAtom); 
}

/**
 *   ELPS    
 * @param table
 */
function addELPSTypetAttr(/*CTable*/table)
{
    var cTableAtom = new Atom("select");
    cTableAtom.addOption(GroupType[0], GROUP_TYPE_1J1_VALUE);
    cTableAtom.addOption(GroupType[1], GROUP_TYPE_1B1_VALUE);
    cTableAtom.setValue(GROUP_TYPE_1B1_VALUE);
    
    cTableAtom.element.disabled = true;
    var cTableAtomEle = cTableAtom.element; 
    cTableAtomEle.onchange = elpstypeChange;
    table.addAttrRow("grouptype", RESOURCE["grouptype"], cTableAtom); 
}

/**
 *            
 */
function elpstypeChange()
{
	var elpsType = elpsTable.getAttrValue("grouptype");
	var apschannelAtom = elpsTable.getAtom("apschannel");
	var switchdirectionAtom = elpsTable.getAtom("switchdirection");
	if(elpsType == GROUP_TYPE_1B1_VALUE)
	{
		apschannelAtom.setValue(APS_CHANNEL_HAVE_VALUE);
		switchdirectionAtom.setValue(SWITCH_DIRECTION_DOUBLE_VALUE);
		apschannelAtom.element.disabled = true;
		switchdirectionAtom.element.disabled = true;
	}
	else
	{
		apschannelAtom.setValue(APS_CHANNEL_NOHAVE_VALUE);
		switchdirectionAtom.setValue(SWITCH_DIRECTION_SINGLE_VALUE);
		apschannelAtom.element.disabled = false;
		switchdirectionAtom.element.disabled = false;
	}
}

/**
 *          
 * @param table
 **/
function addWorkPortAttr(/*CTable*/table)
{
    var cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element; 
    cTableAtomEle.onchange = resumeBtnStatus;
    table.addAttrRow("wPort", RESOURCE["workPort"], cTableAtom); 
    cTableAtom = new Atom("text");
    cTableAtom.setValue(VLAN_DEFATUL);
    var cTableAtomEle = cTableAtom.element; 
    textCheck(cTableAtomEle, VLAN_MIN, VLAN_MAX,null,win.INVALID_VLANID_SHOW);
    cTableAtomEle.onchange = resumeBtnStatus;
    table.addAttrRow("wvlanid", RESOURCE["workVLANID"], cTableAtom); 
}

/**
 *          
 * @param table
 **/
function addProtectPortAttr(/*CTable*/table)
{
    var cTableAtom = new Atom("select");
    var cTableAtomEle = cTableAtom.element; 
    cTableAtomEle.onchange = resumeBtnStatus;
    table.addAttrRow("pPort", RESOURCE["protectPort"], cTableAtom); 
    cTableAtom = new Atom("text");
    cTableAtom.setValue(VLAN_DEFATUL);
    var cTableAtomEle = cTableAtom.element; 
    textCheck(cTableAtomEle, VLAN_MIN, VLAN_MAX,null,win.INVALID_VLANID_SHOW);
    cTableAtomEle.onchange = resumeBtnStatus;
    table.addAttrRow("pvlanid", RESOURCE["protectVLANID"], cTableAtom);  
}

/**
 *          
 * @param table
 **/
function addRevTimeAttr(/*CTable*/table)
{
    var cTableAtom = new Atom("text");
    cTableAtom.setValue(WTRTIME_DEFAULT);
    var cTableAtomEle = cTableAtom.element;
    checkText(cTableAtomEle, WTRTIME_MIN, WTRTIME_MAX);
    cTableAtomEle.onchange = resumeBtnStatus;
    table.addAttrRow("revtime", RESOURCE["revtime"], cTableAtom); 
}

/**
 *          
 * @param table
 **/
function addDelayTimeAttr(/*CTable*/table)
{
    var cTableAtom = new Atom("text");
    cTableAtom.setValue(DELAYTIME_DEFAULT);
    var cTableAtomEle = cTableAtom.element; 
    checkText(cTableAtomEle, DELAYTIME_MIN, DELAYTIME_MAX);
    cTableAtomEle.onchange = resumeBtnStatus;
    table.addAttrRow("delaytime", RESOURCE["delaytime"], cTableAtom); 
}

/**
 *   APS     
 * @param table
 **/
function addAPSChannelAttr(/*CTable*/table)
{
    var cTableAtom = new Atom("select");
    cTableAtom.addOption(ApsChannel[0], APS_CHANNEL_NOHAVE_VALUE);
    cTableAtom.addOption(ApsChannel[1], APS_CHANNEL_HAVE_VALUE);
    var cTableAtomEle = cTableAtom.element; 
    cTableAtomEle.onchange = resumeBtnStatus;
    table.addAttrRow("apschannel", RESOURCE["apschannel"], cTableAtom); 
}

/**
 *          
 * @param table
 **/
function addSwitchDirectionAttr(/*CTable*/table)
{
    var cTableAtom = new Atom("select");
    cTableAtom.addOption(SwitchDirection[0], SWITCH_DIRECTION_SINGLE_VALUE);
    cTableAtom.addOption(SwitchDirection[1], SWITCH_DIRECTION_DOUBLE_VALUE);
    var cTableAtomEle = cTableAtom.element; 
    cTableAtomEle.onchange = resumeBtnStatus;
    table.addAttrRow("switchdirection", RESOURCE["switchdirection"], cTableAtom); 
}

/**
 *          
 * @param table
 **/
function addRevModeAttr(/*CTable*/table)
{
    var cTableAtom = new Atom("select");
    cTableAtom.addOption(RevMode[0], NONREVERTIVEMODE);
    cTableAtom.addOption(RevMode[1], REVERTIVEMODE);
    var cTableAtomEle = cTableAtom.element; 
    cTableAtomEle.onchange = resumeBtnStatus;
    table.addAttrRow("revmode", RESOURCE["revmode"], cTableAtom); 
}

/**
 *       
 */
function resumeBtnStatus()
{
	$("okbtn").disabled = false;
    $("applybtn").disabled = false;
}

/**
 *      
 */
function initButton()
{
	$("okbtn").value =  RESOURCE["okbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	$("cancelbtn").value = RESOURCE["cancelbutton"];
}

/**
 *        
 */
function initPort()
{
    getPortList();
}

/**
 *   ERPS
 */
function createELPS(/*boolean*/okFlag)
{
    if (okFlag && $("applybtn").disabled)
    {
        xcloseDialog();
        return;
    }
    else
    {
        if (null == elpsTable.getAttrValue("wPort") 
        	|| null == elpsTable.getAttrValue("pPort"))
        {
            return;
        }
        setBtnDisabled(true);
        var xml = createELPSXML();

        var URL = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_CREATE_ELPS +"&nmUser=" + winurlobj["nmUser"];
       	loadXMLdoc(URL, "POST", false, createELPSBack, okFlag, "inputdata=" + xml);
    }
}

/**
 *     ERPS XML  
 */
function createELPSXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var wPort = elpsTable.getAttrValue("wPort");
    var wVlanID = elpsTable.getAttrValue("wvlanid");
    var pPort = elpsTable.getAttrValue("pPort");
    var pVlanID = elpsTable.getAttrValue("pvlanid");
    
    row = new tagElement("row-params");
    row.appendChild(new tagElement("param","neid",winurlobj["neid"]));
    row.appendChild(new tagElement("param","slotid",winurlobj["slotid"]));
    
	row.appendChild(new tagElement("param","boardname",win.currentBoardName));
    row.appendChild(new tagElement("param","groupid",elpsTable.getAttrValue("elpsid")));
    row.appendChild(new tagElement("param","grouptype",elpsTable.getAttrValue("grouptype")));
    row.appendChild(new tagElement("param","wportid",wPort));
    var wportElm = elpsTable.getAtom("wPort").element;
    row.appendChild(new tagElement("param","wportname",wportElm.options[wportElm.selectedIndex].text));
    row.appendChild(new tagElement("param","wvlanidlog",wVlanID));
    wVlanID = (wVlanID == win.INVALID_VLANID_SHOW?win.INVALID_VLANID:wVlanID);
    row.appendChild(new tagElement("param","wvlanid",wVlanID));
    row.appendChild(new tagElement("param","pportid",pPort));
    var pportElm = elpsTable.getAtom("pPort").element;
    row.appendChild(new tagElement("param","pportname",pportElm.options[pportElm.selectedIndex].text));
    row.appendChild(new tagElement("param","pvlanidlog",pVlanID));
    pVlanID = (pVlanID == win.INVALID_VLANID_SHOW?win.INVALID_VLANID:pVlanID);
    row.appendChild(new tagElement("param","pvlanid",pVlanID));
    
    row.appendChild(new tagElement("param","revtime",elpsTable.getAttrValue("revtime")));
    row.appendChild(new tagElement("param","delaytime",elpsTable.getAttrValue("delaytime")));
    row.appendChild(new tagElement("param","apschannel",elpsTable.getAttrValue("apschannel")));
    row.appendChild(new tagElement("param","switchdirection",elpsTable.getAttrValue("switchdirection")));
    row.appendChild(new tagElement("param","revmode",elpsTable.getAttrValue("revmode")));
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *   ERPS
 */
function createELPSBack(/*XMLDOM*/doc, /*boolean*/okFlag)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATION_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
        setBtnDisabled(false);
    }
    else
    {
        win.queryElps(false);
        $("okbtn").disabled = false;
        $("cancelbtn").disabled = false;
        $("applybtn").disabled = true;
        if (okFlag)
        {
            xcloseDialog();
            return;
        }
    }
}

/**
 *       
 */
function getPortList()
{
    setBtnDisabled(true);
    
    var xml = getPortListXML();
    
    var sfid = TECMDCODE_GET_ELPS_RES;
    
    var URL = "../../../../../neExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", false, getPortListBack, null, "inputdata=" + xml);
}

/**
 *        XML
 */
function getPortListXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    
    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", winurlobj["slotid"]);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *           
 * @param doc
 * @param portFlag
 */
function getPortListBack(/*XMLDOM*/doc, /*boolean*/portFlag)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    var portid,portname;
    var portAtom = null;
    if (OPERATION_SUCCESS == smallErrorCode)
    {
        for (var i = 0, len = data.getDataRowLength(); i < len; i ++)
        {
            portid = data.getDataRowParam(i, "portid", "portid");
            portname = data.getDataRowParam(i, "portname", "portname");
            
            portAtom = elpsTable.getAtom("wPort");
            portAtom.addOption(portname, portid);
            
            portAtom = elpsTable.getAtom("pPort");
            portAtom.addOption(portname, portid);
        }
    }
    
    setBtnDisabled(false);
}

/**
 *     
 */
function doCancel()
{
    xcloseDialog();
}

/**
 *         
 */
function setBtnDisabled(/*boolean*/flag)
{
    $("okbtn").disabled = flag;
    $("applybtn").disabled = flag;
    $("cancelbtn").disabled = flag
}

/**
 *        
 * @param data
 */
function showErrorDialog(/*Dateinterface*/data)
{
    var errorArray = null;
    errorArray = new Array();
    errorArray.push("nename");
    errorArray.push("slotid");
    errorArray.push("boardname");
    openErrPage("../../../../../page/", data.getError(), errorArray); 
}
