var elpsst;
var elpsmapst;

var winobj = getNeProperty(self);
var neid = winobj["neid"];
var btnRightArr = new Object();

var SelectedGroupRowIndex = -1;

var INVALID_VLANID = "65535";
var INVALID_MEP = "FFFFFFFF";
var INVALID_SHOWVALUE = "/";
var INVALID_VLANID = 65535;
var INVALID_VLANID_SHOW = "/";


var QUERYSWITCHSTATE = -1;
var LOCKED = 1;
var FORCETOPROTECTUNIT = 2;
var MANUALTOPROTECTIONUNIT = 3;
var MANUALTOWORKONGUNIT = 8;
var CLEAR = 0;

var currentBoardName = "";

/**
 *      
 * 
 * @param  
 * @return  
 */
function init()
{
	currentBoardName = winobj.subrackname + "-" 
					+ getSlotIDFromSlot(winobj.slotid) + "-" 
					+ winobj.boardname;
	initButton();
	initTable();
	if(btnRightArr.queryElpsBtn.right)
	{
		queryElps(true);
	}
}


/**
 *          
 * 
 * @param  
 * @return  
 */
function initButton()
{
	$("queryElpsBtn").value = RESOURCE["querybutton"];
	$("applyElpsBtn").value = RESOURCE["applybutton"];
	$("addElpsBtn").value = RESOURCE["newbutton"];
	$("delElpsBtn").value = RESOURCE["deletebutton"];
	$("setOAMBtn").value = RESOURCE["setOAM"];
	if(SYSTEMCONF.getLanguage() == "en")
	{
		$("setOAMBtn").className = "buttonstyle3";
	}
	$("switchBtn").value = RESOURCE["switchBtn"];
	$("groupTableTitle").innerText = RESOURCE["groupTableTitle"];
	$("groupUnitTableTitle").innerText = RESOURCE["groupUnitTableTitle"];
	$("totalSpanTitle").innerText = RESOURCE["totalrows"];
	$("totalSpan").innerText = "0";
	$("selectedSpanTitle").innerText = RESOURCE["selrows"];
	$("selectedSpan").innerText = "0";
	$("applyElpsBtn").disabled = true;
	$("delElpsBtn").disabled = true;
	$("setOAMBtn").disabled = true;
	$("switchBtn").disabled = true;

	btnRightArr.queryElpsBtn = new BtnRightObj("queryElpsBtn",TECMDCODE_QUERY_ELPS);
	btnRightArr.applyElpsBtn = new BtnRightObj("applyElpsBtn",TECMDCODE_MODIFY_ELPS_PARAM);
	btnRightArr.addElpsBtn = new BtnRightObj("addElpsBtn",TECMDCODE_CREATE_ELPS);
	btnRightArr.delElpsBtn = new BtnRightObj("delElpsBtn",TECMDCODE_DELETE_ELPS);
	btnRightArr.setOAMBtn = new BtnRightObj("setOAMBtn",TECMDCODE_SET_ELPS_OAM);
	btnRightArr.switchBtn = new BtnRightObj("switchBtn",TECMDCODE_SET_ELPS_SWITCH);
	btnRightArr.querySwitchState = new BtnRightObj("querySwitchState",TECMDCODE_GET_ELPS_SWITCH);
	btnRightArr.switchRight = new BtnRightObj("switchRight",TECMDCODE_SET_ELPS_SWITCH);
	getRightInfo(winobj, btnRightArr);
	$("queryElpsBtn").disabled = !btnRightArr.queryElpsBtn.right;
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function initTable()
{
	elpsst = new SortTable();
	elpsst.setImage("../../../../../images/");
	createTableHead(elpsst, window.tableconf[0]);
	elpsst.setOnCellEditHandler(elpsCellEditHandler);
	elpsst.setOnRowSelectHandler(elpsRowSelectHandler);
	$("elpscontainer").appendChild(elpsst.getTable());
	$("elpscontainer").oncontextmenu=popupMenuHandler;	  

	elpsmapst = new SortTable();
	elpsmapst.setImage("../../../../../images/");
	createTableHead(elpsmapst, window.tableconf[1]);
	$("elpsmapcontainer").appendChild(elpsmapst.getTable());

	var totalHeight = getComponetHeight($("tableContainer"), 150);

	elpsst.setBodyHeight((totalHeight) * 0.6 + "px");
	
	elpsmapst.setBodyHeight((totalHeight) * 0.4 + "px");
}

/**
 *   VLANID,65535     "/"
 * @param vlanid
 */
function convertVlanID(vlanid)
{
	if(vlanid == INVALID_VLANID)
	{
		vlanid = INVALID_VLANID_SHOW;
	}
	return vlanid;
}

/**
 * ELPS         
 * @param param
 */
function elpsCellEditHandler(/*Object*/param)
{
	if(param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		$("applyElpsBtn").disabled = !btnRightArr.applyElpsBtn.right;
	}
}
/**
 * ELPS         ,       
 * @param param
 */
function elpsRowSelectHandler(/*Array*/param)
{
	var rows = elpsst.getSelectedRows();
	if(rows.length > 0)
	{
		queryElpsOAM(rows[0]);
	}
	else
	{
		elpsmapst.clearTableData();
		SelectedGroupRowIndex = -1;
	}
	$("selectedSpan").innerText = rows.length;
}

/**
 *     ELPSOAM       
 *                 
 */
function forceQueryElpsOAM()
{
	SelectedGroupRowIndex = -1;
	var rows = elpsst.getSelectedRows();
	$("selectedSpan").innerText = rows.length;
	if(rows.length > 0)
	{
		queryElpsOAM(rows[0]);
	}
}

/**
 *   Elps
 * 
 * @param  
 * @return  
 */
function queryElps(bshowError)
{
	$("queryElpsBtn").disabled = true;
	$("applyElpsBtn").disabled = true;
	$("addElpsBtn").disabled = true;
	$("delElpsBtn").disabled = true;;
	LoadingProcess.showWaitStatus("../../../../../images/",RESOURCE["loadingtitle"]);
	var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_ELPS + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, queryElpscallback,bshowError, "inputdata="
			+ createQueryElpsXML());
}

/**
 *       IPPigg XML  
 * 
 * @param  
 * @return  
 */
function createQueryElpsXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;

	param = new tagElement("param","neid",winobj["neid"]);
	row.appendChild(param);
	
	if(typeof(winobj["slotid"]) != "undefined" && winobj["slotid"])
	{
		param = new tagElement("param","slotid",winobj["slotid"]);
		row.appendChild(param);
		
		param = new tagElement("param","boardname",currentBoardName);
		row.appendChild(param);
	}
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *             
 * 
 * @param doc:          
 * @param bshowError          
 * @return  
 */
function queryElpscallback(/*XMLDOM*/doc,/*boolean*/bshowError)
{
	LoadingProcess.removeWaitStatus();
	var data = EncapsulateData(doc);
	var lastSelected = [];
	for(var i = 0,len = elpsst.getDataRowLength();i < len;i++)
	{
		if (elpsst.getRowSelFlag(i))
		{
			lastSelected[lastSelected.length] = elpsst.getCellStoreValue(i, "groupid","groupid");
		}
	}
	elpsst.clearTableData();
	createTableBody(elpsst, window.tableconf[0], data, RESOURCE);
	for(var i = 0; i < elpsst.getDataRowLength(); i++)
	{
	  	var storevalue = elpsst.getCellStoreValue(i, "groupid","groupid");
	  	if(lastSelected.contains(storevalue))
	  	{
	  		elpsst.setRowSelect(i);
	  	}
	  	var groupstatus = elpsst.getCellStoreValue(i, "groupstatus","groupstatus");
	  	if(typeof(groupstatus) == "undefined" || groupstatus == null || groupstatus == "")
	  	{
	  		elpsst.getCellShow(i,"groupstatus").setValue(INVALID_SHOWVALUE);
		}
		var switchstatus = elpsst.getCellStoreValue(i, "switchstatus","switchstatus");
	  	if(typeof(switchstatus) == "undefined" || switchstatus == null || switchstatus == "")
	  	{
	  		elpsst.getCellShow(i,"switchstatus").setValue(INVALID_SHOWVALUE);
		}
	}
	SelectedGroupRowIndex = -1;
	if(elpsst.getSelectedRows().length == 0 && elpsst.getDataRowLength() > 0)
	{
		elpsst.setRowSelect(0);
	}
	elpsRowSelectHandler();
	$("totalSpan").innerText = elpsst.getDataRowLength();
	$("selectedSpan").innerText = elpsst.getSelectedRows().length;
	if(typeof(bshowError) != "undefined" && bshowError)
	{
		showErrorDialog(data);
	}
	
	$("queryElpsBtn").disabled = !btnRightArr.queryElpsBtn.right;
	$("addElpsBtn").disabled = !btnRightArr.addElpsBtn.right;
}

/**
 *   ELPS     
 */
function applyELPS()
{
	var xml = createApplyELPSXML();
	if(xml == null)
	{
		return;
	}
	$("applyElpsBtn").disabled = true;
	LoadingProcess.showWaitStatus("../../../../../images/",RESOURCE["loadingtitle"]);
	var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_MODIFY_ELPS_PARAM + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, applyELPScallback,null, "inputdata=" + xml);
}

/**
 *        OAM  
 * @param rowIndex   
 */
function queryElpsOAM(/*String*/rowIndex)
{
	if(SelectedGroupRowIndex == rowIndex)
	{
		return;
	}
	SelectedGroupRowIndex = rowIndex;
	var xml = createQueryElpsOAM(rowIndex);
	if(xml == null)
	{
		return;
	}
	elpsmapst.clearTableData();
	var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_ELPS_OAM + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, queryElpsOAMcallback, rowIndex, "inputdata="+ xml);
}

/**
 *           OAM XML  
 * 
 * @param  
 * @return  
 */
function createQueryElpsOAM(/*string*/rowIndex)
{
	if(rowIndex < 0 || rowIndex > (elpsst.getDataRowLength() - 1))
	{
		return null;
	}
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	param = new tagElement("param","neid",winobj["neid"]);
	row.appendChild(param);
	
	param = new tagElement("param","slotid",winobj["slotid"]);
	row.appendChild(param);
	
	param = new tagElement("param","boardname",currentBoardName);
	row.appendChild(param);
	
	param = new tagElement("param","groupid",elpsst.getCellStoreValue(rowIndex, "groupid", "groupid"));
	row.appendChild(param);

	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *   ARPIP       
 * @param doc
 */
function queryElpsOAMcallback(/*XMLDOM*/doc,/*String*/rowIndex)
{
	var data = EncapsulateData(doc);
	$("delElpsBtn").disabled = !btnRightArr.delElpsBtn.right;
	$("setOAMBtn").disabled = !btnRightArr.setOAMBtn.right;
	$("switchBtn").disabled = false;
	var data = constructOAMDataInterface(rowIndex,data);

	elpsmapst.clearTableData();
	createTableBody(elpsmapst, window.tableconf[1], data, RESOURCE);
}

/**
 *      OAM   DateInterface  
 * @param rowIndex
 * @param oamdata
 */
function constructOAMDataInterface(/*String*/rowIndex,/*DateInterface*/oamdata)
{
	var dinterface = new DataInterface();//        
	var workRow = new Object();
	var protectRow = new Object();

	workRow["portid"] = getParamTag(elpsst.getCellStoreValue(rowIndex,"wportid","wportid"));
	workRow["portname"] = getParamTag(elpsst.getCellStoreValue(rowIndex,"wportname","wportname"));
	workRow["unittype"] = getParamTag(UNITTYPE_WORK);
	workRow["vlanid"] = getParamTag(elpsst.getCellStoreValue(rowIndex,"wvlanid","wvlanid"));
	workRow["status"] = getParamTag(elpsst.getCellStoreValue(rowIndex,"wstatus","wstatus"));
	workRow["mdname"] = getParamTag(oamdata.getDataRowParam(0,"wmdname"));
	workRow["mdid"] = getParamTagNoConvert(oamdata.getDataRowParam(0,"wmd"));
	workRow["maname"] = getParamTag(oamdata.getDataRowParam(0,"wmaname"));
	workRow["maid"] = getParamTagNoConvert(oamdata.getDataRowParam(0,"wma"));
	workRow["mpid"] = getParamTagNoConvert(oamdata.getDataRowParam(0,"wmep"));
	dinterface.rows[dinterface.rows.length] = workRow;
	
	protectRow["portid"] = getParamTag(elpsst.getCellStoreValue(rowIndex,"pportid","pportid"));
	protectRow["portname"] = getParamTag(elpsst.getCellStoreValue(rowIndex,"pportname","pportname"));
	protectRow["unittype"] = getParamTag(UNITTYPE_PROTECT);
	protectRow["vlanid"] = getParamTag(elpsst.getCellStoreValue(rowIndex,"pvlanid","pvlanid"));
	protectRow["status"] = getParamTag(elpsst.getCellStoreValue(rowIndex,"pstatus","pstatus"));
	protectRow["mdname"] = getParamTag(oamdata.getDataRowParam(0,"pmdname"));
	protectRow["mdid"] = getParamTagNoConvert(oamdata.getDataRowParam(0,"pmd"));
	protectRow["maname"] = getParamTag(oamdata.getDataRowParam(0,"pmaname"));
	protectRow["maid"] = getParamTagNoConvert(oamdata.getDataRowParam(0,"pma"));
	protectRow["mpid"] = getParamTagNoConvert(oamdata.getDataRowParam(0,"pmep"));
	dinterface.rows[dinterface.rows.length] = protectRow;
	return dinterface;
}

/**
 *   Param  , Value      
 * value   null  ""    "/"
 * @param value
 */
function getParamTag(/*String*/value)
{
	var ptag = new ParamTag();
	if(typeof(value) == "undefined" || value == null || value == "")
	{
		value = INVALID_SHOWVALUE;
	}
	ptag.value = value
	return ptag;
}

/**
 *   Param  , Value      
 * @param value
 */
function getParamTagNoConvert(/*String*/value)
{
	var ptag = new ParamTag();
	ptag.value = value
	return ptag;
}

/**
 *   MPID,      Prototype      00-00-0001
 *       FFFFFFF    "/"
 * @param mpid
 */
function convertMPID(/*String*/mpid)
{
	var mep = mpid
	if(mpid.length >= 8)
	{
		
		if(mpid == INVALID_MEP)
		{
			mep = INVALID_SHOWVALUE;
		}
		else
		{
			mep = mpid.substr(0,2) + "-" + mpid.substr(2,2) + "-" + mpid.substr(4);
		}
	}
	return mep;
}

/**
 *     IPPing   XML
 */
function createApplyELPSXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	for(var rowindex = 0,rowlen = elpsst.getDataRowLength();rowindex<rowlen;rowindex++)
	{
    	if(!elpsst.getModify(rowindex))
    	{
    		continue;
    	}
    	row = new tagElement("row-params");
    	
    	appendSlotGroupIDParam(row,rowindex);
    	
    	appendParamParam(row,rowindex);

		bussiness.appendChild(row);
	}
	if(0 == bussiness.childNodes.length)
	{
		return null;
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 *           
 * @param row
 * @param rowindex
 */
function appendSlotGroupIDParam(/*tagElement*/row,/*string*/rowindex)
{
	var param = new tagElement("param","neid",winobj.neid);
	row.appendChild(param);
	param = new tagElement("param","slotid",winobj.slotid);
	row.appendChild(param);
	param = new tagElement("param","boardname",currentBoardName);
	row.appendChild(param);
	param = new tagElement("param","groupid",elpsst.getCellStoreValue(rowindex, "groupid", "groupid"));
	row.appendChild(param);
}

/**
 *            
 * @param row
 * @param rowindex
 */
function appendParamParam(/*tagElement*/row,/*string*/rowindex)
{
	var param = null;
	if(elpsst.getCellModify(rowindex,"status"))
	{
		param = new tagElement("param","status",elpsst.getCellStoreValue(rowindex,"status","status"));
		row.appendChild(param);
	}
	
	if(elpsst.getCellModify(rowindex,"revtime"))
	{
		param = new tagElement("param","revtime",elpsst.getCellStoreValue(rowindex,"revtime","revtime"));
		row.appendChild(param);
	}
	if(elpsst.getCellModify(rowindex,"delaytime"))
	{
		param = new tagElement("param","delaytime",elpsst.getCellStoreValue(rowindex,"delaytime","delaytime"));
		row.appendChild(param);
	}

	if(elpsst.getCellModify(rowindex,"apschannel") || elpsst.getCellModify(rowindex,"revmode")
		|| elpsst.getCellModify(rowindex,"switchdirection") || elpsst.getCellModify(rowindex,"grouptype"))
	{
		param = new tagElement("param","grouptype",elpsst.getCellStoreValue(rowindex,"grouptype","grouptype"));
		row.appendChild(param);
		
		param = new tagElement("param","apschannel",elpsst.getCellStoreValue(rowindex,"apschannel","apschannel"));
		row.appendChild(param);
		
		param = new tagElement("param","switchdirection",elpsst.getCellStoreValue(rowindex,"switchdirection","switchdirection"));
		row.appendChild(param);
		
		param = new tagElement("param","revmode",elpsst.getCellStoreValue(rowindex,"revmode","revmode"));
		row.appendChild(param);
	}
}

/**
 *   ELPS     
 * @param doc
 */
function applyELPScallback(/*XMLDOM*/doc)
{
	LoadingProcess.removeWaitStatus();
	var data = EncapsulateData(doc);
	
	if(OPERATION_SUCCESS != data.getSErrorCode() )
	{
		$("applyElpsBtn").disabled = !btnRightArr.applyElpsBtn.right;
		showErrorDialog(data);
	}
	else
	{
		refreshTableState(elpsst,window.tableconf[0],data);
	}
	
}

/**
 *   ELPS
 * 
 * @param rowIndex
 * @return  
 */
function deleteELPS()
{
	var selRows = elpsst.getSelectedRows();
	if (selRows.length <= 0)
	{
		return;
	}
	if (!confirm(RESOURCE["SERICE_DELETE_WARN"])) 
    {
        return;
    }
    if (!confirm(RESOURCE["SERVICE_BREAK_WARN"])) 
    {
        return;
    }

	var xml = createDeleteElpsXML();
	if(xml == null)
	{
		return;
	}
	var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_DELETE_ELPS + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, deleteElpscallback, selRows, "inputdata="+ xml);
}

/**
 *     ELPS XML  
 * 
 * @param  
 * @return  
 */
function createDeleteElpsXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	var selectedRows = elpsst.getSelectedRows();
	for (var i = 0, len = selectedRows.length; i < len; i++) 
    {
        var row = new tagElement("row-params");
        
        param = new tagElement("param","neid",winobj.neid);//  id  
        row.appendChild(param);
        
        param = new tagElement("param","slotid",winobj.slotid);
        row.appendChild(param);
        
        param = new tagElement("param","boardname",currentBoardName);
		row.appendChild(param);
        
        var groupIdValue = elpsst.getCellStoreValue(selectedRows[i], "groupid", "groupid");
        param = new tagElement("param","groupid",groupIdValue);
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *  ELPS     
 * @param doc
 */
function deleteElpscallback(/*XMLDOM*/doc,/*Array*/selRows)
{
	var data = EncapsulateData(doc);
	
	if(OPERATION_SUCCESS == data.getSErrorCode())
	{
		$("delElpsBtn").disabled = true;
		$("setOAMBtn").disabled = true;
		$("switchBtn").disabled = true;
		elpsmapst.clearTableData();
		for(var i = 0;i < selRows.length;i++)
		{
			elpsst.deleteRow(selRows[i]);
		}
		elpsst.adjustDataRows();
		$("totalSpan").innerText = elpsst.getDataRowLength();
	}
	showErrorDialog(data);
}


/**
 *       
 *               
 */
function showErrorDialog(/*Object*/data)
{
	var errArr = [];
	errArr[0] = "nename";
	errArr[1] = "slotid";
	errArr[2] = "boardname";
	openErrPage("../../../../../page/", data.getError(), errArr); 
}

/**
 *   ELPS    ,      
 */
function addElps()
{
	var URL = "elpscreate.html?neid=" + winobj["neid"] + "&nmUser=" + winobj["nmUser"];
	if(typeof(winobj["slotid"]) != "undefined" && winobj["slotid"])
	{
		URL = URL + "&slotid=" + winobj["slotid"];
	}
    xshowModalDialog(URL, RESOURCE["createELPS"], 400, 330, "../../../../../images/");
}

/**
 *   ELPS OAM    ,  OAM   
 */
function setElpsOAM()
{
	var URL = "setelpsoam.html?neid=" + winobj["neid"] + "&nmUser=" + winobj["nmUser"];
	if(typeof(winobj["slotid"]) != "undefined" && winobj["slotid"])
	{
		URL = URL + "&slotid=" + winobj["slotid"];
	}
    xshowModalDialog(URL, RESOURCE["setELPSOAM"], 400, 250, "../../../../../images/");
}

/**
 *   ELPS   ID
 */
function getElpsAvailableID()
{
	var tempid = 0;
	var idlist = [];
	for(var i = 0,len = elpsst.getDataRowLength();i < len;i++)
	{
		tempid = parseInt(elpsst.getCellStoreValue(i,"groupid","groupid"));
		idlist[idlist.length] = tempid;
	}
	idlist.sort();
	var availableid = 1;
	for(var i = 0,len = idlist.length;i < len;i++)
	{
		tempid = idlist[i];
		if(tempid > availableid)
		{
			break;
		}
		else
		{
			availableid = tempid + 1;
		}
	}
	return availableid;
}

/**
 *            
 */
function getElpsSelectedObject()
{
	var rows = elpsst.getSelectedRows();
	var selecteObj = new Object();
	if(rows.length > 0)
	{
		selecteObj.elpsid = elpsst.getCellStoreValue(rows[0],"groupid","groupid");
		selecteObj.wportid = elpsst.getCellStoreValue(rows[0],"wportid","wportid");
		selecteObj.wvlanid = elpsst.getCellStoreValue(rows[0],"wvlanid","wvlanid");
		selecteObj.pportid = elpsst.getCellStoreValue(rows[0],"pportid","pportid");
		selecteObj.pvlanid = elpsst.getCellStoreValue(rows[0],"pvlanid","pvlanid");
		selecteObj.wmd = elpsmapst.getCellStoreValue(0,"mdid","mdid");
		selecteObj.wma = elpsmapst.getCellStoreValue(0,"maid","maid");
		selecteObj.wmpid = elpsmapst.getCellStoreValue(0,"mpid","mpid");
		selecteObj.pmd = elpsmapst.getCellStoreValue(1,"mdid","mdid");
		selecteObj.pma = elpsmapst.getCellStoreValue(1,"maid","maid");
		selecteObj.pmpid = elpsmapst.getCellStoreValue(1,"mpid","mpid");
	}
	return selecteObj;
}

/**
 *          
 */
function createjsDOMenu()
{

	removejsDOMmenu();
	var isSelected = false;	

	for(var i = 0, len = elpsst.getDataRowLength(); i < len; i++)
	{
		if(elpsst.getRowSelFlag(i))
		{
			isSelected = true;
			break;
		}
	}	
	var queryswitchflag = btnRightArr.querySwitchState.right;	
	var switchrightflag = btnRightArr.switchRight.right;
	if (true == isSelected)
    {
		cursorMenu1 = new jsDOMenu(180);
		with (cursorMenu1)
		{
			addMenuItem(new menuItem(RESOURCE["queryswitchstate"],"",querySwitchStateInfo,QUERYSWITCHSTATE,queryswitchflag));
			addMenuItem(new menuItem("-"));
			
			addMenuItem(new menuItem(RESOURCE["clear"],"",switchFunction,CLEAR,switchrightflag));
			addMenuItem(new menuItem("-"));
			addMenuItem(new menuItem(RESOURCE["locked"],"",switchFunction,LOCKED,switchrightflag));
			addMenuItem(new menuItem("-"));
			
			addMenuItem(new menuItem(RESOURCE["forcetoprotectionunit"],"",switchFunction,FORCETOPROTECTUNIT,switchrightflag));
			addMenuItem(new menuItem("-"));
			
			addMenuItem(new menuItem(RESOURCE["manualtoworkingunit"],"",switchFunction,MANUALTOWORKONGUNIT,switchrightflag));
			addMenuItem(new menuItem(RESOURCE["manualtoprotectionunit"],"",switchFunction,MANUALTOPROTECTIONUNIT,switchrightflag));
		}
	
		setPopUpMenu(cursorMenu1);
	}
}

/**
 *       
 * @param command
 */
function switchFunction(/*String*/command)
{
    var selectedLines = elpsst.getSelectedRows();
    
    if (selectedLines.length > 1)
    {
        alert(RESOURCE["chooseoneline"]);
        return;
    }
    else if (0 == selectedLines.length)
    {
        alert(RESOURCE["norowselected"]);
        return;
    }
    sendSwitchInfo(command);

}

/**
 *         
 */
function querySwitchStateInfo()
{
	var selectedLines = elpsst.getSelectedRows();
    if (selectedLines.length > 0) 
    {
        var xmlstr = createQuerySwitchStateXML(selectedLines);

        var urlreq = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_ELPS_SWITCH + "&flag=1";
        loadXMLdoc(urlreq, "POST", true, querySwitchStateCallback, null, "inputdata=" + xmlstr);
    }
}

/**
 *             
 * @param selectedLines
 */
function createQuerySwitchStateXML(/*Array*/selectedLines)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    
    
    var param = null;
    
    for (var i = 0, len = selectedLines.length; i < len; i++) 
    {
        var row = new tagElement("row-params");
        
        param = new tagElement("param","neid",winobj.neid);
        row.appendChild(param);
        
        param = new tagElement("param","slotid",winobj.slotid);
        row.appendChild(param);
        
        param = new tagElement("param","boardname",currentBoardName);
		row.appendChild(param);
        
        param = new tagElement("param","groupId",elpsst.getCellStoreValue(selectedLines[i], "groupid", "groupid"));
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

/**
 *           
 * @param doc
 */
function querySwitchStateCallback(/*XMLDOM*/doc)
{
    var dinterface = EncapsulateData(doc);
    for(var i = 0,len = dinterface.getDataRowLength();i < len;i++)
    {
    	var groupid = dinterface.getDataRowParam(i,"groupid");
    	var groupstatus = dinterface.getDataRowParam(i,"groupstatus");
    	var switchstatus = dinterface.getDataRowParam(i,"switchstatus");
    	var wstatus = dinterface.getDataRowParam(i,"wstatus");
    	var pstatus = dinterface.getDataRowParam(i,"pstatus");
    	var rowindex = getRowIndexFromSelected(groupid);
    	if(rowindex >= 0)
    	{
    		elpsst.setCellValue(elpsst.getCell(rowindex,"groupstatus"),"groupstatus",groupstatus);
    		elpsst.setCellValue(elpsst.getCell(rowindex,"switchstatus"),"switchstatus",switchstatus);
    		elpsst.getCellShow(rowindex,"groupstatus").setValue(RESOURCE[GroupStatus[groupstatus]]);
    		elpsst.getCellShow(rowindex,"switchstatus").setValue(RESOURCE[SwitchStatus[switchstatus]]);
    		elpsst.setCellValue(elpsst.getCell(rowindex,"wstatus"),"wstatus",wstatus);
    		elpsst.setCellValue(elpsst.getCell(rowindex,"pstatus"),"pstatus",pstatus);
    		var selectedLines = elpsst.getSelectedRows();
    		if(rowindex == selectedLines[0])
    		{
    			var workIndex = 0,protectIndex = 1;
    			if(elpsmapst.getCellStoreValue(0,"unittype","unittype") != UNITTYPE_WORK)
    			{
    				workIndex = 1;
    				protectIndex = 0;
    			}
    			elpsmapst.getCellShow(workIndex,"status").setValue(RESOURCE[UnitStatus[wstatus]])
    			elpsmapst.getCellShow(protectIndex,"status").setValue(RESOURCE[UnitStatus[pstatus]])
    		}
    	}
    }
    showErrorDialog(dinterface);
}

/**
 *   GroupID           
 * @param groupid
 */
function getRowIndexFromSelected(/*String*/groupid)
{
	var selectedLines = elpsst.getSelectedRows();
	var rowIndex = -1;
	for(var i = 0,len = selectedLines.length;i < len;i++)
	{
		if(elpsst.getCellStoreValue(selectedLines[i],"groupid","groupid") == groupid)
		{
			rowIndex = selectedLines[i];
			break;
		}
	}
	return rowIndex;
}

/**
 *              XML   
 * @param selectLine
 * @param switchCommand
 */
function createSendSwitchInfoXML(/*String*/selectLine, /*String*/switchCommand)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param","neid",winobj.neid);
    row.appendChild(param);
    
    param = new tagElement("param","slotid",winobj.slotid);
    row.appendChild(param);
    
    param = new tagElement("param","boardname",currentBoardName);
	row.appendChild(param);
    
    var groupIdValue = elpsst.getCellStoreValue(selectLine, "groupid", "groupid");
    param = new tagElement("param","groupid",groupIdValue);
    row.appendChild(param);
    
    param = new tagElement("param","switchtype",switchCommand);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
    
}

/**
 *          
 * @param command
 */
function sendSwitchInfo(/*String*/command)
{
	var selectLine = elpsst.getSelectedRows()[0];
	var xmlstr = createSendSwitchInfoXML(selectLine,command);
	if (null != xmlstr) 
    {
    	removejsDOMmenu();
        if (command == LOCKED || command == FORCETOPROTECTUNIT) 
        {
            if (!confirm(RESOURCE["isSwitch_" + command]))
            {
                return;
            }
        }
        var urlreq = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_ELPS_SWITCH + "&flag=1";
        loadXMLdoc(urlreq, "POST", true, sendSwitchInfoCallback, null, "inputdata=" + xmlstr);
    }
}

/**
 *         
 * @param doc
 */
function sendSwitchInfoCallback(/*XMLDOM*/doc)
{
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    if (OPERATION_SUCCESS == dinterface.getSErrorCode()) 
    {
    	alert(RESOURCE["queryswitchstatus2"]);
        querySwitchStateInfo();
    }
}

/**
 *          
 */
function popupMenuHandler(evt)
{	
	if (!evt)
	{
		evt = window.event;
	}

	var elem = (evt.target) ? evt.target : evt.srcElement;
	if (elem != null && elem.blur)
	{
		elem.blur();
	}
	while (elem != null)
	{
		if (elem.tagName == 'TD')
		{
			break;
		}
		else
		{
			elem = elem.parentNode;
		}
	}
	if (elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
		return;
	}

	var rowid = elem.parentNode.rowIndex;
	var rows = elem.parent.getSelectedRows();
	var colid = elem.colid;

	if (rows.contains(rowid))
	{
		if (null != elem.editElement && 
			 	elem.isEdit == 1)
		{
			createTablePopupMenu(elem, evt);
			return;
		}
		else
		{
			removejsDOMmenu();
			createjsDOMenu();
			showMenu(event);
		}
	}
}
