
language = SYSTEMCONF.getLanguage();

document.title = RESOURCE["arpitemmgr"];
/***************
 *       
****************/

var win = getParentWindow();
var winurlobj = getNeProperty(win.document);
var neid = winurlobj.neid;   
var subrackName = winurlobj.subrackname;                 //    
var slotid = winurlobj.slotid;                           //  ID
var nmUser = winurlobj.nmUser;                           //    
var boardname = winurlobj.boardname;                     //    

var OPRSUCC = 0;                                         //    
var OPRPSUCC = 1;                                        //      
var OPRFAIL = 2;                                         //    

var btnRightArr = new Object();                          //      



/**
 *      
 */
function initPage()
{
	createButton();
    
	createTable();
}

/**
 *      
 */
function createButton()
{	
	$("submitbtn").value=RESOURCE["okbutton"];
	$("cancelbtn").value=RESOURCE["cancelbutton"];
	$("applybtn").value=RESOURCE["applybutton"];
	$("table").onkeydown = macAddress_OnKeyDown;
	initRightData();
}

/**
 *                  
 */
function macAddress_OnKeyDown()
{
    $("applybtn").disabled = !btnRightArr.submitbtn.right;
    $("submitbtn").disabled = !btnRightArr.submitbtn.right;
}

/** 
 *         
 *@param bl:      
 */
function disabledAllBtn(bl)
{
	if(bl)
	{
		$("submitbtn").disabled = bl;
		$("applybtn").disabled = bl;
    }
    else
    {
		$("submitbtn").disabled = !btnRightArr.submitbtn.right;
		$("applybtn").disabled = !btnRightArr.submitbtn.right;
    }
}

/**
 *       
 */
function initRightData()
{
    btnRightArr.submitbtn = new BtnRightObj("submitbtn", TE_Q_CMD_IPPTN_ADD_ARPITEM);
     
    sendRightInfo(btnRightArr);
    
    $("submitbtn").disabled = !btnRightArr.submitbtn.right;
}

/**
 *       
 */
function sendRightInfo()
{
	var url = "../../../../../securityServlet?neID=" + neid + "&nmUser=" + nmUser;
	loadXMLdoc(url, "POST", false, rightHandleBack, null, "inputdata=" + createRightXML());
}

/**
 *           
 *@param doc:      XML  
 */
function rightHandleBack(doc)
{
	var data = EncapsulateData(doc);
	for(var i = 0; i < data.getDataRowLength(); i++)  //       
    {
		var right = data.getDataRowParam(i,"right");
    	
      	if(0 == right)
		{
			btnRightArr[data.getDataRowParam(i,"btnID")].right = false;
		}
		else
		{
			btnRightArr[data.getDataRowParam(i,"btnID")].right = true;
		}
    }
}

/**
 *           XML 
 */
function createRightXML()
{
	var root = new inputxml("datainterface");//Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel=null;;
	var thirdlevel=null;
	
    for(var btnrightobj in btnRightArr)
	{
		secondlevel = new tagElement("row-params"); //bean         	
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","btnID");
		thirdlevel.setAttribute("value",btnRightArr[btnrightobj].btnId);
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");	
		thirdlevel.setAttribute("name","sfid");
		thirdlevel.setAttribute("value",btnRightArr[btnrightobj].sfid);
		secondlevel.appendChild(thirdlevel);
		
		firstlevel.appendChild(secondlevel);
	}
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

/**
 *     
 */
function createTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"],RESOURCE["value"]);
	
	var board = getSlotIDFromSlot(slotid) + "-" + boardname;
	if (subrackName != "")
	{
		board = subrackName + "-" + board;
	}
    
    var atom = new Atom("span");
    atom.setValue(board);
    atom.element.style.width="100%";
    ct.addAttrRow("board",RESOURCE["board"],atom);
    
    atom = new Atom("text");
    atom.setValue("0.0.0.0");
    ct.addAttrRow("arpip",RESOURCE["arpip"],atom);
    
    var objip = ct.getAtom("arpip").element;
    validateIp(objip);
    objip.onkeydown = function()
    {
        $("applybtn").disabled = false;
        $("submitbtn").disabled = false;
    }
   
         
    atom = new Atom("text");
    atom.setValue("00-00-00-00-00-00");
    ct.addAttrRow("arpmac",RESOURCE["arpmac"],atom);
    
    var objmac = ct.getAtom("arpmac").element;
    validateMac(objmac);
    objmac.onkeydown = function()
    {
        $("applybtn").disabled = false;
        $("submitbtn").disabled = false;
    }
    
    document.body.insertBefore(ct.getTable(), document.body.firstChild);
}

/**
 *      XML  
 */
function createXMLData()
{
	var neid = winurlobj["neid"];
	var slotid = winurlobj["slotid"];
	var arpip = ct.getAttrValue("arpip");
	var arpmac = ct.getAttrValue("arpmac");
		
  for(var btnrightobj in btnRightArr)
	{
    var di =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");

    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","slotid");
    param.setAttribute("value",slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","arpip");
    param.setAttribute("value",arpip);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","arpmac");
    param.setAttribute("value",arpmac);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
		
    return di.toString();
  }
}

function sendCreateInfo(flag)
{	
	if($("applybtn").disabled)
  {
    xcloseDialog();
    return;
  }
    
	if (!checkIPAddress(ct.getAttrValue("arpip")))
  {
    	ct.getAtom("arpip").element.focus();
    	return;
  }
		
	if(!checkMac(ct.getAtom("arpmac").element))
  {
  	  ct.getAtom("arpmac").element.focus();
      return;
  }
	disabledAllBtn(true);
    
  var xml = createXMLData();
  
  var URL = "../../../../../neExlorerServlet?sfid="+TE_Q_CMD_IPPTN_ADD_ARPITEM+"&nmUser="+winurlobj["nmUser"];
  loadXMLdoc(URL,"POST",true,PostCallBackHandler,flag,"inputdata="+xml);
    
}

/**
 *   Mac      
 *@param doc:      XML  
 */
function PostCallBackHandler(doc,flag)
{
	  
    var data = EncapsulateData(doc);
    
    if(data.getSErrorCode() != 0)
    {
    	showErrorDialog(data);
    	disabledAllBtn(false);
    	return;
    }
    $("applybtn").disabled = true;
    $("submitbtn").disabled = false;
    win.sendQueryInfo();
    
    if(flag)
    {
    	xcloseDialog();
    }

}

function showErrorDialog(data)
{
	var errArr = [];//                   neid slotid
	errArr.push("nename");
	errArr.push("slotid");
	errArr.push("boardname");
	
	openErrPage("../../../../../page/", data.getError(), errArr); 
}

/**
 *   Mac        
 *@param obj:      
 */
function checkMac(obj)
{
	var pattern = /^[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]$/;
   	var checker = pattern.test(obj.value);
   	if(!checker)
   	{
       	alert(RESOURCE["wrongformat"]);
       	obj.value = "00-00-00-00-00-01";
       	obj.focus();
       	return false;
   	}
   	else
   	{
       	if(obj.value == "00-00-00-00-00-00")
       	{
       	    alert(RESOURCE["macaddrerror0"]);
       	    return false;
       	}
       	
       	var objValue = obj.value.substring(1,2);
       	if( parseInt(objValue,16)%2 != 0 )
       	{
       		  alert(RESOURCE["macaddrerror1"]);
       	    return false;
       	}
       	
       	return true;
   	}
}

function checkIPAddress(ipAddress)
{
	  var ipAddressArray = ipAddress.split(".");
	  var intIPAddressFirst = parseInt(ipAddressArray[0],10);
	  var intIPAddressLast = parseInt(ipAddressArray[3],10);
	  
	  if (0 == intIPAddressFirst || 127 == intIPAddressFirst || 224 <= intIPAddressFirst
	     ||0 == intIPAddressLast || 255 == intIPAddressLast)
	  {
	  	  alert(RESOURCE["iperror"]);
	  	  return false;
	  }
	  
	  return true;
}
