/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.vlangroup.db;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginLog;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEWebLCTVlanGroupMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEVlangroupDbMgr {
    public static final String UNKNOWN = "UNKNOWN";
    private static final Logger logger = TELogFactory.getNormalLogger();
    public static final String DB_COL_SLOT = "Board";
    public static final String DB_COL_PORT = "Port";
    public static final String DB_COL_VLANID = "Vlanid";

    private TEVlangroupDbMgr() {
    }

    public static List<TEWebLCTVlanGroupMOPO> getVlanGroupMOFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEVlangroupDbMgr.getVlanGroupMOFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TEVlangroupDbMgr.getVlanGroupMOFromDB");
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        ArrayList<TEWebLCTVlanGroupMOPO> moList = new ArrayList<TEWebLCTVlanGroupMOPO>();
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TEVlangroupDbMgr.logNullNEError(neID);
                TEVlangroupDbMgr.setOperFail(neID, errRet, 1090596385);
                TEBeanPluginLog.logFuncEnd((String)"TEVlangroupDbMgr.getVlanGroupMOFromDB");
                return moList;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TEWebLCTVlanGroupMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEWebLCTVlanGroupMOPO.class);
        }
        catch (Exception e) {
            TEVlangroupDbMgr.logExceptionOnGet(neID, e);
            TEVlangroupDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEVlangroupDbMgr.getVlanGroupMOFromDB");
            return moList;
        }
        if (null == dbResult) {
            TEVlangroupDbMgr.logNullErrorOnGet(neID);
            TEVlangroupDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEVlangroupDbMgr.getVlanGroupMOFromDB");
            return moList;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    moList.add((TEWebLCTVlanGroupMOPO)obj);
                }
            }
        } else {
            TEVlangroupDbMgr.logRetCodeErrorOnGet(neID, retCode);
            TEVlangroupDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEVlangroupDbMgr.getVlanGroupMOFromDB");
        return moList;
    }

    public static TEWebLCTVlanGroupMOPO getVlanGroupFromDB(int neID, int slotid, int port, int vlanid) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair(DB_COL_SLOT, String.valueOf(slotid));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair(DB_COL_PORT, String.valueOf(port));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair(DB_COL_VLANID, String.valueOf(vlanid));
        criteria.add(aPair);
        TEWebLCTVlanGroupMOPO mopo = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findByID((int[])new int[]{neID}, TEWebLCTVlanGroupMOPO.class, criteria) : TECommonDaoService.findByID_NonLock((int[])new int[]{neID}, TEWebLCTVlanGroupMOPO.class, criteria);
            if (null == dbResult) {
                String tipStr = "Get TEWebLCTVlanGroupMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                logger.error(tipStr);
                return mopo;
            }
        }
        catch (Exception e) {
            String tipStr = "Get TEWebLCTVlanGroupMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            logger.error(tipStr, (Throwable)e);
            return mopo;
        }
        if (0 == dbResult.getResult() && dbResult.getData().size() > 0) {
            mopo = (TEWebLCTVlanGroupMOPO)dbResult.getData().get(0);
        }
        return mopo;
    }

    public static void updateVlanGroupMOToDB(int neID, TEWebLCTVlanGroupMOPO bPathMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEVlangroupDbMgr.updateVlanGroupMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEVlangroupDbMgr.updateVlanGroupMOToDB");
        if (null == bPathMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)bPathMO) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)bPathMO);
        }
        catch (Exception e) {
            TEVlangroupDbMgr.logExceptionErrorOnUpdate(neID, e);
            TEVlangroupDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEVlangroupDbMgr.updateVlanGroupMOToDB");
            return;
        }
        if (null == dbResult) {
            TEVlangroupDbMgr.logNullErrorOnUpdate(neID);
            TEVlangroupDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEVlangroupDbMgr.updateVlanGroupMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEVlangroupDbMgr.logRetCodeErrorOnUpdate(neID, retCode);
            TEVlangroupDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEVlangroupDbMgr.updateVlanGroupMOToDB");
    }

    public static void delAllVlanGroupFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEVlangroupDbMgr.delAllVlanGroupFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TEVlangroupDbMgr.delAllVlanGroupFromDB");
        List<TEWebLCTVlanGroupMOPO> boundPathList = TEVlangroupDbMgr.getVlanGroupMOFromDB(neID, errRet);
        int retCode = errRet.getResult();
        if (0 != retCode) {
            TEVlangroupDbMgr.logRetCodeErrorOnUpdate(neID, retCode);
            errRet.setResult(retCode);
        }
        for (TEWebLCTVlanGroupMOPO boundPath : boundPathList) {
            TEVlangroupDbMgr.delVlanGroupMOToDB(neID, boundPath, errRet);
        }
        TEBeanPluginLog.logFuncBegin((String)"TEVlangroupDbMgr.delAllVlanGroupFromDB");
    }

    public static void createVlanGroupMOToDB(int neID, TEWebLCTVlanGroupMOPO bPathMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEVlangroupDbMgr.createVlanGroupMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEVlangroupDbMgr.createVlanGroupMOToDB");
        if (null == bPathMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)bPathMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)bPathMO);
        }
        catch (Exception e) {
            TEVlangroupDbMgr.logExceptionErrorOnCreate(neID, e);
            TEVlangroupDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEVlangroupDbMgr.createVlanGroupMOToDB");
            return;
        }
        if (null == dbResult) {
            TEVlangroupDbMgr.logNullErrorOnCreate(neID);
            TEVlangroupDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEVlangroupDbMgr.createVlanGroupMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEVlangroupDbMgr.logRetCodeErrorOnCreate(neID, retCode);
            TEVlangroupDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEVlangroupDbMgr.createVlanGroupMOToDB");
    }

    public static void delVlanGroupMOToDB(int neID, TEWebLCTVlanGroupMOPO bPathMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEVlangroupDbMgr.delVlanGroupMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEVlangroupDbMgr.delVlanGroupMOToDB");
        if (null == bPathMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)bPathMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)bPathMO);
        }
        catch (Exception e) {
            TEVlangroupDbMgr.logExceptionErrorOnDel(neID, e);
            TEVlangroupDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEVlangroupDbMgr.delVlanGroupMOToDB");
            return;
        }
        if (null == dbResult) {
            TEVlangroupDbMgr.logNullErrorOnDel(neID);
            TEVlangroupDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEVlangroupDbMgr.delVlanGroupMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEVlangroupDbMgr.logRetCodeErrorOnDel(neID, retCode);
            TEVlangroupDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEVlangroupDbMgr.delVlanGroupMOToDB");
    }

    private static void setOperFail(int neID, TEErrInfoReturn rspErrRet, int retCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        rspErrRet.setResult(1090605056);
        rspErrRet.addErrInfo(TEVlangroupDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, retCode).getErrList());
    }

    public static TEErrInfoReturn constructErrInfoReturn(int neID, int errorCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = UNKNOWN;
        if (null != ne) {
            neName = ne.getNEName();
        }
        return TEVlangroupDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, errorCode);
    }

    public static TEErrInfoReturn constructErrInfoReturn(int[] objID, String[] objName, int retCode) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setObjName(TEVlangroupDbMgr.getObjName(objName));
        errInfo.setErrorCode(retCode);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    public static String getObjName(String[] objName) {
        StringBuffer objNameBuffer = new StringBuffer();
        int len = objName.length;
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                objNameBuffer.append('-');
            }
            objNameBuffer.append(objName[i]);
        }
        return objNameBuffer.toString();
    }

    private static void logNullNEError(int neID) {
        logger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get mo from db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnGet(int neID) {
        logger.error("get mo from db fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionOnGet(int neID, Exception e) {
        logger.error("get mo from db fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnUpdate(int neID, int retCode) {
        String tipStr = String.format("update mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnUpdate(int neID) {
        logger.error("update mo to db device fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionErrorOnUpdate(int neID, Exception e) {
        logger.error("update mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logNullErrorOnCreate(int neID) {
        logger.error("create mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnCreate(int neID, Exception e) {
        logger.error("create mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnCreate(int neID, int retCode) {
        String tipStr = String.format("create mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnDel(int neID) {
        logger.error("delete mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnDel(int neID, Exception e) {
        logger.error("delete mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnDel(int neID, int retCode) {
        String tipStr = String.format("delete mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }
}

