/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.vlangroup.beanplugin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.beanplugin.TEBeanPlugin;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.vlangroup.db.TEVlangroupDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEWebLCTVlanGroupMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryVlangroupPlugin
extends TEBeanPlugin {
    private static final Logger logger = TELogFactory.getNormalLogger();

    public TEErrInfoReturn doAfterSendMessage(int neid, SubFunc subFunc, List<Operation> operationList) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        Operation oper = operationList.get(0);
        Output[] outputList = oper.getOutput();
        if (null == outputList || !"0".equals(outputList[0].getFault(0).getCode())) {
            return errRet;
        }
        TEErrInfoReturn tempErrRet = new TEErrInfoReturn();
        for (Output data : outputList) {
            this.handleVlanGroupData(neid, oper, tempErrRet, data);
            if (0 == tempErrRet.getResult()) continue;
            errRet.setResult(2);
            errRet.addErrInfo(tempErrRet.getErrList());
        }
        return errRet;
    }

    private void handleVlanGroupData(int neID, Operation oper, TEErrInfoReturn errRet, Output data) {
        int firstVlan = TEBeanPluginUtil.getOutputPartValueInt((Output)data, (String)"firstVlan", (int)-1);
        int totalVlan = TEBeanPluginUtil.getOutputPartValueInt((Output)data, (String)"totalVlan", (int)-1);
        if (firstVlan == -1 && totalVlan == -1) {
            return;
        }
        int slotid = TEBeanPluginUtil.getOutputPartValueInt((Output)data, (String)"slotid", (int)-1);
        int port = TEBeanPluginUtil.getOutputPartValueInt((Output)data, (String)"port", (int)-1);
        TEWebLCTVlanGroupMOPO bPathMO = TEVlangroupDbMgr.getVlanGroupFromDB(neID, slotid, port, firstVlan);
        if (0 == errRet.getResult()) {
            if (null == bPathMO) {
                logger.info("tdcMO is null! will create!");
                bPathMO = new TEWebLCTVlanGroupMOPO();
                bPathMO.setBoard(slotid);
                bPathMO.setPort(port);
                bPathMO.setVlanid(firstVlan);
                bPathMO.setVlannum(totalVlan);
                TEVlangroupDbMgr.createVlanGroupMOToDB(neID, bPathMO, errRet);
            } else {
                bPathMO.setVlanid(firstVlan);
                bPathMO.setVlannum(totalVlan);
                TEVlangroupDbMgr.updateVlanGroupMOToDB(neID, bPathMO, errRet);
            }
        }
        TEBeanPluginUtil.fillErrorToOperation((Operation)oper, (TEErrInfoReturn)errRet);
    }
}

