/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.vlangroup;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TEAddVlangroupBean
extends TENEExplorerBean {
    private int slotID = -1;
    private String operObj = "";
    private TEResourceUtil res = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        int lenRow = rowParams.length;
        for (int i = 0; i < lenRow; ++i) {
            Param[] paramArr = rowParams[i].getParam();
            int len = paramArr.length;
            for (int j = 1; j < len; ++j) {
                String name = paramArr[j].getName();
                String value = paramArr[j].getValue();
                if (!name.equalsIgnoreCase("slotID")) continue;
                this.slotID = Integer.parseInt(value);
            }
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int i;
            TENE neObj;
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 1090646019) {
                return;
            }
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo2 = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            this.operObj = null == (neObj = TENEListMgr.getInstance().getNE(neid)) ? String.valueOf(neid) : neObj.getNEName();
            if (errorCode == 0) {
                loginfo2 = new TELogInfo();
                loginfo2.setResult(0);
                loginfo2.setErrCode(0);
                loginfo2.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo2);
            } else if (errorCode == 2 || errorCode == 1) {
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    int size = rowErrors.length;
                    for (int j = 0; j < size; ++j) {
                        loginfo2 = new TELogInfo();
                        loginfo2.setResult(2);
                        loginfo2.setErrCode(Integer.parseInt(rowErrors[j].getErrorMessage().getErrorcode()));
                        loginfo2.setErrInfo(rowErrors[j].getErrorMessage().getErrorinfo());
                        loginfoList.add(loginfo2);
                    }
                }
            } else {
                loginfo2 = new TELogInfo();
                loginfo2.setResult(2);
                loginfo2.setErrCode(errorCode);
                loginfo2.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo2);
            }
            int size = loginfoList.size();
            for (i = 0; i < size; ++i) {
                loginfo2 = (TELogInfo)loginfoList.get(i);
                loginfo2.setCmdID(subfunc.getCode());
                loginfo2.setLocation(ipAddress);
                loginfo2.setUserID(userID);
                loginfo2.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo2.setOperateObject(this.operObj);
                loginfo2.setOperateDesc(this.operationDescribtion());
                loginfo2.setOperateName(this.res.getString("add_vlangroup"));
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private String operationDescribtion() {
        StringBuffer operDesc = new StringBuffer();
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        RowParams rowParams = this.inputData.getBussinessParams().getRowParams(0);
        String PortName = "";
        int Port = -1;
        String firstVlan = "";
        String totalVlan = "";
        if (null != rowParams.getParam("port") && 65535 != Integer.parseInt(rowParams.getParam("port").getValue())) {
            Port = Integer.parseInt(rowParams.getParam("port").getValue());
        }
        PortName = 32768 > Port ? "PORT" + Port : "VCTRUNK" + (Port - 32768);
        if (null != rowParams.getParam("firstVlan")) {
            firstVlan = rowParams.getParam("firstVlan").getValue();
        }
        if (null != rowParams.getParam("totalVlan")) {
            totalVlan = rowParams.getParam("totalVlan").getValue();
        }
        String SERVICE_OAM_RES = "ip" + File.separator + "ngwdm" + File.separator + "res" + File.separator + "vlangroup" + File.separator + "vlangroupres_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
        this.res = TEGetFilePath.getResource((int)this.neid, (String)SERVICE_OAM_RES);
        StringBuffer filePath = new StringBuffer();
        String devVersion = configurDataMgr.getNE(this.neid).getDevPkgVersion();
        filePath.append(TEPathManager.PACKAGE_PATH).append(devVersion).append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("ip").append(File.separator).append("vlangroupres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        operDesc.append(this.res.getString("board")).append(":").append(TEBoardUtil.getShelfBoardName((int)this.neid, (int)this.slotID) + " ").append(this.res.getString("port")).append(":").append(PortName + ",").append(this.res.getString("firstVlan")).append(":").append(firstVlan + ",").append(this.res.getString("totalVlan")).append(":").append(totalVlan);
        return operDesc.toString();
    }
}

