/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.tunnel;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import java.util.ArrayList;

public class TEQueryTunnelBean
extends TENEExplorerBean {
    private final int RESULT_NULL = 38662;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.handleMessage(neid, operationList, subfunc, this.getFilterErrorCodeList());
        this.processAllData();
    }

    private void processAllData() {
        TENE currentNE = TENEListMgr.getInstance().getNE(this.neid);
        BussinessParams bp = this.outputData.getBussinessParams();
        RowParams[] rpArray = bp.getRowParams();
        for (int i = 0; i < rpArray.length; ++i) {
            RowParams rp = rpArray[i];
            this.processNextHopIp(rp);
            this.processBoardName(rp, currentNE);
        }
    }

    private void processNextHopIp(RowParams rp) {
        Param nextHopIpParam = rp.getParam("nextHopIp");
        if (nextHopIpParam != null) {
            String hexIpValue = nextHopIpParam.getValue();
            String strIpValue = this.translateHexToIp(hexIpValue);
            nextHopIpParam.setValue(strIpValue);
        }
    }

    private void processBoardName(RowParams rp, TENE currentNE) {
        Param slotidParam = rp.getParam("slotid");
        if (slotidParam != null) {
            String slotid = slotidParam.getValue();
            String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)Integer.valueOf(slotid));
            TEBoard board = currentNE.getBoard(Integer.parseInt(slotid));
            String boardName = board.getBoardName();
            String neName = currentNE.getNEName();
            if (!"".equals(subrackName)) {
                neName = neName + "-" + subrackName;
            }
            Param paramNeName = new Param();
            paramNeName.setName("neName");
            paramNeName.setValue(neName);
            rp.addParam(paramNeName);
            Param paramBoadName = new Param();
            paramBoadName.setName("boardName");
            paramBoadName.setValue(boardName);
            rp.addParam(paramBoadName);
        }
    }

    private String translateHexToIp(String hexValue) {
        if (hexValue == null || hexValue.length() == 0) {
            return "-";
        }
        while (hexValue.length() < 8) {
            hexValue = "0" + hexValue;
        }
        String[] subStrArray = new String[4];
        String finalString = "";
        StringBuffer stringBuffer = new StringBuffer(finalString);
        for (int i = 0; i < 4; ++i) {
            subStrArray[i] = hexValue.substring(i * 2, i * 2 + 2);
            subStrArray[i] = "" + Long.valueOf(subStrArray[i], 16);
            stringBuffer.append(subStrArray[i]).append(".");
        }
        finalString = stringBuffer.toString();
        finalString = finalString.substring(0, finalString.length() - 1);
        return finalString;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList list = super.getFilterErrorCodeList();
        list.add(new Integer(38662));
        return list;
    }
}

