/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.tunnel;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;

public class TECreateTunnelBean
extends TENEExplorerBean {
    private static final String NSCMD_ETHN_SET_PORTENABLE = "NSCMD_ETHN_SET_PORTENABLE";
    private static final String NSCMD_ETHN_CFG_CREATE_TRANSITTUNNEL_WBID = "NSCMD_ETHN_CFG_CREATE_TRANSITTUNNEL_WBID";
    private static final String NSCMD_ETHN_SET_PORT_TYPE = "NSCMD_ETHN_SET_PORT_TYPE";
    private static final int VCTURNK_BASE = 32768;
    private static final Integer WRONG_PORTTYPE = 39691;
    private static final Integer ERPS_EXIST = 44028;
    public TEResourceUtil resourceUtil = null;

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList operList = super.getOperation(neid, subFunc, inputData, memeryData);
        this.processPositiveOperation(operList);
        this.whetherNeedToProcessReverseOperation(operList);
        this.processAllPortsEnableOperation(operList);
        this.setPortsAsNNI(operList);
        return operList;
    }

    private void processPositiveOperation(ArrayList operList) {
        Operation op = (Operation)operList.get(0);
        Input input = op.getInput();
        Part nextHopIpPart = input.getPart("nextHopIp");
        String nextHopIp = nextHopIpPart.getValue();
        String protoNextHopIp = this.convertIpToPrototype(nextHopIp);
        nextHopIpPart.setValue(protoNextHopIp);
    }

    private void whetherNeedToProcessReverseOperation(ArrayList operList) {
        BussinessParams bp = this.inputData.getBussinessParams();
        RowParams rp = bp.getRowParams(0);
        Param dualDiretParam = rp.getParam("dualdiretion");
        String dualDiretion = dualDiretParam.getValue();
        if ("0".equals(dualDiretion)) {
            return;
        }
        this.processReverseDirectionOperation(operList);
    }

    private void processReverseDirectionOperation(ArrayList operList) {
        BussinessParams bp = this.inputData.getBussinessParams();
        RowParams rp = bp.getRowParams(0);
        Param slotIdParam = rp.getParam("slotid");
        Param tunnelIndexParam = rp.getParam("tunnelIndexR");
        Param inPortParam = rp.getParam("outPort");
        Param inLabelParam = rp.getParam("inLabelR");
        Param outPortParam = rp.getParam("inPort");
        Param outLabelParam = rp.getParam("outLabelR");
        Param nextHopIpParam = rp.getParam("nextHopIpR");
        String slotId = slotIdParam.getValue();
        String tunnelIndex = tunnelIndexParam.getValue();
        String inPort = inPortParam.getValue();
        String inLabel = inLabelParam.getValue();
        String outPort = outPortParam.getValue();
        String outLabel = outLabelParam.getValue();
        String nextHopIp = nextHopIpParam.getValue();
        long iTunnelIndex = Long.parseLong(tunnelIndex);
        tunnelIndex = "" + iTunnelIndex;
        nextHopIp = this.convertIpToPrototype(nextHopIp);
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETHN_CFG_CREATE_TRANSITTUNNEL_WBID);
        Input input = oper.getInput();
        Part slotidPart = input.getPart("slotid");
        slotidPart.setValue(slotId);
        Part tunnelIndexPart = input.getPart("tunnelIndex");
        tunnelIndexPart.setValue(tunnelIndex);
        Part inPortPart = input.getPart("inPort");
        inPortPart.setValue(inPort);
        Part inLabelPart = input.getPart("inLabel");
        inLabelPart.setValue(inLabel);
        Part outPortPart = input.getPart("outPort");
        outPortPart.setValue(outPort);
        Part outLabelPart = input.getPart("outLabel");
        outLabelPart.setValue(outLabel);
        Part nextHopIpPart = input.getPart("nextHopIp");
        nextHopIpPart.setValue(nextHopIp);
        operList.add(oper);
    }

    private void processAllPortsEnableOperation(ArrayList operList) {
        this.processPortEnableOperation(operList, true);
        this.processPortEnableOperation(operList, false);
    }

    private void processPortEnableOperation(ArrayList operList, boolean isInPort) {
        String strPort = isInPort ? "inPort" : "outPort";
        String strPortEnable = isInPort ? "inPortEnable" : "outPortEnable";
        BussinessParams bp = this.inputData.getBussinessParams();
        RowParams rp = bp.getRowParams(0);
        Param slotParam = rp.getParam("slotid");
        String slotId = slotParam.getValue();
        Param portParam = rp.getParam(strPort);
        String portValue = portParam.getValue();
        int portId = Integer.parseInt(portValue);
        if (portId > 32768) {
            return;
        }
        Param portEnableParam = rp.getParam(strPortEnable);
        String portEnableValue = portEnableParam.getValue();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETHN_SET_PORTENABLE);
        Input input = oper.getInput();
        Part slotIdPart = input.getPart("slotid");
        slotIdPart.setValue(slotId);
        Part portPart = input.getPart("port");
        portPart.setValue(portValue);
        Part enablePart = input.getPart("ATTR_ETHOVERSDH_MAC_ENABLE");
        enablePart.setValue(portEnableValue);
        operList.add(oper);
    }

    private String convertIpToPrototype(String ip) {
        if (ip == null || "".equals(ip)) {
            return "";
        }
        String[] strMPIPArry = ip.replace('.', '-').split("-");
        StringBuffer strTemp = new StringBuffer();
        int len = strMPIPArry.length;
        for (int i = 0; i < len; ++i) {
            strMPIPArry[i] = Integer.toHexString(Integer.parseInt(strMPIPArry[i]));
            if (2 > strMPIPArry[i].length()) {
                strMPIPArry[i] = "0" + strMPIPArry[i];
            }
            strTemp.append(strMPIPArry[i]);
        }
        return strTemp.toString();
    }

    private void setPortsAsNNI(ArrayList operList) {
        this.setPortAsNNI(operList, true);
        this.setPortAsNNI(operList, false);
    }

    private void setPortAsNNI(ArrayList operList, boolean isInPort) {
        String strPort = isInPort ? "inPort" : "outPort";
        BussinessParams bp = this.inputData.getBussinessParams();
        RowParams rp = bp.getRowParams(0);
        Param slotParam = rp.getParam("slotid");
        String slotId = slotParam.getValue();
        Param portParam = rp.getParam(strPort);
        String portValue = portParam.getValue();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETHN_SET_PORT_TYPE);
        oper.getInput().getPart("slotid").setValue(slotId);
        oper.getInput().getPart("port").setValue(portValue);
        oper.getInput().getPart("PE_TYPE").setValue("4");
        operList.add(0, oper);
    }

    public ArrayList getFilterErrorCodeList(ArrayList opList) {
        ArrayList list = this.subfunc.getFilterErrCodeList();
        list.add(ERPS_EXIST);
        list.add(WRONG_PORTTYPE);
        if (opList != null) {
            for (int i = 0; i < opList.size(); ++i) {
                Operation op = (Operation)opList.get(i);
                if (!NSCMD_ETHN_CFG_CREATE_TRANSITTUNNEL_WBID.equals(op.getName())) continue;
                String errorCode = op.getOutput(0).getFault(0).getCode();
                if (!(WRONG_PORTTYPE + "").equals(errorCode)) continue;
                list.remove(WRONG_PORTTYPE);
                break;
            }
        }
        return list;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.handleMessage(neid, operationList, subfunc, this.getFilterErrorCodeList(operationList));
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("ip").append(File.separator).append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("transtunnel").append(File.separator).append("transtunnel_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.resourceUtil = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        String operDes = "";
        String slotidPart = rowparams.getParam("slotid").getValue();
        String tunnelIndexPart = rowparams.getParam("tunnelIndex").getValue();
        String inPortPart = rowparams.getParam("inPort").getValue();
        String inLabelPart = rowparams.getParam("inLabel").getValue();
        String outPortPart = rowparams.getParam("outPort").getValue();
        String outLabelPart = rowparams.getParam("outLabel").getValue();
        String nextHopIpPart = rowparams.getParam("nextHopIp").getValue();
        String inPortEnablePart = rowparams.getParam("inPortEnable").getValue();
        String outPortEnablePart = rowparams.getParam("outPortEnable").getValue();
        String dualdiretionPart = rowparams.getParam("dualdiretion").getValue();
        String inPortName = "";
        String outPortName = "";
        inPortName = Integer.parseInt(inPortPart) > 32768 ? TEConfigurationDataMgr.getVCTrunkName((int)(Integer.parseInt(inPortPart) - 32768)) : TEConfigurationDataMgr.getMACName((int)Integer.parseInt(inPortPart));
        outPortName = Integer.parseInt(outPortPart) > 32768 ? TEConfigurationDataMgr.getVCTrunkName((int)(Integer.parseInt(outPortPart) - 32768)) : TEConfigurationDataMgr.getMACName((int)Integer.parseInt(outPortPart));
        operDes = this.resourceUtil.getString("slotid") + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)Integer.parseInt(slotidPart)) + "," + this.resourceUtil.getString("tunnelIndex") + tunnelIndexPart + "," + this.resourceUtil.getString("inPort") + inPortName + "," + this.resourceUtil.getString("inLabel") + inLabelPart + "," + this.resourceUtil.getString("outPort") + outPortName + "," + this.resourceUtil.getString("outLabel") + outLabelPart + "," + this.resourceUtil.getString("nextHopIp") + nextHopIpPart + "," + this.resourceUtil.getString("inPortEnable") + this.resourceUtil.getString("enable_" + inPortEnablePart) + "," + this.resourceUtil.getString("outPortEnable") + this.resourceUtil.getString("enable_" + outPortEnablePart) + "," + this.resourceUtil.getString("dualdiretion") + this.resourceUtil.getString("dualdiretion_" + dualdiretionPart);
        return operDes;
    }
}

