/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.sncp_v2r6c01;

import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEVlanSNCPCreateBean
extends TENEExplorerBean {
    private static final int TIME_OUT = 10;
    private String neName = null;
    private static final String DIRECTION_BI = "1";
    private static final int NSCMD_ETHN_ADD_VLANSWITCHLINK = 31017;
    private static final int NSCMD_ETHN_ADD_VLANSNCP = 31598;
    private Datainterface outputData = null;
    private int neid = -1;
    protected SubFunc subfunc = null;
    private String operObj = "";
    private RowParams rowData = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        this.neName = ne.getNEName();
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        BussinessParams businessparams = inputData.getBussinessParams();
        this.rowData = businessparams.getRowParams(0);
        RowParams rowparams = null;
        int count = 0;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            ArrayList linkOpers = this.getLinkOperations(rowparams);
            ArrayList vlansncpOpers = this.getVlanSNCPOpers(rowparams);
            rowparams = new RowParams();
            int errorCode = this.sendMessage(neid, linkOpers, vlansncpOpers);
            if (0 != errorCode) {
                RowErrors rowError = new RowErrors();
                ErrorMessage errorMessage = new ErrorMessage();
                errorMessage.setErrorcode("" + errorCode);
                errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                rowError.setErrorMessage(errorMessage);
                rowparams.addRowErrors(rowError);
                Param param = null;
                param = new Param("neName", this.neName);
                rowparams.addParam(param);
                ++count;
            }
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
        this.outputData.setErrorMessage(new ErrorMessage());
        if (0 == count) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (businessparams.getRowParamsCount() == count) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private int sendMessage(int neid, ArrayList linkOpers, ArrayList vlansncpOpers) {
        OperationResult result1 = TENECommMgr.getInstance().sendCommand(neid, (List)linkOpers, 10);
        if (0 == result1.retCode) {
            int len = linkOpers.size();
            for (int i = 0; i < len; ++i) {
                Operation operation = (Operation)linkOpers.get(i);
                TEDataConverter.handleSpecialStr((Operation)operation);
                if ("0".equals(operation.getOutput(0).getFault(0).getCode())) continue;
                return Integer.parseInt(operation.getOutput(0).getFault(0).getCode());
            }
        } else {
            return result1.retCode;
        }
        result1 = TENECommMgr.getInstance().sendCommand(neid, (List)vlansncpOpers, 10);
        if (0 == result1.retCode) {
            Operation operation = (Operation)vlansncpOpers.get(0);
            TEDataConverter.handleSpecialStr((Operation)operation);
            return Integer.parseInt(operation.getOutput(0).getFault(0).getCode());
        }
        this.doAfterSendMessage(result1.retCode, neid, this.subfunc, linkOpers);
        return result1.retCode;
    }

    private ArrayList getVlanSNCPOpers(RowParams rowparams) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Operation vlansncpOperation = TECreateObjectFactory.getOperation((int)this.neid, (int)31598);
        String wLinkID = rowparams.getParam("workLinkID").getValue();
        String pLinkID = rowparams.getParam("protectLinkID").getValue();
        Input input = vlansncpOperation.getInput();
        input.setPartValue("slotID", rowparams.getParam("slotID").getValue());
        input.setPartValue("vlansncpID", rowparams.getParam("vlansncpID").getValue());
        input.setPartValue("sncpIndentifier", rowparams.getParam("sncpIndentifier").getValue());
        input.setPartValue("workLinkID", wLinkID.split(",")[0]);
        input.setPartValue("protectLinkID", pLinkID.split(",")[0]);
        operList.add(vlansncpOperation);
        return operList;
    }

    private ArrayList getLinkOperations(RowParams rowparams) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        String wLinkID = rowparams.getParam("workLinkID").getValue();
        String pLinkID = rowparams.getParam("protectLinkID").getValue();
        String direction = rowparams.getParam("direction").getValue();
        Operation linkOperation = TECreateObjectFactory.getOperation((int)this.neid, (int)31017);
        Input input = linkOperation.getInput();
        input.setPartValue("slotid", rowparams.getParam("slotID").getValue());
        input.setPartValue("linkID", wLinkID.split(",")[0]);
        input.setPartValue("srcPort", rowparams.getParam("workSrcPort").getValue());
        input.setPartValue("srcCVlan", rowparams.getParam("workSrcVlan").getValue());
        input.setPartValue("snkPort", rowparams.getParam("workSnkPort").getValue());
        input.setPartValue("snkCVlan", rowparams.getParam("workSnkVlan").getValue());
        operList.add(linkOperation);
        Operation pLinkOperation = (Operation)linkOperation.clone();
        input = pLinkOperation.getInput();
        input.setPartValue("linkID", pLinkID.split(",")[0]);
        input.setPartValue("srcPort", rowparams.getParam("protectSrcPort").getValue());
        input.setPartValue("srcCVlan", rowparams.getParam("protectSrcVlan").getValue());
        input.setPartValue("snkPort", rowparams.getParam("protectSnkPort").getValue());
        input.setPartValue("snkCVlan", rowparams.getParam("protectSnkVlan").getValue());
        operList.add(pLinkOperation);
        if (DIRECTION_BI.equals(direction)) {
            Operation wLinkOperation1 = (Operation)linkOperation.clone();
            input = wLinkOperation1.getInput();
            input.setPartValue("linkID", wLinkID.split(",")[1]);
            input.setPartValue("srcPort", rowparams.getParam("workSnkPort").getValue());
            input.setPartValue("srcCVlan", rowparams.getParam("workSnkVlan").getValue());
            input.setPartValue("snkPort", rowparams.getParam("workSrcPort").getValue());
            input.setPartValue("snkCVlan", rowparams.getParam("workSrcVlan").getValue());
            operList.add(wLinkOperation1);
            Operation pLinkOperation1 = (Operation)linkOperation.clone();
            input = pLinkOperation1.getInput();
            input.setPartValue("linkID", pLinkID.split(",")[1]);
            input.setPartValue("srcPort", rowparams.getParam("protectSnkPort").getValue());
            input.setPartValue("srcCVlan", rowparams.getParam("protectSnkVlan").getValue());
            input.setPartValue("snkPort", rowparams.getParam("protectSrcPort").getValue());
            input.setPartValue("snkCVlan", rowparams.getParam("protectSrcVlan").getValue());
            operList.add(pLinkOperation1);
        }
        return operList;
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEVlanSNCPCreateBean.this.operationDescribtion();
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String operationDescribtion() {
        StringBuffer operDesc = new StringBuffer(40);
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        int slotID = Integer.parseInt(this.rowData.getParam("slotID").getValue());
        StringBuffer filePath = new StringBuffer(19);
        String devVersion = configurDataMgr.getNE(this.neid).getDevPkgVersion();
        filePath.append(TEPathManager.PACKAGE_PATH).append(devVersion).append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("ip").append(File.separator).append("ethernetInfo_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEResourceUtil.getInstance((String)filePath.toString());
        String protectGroupID = this.rowData.getParam("vlansncpID").getValue();
        String direction = this.rowData.getParam("direction").getValue();
        int srcPort = Integer.parseInt(this.rowData.getParam("workSrcPort").getValue());
        String workSrcPortName = "";
        workSrcPortName = 32768 > srcPort ? "PORT" + srcPort : "VCTRUNK" + (srcPort - 32768);
        String workSrcVlan = this.rowData.getParam("workSrcVlan").getValue();
        int snkPort = Integer.parseInt(this.rowData.getParam("workSnkPort").getValue());
        String workSnkPortName = "";
        workSnkPortName = 32768 > snkPort ? "PORT" + snkPort : "VCTRUNK" + (snkPort - 32768);
        String snkVlan = this.rowData.getParam("workSnkVlan").getValue();
        srcPort = Integer.parseInt(this.rowData.getParam("protectSrcPort").getValue());
        String protectSrcPortName = "";
        protectSrcPortName = 32768 > srcPort ? "PORT" + srcPort : "VCTRUNK" + (srcPort - 32768);
        String protectSrcVlan = this.rowData.getParam("protectSrcVlan").getValue();
        operDesc.append(this.operObj).append("-").append(TEBoardUtil.getShelfBoardName((int)this.neid, (int)slotID)).append(":").append(res.getString("protectGroupID")).append(":").append(protectGroupID).append(",").append(res.getString("serviceType")).append(":").append("EPL").append(",").append(res.getString("serviceDirection")).append(":").append(res.getString("serviceDirection" + direction)).append(",").append(res.getString("workService")).append(":").append(res.getString("srcPort")).append(":").append(workSrcPortName).append(",").append(res.getString("srcVlan")).append(":").append(workSrcVlan).append(",").append(res.getString("snkPort")).append(":").append(workSnkPortName).append(",").append(res.getString("snkVlan")).append(":").append(snkVlan).append(";").append(res.getString("protectionService")).append(":").append(res.getString("srcPort")).append(":").append(protectSrcPortName).append(",").append(res.getString("srcVlan")).append(":").append(protectSrcVlan);
        return operDesc.toString();
    }
}

