/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.sncp_v2r6c01;

import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEVlanSNCPConvertBean
implements TENEMgrInterface {
    private static final int TIME_OUT = 10;
    private String neName = null;
    private static final String DIRECTION_BI = "1";
    private static final int NSCMD_ETHN_ADD_VLANSWITCHLINK = 31017;
    private static final int NSCMD_ETHN_ADD_VLANSNCP = 31598;
    private Datainterface outputData = null;
    private String operObj = "";
    private int neid = -1;
    private String slotID = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        this.neName = ne.getNEName();
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = null;
        Param rowparam = null;
        int countError = 0;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            rowparam = rowparams.getParam("slotID");
            this.slotID = rowparam.getValue();
            ArrayList linkOpers = this.getLinkOperations(rowparams);
            ArrayList vlansncpOpers = this.getVlanSNCPOpers(rowparams);
            rowparams = new RowParams();
            int errorCode = this.sendMessage(neid, linkOpers, vlansncpOpers);
            if (0 != errorCode) {
                RowErrors rowError = new RowErrors();
                ErrorMessage errorMessage = new ErrorMessage();
                errorMessage.setErrorcode("" + errorCode);
                errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                rowError.setErrorMessage(errorMessage);
                rowparams.addRowErrors(rowError);
                Param param = null;
                param = new Param("neName", this.neName);
                rowparams.addParam(param);
                ++countError;
            }
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
        this.outputData.setErrorMessage(new ErrorMessage());
        if (0 == countError) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (businessparams.getRowParamsCount() == countError) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
            Param param = null;
            param = new Param("neName", this.neName);
            rowparams.addParam(param);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
            Param paramtmp = null;
            paramtmp = new Param("neName", this.neName);
            rowparams.addParam(paramtmp);
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private int sendMessage(int neid, ArrayList linkOpers, ArrayList vlansncpOpers) {
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, (List)linkOpers, 10);
        if (0 == result.retCode) {
            int len = linkOpers.size();
            for (int i = 0; i < len; ++i) {
                Operation operation = (Operation)linkOpers.get(i);
                TEDataConverter.handleSpecialStr((Operation)operation);
                if ("0".equals(operation.getOutput(0).getFault(0).getCode())) continue;
                return Integer.parseInt(operation.getOutput(0).getFault(0).getCode());
            }
        } else {
            return result.retCode;
        }
        result = TENECommMgr.getInstance().sendCommand(neid, (List)vlansncpOpers, 10);
        if (0 == result.retCode) {
            Operation operation = (Operation)vlansncpOpers.get(0);
            TEDataConverter.handleSpecialStr((Operation)operation);
            return Integer.parseInt(operation.getOutput(0).getFault(0).getCode());
        }
        return result.retCode;
    }

    private ArrayList getVlanSNCPOpers(RowParams rowparams) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Operation vlansncpOperation = TECreateObjectFactory.getOperation((int)this.neid, (int)31598);
        String pLinkID = rowparams.getParam("linkID").getValue();
        Input input = vlansncpOperation.getInput();
        input.setPartValue("slotID", rowparams.getParam("slotID").getValue());
        input.setPartValue("vlansncpID", rowparams.getParam("vlansncpID").getValue());
        input.setPartValue("sncpIndentifier", rowparams.getParam("sncpIndentifier").getValue());
        input.setPartValue("workLinkID", rowparams.getParam("workLinkID").getValue());
        input.setPartValue("protectLinkID", pLinkID.split(",")[0]);
        operList.add(vlansncpOperation);
        return operList;
    }

    private ArrayList getLinkOperations(RowParams rowparams) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        String pLinkID = rowparams.getParam("linkID").getValue();
        String direction = rowparams.getParam("direction").getValue();
        Operation linkOperation = TECreateObjectFactory.getOperation((int)this.neid, (int)31017);
        Operation pLinkOperation = (Operation)linkOperation.clone();
        Input input = pLinkOperation.getInput();
        input.setPartValue("slotid", rowparams.getParam("slotID").getValue());
        input.setPartValue("linkID", pLinkID.split(",")[0]);
        input.setPartValue("srcPort", rowparams.getParam("srcPort").getValue());
        input.setPartValue("srcCVlan", rowparams.getParam("srcVlan").getValue());
        input.setPartValue("snkPort", rowparams.getParam("snkPort").getValue());
        input.setPartValue("snkCVlan", rowparams.getParam("snkVlan").getValue());
        operList.add(pLinkOperation);
        if (DIRECTION_BI.equals(direction)) {
            Operation pLinkOperation1 = (Operation)linkOperation.clone();
            input = pLinkOperation1.getInput();
            input.setPartValue("slotid", rowparams.getParam("slotID").getValue());
            input.setPartValue("linkID", pLinkID.split(",")[1]);
            input.setPartValue("srcPort", rowparams.getParam("snkPort").getValue());
            input.setPartValue("srcCVlan", rowparams.getParam("snkVlan").getValue());
            input.setPartValue("snkPort", rowparams.getParam("srcPort").getValue());
            input.setPartValue("snkCVlan", rowparams.getParam("srcVlan").getValue());
            operList.add(pLinkOperation1);
        }
        return operList;
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEVlanSNCPConvertBean.this.operationDescribtion();
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String operationDescribtion() {
        StringBuffer operDesc = new StringBuffer();
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        StringBuffer filePath = new StringBuffer(19);
        String devVersion = configurDataMgr.getNE(this.neid).getDevPkgVersion();
        filePath.append(TEPathManager.PACKAGE_PATH).append(devVersion).append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("ip").append(File.separator).append("ethernetInfo_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        operDesc.append(this.operObj).append('-').append(TEBoardUtil.getShelfBoardName((int)this.neid, (int)Integer.parseInt(this.slotID)));
        return operDesc.toString();
    }
}

