/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.sncp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;

public class TEVlanSNCPConvertBean
implements TENEMgrInterface {
    private static final int TIME_OUT = 10;
    private String neName = null;
    private static final String DIRECTION_BI = "1";
    private Datainterface outputData = null;
    private String operObj = "";
    private int neid = -1;
    private String slotID = "";
    private static final int EPL_SERVICE = 0;
    private static final int TRANSLAT_CVLAN = 20;
    private static final int ADD_SERVICE = 6;
    private static final int STRIP_SERVICE = 8;
    private static final int TRANSLAT_SERVICE = 10;
    private int serviceType = 0;
    int errorCode = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        this.neName = ne.getNEName();
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = null;
        Param rowparam = null;
        int count = 0;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            rowparam = rowparams.getParam("slotID");
            this.slotID = rowparam.getValue();
            ArrayList linkOpers = this.getLinkOperations(rowparams);
            RowParams rowparamsoutput = new RowParams();
            this.errorCode = this.sendMessage(neid, linkOpers);
            if (0 == this.errorCode) {
                ArrayList vlansncpOpers = this.getVlanSNCPOpers(rowparams);
                if (0 == this.errorCode) {
                    this.errorCode = this.sendMessage(neid, vlansncpOpers);
                }
            }
            if (0 != this.errorCode) {
                RowErrors rowError = new RowErrors();
                ErrorMessage errorMessage = new ErrorMessage();
                errorMessage.setErrorcode("" + this.errorCode);
                errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)this.errorCode));
                rowError.setErrorMessage(errorMessage);
                rowparamsoutput.addRowErrors(rowError);
                Param param = null;
                param = new Param("neName", this.neName);
                rowparamsoutput.addParam(param);
                ++count;
            }
            this.outputData.getBussinessParams().addRowParams(rowparamsoutput);
        }
        this.outputData.setErrorMessage(new ErrorMessage());
        if (0 == count) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (businessparams.getRowParamsCount() == count) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
            Param param = null;
            param = new Param("neName", this.neName);
            rowparams.addParam(param);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
            Param param = null;
            param = new Param("neName", this.neName);
            rowparams.addParam(param);
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private int sendMessage(int neid, ArrayList operationList) {
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, (List)operationList, 10);
        if (0 == result.retCode) {
            int len = operationList.size();
            for (int i = 0; i < len; ++i) {
                Operation operation = (Operation)operationList.get(i);
                TEDataConverter.handleSpecialStr((Operation)operation);
                if ("0".equals(operation.getOutput(0).getFault(0).getCode())) continue;
                return Integer.parseInt(operation.getOutput(0).getFault(0).getCode());
            }
        }
        return result.retCode;
    }

    private ArrayList getVlanSNCPOpers(RowParams rowparams) {
        ArrayList<Operation> queryEtherList = new ArrayList<Operation>();
        Operation oper = null;
        oper = 0 == this.serviceType || 20 == this.serviceType ? TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_GET_VLANSWITCHLINK") : TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_GET_QINQLINK");
        Input input = oper.getInput();
        input.setPartValue("slotID", this.slotID);
        input.setPartValue("linkID", "0");
        queryEtherList.add(oper);
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, queryEtherList, 10);
        if (result.retCode != 0) {
            this.errorCode = result.retCode;
            return null;
        }
        Operation tmpOper = (Operation)queryEtherList.get(0);
        Output[] outputArr = tmpOper.getOutput();
        String linkid = "0";
        for (Output output : outputArr) {
            if (0 == this.serviceType || 20 == this.serviceType) {
                if (!output.getPartValue("srcPort").equals(rowparams.getParam("srcPort").getValue()) || !output.getPartValue("srcVlan").equals(rowparams.getParam("srcVlan").getValue()) || !output.getPartValue("snkPort").equals(rowparams.getParam("snkPort").getValue()) || !output.getPartValue("snkVlan").equals(rowparams.getParam("snkVlan").getValue())) continue;
                linkid = output.getPartValue("linkID");
                continue;
            }
            if (!output.getPartValue("linkType").equals(this.serviceType + "") || !output.getPartValue("srcPort").equals(rowparams.getParam("srcPort").getValue()) || !output.getPartValue("srcVlan").equals(rowparams.getParam("srcVlan").getValue()) || !output.getPartValue("srcSVlan").equals(rowparams.getParam("srcSVlan").getValue()) || !output.getPartValue("snkPort").equals(rowparams.getParam("snkPort").getValue()) || !output.getPartValue("snkVlan").equals(rowparams.getParam("snkVlan").getValue()) || !output.getPartValue("snkSVlan").equals(rowparams.getParam("snkSVlan").getValue())) continue;
            linkid = output.getPartValue("linkID");
        }
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Operation vlansncpOperation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_ADD_VLANSNCP");
        input = vlansncpOperation.getInput();
        input.setPartValue("slotID", rowparams.getParam("slotID").getValue());
        input.setPartValue("vlansncpID", rowparams.getParam("vlansncpID").getValue());
        input.setPartValue("sncpIndentifier", rowparams.getParam("sncpIndentifier").getValue());
        input.setPartValue("workLinkID", rowparams.getParam("workLinkID").getValue());
        input.setPartValue("protectLinkID", linkid);
        operList.add(vlansncpOperation);
        return operList;
    }

    private ArrayList getLinkOperations(RowParams rowparams) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        String direction = rowparams.getParam("direction").getValue();
        this.serviceType = Integer.parseInt(rowparams.getParam("serviceType").getValue());
        Operation linkOperation = null;
        switch (this.serviceType) {
            case 0: 
            case 20: {
                linkOperation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_ADD_VLANSWITCHLINK");
                break;
            }
            case 6: {
                linkOperation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_ADD_QINQINLINK_SINGLEVLAN");
                break;
            }
            case 8: {
                linkOperation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_ADD_QINQELINK_SINGLEVLAN");
                break;
            }
            case 10: {
                linkOperation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_ADD_QINQ_TRANSITLINK");
                break;
            }
            default: {
                TELogFactory.getNormalLogger().error("TEVlanSNCPConvertBean getLinkOperations get error serviceType=" + this.serviceType);
                return operList;
            }
        }
        Operation pLinkOperation = (Operation)linkOperation.clone();
        Input input = pLinkOperation.getInput();
        input.setPartValue("slotid", rowparams.getParam("slotID").getValue());
        input.setPartValue("linkID", "0");
        input.setPartValue("srcPort", rowparams.getParam("srcPort").getValue());
        input.setPartValue("srcCVlan", rowparams.getParam("srcVlan").getValue());
        input.setPartValue("snkPort", rowparams.getParam("snkPort").getValue());
        input.setPartValue("snkCVlan", rowparams.getParam("snkVlan").getValue());
        if (0 != this.serviceType && 20 != this.serviceType) {
            input.setPartValue("srcSVlan", rowparams.getParam("srcSVlan").getValue());
            input.setPartValue("snkSVlan", rowparams.getParam("snkSVlan").getValue());
        }
        operList.add(pLinkOperation);
        if (DIRECTION_BI.equals(direction)) {
            Operation pLinkOperation1 = null;
            pLinkOperation1 = 6 == this.serviceType ? TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_ADD_QINQELINK_SINGLEVLAN") : (Operation)linkOperation.clone();
            input = pLinkOperation1.getInput();
            input.setPartValue("slotid", rowparams.getParam("slotID").getValue());
            input.setPartValue("linkID", "0");
            input.setPartValue("srcPort", rowparams.getParam("snkPort").getValue());
            input.setPartValue("srcCVlan", rowparams.getParam("snkVlan").getValue());
            input.setPartValue("snkPort", rowparams.getParam("srcPort").getValue());
            input.setPartValue("snkCVlan", rowparams.getParam("srcVlan").getValue());
            if (0 != this.serviceType && 20 != this.serviceType) {
                input.setPartValue("srcSVlan", rowparams.getParam("snkSVlan").getValue());
                input.setPartValue("snkSVlan", rowparams.getParam("srcSVlan").getValue());
            }
            operList.add(pLinkOperation1);
        }
        return operList;
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEVlanSNCPConvertBean.this.operationDescribtion();
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String operationDescribtion() {
        StringBuffer operDesc = new StringBuffer();
        operDesc.append(this.operObj).append("-").append(TEBoardUtil.getShelfBoardName((int)this.neid, (int)Integer.parseInt(this.slotID)));
        return operDesc.toString();
    }
}

