/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.service_v2r8c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TEBoundPathDel
extends TENEExplorerBean {
    private static final int VCTRUNK_NUM = 32768;
    private TEResourceUtil res = null;

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        this.converInputData(inputData);
        return TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid);
    }

    private void converInputData(Datainterface inputData) {
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = null;
        String pathListStr = "";
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            pathListStr = rowparams.getParam("pathListNum").getValue();
            String[] pathListStrList = pathListStr.split(",");
            StringBuffer pathListBuf = new StringBuffer();
            int strlen = pathListStrList.length;
            for (int i = 0; i < strlen; ++i) {
                pathListBuf.append(this.tenToHex(pathListStrList[i]));
            }
            rowparams.getParam("pathListNum").setValue(pathListBuf.toString());
        }
    }

    private String tenToHex(String converNum) {
        int converHex = Integer.parseInt(converNum);
        converNum = converHex < 16 ? "000" + Integer.toHexString(converHex) : "00" + Integer.toHexString(converHex);
        return converNum;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(subfunc.getCode());
            loginfo.setLocation(ipAddress);
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                int userID = 0;
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
                loginfo.setUserID(userID);
            }
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setOperateName(subfunc.getSubFuncDes(neid));
            loginfo.setOperateObject("");
            loginfo.setOperateDesc(this.boundPathConfigDetail(inputData, neid));
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            if (null == neObj) {
                loginfo.setOperateObject(String.valueOf(neid));
            } else {
                loginfo.setOperateObject(neObj.getNEName());
            }
            if (errorCode == 0) {
                loginfo.setResult(0);
                loginfo.setErrCode(0);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo);
            } else if (errorCode == 2 || errorCode == 1) {
                loginfo.setResult(errorCode);
                if (null == outputData.getBussinessParams() || outputData.getBussinessParams().getRowParamsCount() == 0) {
                    loginfo.setErrCode(errorCode);
                }
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    if (rowErrors.length <= 0) continue;
                    loginfo.setErrCode(Integer.parseInt(rowErrors[0].getErrorMessage().getErrorcode()));
                    loginfo.setErrInfo(rowErrors[0].getErrorMessage().getErrorinfo());
                    loginfoList.add(loginfo);
                    break;
                }
            } else {
                loginfo.setResult(2);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo);
            }
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private String boundPathConfigDetail(Datainterface inputData, int neid) {
        StringBuffer strBuf = new StringBuffer();
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = null;
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        int slotId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"slotID").getValue());
        StringBuffer filePath = new StringBuffer();
        filePath.append("ip").append(File.separator).append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("ipmgr").append(File.separator).append("evplres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)neid, (StringBuffer)filePath);
        strBuf.append(TEBoardUtil.getShelfBoardName((int)neid, (int)slotId)).append(" ");
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            int vctrunk = Integer.parseInt(rowparams.getParam("vctrunk").getValue()) - 32768;
            String pathDir = rowparams.getParam("direction").getValue();
            if ("0".equals(pathDir)) {
                pathDir = "dbDir";
            } else if ("1".equals(pathDir)) {
                pathDir = "upDir";
            } else if ("2".equals(pathDir)) {
                pathDir = "downDir";
            }
            strBuf.append("VCTRUNK").append(vctrunk).append(": ").append(this.res.getString(pathDir)).append(",");
            strBuf.append(rowparams.getParam("pathList").getValue()).append("; ");
        }
        return strBuf.toString();
    }
}

