/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.service_v2r8c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;

public class TEBoundPathConfig
extends TENEExplorerBean {
    private static final String ADD_PATH = "NSCMD_ETHN_ADD_VCTRUNK_PATH";
    private static final String DEL_PATH = "NSCMD_ETHN_DEL_VCTRUNK_PATH";
    private static final String STATE = "state";
    private static final String PATHLIST = "pathListNum";
    private static final int VCTRUNK_NUM = 32768;
    private TEResourceUtil res = null;

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        return this.convertToOperation(subFunc, inputData);
    }

    public ArrayList convertToOperation(SubFunc subfunc, Datainterface inputData) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList operationList = new ArrayList();
        ArrayList<Operation> addOperationList = new ArrayList<Operation>();
        ArrayList<Operation> delOperationList = new ArrayList<Operation>();
        Operation operation = null;
        Input input = null;
        RowParams rowparams = null;
        Param rowparam = null;
        boolean modifyFlag = true;
        int defaultPartCount = 0;
        int rowlen = businessparams.getRowParamsCount();
        for (int rowInNdex = 0; rowInNdex < rowlen; ++rowInNdex) {
            rowparams = businessparams.getRowParams(rowInNdex);
            if (rowparams.getParam(STATE).getValue().equals("add")) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)ADD_PATH);
            } else {
                if (!rowparams.getParam(STATE).getValue().equals("del")) continue;
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)DEL_PATH);
            }
            if (null == operation) continue;
            input = operation.getInput();
            int partlen = input.getPartCount();
            modifyFlag = input.getPartCount() == 0;
            defaultPartCount = 0;
            String pathListStr = rowparams.getParam(PATHLIST).getValue();
            String[] pathListStrList = pathListStr.split(",");
            StringBuffer pathListBuf = new StringBuffer();
            int strlen = pathListStrList.length;
            for (int i = 0; i < strlen; ++i) {
                pathListBuf.append(this.tenToHex(pathListStrList[i]));
            }
            rowparams.getParam(PATHLIST).setValue(pathListBuf.toString());
            for (int part = 0; part < partlen; ++part) {
                rowparam = rowparams.getParam(input.getPart(part).getName());
                if (null == rowparam) {
                    if (!input.getPart(part).hasDefault()) {
                        modifyFlag = false;
                        break;
                    }
                    ++defaultPartCount;
                    continue;
                }
                if (null != rowparam.getValue()) {
                    input.getPart(part).setValue(rowparam.getValue());
                }
                if (!rowparam.getModifyFlag()) continue;
                modifyFlag = true;
            }
            if (!modifyFlag && defaultPartCount != partlen) continue;
            if (rowparams.getParam(STATE).getValue().equals("add")) {
                addOperationList.add(operation);
                continue;
            }
            if (!rowparams.getParam(STATE).getValue().equals("del")) continue;
            delOperationList.add(operation);
        }
        operationList.addAll(delOperationList);
        operationList.addAll(addOperationList);
        return operationList;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo log = new TELogInfo();
            log.setCmdID(subfunc.getCode());
            log.setLocation(ipAddress);
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                int userID = 0;
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
                log.setUserID(userID);
            }
            log.setUserName(TESysManagerBean.getInstance().getSysUser());
            log.setOperateName(subfunc.getSubFuncDes(neid));
            log.setOperateObject("");
            log.setOperateDesc(this.boundPathConfigDetail(inputData, neid));
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            if (null == neObj) {
                log.setOperateObject(String.valueOf(neid));
            } else {
                log.setOperateObject(neObj.getNEName());
            }
            if (errorCode == 0) {
                log.setResult(0);
                log.setErrCode(0);
                log.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(log);
            } else if (errorCode == 2 || errorCode == 1) {
                log.setResult(errorCode);
                if (null == outputData.getBussinessParams() || outputData.getBussinessParams().getRowParamsCount() == 0) {
                    log.setErrCode(errorCode);
                }
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    if (rowErrors.length <= 0) continue;
                    log.setErrCode(Integer.parseInt(rowErrors[0].getErrorMessage().getErrorcode()));
                    log.setErrInfo(rowErrors[0].getErrorMessage().getErrorinfo());
                    loginfoList.add(log);
                    break;
                }
            } else {
                log.setResult(2);
                log.setErrCode(errorCode);
                log.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(log);
            }
            int isize = loginfoList.size();
            for (int i = 0; i < isize; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private String boundPathConfigDetail(Datainterface inputData, int neid) {
        StringBuffer sb = new StringBuffer();
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = null;
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        int slotId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"slotID").getValue());
        StringBuffer path = new StringBuffer();
        path.append("ip").append(File.separator).append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("ipmgr").append(File.separator).append("evplres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)neid, (StringBuffer)path);
        sb.append(TEBoardUtil.getShelfBoardName((int)neid, (int)slotId)).append(" ");
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            if (!rowparams.getParam(STATE).getValue().equals("all")) continue;
            int vctrunk = Integer.parseInt(rowparams.getParam("vctrunk").getValue()) - 32768;
            String pathDir = rowparams.getParam("direction").getValue();
            if ("0".equals(pathDir)) {
                pathDir = "dbDir";
            } else if ("1".equals(pathDir)) {
                pathDir = "upDir";
            } else if ("2".equals(pathDir)) {
                pathDir = "downDir";
            }
            sb.append("VCTRUNK").append(vctrunk).append(": ").append(this.res.getString(pathDir)).append(",");
            sb.append(rowparams.getParam(PATHLIST).getValue()).append("; ");
        }
        return sb.toString();
    }

    private String tenToHex(String converNum) {
        int converHex = Integer.parseInt(converNum);
        converNum = converHex < 16 ? "000" + Integer.toHexString(converHex) : "00" + Integer.toHexString(converHex);
        return converNum;
    }
}

