/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.service_v2r6c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.service.TEEVPL;
import com.huawei.nglct.nemgr.ip.ngwdm.service.TEEVPLMgmtSuper;
import com.huawei.nglct.nemgr.ip.ngwdm.service.TEIPUtils;
import com.huawei.nglct.nemgr.ip.ngwdm.service.db.TEEVPLMgmtDBHander;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;

public class TEEVPLMgmt
extends TEEVPLMgmtSuper {
    public static final int TYPE_QINQELINKSL = 8;
    public static final int TYPE_QINQELINKDL = 9;
    public static final int TYPE_QINQTRANSIT = 10;
    public static final int TYPE_LINK = 0;
    public static final int TYPE_QINQINLINKSL = 6;
    public static final int TYPE_QINQINLINKDL = 7;
    private static ArrayList eplList = new ArrayList();
    private static ArrayList evplList = new ArrayList();
    private static int neID = -1;
    private static int slotID = -1;
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String SERVICE_RES = "ip" + File.separator + "ngwdm" + File.separator + "res" + File.separator + "ipservice" + File.separator + "ethernetInfo_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memoryData, String user, String ipAddress) {
        Datainterface outData = null;
        if (subFunc.getCode() == 2108702 && inputData.getBussinessParams().getRowParams().length > 0) {
            int tneid = -1;
            int tslotid = -1;
            boolean fromNE = true;
            Param[] tParams = inputData.getBussinessParams().getRowParams()[0].getParam();
            int size = tParams.length;
            for (int i = 0; i < size; ++i) {
                if ("showCouple".equalsIgnoreCase(tParams[i].getName())) {
                    this.showCouple = !"0".equalsIgnoreCase(tParams[i].getValue());
                    continue;
                }
                if ("showShared".equalsIgnoreCase(tParams[i].getName())) {
                    this.showShared = !"0".equalsIgnoreCase(tParams[i].getValue());
                    continue;
                }
                if ("fromNE".equalsIgnoreCase(tParams[i].getName())) {
                    fromNE = !"0".equalsIgnoreCase(tParams[i].getValue());
                    continue;
                }
                if ("neID".equalsIgnoreCase(tParams[i].getName())) {
                    tneid = Integer.parseInt(tParams[i].getValue());
                    continue;
                }
                if (!"slotID".equalsIgnoreCase(tParams[i].getName())) continue;
                tslotid = Integer.parseInt(tParams[i].getValue());
            }
            if (!fromNE && tneid == neID && tslotid == slotID) {
                TEEVPL tLink = null;
                ArrayList rList = this.coupleEvplList(eplList, evplList);
                this.outputData = new Datainterface();
                BussinessParams bussinessParams = new BussinessParams();
                this.outputData.setBussinessParams(bussinessParams);
                RowParams rowparams = null;
                int size2 = rList.size();
                for (int i = 0; i < size2; ++i) {
                    tLink = (TEEVPL)rList.get(i);
                    rowparams = tLink.toRowParams();
                    bussinessParams.addRowParams(rowparams);
                }
                rList.clear();
                this.outputData.setErrorMessage(new ErrorMessage());
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                return this.outputData;
            }
            slotID = tslotid;
            neID = tneid;
        }
        outData = super.performBussinessProcess(neid, subFunc, inputData, memoryData, user, ipAddress);
        int funCode = subFunc.getCode();
        if (2108702 == funCode) {
            if (this.isSaveEVPLToDB()) {
                TEEVPLMgmtDBHander.saveEVPLToDB(neID, slotID, inputData, outData);
            }
        } else if (2108700 == funCode && this.isDelEVPLFromDB()) {
            TEEVPLMgmtDBHander.delEVPLFromDB(neID, slotID, inputData, outData);
        }
        return outData;
    }

    @Override
    protected boolean isDelEVPLFromDB() {
        return TESysManagerBean.getInstance().isIntegratedStatus();
    }

    protected boolean isSaveEVPLToDB() {
        return TESysManagerBean.getInstance().isIntegratedStatus();
    }

    protected ArrayList parseVlanSwitchLink(Operation operation, ArrayList eplList) {
        ArrayList<RowParams> errList = new ArrayList<RowParams>();
        Output output = null;
        TEEVPL link = null;
        RowParams errRow = null;
        int linkNum = operation.getOutputCount();
        for (int j = 0; j < linkNum; ++j) {
            output = operation.getOutput(j);
            errRow = TEIPUtils.handleRowError(output);
            if (errRow != null) {
                errList.add(errRow);
                continue;
            }
            link = new TEEVPL();
            int partNum = output.getPartCount();
            for (int k = 0; k < partNum; ++k) {
                link.setPropValue(output.getPart(k));
            }
            link.direction = 0;
            link.linkType = 0;
            if (link.upLinkID > 0) {
                eplList.add(link);
                continue;
            }
            TELogFactory.getNormalLogger().error("parseVlanSwitchLink() invalid link=" + link);
        }
        return errList;
    }

    @Override
    protected boolean isCoupleQinQEvpl(TEEVPL evpl1, TEEVPL evpl2) {
        if (evpl1.srcPort != evpl2.snkPort || evpl1.snkPort != evpl2.srcPort || evpl1.oamEnable != evpl2.oamEnable) {
            return false;
        }
        int firstType = evpl1.linkType;
        int secondType = evpl2.linkType;
        if (secondType == 6 && firstType == 8 || secondType == 8 && firstType == 6) {
            if (firstType == 8) {
                if (evpl2.srcVlan != evpl2.snkVlan) {
                    return evpl2.srcSVlan == evpl1.snkSVlan && evpl2.snkSVlan == evpl1.srcSVlan && evpl2.srcVlan == evpl1.snkVlan && evpl2.srcVlan != evpl1.srcVlan;
                }
                return evpl2.snkSVlan == evpl1.srcSVlan && 65535 == evpl1.snkSVlan && 65535 == evpl1.srcVlan && 65535 == evpl1.snkVlan && (65535 == evpl1.srcVlan && 65535 == evpl2.srcVlan || evpl2.srcVlan != evpl1.srcVlan);
            }
            if (secondType == 8) {
                if (evpl1.srcVlan != evpl1.snkVlan) {
                    return evpl2.srcSVlan == evpl1.snkSVlan && evpl2.snkSVlan == evpl1.srcSVlan && evpl2.snkVlan == evpl1.srcVlan && evpl2.srcVlan != evpl1.srcVlan;
                }
                return evpl2.srcSVlan == evpl1.snkSVlan && 65535 == evpl2.snkSVlan && 65535 == evpl2.srcVlan && 65535 == evpl2.snkVlan && (65535 == evpl2.srcVlan && 65535 == evpl1.srcVlan || evpl2.srcVlan != evpl1.srcVlan);
            }
            return evpl2.srcSVlan == evpl1.snkSVlan && evpl2.snkSVlan == evpl1.srcSVlan;
        }
        if (secondType == 9 && firstType == 7 || secondType == 7 && firstType == 9) {
            return evpl2.srcSVlan == evpl1.snkSVlan && evpl2.snkSVlan == evpl1.srcSVlan;
        }
        if (secondType == 0 && firstType == 0) {
            return evpl2.srcVlan == evpl1.snkVlan && evpl2.snkVlan == evpl1.srcVlan && evpl1.isActive == evpl2.isActive;
        }
        if (secondType == 1 && firstType == 1) {
            return evpl2.srcVlan == evpl1.snkVlan && evpl2.snkVlan == evpl1.srcVlan && evpl1.isActive == evpl2.isActive;
        }
        return false;
    }

    @Override
    protected String operationDescribtion() {
        StringBuffer desSb = new StringBuffer();
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotID);
        int boardType = configurDataMgr.getBoard(neID, slotID).getBoardType();
        String boardName = configurDataMgr.getBoardTypeName(neID, boardType);
        this.resourceUtil = TEGetFilePath.getResource((int)neID, (String)SERVICE_RES);
        desSb.append(this.resourceUtil.getString("board")).append(":");
        if (!"".equals(subrackName)) {
            desSb.append(subrackName).append("-");
        }
        desSb.append(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotID)).append("-").append(boardName);
        return desSb.toString();
    }
}

