/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.service.db;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.lpt.TEWebLCTLinklpt;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class TELinklptDBMgr {
    private static final Logger logger = TELogFactory.getNormalLogger();

    private TELinklptDBMgr() {
    }

    private static void logExpErrOnCreate(int neID, Exception e) {
        logger.error("create  fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErr(int neID, int retCode) {
        String tipStr = String.format("delete  fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    public static List<TEWebLCTLinklpt> getAllLinklptFromDB(int neID, int slotID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TELinklptDBMgr.getLinklptFromDB";
        logger.info("TELinklptDBMgr.getLinklptFromDB: begin.");
        ArrayList<TEWebLCTLinklpt> linkLptList = new ArrayList<TEWebLCTLinklpt>();
        TEDaoOperationResult dbRet = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TELinklptDBMgr.logNullNEError(neID);
                errRet.setResult(1090596385);
                TELinklptDBMgr.logFunEnd("TELinklptDBMgr.getLinklptFromDB");
                return linkLptList;
            }
            dbRet = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID, slotID}, TEWebLCTLinklpt.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID, slotID}, TEWebLCTLinklpt.class);
        }
        catch (Exception e) {
            logger.error("get lpt from db fail! neID->" + neID + " slotID->" + slotID, (Throwable)e);
            errRet.setResult(1092743443);
            TELinklptDBMgr.logFunEnd("TELinklptDBMgr.getLinklptFromDB");
            return linkLptList;
        }
        if (null == dbRet) {
            logger.error("get lpt from db fail! dbRet is null! neID->" + neID);
            errRet.setResult(1092743443);
            TELinklptDBMgr.logFunEnd("TELinklptDBMgr.getLinklptFromDB");
            return linkLptList;
        }
        int retCode = dbRet.getResult();
        if (0 == retCode) {
            List data = dbRet.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    linkLptList.add((TEWebLCTLinklpt)obj);
                }
            }
        } else {
            TELinklptDBMgr.logRetCodeErrorOnGet(neID, retCode);
            errRet.setResult(retCode);
        }
        TELinklptDBMgr.logFunEnd("TELinklptDBMgr.getLinklptFromDB");
        return linkLptList;
    }

    public static TEWebLCTLinklpt getLinklptByLinkid(int neID, int slotID, int linkid, TEErrInfoReturn errRet) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair("Linkid", String.valueOf(linkid));
        criteria.add(aPair);
        TEWebLCTLinklpt mopo = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findByID((int[])new int[]{neID, slotID}, TEWebLCTLinklpt.class, criteria) : TECommonDaoService.findByID_NonLock((int[])new int[]{neID, slotID}, TEWebLCTLinklpt.class, criteria);
            if (null == dbResult) {
                String tipStr = "Get TEWebLCTLinklpt fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                logger.error(tipStr);
                return mopo;
            }
        }
        catch (Exception e) {
            String tipStr = "Get TEWebLCTLinklpt fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            logger.error(tipStr, (Throwable)e);
            return mopo;
        }
        if (0 == dbResult.getResult() && dbResult.getData().size() > 0) {
            mopo = (TEWebLCTLinklpt)dbResult.getData().get(0);
        }
        return mopo;
    }

    public static void updateLinklptToDB(int neID, int slotID, TEWebLCTLinklpt mo, TEErrInfoReturn errRet) {
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID, slotID}, (Object)mo) : TECommonDaoService.update_NonLock((int[])new int[]{neID, slotID}, (Object)mo);
        }
        catch (Exception e) {
            String tipStr = "Get TEWebLCTLinklpt fail! ";
            logger.error(tipStr, (Throwable)e);
            errRet.setResult(1092743443);
            return;
        }
        if (null == dbResult) {
            TELinklptDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            errRet.setResult(retCode);
        }
    }

    public static void delLinklptFromDB(int neID, int slotID, TEWebLCTLinklpt lpt, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TELinklptDBMgr.delLinklptFromDB";
        logger.info("TELinklptDBMgr.delLinklptFromDB: begin.");
        TEDaoOperationResult dbRet = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbRet = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID, slotID}, (Object)lpt) : TECommonDaoService.delete_NonLock((int[])new int[]{neID, slotID}, (Object)lpt);
        }
        catch (Exception e) {
            logger.error("delete lpt from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TELinklptDBMgr.logFunEnd("TELinklptDBMgr.delLinklptFromDB");
            return;
        }
        if (null == dbRet) {
            TELinklptDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TELinklptDBMgr.logFunEnd("TELinklptDBMgr.delLinklptFromDB");
            return;
        }
        int retCode = dbRet.getResult();
        if (0 != retCode) {
            TELinklptDBMgr.logRetCodeErr(neID, retCode);
            errRet.setResult(retCode);
        }
        TELinklptDBMgr.logFunEnd("TELinklptDBMgr.delLinklptFromDB");
    }

    private static void logFunEnd(String funcName) {
        logger.info(funcName + ": end.");
    }

    public static void createLinklptToDB(int neID, int slotID, TEWebLCTLinklpt lpt, TEErrInfoReturn errRet) {
        String FUNCNAME = "TELinklptDBMgr.createLinklptToDB";
        logger.info("TELinklptDBMgr.createLinklptToDB: begin.");
        TEDaoOperationResult dbRet = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbRet = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID, slotID}, (Object)lpt) : TECommonDaoService.create_NonLock((int[])new int[]{neID, slotID}, (Object)lpt);
        }
        catch (Exception e) {
            TELinklptDBMgr.logExpErrOnCreate(neID, e);
            errRet.setResult(1092743443);
            TELinklptDBMgr.logFunEnd("TELinklptDBMgr.createLinklptToDB");
            return;
        }
        if (null == dbRet) {
            TELinklptDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TELinklptDBMgr.logFunEnd("TELinklptDBMgr.createLinklptToDB");
            return;
        }
        int retCode = dbRet.getResult();
        if (0 != retCode) {
            TELinklptDBMgr.logRetCodeErr(neID, retCode);
            errRet.setResult(retCode);
        }
        TELinklptDBMgr.logFunEnd("TELinklptDBMgr.createLinklptToDB");
    }

    private static void logNullError(int neID) {
        logger.error("delete clock to db device fail! neID->" + neID);
    }

    public static void delAllLinklptFromDB(int neID, int slotid, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TELinklptDBMgr.delAllLinklptFromDB";
        logger.info("TELinklptDBMgr.delAllLinklptFromDB: begin.");
        List<TEWebLCTLinklpt> lptList = TELinklptDBMgr.getAllLinklptFromDB(neID, slotid, errRet);
        for (TEWebLCTLinklpt lpt : lptList) {
            TELinklptDBMgr.delLinklptFromDB(neID, slotid, lpt, errRet);
        }
    }

    private static void logNullNEError(int neID) {
        logger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }
}

