/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.service.db;

import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfo;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfoList;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLContainer;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;

public final class TEEVPLMgmtDBHander {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEEVPLMgmtDBHander() {
    }

    public static void saveEVPLToDB(int neID, int slotID, Datainterface inputData, Datainterface outputData) {
        e2eLogger.info("saveEVPLToDB: begin.");
        int result = TEEVPLMgmtDBHander.saveEVPLToDBImpl(neID, slotID, outputData);
        if (0 != result) {
            String tipStr = "saveEVPLToDB: saveEVPLToDBImpl fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, result:%d]", neID, slotID, result);
            e2eLogger.error(tipStr);
            TEEVPLMgmtDBHander.constructErrCode(inputData, outputData, result);
        }
        e2eLogger.info("saveEVPLToDB: end.");
    }

    private static void constructErrCode(Datainterface inputData, Datainterface outputData, int result) {
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorcode(String.valueOf(result));
        RowErrors rowErrors = new RowErrors();
        rowErrors.setErrorMessage(errorMessage);
        rowErrors.setParam(inputData.getBussinessParams().getRowParams(0).getParam());
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 == retCode) {
            errorMessage = outputData.getErrorMessage();
            errorMessage.setErrorcode(String.valueOf(1));
            RowParams rowParam = new RowParams();
            rowParam.addRowErrors(rowErrors);
            outputData.getBussinessParams().addRowParams(0, rowParam);
        } else {
            outputData.getBussinessParams().getRowParams(0).addRowErrors(rowErrors);
        }
    }

    private static int saveEVPLToDBImpl(int neID, int slotID, Datainterface data) {
        e2eLogger.info("saveEVPLToDBImpl: begin.");
        List<TEEtherEVPLMOPO> evplPOList = TEEVPLMgmtDBHander.constructEVPL(data);
        if (evplPOList.isEmpty()) {
            String tipStr = "saveEVPLToDBImpl: The evplPOList is empty! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.info(tipStr);
            e2eLogger.info("saveEVPLToDBImpl: end.");
            return 0;
        }
        TEEtherEVPLContainer container = TEEthXCUtil.getContainer(neID, slotID);
        if (null == container) {
            String tipStr = "saveEVPLToDBImpl: The container is null! create new one. ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.info(tipStr);
            container = new TEEtherEVPLContainer();
        } else {
            TEEVPLMgmtDBHander.cleanContainer(container);
        }
        container.getEVPLList().addAll(evplPOList);
        int retCode = TEEthXCUtil.saveContainerToDB(neID, slotID, container);
        e2eLogger.info("saveEVPLToDBImpl: end.");
        return retCode;
    }

    private static void cleanContainer(TEEtherEVPLContainer container) {
        container.getVlanSncpList().clear();
        TEEtherEVPLMOPO evplMO = null;
        Iterator iter = container.getEVPLList().iterator();
        while (iter.hasNext()) {
            evplMO = (TEEtherEVPLMOPO)iter.next();
            if (1 != evplMO.getActivateState()) continue;
            iter.remove();
        }
    }

    private static List<TEEtherEVPLMOPO> constructEVPL(Datainterface data) {
        ArrayList<TEEtherEVPLMOPO> evplPOList = new ArrayList<TEEtherEVPLMOPO>();
        if (null == data) {
            e2eLogger.error("constructEVPL: data is null!");
            return evplPOList;
        }
        BussinessParams bussiness = data.getBussinessParams();
        if (null == bussiness) {
            e2eLogger.error("constructEVPL: bussiness is null!");
            return evplPOList;
        }
        TEEtherEVPLMOPO evplPO = null;
        RowParams rowparams = null;
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            int isActive;
            rowparams = bussiness.getRowParams(i);
            if (null == rowparams.getParam("linkType") || 0 == (isActive = Integer.parseInt(rowparams.getParam("isactive").getValue()))) continue;
            int upLinkID = Integer.parseInt(rowparams.getParam("upLinkID").getValue());
            int downLinkID = Integer.parseInt(rowparams.getParam("downLinkID").getValue());
            int linkType = Integer.parseInt(rowparams.getParam("linkType").getValue());
            int direction = Integer.parseInt(rowparams.getParam("direction").getValue());
            int srcPort = Integer.parseInt(rowparams.getParam("srcPort").getValue());
            int srcVlan = Integer.parseInt(rowparams.getParam("srcVlan").getValue());
            int srcSVlan = Integer.parseInt(rowparams.getParam("srcSVlan").getValue());
            int snkPort = Integer.parseInt(rowparams.getParam("snkPort").getValue());
            int snkVlan = Integer.parseInt(rowparams.getParam("snkVlan").getValue());
            int snkSVlan = Integer.parseInt(rowparams.getParam("snkSVlan").getValue());
            int cVlanPri = Integer.parseInt(rowparams.getParam("cVlanPri").getValue());
            int sVlanPri = Integer.parseInt(rowparams.getParam("sVlanPri").getValue());
            int oamEN = Integer.parseInt(rowparams.getParam("oamEN").getValue());
            short serviceType = (short)linkType;
            short srcPortType = (short)TEEthXCUtil.getE2EPortType(srcPort);
            short snkPortType = (short)TEEthXCUtil.getE2EPortType(snkPort);
            evplPO = new TEEtherEVPLMOPO();
            evplPO.setIDNE(upLinkID);
            evplPO.setDirection((short)0);
            evplPO.setServiceType(serviceType);
            evplPO.setSrcPortID((long)srcPort);
            evplPO.setSrcPortType(srcPortType);
            evplPO.setSrcVlanID(srcVlan);
            evplPO.setSrcSVlanID(srcSVlan);
            evplPO.setSrcTunnelLabel(-1L);
            evplPO.setSrcVCLabel(-1L);
            evplPO.setSnkPortID((long)snkPort);
            evplPO.setSnkPortType(snkPortType);
            evplPO.setSnkVlanID(snkVlan);
            evplPO.setSnkSVlanID(snkSVlan);
            evplPO.setSnkTunnelLabel(-1L);
            evplPO.setSnkVCLabel(-1L);
            evplPO.setPktPRI(cVlanPri);
            evplPO.setSVlanPRI(sVlanPri);
            evplPO.setForwardPRI(-1);
            evplPO.setActivateState((short)1);
            evplPO.setRPRdstNodeID((short)-1);
            evplPO.setRPRFwdPRI((short)-1);
            evplPO.setRPRRingDir((short)-1);
            evplPO.setLinkOAM(oamEN);
            evplPOList.add(evplPO);
            if (1 != direction) continue;
            evplPO = new TEEtherEVPLMOPO();
            evplPO.setIDNE(downLinkID);
            evplPO.setDirection((short)0);
            evplPO.setServiceType((short)TEEthXCUtil.getReverseLinkType(linkType));
            evplPO.setSrcPortID((long)snkPort);
            evplPO.setSrcPortType(snkPortType);
            evplPO.setSrcVlanID(snkVlan);
            evplPO.setSrcSVlanID(snkSVlan);
            evplPO.setSrcTunnelLabel(-1L);
            evplPO.setSrcVCLabel(-1L);
            evplPO.setSnkPortID((long)srcPort);
            evplPO.setSnkPortType(srcPortType);
            evplPO.setSnkVlanID(srcVlan);
            evplPO.setSnkSVlanID(srcSVlan);
            evplPO.setSnkTunnelLabel(-1L);
            evplPO.setSnkVCLabel(-1L);
            evplPO.setPktPRI(cVlanPri);
            evplPO.setSVlanPRI(sVlanPri);
            evplPO.setForwardPRI(-1);
            evplPO.setActivateState((short)1);
            evplPO.setRPRdstNodeID((short)-1);
            evplPO.setRPRFwdPRI((short)-1);
            evplPO.setRPRRingDir((short)-1);
            evplPO.setLinkOAM(oamEN);
            evplPOList.add(evplPO);
        }
        return evplPOList;
    }

    public static void delEVPLFromDB(int neID, int slotID, Datainterface inputData, Datainterface outputData) {
        BussinessParams bussiness = inputData.getBussinessParams();
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams rowParam = bussiness.getRowParams(i);
            int linkID = Integer.parseInt(rowParam.getParam("linkID").getValue());
            TEEthServiceOAMUtil.deleteElineOAM(neID, slotID, linkID);
        }
    }

    private static int delEVPLFromDBImpl(int neID, int slotID, Datainterface outputData) {
        e2eLogger.info("delEVPLFromDBImpl: begin");
        TEEtherEVPLContainer container = TEEthXCUtil.getContainer(neID, slotID);
        if (null == outputData) {
            e2eLogger.error("delEVPLFromDBImpl: outputData is null!");
            e2eLogger.info("delEVPLFromDBImpl: end");
            return 1090646019;
        }
        BussinessParams bussiness = outputData.getBussinessParams();
        if (null == bussiness) {
            e2eLogger.error("delEVPLFromDBImpl: bussiness is null!");
            e2eLogger.info("delEVPLFromDBImpl: end");
            return 1090646019;
        }
        int linkID = -1;
        RowParams rowParam = null;
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowParam = bussiness.getRowParams(i);
            linkID = Integer.parseInt(rowParam.getParam("linkID").getValue());
            TEEthXCUtil.delEvplFromContainer(container, linkID);
        }
        int retCode = TEEthXCUtil.saveContainerToDB(neID, slotID, container);
        e2eLogger.info("delEVPLFromDBImpl: end");
        return retCode;
    }

    public static TEErrInfoReturn delEVPLFromDB(int neID, int slotID, List<Integer> linkIDList) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(0);
        if (null == linkIDList || linkIDList.isEmpty()) {
            return errRet;
        }
        TEEtherEVPLContainer container = TEEthXCUtil.getContainer(neID, slotID);
        if (null == container) {
            TEEVPLMgmtDBHander.cosntructAllFailError(neID, slotID, linkIDList, errRet);
            return errRet;
        }
        boolean isAllSucc = true;
        boolean isAllFail = true;
        for (Integer linkID : linkIDList) {
            int errCode = TEEthXCUtil.delEvplFromContainer(container, linkID);
            if (0 != errCode) {
                TEErrInfo errInfo = new TEErrInfo();
                errInfo.setObjID(new int[]{neID, slotID, linkID});
                errInfo.setErrorCode(errCode);
                errRet.addErrInfo(errInfo);
                isAllSucc = false;
                continue;
            }
            isAllFail = true;
        }
        TEEVPLMgmtDBHander.setGlobalErrCode(errRet, isAllSucc, isAllFail);
        int retCode = TEEthXCUtil.saveContainerToDB(neID, slotID, container);
        if (0 != retCode) {
            TEEVPLMgmtDBHander.cosntructAllFailError(neID, slotID, linkIDList, errRet);
            return errRet;
        }
        return errRet;
    }

    private static void setGlobalErrCode(TEErrInfoReturn errRet, boolean isAllSucc, boolean isAllFail) {
        if (isAllSucc) {
            errRet.setResult(0);
        } else if (isAllFail) {
            errRet.setResult(2);
        } else {
            errRet.setResult(1);
        }
    }

    private static void cosntructAllFailError(int neID, int slotID, List<Integer> linkIDList, TEErrInfoReturn errRet) {
        errRet.setResult(2);
        for (Integer linkID : linkIDList) {
            TEErrInfo errInfo = new TEErrInfo();
            errInfo.setObjID(new int[]{neID, slotID, linkID});
            errInfo.setErrorCode(1092743443);
            errRet.addErrInfo(errInfo);
        }
    }

    public static QAsnEthXCInfoList constructDelMsg(int neID, int slotID, Datainterface outputData) {
        QAsnEthXCInfoList xcInfoList = new QAsnEthXCInfoList();
        if (null == outputData) {
            e2eLogger.error("constructDelMsg: outputData is null!");
            return xcInfoList;
        }
        BussinessParams bussiness = outputData.getBussinessParams();
        if (null == bussiness) {
            e2eLogger.error("constructDelMsg: bussiness is null!");
            return xcInfoList;
        }
        int linkID = -1;
        RowParams rowParam = null;
        QAsnEthXCInfo xcInfo = null;
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowParam = bussiness.getRowParams(i);
            linkID = Integer.parseInt(rowParam.getParam("linkID").getValue());
            xcInfo = new QAsnEthXCInfo();
            xcInfo.xcIndex.neID = neID;
            xcInfo.xcIndex.slotID = slotID;
            xcInfo.xcIndex.xcID = linkID;
            TEEthXCUtil.fillEmptyInfo(xcInfo);
            xcInfoList.add((Object)xcInfo);
        }
        return xcInfoList;
    }

    public static QAsnEthXCInfoList constructDelMsg(int neID, int slotID, List<Integer> delLinkIDList) {
        QAsnEthXCInfoList xcInfoList = new QAsnEthXCInfoList();
        if (delLinkIDList.isEmpty()) {
            return xcInfoList;
        }
        QAsnEthXCInfo xcInfo = null;
        for (Integer linkID : delLinkIDList) {
            xcInfo = new QAsnEthXCInfo();
            xcInfo.xcIndex.neID = neID;
            xcInfo.xcIndex.slotID = slotID;
            xcInfo.xcIndex.xcID = linkID;
            TEEthXCUtil.fillEmptyInfo(xcInfo);
            xcInfoList.add((Object)xcInfo);
        }
        return xcInfoList;
    }
}

