/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.service.db;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.service.db.TELinkIDGenerator;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLContainer;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLMOPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public final class TECreateEVPLDBHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TECreateEVPLDBHandler() {
    }

    public static List<Integer> getLinkIDList(int neID, int slotID) {
        e2eLogger.info("getLinkIDList: begin.");
        ArrayList<Integer> linkIDList = new ArrayList<Integer>();
        TEEtherEVPLContainer container = TEEthXCUtil.getContainer(neID, slotID);
        if (null == container) {
            String tipStr = "getLinkIDList: the container is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr);
            e2eLogger.info("getLinkIDList: end.");
            return linkIDList;
        }
        Set evplMOSet = null;
        Iterator evplMOIter = null;
        TEEtherEVPLMOPO evplMO2 = null;
        evplMOSet = container.getEVPLList();
        for (TEEtherEVPLMOPO evplMO2 : evplMOSet) {
            linkIDList.add(evplMO2.getIDNE());
        }
        e2eLogger.info("getLinkIDList: end.");
        return linkIDList;
    }

    public static List<TEEtherEVPLMOPO> getCreatedEVPL(int neID, int slotID, List<Integer> oldLinkIDList) {
        e2eLogger.info("getCreatedEVPL: begin.");
        ArrayList<TEEtherEVPLMOPO> evplMOList = new ArrayList<TEEtherEVPLMOPO>();
        HashSet<Integer> linkIDSet = new HashSet<Integer>();
        TEEthXCUtil.getEVPLFromNESaveDB(neID, slotID, linkIDSet);
        TEEtherEVPLContainer container = TEEthXCUtil.getContainer(neID, slotID);
        if (null == container) {
            String tipStr = "getCreatedEVPL: the container is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr);
            e2eLogger.info("getCreatedEVPL: end.");
            return evplMOList;
        }
        TEEtherEVPLMOPO evplMO2 = null;
        Set evplMOSet = container.getEVPLList();
        for (TEEtherEVPLMOPO evplMO2 : evplMOSet) {
            if (oldLinkIDList.contains(evplMO2.getIDNE())) continue;
            evplMOList.add(evplMO2);
        }
        e2eLogger.info("getCreatedEVPL: end.");
        return evplMOList;
    }

    public static Set<Integer> getCreatedLinkID(int neID, int slotID, TEEtherEVPLContainer container) {
        Set<Object> createdLinkID = null;
        createdLinkID = TESysManagerBean.getInstance().isIntegratedStatus() ? TECreateEVPLDBHandler.getCreatedLinkIDFromDB(neID, slotID, container) : new HashSet();
        return createdLinkID;
    }

    private static Set<Integer> getCreatedLinkIDFromDB(int neID, int slotID, TEEtherEVPLContainer container) {
        e2eLogger.info("getCreatedLinkIDFromDB: begin.");
        HashSet<Integer> evplMOIDList = new HashSet<Integer>();
        if (null == container) {
            String tipStr = "getCreatedLinkIDFromDB: the container is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr);
            e2eLogger.info("getCreatedLinkIDFromDB: end.");
            return evplMOIDList;
        }
        TEEtherEVPLMOPO evplMO2 = null;
        Set evplMOSet = container.getEVPLList();
        for (TEEtherEVPLMOPO evplMO2 : evplMOSet) {
            evplMOIDList.add(evplMO2.getIDNE());
        }
        e2eLogger.info("getCreatedLinkIDFromDB: end.");
        return evplMOIDList;
    }

    public static List<TEEtherEVPLMOPO> sortByGenerator(List<TEEtherEVPLMOPO> evplMOList, TELinkIDGenerator lineIDGenerator) {
        ArrayList<TEEtherEVPLMOPO> sortedEvplMOList = new ArrayList<TEEtherEVPLMOPO>(evplMOList.size());
        HashMap<Integer, TEEtherEVPLMOPO> evplMOMap = new HashMap<Integer, TEEtherEVPLMOPO>(evplMOList.size());
        for (TEEtherEVPLMOPO evplMO : evplMOList) {
            evplMOMap.put(evplMO.getIDNE(), evplMO);
        }
        List<Integer> newLinkIDList = lineIDGenerator.getGeneratedLinkIDList();
        TEEtherEVPLMOPO tempEvplMO = null;
        for (Integer linkID : newLinkIDList) {
            tempEvplMO = (TEEtherEVPLMOPO)evplMOMap.get(linkID);
            if (null == tempEvplMO) continue;
            sortedEvplMOList.add(tempEvplMO);
        }
        return sortedEvplMOList;
    }
}

