/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.service;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.service.db.TELinkIDGenerator;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;

public class TEIPUtils {
    private static final String REALPAHT_NO_REALBOARD = "38669";

    static boolean isNoRecordError(String errCode) {
        return "38662".equals(errCode) || "38900".equals(errCode) || "39182".equals(errCode) || "39174".equals(errCode) || "39169".equals(errCode);
    }

    public static RowParams handleRowError(Output output) {
        RowParams errRow = null;
        String errCode = output.getFault(0).getCode();
        if (null != errCode && !"0".equals(errCode) && !TEIPUtils.isNoRecordError(errCode)) {
            errRow = new RowParams();
            RowErrors err = new RowErrors();
            ErrorMessage errMsg = new ErrorMessage();
            errMsg.setErrorcode(errCode);
            if (!errCode.equals("") && (output.getFault(0).getValue() == null || "".equals(output.getFault(0).getValue()))) {
                errMsg.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errCode)));
            } else {
                errMsg.setErrorinfo(output.getFault(0).getValue());
            }
            err.setErrorMessage(errMsg);
            Param errParam = new Param();
            errParam.setName("linkID");
            String errLinkID = "-1";
            Part part = null;
            int partNum = output.getPartCount();
            for (int partIndex = 0; partIndex < partNum; ++partIndex) {
                part = output.getPart(partIndex);
                if (!"linkID".equalsIgnoreCase(part.getName())) continue;
                if (null == part.getValue()) break;
                errLinkID = part.getValue();
                break;
            }
            errParam.setValue(errLinkID);
            errRow.addRowErrors(err);
        }
        return errRow;
    }

    public static RowParams handleRowError(int neid, int slotID, Output output) {
        RowParams errorRow = null;
        String errCode = output.getFault(0).getCode();
        if (null != errCode && !"0".equals(errCode) && !TEIPUtils.isNoRecordError(errCode)) {
            errorRow = new RowParams();
            RowErrors err1 = new RowErrors();
            ErrorMessage errMsg = new ErrorMessage();
            errMsg.setErrorcode(errCode);
            if (!errCode.equals("") && (output.getFault(0).getValue() == null || "".equals(output.getFault(0).getValue()))) {
                errMsg.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errCode)));
            } else {
                errMsg.setErrorinfo(output.getFault(0).getValue());
            }
            err1.setErrorMessage(errMsg);
            Param errParam = new Param();
            errParam.setName("linkID");
            String errLinkID = "-1";
            Part part1 = null;
            int partNum = output.getPartCount();
            for (int partIndex = 0; partIndex < partNum; ++partIndex) {
                part1 = output.getPart(partIndex);
                if (!"linkID".equalsIgnoreCase(part1.getName())) continue;
                if (null == part1.getValue()) break;
                errLinkID = part1.getValue();
                break;
            }
            errParam.setValue(errLinkID);
            err1.addParam(errParam);
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            Param nenameParam = new Param();
            nenameParam.setName("nename");
            nenameParam.setValue(neObj.getNEName());
            err1.addParam(nenameParam);
            Param slotidParam = new Param();
            slotidParam.setName("slotID");
            slotidParam.setValue(String.valueOf(slotID));
            err1.addParam(slotidParam);
            Param boardnameParam = new Param();
            boardnameParam.setName("boardname");
            boardnameParam.setValue(neObj.getBoard(slotID).getBoardName());
            err1.addParam(boardnameParam);
            Param queryInfo = new Param();
            queryInfo.setName("queryInfo");
            if (REALPAHT_NO_REALBOARD.equals(errCode)) {
                queryInfo.setValue("RealPathNoBoard");
            } else {
                queryInfo.setValue("");
            }
            err1.addParam(queryInfo);
            errorRow.addRowErrors(err1);
        }
        return errorRow;
    }

    public static Datainterface resetInputData(Datainterface inputData, TELinkIDGenerator lineIDGenerator) {
        RowParams rowParams = null;
        RowParams tmpRowParams = null;
        Datainterface rInputData = new Datainterface();
        BussinessParams rBussinessParams = new BussinessParams();
        rInputData.setBussinessParams(rBussinessParams);
        BussinessParams bussinessParams = inputData.getBussinessParams();
        int m = bussinessParams.getRowParamsCount();
        for (int i = 0; i < m; ++i) {
            String[] snkCVlans;
            int snkLength;
            rowParams = bussinessParams.getRowParams(i);
            String[] srcCVlans = rowParams.getParam("srcCVlan").getValue().split(",");
            int srcLength = srcCVlans.length;
            if (srcLength > (snkLength = (snkCVlans = rowParams.getParam("snkCVlan").getValue().split(",")).length)) {
                for (int j = 0; j < srcLength; ++j) {
                    tmpRowParams = (RowParams)rowParams.clone();
                    tmpRowParams.getParam("srcCVlan").setValue(srcCVlans[j]);
                    tmpRowParams.getParam("snkCVlan").setValue(snkCVlans[0]);
                    rBussinessParams.addRowParams(tmpRowParams);
                }
                continue;
            }
            if (srcLength < snkLength) {
                for (int k = 0; k < snkLength; ++k) {
                    tmpRowParams = (RowParams)rowParams.clone();
                    tmpRowParams.getParam("srcCVlan").setValue(srcCVlans[0]);
                    tmpRowParams.getParam("snkCVlan").setValue(snkCVlans[k]);
                    rBussinessParams.addRowParams(tmpRowParams);
                }
                continue;
            }
            for (int l = 0; l < srcLength; ++l) {
                tmpRowParams = (RowParams)rowParams.clone();
                tmpRowParams.getParam("srcCVlan").setValue(srcCVlans[l]);
                tmpRowParams.getParam("snkCVlan").setValue(snkCVlans[l]);
                rBussinessParams.addRowParams(tmpRowParams);
            }
        }
        int linkID = -1;
        int iSize = rBussinessParams.getRowParamsCount();
        for (int i = 0; i < iSize; ++i) {
            rowParams = rBussinessParams.getRowParams(i);
            String partValue = rowParams.getParam("linkID").getValue();
            linkID = 0;
            if (null == partValue || 0 == Integer.parseInt(partValue)) {
                linkID = lineIDGenerator.generateLinkID();
                TELogFactory.getE2ELogger().info("generate linkID->" + linkID);
            } else {
                linkID = Integer.parseInt(partValue);
            }
            rowParams.getParam("linkID").setValue(String.valueOf(linkID));
        }
        return rInputData;
    }
}

