/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.service;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEGetBoardMode;
import com.huawei.nglct.nemgr.ip.ngwdm.TENGWDMIPUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;

public class TEGetEtherBoardInfoBean
implements TENEMgrInterface {
    private int neID = -1;
    private int boardType = -1;
    private int slotID = -1;
    private Datainterface output = null;
    private static final String PORT_NM_PARAM = "portName";
    private static final String PORT_NO_PARAM = "portNO";
    private static final String NE_NAME_PARAM = "neName";
    private static final String SLOT_ID_PARAM = "slotID";
    private static final String BOARD_NAME_PARAM = "boardName";
    private Logger log = TELogFactory.getNormalLogger();
    private static final int LGCBD_NOTINSTALL = 24588;
    private int boardMode = -1;
    private boolean fail = false;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        this.output = new Datainterface();
        try {
            Param tparam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)SLOT_ID_PARAM);
            this.slotID = Integer.parseInt(tparam.getValue());
            this.getEthBoardInfo(subFunc, memeryData);
            if (!this.fail) {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            }
        }
        catch (Exception ex) {
            this.log.error("Get BoardInfo Fail!\n", (Throwable)ex);
        }
        return this.output;
    }

    private void getEthBoardInfo(SubFunc subFunc, Datainterface memeryData) {
        ArrayList vcPortList;
        int portNO = -1;
        RowParams rowParam1 = null;
        String portName = "";
        TEConfigurationDataMgr confDataMgr = TEConfigurationDataMgr.getInstance();
        if (null == confDataMgr.getBoard(this.neID, this.slotID)) {
            this.fail = true;
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)24588));
            return;
        }
        this.boardType = confDataMgr.getBoard(this.neID, this.slotID).getBoardType();
        Param param = null;
        rowParam1 = new RowParams();
        TENE neObj = TENEListMgr.getInstance().getNE(this.neID);
        if (neObj != null) {
            param = new Param(NE_NAME_PARAM, neObj.getNEName());
            rowParam1.addParam(param);
        }
        param = new Param(BOARD_NAME_PARAM, confDataMgr.getBoardTypeName(this.neID, this.boardType));
        rowParam1.addParam(param);
        rowParam1.addParam(new Param("subrackid", String.valueOf(TEBoardUtil.getSubrackIDFromSlot((int)this.neID, (int)this.slotID))));
        rowParam1.addParam(new Param("subrackname", TEBoardUtil.getSubrackNameFromSlot((int)this.neID, (int)this.slotID)));
        rowParam1.addParam(new Param("showslotid", String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)this.neID, (int)this.slotID))));
        this.output.setBussinessParams(new BussinessParams());
        this.output.getBussinessParams().addRowParams(rowParam1);
        if (TENGWDMIPUtil.isLEM18Board(this.boardType)) {
            this.boardMode = TEGetBoardMode.queryBoardMode((int)this.neID, (int)this.slotID);
        }
        ArrayList macPortList = this.getMacPortList();
        Collections.sort(macPortList);
        ArrayList<Integer> PortList = new ArrayList<Integer>();
        int len = macPortList.size();
        for (int i = 0; i < len; ++i) {
            portNO = Integer.parseInt(macPortList.get(i).toString());
            if (PortList.contains(portNO)) continue;
            PortList.add(portNO);
            portName = TEConfigurationDataMgr.getMACName((int)portNO);
            rowParam1 = new RowParams();
            param = new Param(PORT_NO_PARAM, String.valueOf(portNO));
            rowParam1.addParam(param);
            param = new Param(PORT_NM_PARAM, portName);
            rowParam1.addParam(param);
            this.output.getBussinessParams().addRowParams(rowParam1);
        }
        if (TENGWDMIPUtil.isLEM18Board(this.boardType)) {
            vcPortList = TENGWDMIPUtil.getVCTrunkPortList(this.neID, this.slotID, this.boardType, this.boardMode);
            TENGWDMIPUtil.filterVCTRUNKPort(macPortList, vcPortList);
        } else {
            vcPortList = confDataMgr.getETHVCTrunkPort(this.neID, this.slotID, this.boardType);
        }
        Collections.sort(vcPortList);
        int len2 = vcPortList.size();
        for (int i = 0; i < len2; ++i) {
            portNO = Integer.parseInt(vcPortList.get(i).toString());
            if (PortList.contains(portNO)) continue;
            PortList.add(portNO);
            portName = TEConfigurationDataMgr.getVCTrunkName((int)(portNO - 32768));
            rowParam1 = new RowParams();
            param = new Param(PORT_NO_PARAM, String.valueOf(portNO));
            rowParam1.addParam(param);
            param = new Param(PORT_NM_PARAM, portName);
            rowParam1.addParam(param);
            this.output.getBussinessParams().addRowParams(rowParam1);
        }
    }

    private ArrayList getMacPortList() {
        ArrayList allPortList;
        if (TENGWDMIPUtil.isLEM18Board(this.boardType)) {
            allPortList = TENGWDMIPUtil.getMACPortList(this.neID, this.slotID, this.boardType, this.boardMode);
        } else {
            int cVer;
            allPortList = TEConfigurationDataMgr.getInstance().getETHMACPort(this.neID, this.boardType);
            String neVer = TEConfigurationDataMgr.getInstance().getNE(this.neID).getHostVersion();
            int rVer = Integer.parseInt(neVer.split("\\.")[2]);
            if (rVer * 100 + (cVer = Integer.parseInt(neVer.split("\\.")[3])) < 320) {
                return allPortList;
            }
        }
        ArrayList existPortList = this.getExistPortList(allPortList);
        if (existPortList.isEmpty()) {
            return allPortList;
        }
        return existPortList;
    }

    private ArrayList getExistPortList(ArrayList portList) {
        try {
            ArrayList<Object> operationList = new ArrayList<Object>();
            Operation oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_PORT");
            Input input = oper.getInput();
            Part part = input.getPart(SLOT_ID_PARAM);
            part.setValue(String.valueOf(this.slotID));
            part = input.getPart("portID");
            int size = portList.size();
            for (int i = 0; i < size; ++i) {
                part.setValue(String.valueOf((Integer)portList.get(i)));
                operationList.add(oper.clone());
            }
            ArrayList<Integer> returnList = new ArrayList<Integer>();
            if (operationList.size() == 0) {
                return returnList;
            }
            int result = TENECommMgr.getInstance().sendCommand((int)this.neID, operationList, (int)10).retCode;
            if (result == 0) {
                int len = operationList.size();
                for (int j = 0; j < len; ++j) {
                    Operation oOperation = (Operation)operationList.get(j);
                    if (!String.valueOf(0).equals(oOperation.getOutput()[0].getFault()[0].getCode())) continue;
                    String portId = oOperation.getOutput()[0].getPartValue("portID");
                    returnList.add(Integer.valueOf(portId));
                }
            }
            return returnList;
        }
        catch (Exception e) {
            return new ArrayList();
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

