/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.service;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.uflight.qxprotocol.definitions.Part;

public class TEEVPLPortProperty
implements Comparable {
    static final int INT_INVALID = 65535;
    static final int BYTE_INVALID = 255;
    public int port = 65535;
    public int portType = 255;
    public int portEnable = 255;
    public int portTag = 255;

    public TEEVPLPortProperty() {
    }

    public TEEVPLPortProperty(TEEVPLPortProperty other) {
        this.port = other.port;
        this.portType = other.portType;
        this.portEnable = other.portEnable;
        this.portTag = other.portTag;
    }

    public boolean setPropValue(Part part) {
        return this.setPropValue(part.getName(), part.getValue(), part.getType());
    }

    boolean setPropValue(String propName, String value, String type) {
        int intValue = 65535;
        if ("slotID".equalsIgnoreCase(propName)) {
            return false;
        }
        try {
            if (!"INT".equalsIgnoreCase(type) && !"BYTE".equalsIgnoreCase(type)) {
                TELogFactory.getNormalLogger().error("setPropValue() invalid type=" + propName + "," + type);
                return false;
            }
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            TELogFactory.getNormalLogger().error("setPropValue() parsing: " + propName + "," + value, (Throwable)nfe);
            return false;
        }
        if ("port".equalsIgnoreCase(propName)) {
            this.port = intValue;
        } else if ("portType".equalsIgnoreCase(propName)) {
            this.portType = intValue;
        } else if ("portEnable".equalsIgnoreCase(propName)) {
            this.portEnable = intValue;
        } else if ("portTag".equalsIgnoreCase(propName)) {
            this.portTag = intValue;
        } else {
            TELogFactory.getNormalLogger().error("setPropValue() invalid name=" + propName);
            return false;
        }
        return true;
    }

    public RowParams toRowParams() {
        RowParams rowParams = new RowParams();
        Param param = null;
        param = new Param("port", String.valueOf(this.port));
        rowParams.addParam(param);
        param = new Param("portType", String.valueOf(this.portType));
        rowParams.addParam(param);
        param = new Param("portEnable", String.valueOf(this.portEnable));
        rowParams.addParam(param);
        param = new Param("portTag", String.valueOf(this.portTag));
        rowParams.addParam(param);
        return rowParams;
    }

    public String toString() {
        return "" + this.port;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TEEVPLPortProperty)) {
            return false;
        }
        TEEVPLPortProperty other = (TEEVPLPortProperty)obj;
        return this.port == other.port;
    }

    public int hashCode() {
        return this.port;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof TEEVPLPortProperty)) {
            return 1;
        }
        TEEVPLPortProperty other = (TEEVPLPortProperty)obj;
        return this.port - other.port;
    }
}

