/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.service;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ip.ngwdm.service.TEEVPL;
import com.huawei.nglct.nemgr.ip.ngwdm.service.TEEVPLPortProperty;
import com.huawei.nglct.nemgr.ip.ngwdm.service.TEIPUtils;
import com.huawei.nglct.nemgr.ip.ngwdm.service.db.TEEVPLMgmtDBHander;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TEEVPLMgmt_05370410v01
extends TENEExplorerBean {
    private static final int SFUN_QUERY_EVPL = 11550;
    private static final int SFUN_QUERY_PORTATTR = 11111;
    private static final int NSCMD_ETHN_GET_VLANSWITCHLINK = 31443;
    private static final int NSCMD_ETHN_GET_QINQLINK = 31458;
    private static final int NSCMD_ETHN_GET_QINQINLINKDEFVLANPRI = 31460;
    private static final int NSCMD_ETHN_GET_PORT_TYPE = 30793;
    private static final int NSCMD_ETHN_GET_PORTENABLE = 29090;
    private static final int NSCMD_ETHN_GET_ETHTAG = 29122;
    private static final int NSCMD_ETHN_GET_VLANSNCP_OAMEN = 31597;
    public static final int TYPE_LINK = 0;
    public static final int TYPE_QINQINLINKSL = 6;
    public static final int TYPE_QINQINLINKDL = 7;
    public static final int TYPE_QINQELINKSL = 8;
    public static final int TYPE_QINQELINKDL = 9;
    private boolean showCouple = true;
    private boolean showShared = true;
    private static List<TEEVPL> eplList = new ArrayList<TEEVPL>();
    private static List<TEEVPL> evplList = new ArrayList<TEEVPL>();
    private static int neID = -1;
    private static int slotID = -1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memoryData, String user, String ipAddress) {
        Datainterface outData = null;
        if (subFunc.getCode() == 11550 && inputData.getBussinessParams().getRowParams().length > 0) {
            int tneID = -1;
            int tslotid = -1;
            boolean fromNE = true;
            Param[] evplParam = inputData.getBussinessParams().getRowParams()[0].getParam();
            int size = evplParam.length;
            for (int i = 0; i < size; ++i) {
                if ("showCouple".equalsIgnoreCase(evplParam[i].getName())) {
                    this.showCouple = !"0".equalsIgnoreCase(evplParam[i].getValue());
                    continue;
                }
                if ("showShared".equalsIgnoreCase(evplParam[i].getName())) {
                    this.showShared = !"0".equalsIgnoreCase(evplParam[i].getValue());
                    continue;
                }
                if ("fromNE".equalsIgnoreCase(evplParam[i].getName())) {
                    fromNE = !"0".equalsIgnoreCase(evplParam[i].getValue());
                    continue;
                }
                if ("neID".equalsIgnoreCase(evplParam[i].getName())) {
                    tneID = Integer.parseInt(evplParam[i].getValue());
                    continue;
                }
                if (!"slotID".equalsIgnoreCase(evplParam[i].getName())) continue;
                tslotid = Integer.parseInt(evplParam[i].getValue());
            }
            if (!fromNE && tneID == neID && tslotid == slotID) {
                this.outputData = new Datainterface();
                TEEVPL link = null;
                List<TEEVPL> returnList = this.coupleEvplList(eplList, evplList);
                BussinessParams bussiness = new BussinessParams();
                this.outputData.setBussinessParams(bussiness);
                RowParams rowparams = null;
                int size2 = returnList.size();
                for (int ii = 0; ii < size2; ++ii) {
                    link = returnList.get(ii);
                    rowparams = link.toRowParams();
                    bussiness.addRowParams(rowparams);
                }
                returnList.clear();
                this.outputData.setErrorMessage(new ErrorMessage());
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                return this.outputData;
            }
            neID = tneID;
            slotID = tslotid;
        }
        outData = super.performBussinessProcess(neid, subFunc, inputData, memoryData, user, ipAddress);
        if (2108702 == subFunc.getCode() && this.isSaveEVPLToDB()) {
            TEEVPLMgmtDBHander.saveEVPLToDB(neID, slotID, inputData, outData);
        }
        return outData;
    }

    protected boolean isDelEVPLFromDB() {
        return TESysManagerBean.getInstance().isIntegratedStatus();
    }

    protected boolean isSaveEVPLToDB() {
        return TESysManagerBean.getInstance().isIntegratedStatus();
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subFunc) {
        if (subFunc.getCode() == 11550) {
            BussinessParams bussinessParams = new BussinessParams();
            this.outputData.setBussinessParams(bussinessParams);
            Operation operation = null;
            eplList.clear();
            evplList.clear();
            boolean hasFault = false;
            boolean hasSucc = false;
            List<RowParams> errList = null;
            int size = operationList.size();
            for (int i = 0; i < size; ++i) {
                int errIndex;
                int errNum;
                operation = (Operation)operationList.get(i);
                if (31443 == operation.getCmdid()) {
                    errList = this.parseVlanSwitchLink(operation, eplList);
                    if (!errList.isEmpty()) {
                        hasFault = true;
                        errNum = errList.size();
                        for (errIndex = 0; errIndex < errNum; ++errIndex) {
                            bussinessParams.addRowParams(errList.get(errIndex));
                        }
                    }
                    if (eplList.isEmpty()) continue;
                    hasSucc = true;
                    continue;
                }
                if (31597 == operation.getCmdid()) {
                    errList = this.parseOAMEnable(operation, eplList);
                    if (!errList.isEmpty()) {
                        hasFault = true;
                        errNum = errList.size();
                        for (errIndex = 0; errIndex < errNum; ++errIndex) {
                            bussinessParams.addRowParams(errList.get(errIndex));
                        }
                    }
                    if (eplList.isEmpty()) continue;
                    hasSucc = true;
                    continue;
                }
                if (31458 == operation.getCmdid()) {
                    errList = this.parseQinQLink(operation, evplList);
                    if (!errList.isEmpty()) {
                        hasFault = true;
                        errNum = errList.size();
                        for (errIndex = 0; errIndex < errNum; ++errIndex) {
                            bussinessParams.addRowParams(errList.get(errIndex));
                        }
                    }
                    if (evplList.isEmpty()) continue;
                    hasSucc = true;
                    continue;
                }
                if (31460 == operation.getCmdid()) {
                    errList = this.parseVlanPri(operation, evplList);
                    if (!errList.isEmpty()) {
                        hasFault = true;
                        errNum = errList.size();
                        for (errIndex = 0; errIndex < errNum; ++errIndex) {
                            bussinessParams.addRowParams(errList.get(errIndex));
                        }
                    }
                    if (operation.getOutputCount() - errList.size() <= 0) continue;
                    hasSucc = true;
                    continue;
                }
                TELogFactory.getNormalLogger().error("handleMessage() SFUN_QUERY_EVPL got an invalid cmd: " + operation.getCmdid());
            }
            List<TEEVPL> returnList = this.coupleEvplList(eplList, evplList);
            TEEVPL link = null;
            RowParams rowparams = null;
            int size2 = returnList.size();
            for (int i = 0; i < size2; ++i) {
                link = returnList.get(i);
                rowparams = link.toRowParams();
                bussinessParams.addRowParams(rowparams);
            }
            returnList.clear();
            this.outputData.setErrorMessage(new ErrorMessage());
            if (!hasFault) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            } else if (!hasSucc) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
            }
        } else if (subFunc.getCode() == 11111) {
            int i;
            BussinessParams busParams = new BussinessParams();
            this.outputData.setBussinessParams(busParams);
            ArrayList portList = new ArrayList();
            Operation operation = null;
            boolean hasErr = false;
            boolean hasSucc = false;
            List<RowParams> errList = null;
            int size = operationList.size();
            for (i = 0; i < size; ++i) {
                operation = (Operation)operationList.get(i);
                if (30793 == operation.getCmdid() || 29090 == operation.getCmdid() || 29122 == operation.getCmdid()) {
                    errList = this.parsePortProp(operation, portList);
                    if (errList.isEmpty()) continue;
                    hasErr = true;
                    int errNum = errList.size();
                    for (int errIndex = 0; errIndex < errNum; ++errIndex) {
                        busParams.addRowParams(errList.get(errIndex));
                    }
                    continue;
                }
                TELogFactory.getNormalLogger().error("handleMessage() SFUN_QUERY_BINDPATH got an invalid cmd: " + operation.getCmdid());
            }
            if (!portList.isEmpty()) {
                hasSucc = true;
            }
            Collections.sort(portList);
            size = portList.size();
            for (i = 0; i < size; ++i) {
                busParams.addRowParams(((TEEVPLPortProperty)portList.get(i)).toRowParams());
            }
            portList.clear();
            this.outputData.setErrorMessage(new ErrorMessage());
            if (!hasErr) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            } else if (!hasSucc) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
            }
        } else {
            super.handleMessage(neid, operationList, subFunc);
        }
    }

    private List<RowParams> parseVlanSwitchLink(Operation oper1, List<TEEVPL> eplList) {
        ArrayList<RowParams> errList = new ArrayList<RowParams>();
        Output rOutput = null;
        TEEVPL rLink = null;
        RowParams errRow = null;
        int linkNum = oper1.getOutputCount();
        for (int j = 0; j < linkNum; ++j) {
            rOutput = oper1.getOutput(j);
            errRow = TEIPUtils.handleRowError(rOutput);
            if (errRow != null) {
                errList.add(errRow);
                continue;
            }
            rLink = new TEEVPL();
            int partNum = rOutput.getPartCount();
            for (int k = 0; k < partNum; ++k) {
                rLink.setPropValue(rOutput.getPart(k));
            }
            rLink.direction = 0;
            rLink.linkType = 0;
            if (rLink.upLinkID > 0) {
                eplList.add(rLink);
                continue;
            }
            TELogFactory.getNormalLogger().error("parseVlanSwitchLink() invalid link=" + rLink);
        }
        return errList;
    }

    private List<RowParams> parseOAMEnable(Operation operation, List<TEEVPL> eplList) {
        ArrayList<RowParams> errList = new ArrayList<RowParams>();
        Output rOutput = null;
        TEEVPL link = null;
        RowParams errRow = null;
        int linkNum = operation.getOutputCount();
        block0: for (int j = 0; j < linkNum; ++j) {
            rOutput = operation.getOutput(j);
            errRow = TEIPUtils.handleRowError(rOutput);
            if (errRow != null) {
                errList.add(errRow);
                continue;
            }
            link = new TEEVPL();
            int partNum = rOutput.getPartCount();
            for (int k = 0; k < partNum; ++k) {
                link.setPropValue(rOutput.getPart(k));
            }
            if (link.upLinkID > 0) {
                int len = eplList.size();
                for (int i = 0; i < len; ++i) {
                    TEEVPL eplData = eplList.get(i);
                    if (eplData.upLinkID != link.upLinkID) continue;
                    eplData.oamEnable = link.oamEnable;
                    continue block0;
                }
                continue;
            }
            TELogFactory.getNormalLogger().error("parseVlanSwitchLink() invalid link=" + link);
        }
        return errList;
    }

    private List<RowParams> parseQinQLink(Operation aOper, List<TEEVPL> evplList) {
        ArrayList<RowParams> errList = new ArrayList<RowParams>();
        Output rOutput = null;
        TEEVPL link = null;
        RowParams errRow = null;
        int linkNum = aOper.getOutputCount();
        for (int j = 0; j < linkNum; ++j) {
            rOutput = aOper.getOutput(j);
            errRow = TEIPUtils.handleRowError(rOutput);
            if (errRow != null) {
                errList.add(errRow);
                continue;
            }
            link = new TEEVPL();
            int partNum = rOutput.getPartCount();
            for (int k = 0; k < partNum; ++k) {
                link.setPropValue(rOutput.getPart(k));
            }
            link.direction = 0;
            if (link.upLinkID > 0) {
                evplList.add(link);
                continue;
            }
            TELogFactory.getNormalLogger().error("parseQinQLink() invalid link=" + link.upLinkID);
        }
        return errList;
    }

    private List<RowParams> parseVlanPri(Operation operation, List<TEEVPL> evplList) {
        ArrayList<RowParams> errList = new ArrayList<RowParams>();
        Output priOutput = null;
        TEEVPL evplLink = null;
        RowParams errRow = null;
        TEEVPL seedLink = new TEEVPL();
        seedLink.direction = 0;
        int linkNum = operation.getOutputCount();
        for (int j = 0; j < linkNum; ++j) {
            priOutput = operation.getOutput(j);
            errRow = TEIPUtils.handleRowError(priOutput);
            if (errRow != null) {
                errList.add(errRow);
                continue;
            }
            int partNum = priOutput.getPartCount();
            for (int k = 0; k < partNum; ++k) {
                seedLink.setPropValue(priOutput.getPart(k));
            }
            evplLink = null;
            int index = evplList.indexOf(seedLink);
            if (index < 0) {
                TELogFactory.getNormalLogger().error("parseVlanPri() invalid link=" + seedLink.upLinkID);
                continue;
            }
            evplLink = evplList.get(index);
            if (7 == evplLink.linkType) {
                evplLink.cVlanPri = seedLink.cVlanPri;
                evplLink.sVlanPri = seedLink.sVlanPri;
                continue;
            }
            if (6 != evplLink.linkType) continue;
            evplLink.sVlanPri = seedLink.sVlanPri;
        }
        return errList;
    }

    private List<TEEVPL> coupleEvplList(List<TEEVPL> eplList, List<TEEVPL> evplList) {
        ArrayList<TEEVPL> list = new ArrayList<TEEVPL>();
        if (this.showCouple) {
            list.addAll(this.coupleEPL(eplList));
            if (this.showShared) {
                list.addAll(this.coupleEVPL(list));
            }
        } else {
            list.addAll(eplList);
            if (this.showShared) {
                list.addAll(list);
            }
        }
        return list;
    }

    private List<TEEVPL> coupleEPL(List<TEEVPL> eplList) {
        ArrayList<TEEVPL> resultList = new ArrayList<TEEVPL>();
        ArrayList<TEEVPL> tempEplList = new ArrayList<TEEVPL>();
        TEEVPL cur = null;
        TEEVPL newLink = null;
        tempEplList.addAll(eplList);
        int currentIdx = 0;
        while (currentIdx < tempEplList.size()) {
            cur = (TEEVPL)tempEplList.get(currentIdx);
            if (1 == cur.direction) {
                resultList.add(cur);
                tempEplList.remove(currentIdx);
                continue;
            }
            int foundIdx = this.findCoupleQinQEvpl(cur, tempEplList, currentIdx + 1);
            if (foundIdx >= 0) {
                newLink = new TEEVPL(cur);
                newLink.direction = 1;
                newLink.downLinkID = ((TEEVPL)tempEplList.get((int)foundIdx)).upLinkID;
                newLink.oamEnable = ((TEEVPL)tempEplList.get((int)foundIdx)).oamEnable;
                newLink.coupledFlag = true;
                ((TEEVPL)tempEplList.get((int)foundIdx)).coupledFlag = true;
                resultList.add(newLink);
                tempEplList.remove(currentIdx);
                continue;
            }
            ++currentIdx;
        }
        for (currentIdx = 0; currentIdx < tempEplList.size(); ++currentIdx) {
            cur = (TEEVPL)tempEplList.get(currentIdx);
            if (cur.coupledFlag) continue;
            cur.direction = 0;
            resultList.add(cur);
        }
        return resultList;
    }

    private List<TEEVPL> coupleEVPL(List<TEEVPL> evplList) {
        ArrayList<TEEVPL> resultList = new ArrayList<TEEVPL>();
        ArrayList<TEEVPL> ingressEvpls = new ArrayList<TEEVPL>();
        ArrayList<TEEVPL> egressEvpls = new ArrayList<TEEVPL>();
        TEEVPL currentEvpl = null;
        TEEVPL newLink = null;
        int size = evplList.size();
        for (int i = 0; i < size; ++i) {
            currentEvpl = evplList.get(i);
            int type = currentEvpl.linkType;
            if (6 == type || 7 == type) {
                ingressEvpls.add(currentEvpl);
                continue;
            }
            if (8 == type || 9 == type) {
                egressEvpls.add(currentEvpl);
                continue;
            }
            TELogFactory.getNormalLogger().error("coupleEVPL() invalid linkType: " + currentEvpl.upLinkID + ", " + currentEvpl.linkType);
        }
        int curIndex = 0;
        curIndex = 0;
        while (curIndex < ingressEvpls.size()) {
            currentEvpl = (TEEVPL)ingressEvpls.get(curIndex);
            int foundIndex = this.findCoupleQinQEvpl(currentEvpl, egressEvpls, 0);
            if (foundIndex >= 0) {
                newLink = new TEEVPL(currentEvpl);
                newLink.direction = 1;
                newLink.downLinkID = ((TEEVPL)egressEvpls.get((int)foundIndex)).upLinkID;
                newLink.coupledFlag = true;
                ((TEEVPL)egressEvpls.get((int)foundIndex)).coupledFlag = true;
                resultList.add(newLink);
                ingressEvpls.remove(curIndex);
                continue;
            }
            ++curIndex;
        }
        for (curIndex = 0; curIndex < ingressEvpls.size(); ++curIndex) {
            currentEvpl = (TEEVPL)ingressEvpls.get(curIndex);
            currentEvpl.direction = 0;
            resultList.add(currentEvpl);
        }
        for (curIndex = 0; curIndex < egressEvpls.size(); ++curIndex) {
            currentEvpl = (TEEVPL)egressEvpls.get(curIndex);
            if (currentEvpl.coupledFlag) continue;
            currentEvpl.direction = 0;
            resultList.add(currentEvpl);
        }
        return resultList;
    }

    private int findCoupleQinQEvpl(TEEVPL seed, List<TEEVPL> linkList, int fromIndex) {
        for (int foundIndex = fromIndex; foundIndex < linkList.size(); ++foundIndex) {
            if (!this.isCoupleQinQEvpl(seed, linkList.get(foundIndex))) continue;
            return foundIndex;
        }
        return -1;
    }

    private boolean isCoupleQinQEvpl(TEEVPL fstEvpl, TEEVPL scdEvpl) {
        if (fstEvpl.srcPort != scdEvpl.snkPort || fstEvpl.snkPort != scdEvpl.srcPort) {
            return false;
        }
        int firstType = fstEvpl.linkType;
        int secondType = scdEvpl.linkType;
        if (secondType == 6 && firstType == 8 || secondType == 8 && firstType == 6) {
            if (firstType == 8) {
                if (scdEvpl.srcVlan != scdEvpl.snkVlan) {
                    return scdEvpl.srcSVlan == fstEvpl.snkSVlan && scdEvpl.snkSVlan == fstEvpl.srcSVlan && scdEvpl.srcVlan == fstEvpl.snkVlan && scdEvpl.srcVlan != fstEvpl.srcVlan;
                }
                return scdEvpl.snkSVlan == fstEvpl.srcSVlan && 65535 == fstEvpl.snkSVlan && 65535 == fstEvpl.srcVlan && 65535 == fstEvpl.snkVlan && (65535 == fstEvpl.srcVlan && 65535 == scdEvpl.srcVlan || scdEvpl.srcVlan != fstEvpl.srcVlan);
            }
            if (secondType == 8) {
                if (fstEvpl.srcVlan != fstEvpl.snkVlan) {
                    return scdEvpl.srcSVlan == fstEvpl.snkSVlan && scdEvpl.snkSVlan == fstEvpl.srcSVlan && scdEvpl.snkVlan == fstEvpl.srcVlan && scdEvpl.srcVlan != fstEvpl.srcVlan;
                }
                return scdEvpl.srcSVlan == fstEvpl.snkSVlan && 65535 == scdEvpl.snkSVlan && 65535 == scdEvpl.srcVlan && 65535 == scdEvpl.snkVlan && (65535 == scdEvpl.srcVlan && 65535 == fstEvpl.srcVlan || scdEvpl.srcVlan != fstEvpl.srcVlan);
            }
            return scdEvpl.srcSVlan == fstEvpl.snkSVlan && scdEvpl.snkSVlan == fstEvpl.srcSVlan;
        }
        if (secondType == 9 && firstType == 7 || secondType == 7 && firstType == 9) {
            return scdEvpl.srcSVlan == fstEvpl.snkSVlan && scdEvpl.snkSVlan == fstEvpl.srcSVlan;
        }
        if (secondType == 0 && firstType == 0) {
            return scdEvpl.srcVlan == fstEvpl.snkVlan && scdEvpl.snkVlan == fstEvpl.srcVlan;
        }
        return false;
    }

    private List<RowParams> parsePortProp(Operation operation, List portList) {
        ArrayList<RowParams> errList = new ArrayList<RowParams>();
        Output output = null;
        TEEVPLPortProperty portProperty = null;
        RowParams aErrRow = null;
        TEEVPLPortProperty seedPort = new TEEVPLPortProperty();
        int portNum = operation.getOutputCount();
        for (int j = 0; j < portNum; ++j) {
            output = operation.getOutput(j);
            aErrRow = TEIPUtils.handleRowError(output);
            if (aErrRow != null) {
                errList.add(aErrRow);
                continue;
            }
            int partNum = output.getPartCount();
            for (int k = 0; k < partNum; ++k) {
                seedPort.setPropValue(output.getPart(k));
            }
            portProperty = null;
            int index = portList.indexOf(seedPort);
            if (index < 0) {
                portProperty = new TEEVPLPortProperty();
                portProperty.port = seedPort.port;
                portList.add(portProperty);
            } else {
                portProperty = (TEEVPLPortProperty)portList.get(index);
            }
            if (30793 == operation.getCmdid()) {
                portProperty.portType = seedPort.portType;
                continue;
            }
            if (29090 == operation.getCmdid()) {
                portProperty.portEnable = seedPort.portEnable;
                continue;
            }
            if (29122 != operation.getCmdid()) continue;
            portProperty.portTag = seedPort.portTag;
        }
        return errList;
    }
}

