/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.service;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.QxMapping;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.service.TEEVPL;
import com.huawei.nglct.nemgr.ip.ngwdm.service.TEEVPLMgmtSuper;
import com.huawei.nglct.nemgr.ip.ngwdm.service.db.TEEVPLMgmtDBHander;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TEEVPLMgmt
extends TEEVPLMgmtSuper {
    public static final int TYPE_LINK = 0;
    public static final int TYPE_QINQINLINKSL = 6;
    public static final int TYPE_QINQINLINKDL = 7;
    public static final int TYPE_QINQELINKSL = 8;
    public static final int TYPE_QINQELINKDL = 9;
    public static final int TYPE_QINQTRANSIT = 10;
    public static final int TYPE_TRANSIT_CVLAN = 20;
    private static int neID = -1;
    private static final int ECOM_QX_LEN = 2;

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memoryData, String user, String ipAddress) {
        Datainterface outData = null;
        if (subFunc.getCode() == 2108702) {
            Param boardTypeParam = inputData.getBussinessParams().getRowParams()[0].getParam("boardtype");
            QxMapping[] qxList = subFunc.getQxMapping();
            if (boardTypeParam != null && String.valueOf(1095).equals(boardTypeParam.getValue())) {
                ArrayList<QxMapping> newQxList = new ArrayList<QxMapping>(2);
                for (int index = 0; index < qxList.length; ++index) {
                    String qxName = qxList[index].getContent();
                    if (!qxName.equals("NSCMD_ETHN_GET_QINQLINK") && !qxName.equals("NSCMD_ETHN_GET_QINQINLINKDEFVLANPRI")) continue;
                    newQxList.add(qxList[index]);
                }
                subFunc.setQxMapping(newQxList);
            } else if (2 == qxList.length) {
                this.processLENBoard(subFunc, qxList);
            }
            if (inputData.getBussinessParams().getRowParams().length > 0) {
                int tempNEID = -1;
                int tempSlotID = -1;
                boolean fromNE = true;
                Param[] params1 = inputData.getBussinessParams().getRowParams()[0].getParam();
                int size = params1.length;
                for (int i = 0; i < size; ++i) {
                    if ("showCouple".equalsIgnoreCase(params1[i].getName())) {
                        this.showCouple = !"0".equalsIgnoreCase(params1[i].getValue());
                        continue;
                    }
                    if ("showShared".equalsIgnoreCase(params1[i].getName())) {
                        this.showShared = !"0".equalsIgnoreCase(params1[i].getValue());
                        continue;
                    }
                    if ("fromNE".equalsIgnoreCase(params1[i].getName())) {
                        fromNE = !"0".equalsIgnoreCase(params1[i].getValue());
                        continue;
                    }
                    if ("neID".equalsIgnoreCase(params1[i].getName())) {
                        tempNEID = Integer.parseInt(params1[i].getValue());
                        continue;
                    }
                    if (!"slotID".equalsIgnoreCase(params1[i].getName())) continue;
                    tempSlotID = Integer.parseInt(params1[i].getValue());
                }
                if (!fromNE && tempNEID == neID && tempSlotID == slotID) {
                    TEEVPL link1 = null;
                    ArrayList returnList = this.coupleEvplList(eplList, evplList);
                    this.outputData = new Datainterface();
                    BussinessParams bussinessParams1 = new BussinessParams();
                    this.outputData.setBussinessParams(bussinessParams1);
                    RowParams rowparams = null;
                    int size2 = returnList.size();
                    for (int i = 0; i < size2; ++i) {
                        link1 = (TEEVPL)returnList.get(i);
                        rowparams = link1.toRowParams();
                        bussinessParams1.addRowParams(rowparams);
                    }
                    returnList.clear();
                    this.outputData.setErrorMessage(new ErrorMessage());
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                    return this.outputData;
                }
                neID = tempNEID;
                slotID = tempSlotID;
            }
        }
        outData = super.performBussinessProcess(neid, subFunc, inputData, memoryData, user, ipAddress);
        int subFuncCode = subFunc.getCode();
        if (2108702 == subFuncCode) {
            if (this.isSaveEVPLToDB()) {
                TEEVPLMgmtDBHander.saveEVPLToDB(neID, slotID, inputData, outData);
            }
        } else if (2108700 == subFuncCode && this.isDelEVPLFromDB()) {
            TEEVPLMgmtDBHander.delEVPLFromDB(neID, slotID, inputData, outData);
        }
        return outData;
    }

    protected boolean isSaveEVPLToDB() {
        boolean isSave = false;
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            isSave = true;
        }
        return isSave;
    }

    @Override
    protected boolean isDelEVPLFromDB() {
        boolean isDel = false;
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            isDel = true;
        }
        return isDel;
    }

    private void processLENBoard(SubFunc subFunc, QxMapping[] qxList) {
        ArrayList<QxMapping> newQxList = new ArrayList<QxMapping>(4);
        newQxList.add(qxList[0]);
        newQxList.add(qxList[1]);
        QxMapping qxMapping = new QxMapping();
        qxMapping.setContent("NSCMD_ETHN_GET_VLANSWITCHLINK");
        qxMapping.setParent(0);
        qxMapping.setSerialno(1);
        qxMapping.deleteParent();
        newQxList.add(qxMapping);
        qxMapping = new QxMapping();
        qxMapping.setContent("NSCMD_ETHN_GET_VLANSNCP_OAMEN");
        qxMapping.setParent(0);
        qxMapping.setSerialno(3);
        qxMapping.deleteParent();
        newQxList.add(qxMapping);
        subFunc.setQxMapping(newQxList);
    }

    @Override
    protected boolean isCoupleQinQEvpl(TEEVPL first1, TEEVPL second) {
        if (first1.srcPort != second.snkPort || first1.snkPort != second.srcPort || first1.oamEnable != second.oamEnable) {
            return false;
        }
        int firstType = first1.linkType;
        int secondType = second.linkType;
        if (secondType == 6 && firstType == 8 || secondType == 8 && firstType == 6) {
            if (firstType == 8) {
                if (second.srcVlan != second.snkVlan) {
                    return second.srcSVlan == first1.snkSVlan && second.snkSVlan == first1.srcSVlan && second.srcVlan == first1.snkVlan && second.srcVlan != first1.srcVlan;
                }
                return second.snkSVlan == first1.srcSVlan && second.srcSVlan == first1.snkSVlan && second.snkVlan == first1.srcVlan && second.srcVlan == first1.snkVlan;
            }
            if (secondType == 8) {
                if (first1.srcVlan != first1.snkVlan) {
                    return second.srcSVlan == first1.snkSVlan && second.snkSVlan == first1.srcSVlan && second.snkVlan == first1.srcVlan && second.srcVlan != first1.srcVlan;
                }
                return second.snkSVlan == first1.srcSVlan && second.srcSVlan == first1.snkSVlan && second.snkVlan == first1.srcVlan && second.srcVlan == first1.snkVlan;
            }
            return second.srcSVlan == first1.snkSVlan && second.snkSVlan == first1.srcSVlan;
        }
        if (secondType == 9 && firstType == 7 || secondType == 7 && firstType == 9) {
            return second.srcSVlan == first1.snkSVlan && second.snkSVlan == first1.srcSVlan;
        }
        if (secondType == 0 && firstType == 0 || secondType == 20 && firstType == 20) {
            return second.srcVlan == first1.snkVlan && second.snkVlan == first1.srcVlan && first1.isActive == second.isActive;
        }
        if (secondType == 1 && firstType == 1) {
            return second.srcVlan == first1.snkVlan && second.snkVlan == first1.srcVlan && first1.isActive == second.isActive;
        }
        return false;
    }

    @Override
    protected String operationDescribtion() {
        StringBuffer operDesc = new StringBuffer();
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotID);
        int boardType = configurDataMgr.getBoard(neID, slotID).getBoardType();
        String boardName = configurDataMgr.getBoardTypeName(neID, boardType);
        StringBuffer filePath = new StringBuffer();
        filePath.append("ip").append(File.separator).append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("ipservice").append(File.separator).append("ethernetInfo_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)neID, (StringBuffer)filePath);
        operDesc.append(res.getString("board")).append(":");
        if (!"".equals(subrackName)) {
            operDesc.append(subrackName).append("-");
        }
        operDesc.append(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotID)).append("-").append(boardName);
        return operDesc.toString();
    }
}

