/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.service;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEVBMgrSuperBean;
import com.huawei.nglct.nemgr.ip.ngwdm.service.TEIPUtils;
import com.huawei.nglct.nemgr.ip.ngwdm.service.TEVCTrunk;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TEBoundPath
extends TEVBMgrSuperBean {
    private static final int NSCMD_ETHN_GET_VCTRUNK_PATH = 30780;
    private static final int NSCMD_ETHN_GET_VCTRUNK_PATH_EX = 34195;
    int slotID = -1;
    private static final int SLOTOVER = 39169;

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        Param[] paramArr = rowParams[0].getParam();
        int len = paramArr.length;
        for (int i = 1; i < len; ++i) {
            String name = paramArr[i].getName();
            String value = paramArr[i].getValue();
            if (!name.equalsIgnoreCase("slotID")) continue;
            this.slotID = Integer.parseInt(value);
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subFunc) {
        BussinessParams bussinessParams = new BussinessParams();
        this.outputData.setBussinessParams(bussinessParams);
        Operation operation = null;
        HashMap vctrunkMap = new HashMap();
        boolean hasFault = false;
        boolean hasSucc = false;
        ArrayList errList = null;
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            operation = (Operation)operationList.get(i);
            if (30780 == operation.getCmdid() || 34195 == operation.getCmdid()) {
                errList = this.parseVCTrunk(operation, vctrunkMap);
                if (!errList.isEmpty()) {
                    hasFault = true;
                    int errNum = errList.size();
                    for (int errIndex = 0; errIndex < errNum; ++errIndex) {
                        bussinessParams.addRowParams((RowParams)errList.get(errIndex));
                    }
                }
                if (vctrunkMap.isEmpty()) continue;
                hasSucc = true;
                continue;
            }
            TELogFactory.getNormalLogger().error("handleMessage() SFUN_QUERY_BOUNDPATH got an invalid cmd: " + operation.getCmdid());
        }
        ArrayList returnList = new ArrayList(vctrunkMap.size());
        Iterator it = vctrunkMap.values().iterator();
        while (it.hasNext()) {
            returnList.add(it.next());
        }
        Collections.sort(returnList);
        TEVCTrunk vctrunk = null;
        List rows = null;
        int size2 = returnList.size();
        for (int i = 0; i < size2; ++i) {
            vctrunk = (TEVCTrunk)returnList.get(i);
            rows = vctrunk.toRowParams();
            int rowNum = rows.size();
            for (int j = 0; j < rowNum; ++j) {
                bussinessParams.addRowParams((RowParams)rows.get(j));
            }
        }
        vctrunkMap.clear();
        returnList.clear();
        this.outputData.setErrorMessage(new ErrorMessage());
        if (!hasFault) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (!hasSucc) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
    }

    private ArrayList parseVCTrunk(Operation operation, HashMap vctrunkMap) {
        ArrayList<RowParams> errList = new ArrayList<RowParams>();
        Output output = null;
        TEVCTrunk vctrunk = null;
        RowParams errRow = null;
        Param errParam = null;
        int slotid = -1;
        int boardtype = -1;
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        int vctrunkNum = operation.getOutputCount();
        for (int j = 0; j < vctrunkNum; ++j) {
            output = operation.getOutput(j);
            errRow = TEIPUtils.handleRowError(output);
            if (errRow != null) {
                errParam = new Param("neid", "" + this.neid);
                errRow.getRowErrors(0).addParam(errParam);
                errParam = new Param("nename", "" + neObj.getNEName());
                errRow.getRowErrors(0).addParam(errParam);
                slotid = Integer.parseInt(operation.getInput().getPart("slotID").getValue());
                errParam = new Param("slotid", "" + slotid);
                errRow.getRowErrors(0).addParam(errParam);
                boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
                errParam = new Param("boardname", "" + TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype));
                errRow.getRowErrors(0).addParam(errParam);
                errList.add(errRow);
                continue;
            }
            String errCode = output.getFault(0).getCode();
            if ("39169".equals(errCode)) continue;
            Part part = null;
            int vctrunkNo = -1;
            int level = -1;
            int direction = -1;
            int pathNum = -1;
            String pathStr = null;
            int partNum = output.getPartCount();
            for (int k = 1; k < partNum; ++k) {
                int intValue;
                block16: {
                    intValue = -1;
                    part = output.getPart(k);
                    if ("pathList".equalsIgnoreCase(part.getName())) {
                        pathStr = part.getValue();
                        continue;
                    }
                    try {
                        if ("INT".equalsIgnoreCase(part.getType()) || "BYTE".equalsIgnoreCase(part.getType())) {
                            intValue = Integer.parseInt(part.getValue());
                            break block16;
                        }
                        TELogFactory.getNormalLogger().error("setPropValue() invalid type=" + part.getName() + "," + part.getType());
                    }
                    catch (NumberFormatException nfe) {
                        TELogFactory.getNormalLogger().error("setPropValue() parsing: " + part.getName() + "," + part.getType(), (Throwable)nfe);
                    }
                    break;
                }
                if ("vctrunk".equalsIgnoreCase(part.getName())) {
                    vctrunkNo = intValue;
                    continue;
                }
                if ("level".equalsIgnoreCase(part.getName())) {
                    level = intValue;
                    continue;
                }
                if ("direction".equalsIgnoreCase(part.getName())) {
                    direction = intValue;
                    continue;
                }
                if ("pathNum".equalsIgnoreCase(part.getName())) {
                    pathNum = intValue;
                    continue;
                }
                TELogFactory.getNormalLogger().error("setPropValue() invalid name=" + part.getName());
                break;
            }
            if (vctrunkNo < 0) {
                TELogFactory.getNormalLogger().error("parseVCTrunk() invalid vctrunk");
            }
            if (null == (vctrunk = (TEVCTrunk)vctrunkMap.get(vctrunkNo))) {
                vctrunk = new TEVCTrunk();
                vctrunkMap.put(vctrunkNo, vctrunk);
            }
            byte[] pathBytes = null;
            pathBytes = null == pathStr ? new byte[]{} : IOStreamConvertor.getByteArrayFromString((String)pathStr);
            if (pathNum < 0) {
                pathNum = pathBytes.length / 2;
            }
            vctrunk.vctrunk = vctrunkNo;
            vctrunk.level = level;
            ArrayList<Integer> pathList = new ArrayList<Integer>(pathNum);
            for (int pathIndex = 0; pathIndex < pathNum && pathBytes.length > pathIndex * 2 + 1; ++pathIndex) {
                int pathNo = IOStreamConvertor.readUnsignedShort((byte[])pathBytes, (int)(pathIndex * 2));
                pathList.add(pathNo);
            }
            if (2 == direction || 0 == direction) {
                vctrunk.downLinkList.addAll(pathList);
            }
            if (1 != direction && 0 != direction) continue;
            vctrunk.upLinkList.addAll(pathList);
        }
        return errList;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        final int sneid = neid;
        final int sslotID = this.slotID;
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEBoundPath.this.operationDescribtion(sneid, sslotID);
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String operationDescribtion(int neid, int slotID) {
        StringBuffer operDesc = new StringBuffer();
        StringBuffer filePath = new StringBuffer(36);
        filePath.append("ip").append(File.separator).append("ngwdm").append(File.separator).append("res").append(File.separator).append("ipservice").append(File.separator).append("ethernetInfo_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)neid, (StringBuffer)filePath);
        operDesc.append(TEBoardUtil.getShelfBoardName((int)neid, (int)slotID)).append(':').append(res.getString("vctrunkPort")).append(',').append(res.getString("level")).append(',').append(res.getString("pathDirection")).append(',').append(res.getString("boundPath")).append(',').append(res.getString("boundPathCount"));
        return operDesc.toString();
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        temp.add(39169);
        return temp;
    }
}

