/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.service;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCNoticeMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.service.db.TECreateBIAddSVlanBean;
import com.huawei.nglct.nemgr.ip.ngwdm.service.db.TECreateEVPLDBHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.service.db.TELinkIDGenerator;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLMOPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEAddStrip
implements TENEMgrInterface {
    private Datainterface outputData = new Datainterface();
    ArrayList rowErrorList = new ArrayList();
    int neID = -1;
    int slotID = -1;
    int srcPort = -1;
    int snkPort = -1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)0);
        this.outputData.setErrorMessage(bigErr);
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        Param[] paramArr = rowParams[0].getParam();
        String operateType = rowParams[0].getParam("operateType").getValue();
        if ("addsvlanbi".equalsIgnoreCase(operateType)) {
            return TECreateBIAddSVlanBean.createEVPL(neid, subFunc, inputData, memeryData, user, ipAddress);
        }
        int tempSlotID = -1;
        int len = paramArr.length;
        for (int i = 1; i < len; ++i) {
            String name = paramArr[i].getName();
            String value = paramArr[i].getValue();
            if (!name.equalsIgnoreCase("slotID")) continue;
            tempSlotID = Integer.parseInt(value);
            break;
        }
        ArrayList<Integer> oldLinkIDList = new ArrayList();
        TELinkIDGenerator lineIDGenerator = new TELinkIDGenerator();
        if (this.isNeedSendCreateNtf()) {
            lineIDGenerator.init(neid, tempSlotID);
            oldLinkIDList = lineIDGenerator.getGeneratedLinkIDList();
        }
        try {
            ArrayList operList = new ArrayList();
            this.buildQinqLinkSingleVlanOper(neid, paramArr, operList, lineIDGenerator);
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operList, 10);
            if (result.retCode != 0) {
                bigErr = TEErrorResourceUtil.getErrorMessage((int)result.retCode);
                this.outputData.setErrorMessage(bigErr);
            }
            Operation tmpOper = (Operation)operList.get(0);
            bigErr = this.handleQinSingleLinkOutput(neid, bigErr, tmpOper);
            ArrayList operListStrip = new ArrayList();
            Param[] paramArrStrip = rowParams[1].getParam();
            this.buildQinqDoubleLinkOper(neid, operListStrip, paramArrStrip, lineIDGenerator);
            OperationResult resultStrip = TENECommMgr.getInstance().sendCommand(neid, operListStrip, 10);
            if (resultStrip.retCode != 0) {
                bigErr = TEErrorResourceUtil.getErrorMessage((int)resultStrip.retCode);
                this.outputData.setErrorMessage(bigErr);
            }
            Operation tmpOperStrip = (Operation)operListStrip.get(0);
            this.handleQinSingleLinkOutput(neid, bigErr, tmpOperStrip);
        }
        catch (NumberFormatException ex) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)ex);
        }
        catch (IndexOutOfBoundsException e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        if (this.isNeedSendCreateNtf()) {
            List<TEEtherEVPLMOPO> evplMOList = TECreateEVPLDBHandler.getCreatedEVPL(neid, tempSlotID, oldLinkIDList);
            if (!(evplMOList = TECreateEVPLDBHandler.sortByGenerator(evplMOList, lineIDGenerator)).isEmpty()) {
                TEEthXCNoticeMgr.sendCreateNtf(TEEthXCUtil.poEthXC2AsnEthXC(neid, tempSlotID, evplMOList));
            }
        }
        return this.outputData;
    }

    protected boolean isNeedSendCreateNtf() {
        boolean isNeed = false;
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            isNeed = true;
        }
        return isNeed;
    }

    private ErrorMessage handleQinSingleLinkOutput(int neid, ErrorMessage bigErr, Operation tmpOper) {
        for (Output output : tmpOper.getOutput()) {
            for (Fault fault : output.getFault()) {
                int code = Integer.parseInt(fault.getCode());
                if (code == 0) continue;
                TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)neid, (int)code));
                RowErrors rowError = new RowErrors();
                Param errorParam = new Param("errorBbj", neid + "ADD SVLAN");
                rowError.addParam(errorParam);
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)code));
                this.rowErrorList.add(rowError);
                bigErr = TEErrorResourceUtil.getErrorMessage((int)code);
                this.outputData.setErrorMessage(bigErr);
            }
        }
        return bigErr;
    }

    private void buildQinqDoubleLinkOper(int neid, ArrayList operListStrip, Param[] paramArrStrip, TELinkIDGenerator lineIDGenerator) {
        Operation operStrip = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_ADD_QINQELINK_SINGLEVLAN");
        Input inputStrip = operStrip.getInput();
        int len = paramArrStrip.length;
        for (int i = 1; i < len; ++i) {
            String name = paramArrStrip[i].getName();
            String value = paramArrStrip[i].getValue();
            if (name.equalsIgnoreCase("slotID")) {
                inputStrip.setPartValue("slotID", value);
            }
            int newLinkID = lineIDGenerator.generateLinkID();
            TELogFactory.getE2ELogger().info("generate linkID->" + newLinkID);
            if (name.equalsIgnoreCase("linkID")) {
                inputStrip.setPartValue("linkID", String.valueOf(newLinkID));
            }
            if (name.equalsIgnoreCase("srcPort")) {
                inputStrip.setPartValue("srcPort", value);
            }
            if (name.equalsIgnoreCase("srcCVlan")) {
                inputStrip.setPartValue("srcCVlan", value);
            }
            if (name.equalsIgnoreCase("snkPort")) {
                inputStrip.setPartValue("snkPort", value);
            }
            if (name.equalsIgnoreCase("snkCVlan")) {
                inputStrip.setPartValue("snkCVlan", value);
            }
            if (!name.equalsIgnoreCase("srcSVlan")) continue;
            inputStrip.setPartValue("srcSVlan", value);
        }
        operListStrip.add(operStrip);
    }

    private void buildQinqLinkSingleVlanOper(int neid, Param[] paramArr, ArrayList operList, TELinkIDGenerator lineIDGenerator) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_ADD_QINQINLINK_SINGLEVLAN");
        Input input = oper.getInput();
        int len = paramArr.length;
        for (int i = 1; i < len; ++i) {
            String name = paramArr[i].getName();
            String value = paramArr[i].getValue();
            if (name.equalsIgnoreCase("slotID")) {
                this.slotID = Integer.parseInt(value);
                input.setPartValue("slotID", value);
            }
            int newLinkID = lineIDGenerator.generateLinkID();
            TELogFactory.getE2ELogger().info("generate linkID->" + newLinkID);
            if (name.equalsIgnoreCase("linkID")) {
                input.setPartValue("linkID", String.valueOf(newLinkID));
            }
            if (name.equalsIgnoreCase("srcPort")) {
                this.srcPort = Integer.parseInt(value);
                input.setPartValue("srcPort", value);
            }
            if (name.equalsIgnoreCase("srcCVlan")) {
                input.setPartValue("srcCVlan", value);
            }
            if (name.equalsIgnoreCase("snkPort")) {
                this.snkPort = Integer.parseInt(value);
                input.setPartValue("snkPort", value);
            }
            if (name.equalsIgnoreCase("snkCVlan")) {
                input.setPartValue("snkCVlan", value);
            }
            if (!name.equalsIgnoreCase("snkSVlan")) continue;
            input.setPartValue("snkSVlan", value);
        }
        operList.add(oper);
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        final int stripNeid = neid;
        final Datainterface stripInputData = inputData;
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEAddStrip.this.operationDescribtion(stripNeid, stripInputData);
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String operationDescribtion(int neID, Datainterface inputData) {
        RowParams rowParams2;
        int len;
        StringBuffer operDesc = new StringBuffer();
        String srcPortName = "";
        srcPortName = 32768 > this.srcPort ? "PORT" + this.srcPort : "VCTRUNK" + (this.srcPort - 32768);
        String snkPortName = "";
        snkPortName = 32768 > this.snkPort ? "PORT" + this.snkPort : "VCTRUNK" + (this.snkPort - 32768);
        StringBuffer filePath = new StringBuffer(20);
        filePath.append(TEPathManager.RESOURCE_PROFILE_PATH).append("ip").append(File.separator).append("ethernetInfo_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)neID, (StringBuffer)filePath);
        operDesc.append(res.getString("board")).append(':').append(TEBoardUtil.getShelfBoardName((int)neID, (int)this.slotID)).append(',').append(res.getString("srcPort")).append(':').append(srcPortName).append(',').append(res.getString("snkPort")).append(':').append(snkPortName);
        RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
        String operationLog1 = "";
        String operationLog2 = "";
        String operationLog3 = "";
        String operationLog4 = "";
        if (null != rowParams.getParam("srcCVlan") && 65535 != Integer.parseInt(rowParams.getParam("srcCVlan").getValue())) {
            operationLog1 = "," + res.getString("src_CVlan") + ":";
        }
        if (null != rowParams.getParam("snkCVlan") && 65535 != Integer.parseInt(rowParams.getParam("snkCVlan").getValue())) {
            operationLog2 = "," + res.getString("snk_CVlan") + ":";
        }
        if (null != rowParams.getParam("srcSVlan") && 65535 != Integer.parseInt(rowParams.getParam("srcSVlan").getValue())) {
            operationLog3 = "," + res.getString("src_SVlan") + ":";
        }
        if (null != rowParams.getParam("snkSVlan") && 65535 != Integer.parseInt(rowParams.getParam("snkSVlan").getValue())) {
            operationLog4 = "," + res.getString("snk_SVlan") + ":";
        }
        if ((len = 1) < inputData.getBussinessParams().getRowParamsCount() && this.srcPort == Integer.parseInt((rowParams2 = inputData.getBussinessParams().getRowParams(1)).getParam("snkPort").getValue()) && this.snkPort == Integer.parseInt(rowParams2.getParam("srcPort").getValue())) {
            len = 2;
        }
        StringBuffer operationLog1Buffer = new StringBuffer(operationLog1);
        StringBuffer operationLog2Buffer = new StringBuffer(operationLog2);
        StringBuffer operationLog3Buffer = new StringBuffer(operationLog3);
        StringBuffer operationLog4Buffer = new StringBuffer(operationLog4);
        int size = inputData.getBussinessParams().getRowParamsCount() - 1;
        for (int index = 0; index <= size; index += len) {
            RowParams rowParams1 = inputData.getBussinessParams().getRowParams(index);
            if (!"".equals(operationLog1)) {
                String srcCVlan = rowParams1.getParam("srcCVlan").getValue();
                operationLog1Buffer.append(',').append(srcCVlan);
            }
            if (!"".equals(operationLog2)) {
                String snkCVlan = rowParams1.getParam("snkCVlan").getValue();
                operationLog2Buffer.append(',').append(snkCVlan);
            }
            if (!"".equals(operationLog3)) {
                String srcSVlan = rowParams1.getParam("srcSVlan").getValue();
                operationLog3Buffer.append(',').append(srcSVlan);
            }
            if ("".equals(operationLog4)) continue;
            String snkSVlan = rowParams1.getParam("snkSVlan").getValue();
            operationLog4Buffer.append(',').append(snkSVlan);
        }
        operationLog1 = operationLog1Buffer.toString();
        operationLog2 = operationLog2Buffer.toString();
        operationLog3 = operationLog3Buffer.toString();
        operationLog4 = operationLog4Buffer.toString();
        operDesc.append(operationLog1.replaceFirst(":,", ":")).append(operationLog2.replaceFirst(":,", ":")).append(operationLog3.replaceFirst(":,", ":")).append(operationLog4.replaceFirst(":,", ":"));
        if (2 == len) {
            operDesc.append(',').append(res.getString("serviceDirection1"));
        }
        return operDesc.toString();
    }
}

