/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.qos.remark;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.TENGWDMIPUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class TEQueryRemarkPortRes
extends TENEExplorerBean {
    public static final String W32PORT_ATTR_QOS_REMARK = "W32PORT_ATTR_QOS_REMARK";
    private int slotID = -1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        String slotStr = inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue();
        this.slotID = Integer.parseInt(slotStr);
        int bdType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotID);
        ArrayList portList = TENGWDMIPUtil.getEthPortList(neid, this.slotID, bdType);
        TreeSet<Integer> portSet = new TreeSet<Integer>();
        Set<Integer> usedPorts = this.getUserdPorts(neid, inputData);
        portSet.addAll(portList);
        Datainterface outputData = this.constructOutputData(portSet, usedPorts);
        return outputData;
    }

    private Set<Integer> getUserdPorts(int neid, Datainterface inputData) {
        RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
        HashSet<Integer> portSet = new HashSet<Integer>();
        Operation operationAssoPort = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETH_GET_EGRCOSPRIMAP_ASSOPORT");
        if (operationAssoPort == null) {
            return portSet;
        }
        ArrayList<Operation> operList = new ArrayList<Operation>();
        String slotid = rowParams.getParam("slotid").getValue();
        operationAssoPort.getInput().setPartValue("slotid", slotid);
        operationAssoPort.getInput().setPartValue("remarkID", "0");
        operList.add(operationAssoPort);
        int result = this.sendMessage(neid, operList);
        if (result == 0 && null != operList && operList.size() > 0) {
            Operation operation = (Operation)operList.get(0);
            Output output = null;
            for (int i = operation.getOutputCount() - 1; i > -1; --i) {
                int portNum;
                output = operation.getOutput(i);
                if (!"0".equals(output.getFault(0).getCode()) || (portNum = Integer.parseInt(output.getPartValue("boundPortNum"))) <= 0) continue;
                Integer portID = Integer.parseInt(output.getPartValue("boundPort"));
                portSet.add(portID);
            }
        }
        return portSet;
    }

    private Datainterface constructOutputData(Set<Integer> supportPorts, Set<Integer> usedPorts) {
        Datainterface outputData = new Datainterface();
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        outputData.setBussinessParams(new BussinessParams());
        Iterator<Integer> serIT = supportPorts.iterator();
        while (serIT.hasNext()) {
            RowParams rowParams = new RowParams();
            int portid = serIT.next();
            if (usedPorts.contains(portid)) continue;
            Param param = new Param("portid", String.valueOf(portid));
            rowParams.addParam(param);
            outputData.getBussinessParams().addRowParams(rowParams);
        }
        return outputData;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

