/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.qos;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.qos.TEFlowData;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class TEQueryFlowSuperBean
extends TENEExplorerBean {
    private TEResourceUtil res = null;
    protected static final int TIME_OUT = 10;
    private List firstOperList;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            ArrayList firstOperationNameList = new ArrayList();
            this.outputData = new Datainterface();
            RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
            Param[] param = rowParams[0].getParam();
            int slotid = Integer.valueOf(param[1].getValue());
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            switch (boardType) {
                case 927: 
                case 1067: {
                    firstOperationNameList.addAll(this.getTBEOperationList());
                    break;
                }
                default: {
                    firstOperationNameList = null;
                }
            }
            this.firstOperList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid, firstOperationNameList);
            int firstResult = this.sendMessage(neid, this.firstOperList);
            if (firstResult == 0) {
                ArrayList<String> secondOperNameList = new ArrayList<String>();
                secondOperNameList.add("NSCMD_ETHN_GET_FLOWTYPE");
                secondOperNameList.add("NSCMD_ETHN_GET_FLOW_ACTION");
                ArrayList secondOperList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid, secondOperNameList);
                if (this.structureSecondlyData(this.firstOperList, secondOperList)) {
                    int secondResult = this.sendMessage(neid, secondOperList);
                    if (secondResult == 0) {
                        ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
                        this.handleMessage(neid, secondOperList, subFunc, filterErrorCodeList);
                    } else {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)secondResult));
                    }
                } else {
                    ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
                    this.handleMessage(neid, (ArrayList)this.firstOperList, subFunc, filterErrorCodeList);
                }
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)firstResult));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryFlowBean.performBussinessProcess() fail!", (Throwable)e);
        }
        return this.outputData;
    }

    public int sendMessage(int neid, List operList) {
        int retCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operList, 10);
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    public boolean structureSecondlyData(List parentOperationList, List childOperationList) {
        if (parentOperationList.isEmpty()) {
            return false;
        }
        ArrayList<Operation> tempList = new ArrayList<Operation>();
        int nullIdCount = 0;
        int size = parentOperationList.size();
        for (int i = 0; i < size; ++i) {
            Operation parentOperation = (Operation)parentOperationList.get(i);
            Output[] outPutArray = parentOperation.getOutput();
            int count = 0;
            for (int j = 0; j < outPutArray.length; ++j) {
                String flowid = outPutArray[j].getPart("flowid").getValue();
                if (flowid == null) {
                    ++count;
                    continue;
                }
                int length = childOperationList.size();
                for (int k = 0; k < length; ++k) {
                    Operation childOperation = (Operation)((Operation)childOperationList.get(k)).clone();
                    childOperation.getInput().setPartValue("flowid", flowid);
                    tempList.add(childOperation);
                }
            }
            if (count != outPutArray.length) continue;
            ++nullIdCount;
        }
        childOperationList.clear();
        childOperationList.addAll(tempList);
        return nullIdCount != size;
    }

    public void handleMessage(int neid, ArrayList secondOperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        RowParams tempRowParam;
        int errorCount;
        String flowId;
        this.outputData = TEQueryFlowSuperBean.convertToDatainterface(neid, subfunc, secondOperList, filterErrorCodeList);
        if (null == this.outputData || null == this.outputData.getBussinessParams()) {
            return;
        }
        RowParams rowparams = null;
        Param param = null;
        int size = this.outputData.getBussinessParams().getRowParamsCount();
        HashMap<Integer, TEFlowData> flowDataMap = new HashMap<Integer, TEFlowData>(size);
        for (int i = size - 1; i >= 0; --i) {
            boolean idIsExist = true;
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowparams.getParam().length == 0) continue;
            param = Datainterface.getParam((Param[])rowparams.getParam(), (String)"flowid");
            flowId = param.getValue();
            TEFlowData flowData = (TEFlowData)flowDataMap.get(Integer.valueOf(flowId));
            if (flowData == null) {
                flowData = new TEFlowData();
                idIsExist = false;
            }
            if ((param = rowparams.getParam("statEnable")) != null && param.getValue() != null && !"".equals(param.getValue())) {
                flowData.setStatEnable(Byte.parseByte(param.getValue()));
            }
            if ((param = rowparams.getParam("monitorstatus")) != null && param.getValue() != null && !"".equals(param.getValue())) {
                flowData.setMonitorStatus(Byte.parseByte(param.getValue()));
            }
            if ("".equals((param = rowparams.getParam("qostype")).getValue())) {
                if (!idIsExist) {
                    flowDataMap.put(Integer.valueOf(flowId), flowData);
                    continue;
                }
                this.outputData.getBussinessParams().setRowParams(i, null);
                continue;
            }
            int qosType = Integer.valueOf(param.getValue());
            param = Datainterface.getParam((Param[])rowparams.getParam(), (String)"paraid");
            int idOfboundType = Integer.valueOf(param.getValue());
            switch (qosType) {
                case 1: {
                    flowData.setBoundCarId(idOfboundType);
                    break;
                }
                case 2: {
                    flowData.setBoundCosId(idOfboundType);
                    break;
                }
                case 3: {
                    flowData.setBoundShapingId(idOfboundType);
                    break;
                }
            }
            flowDataMap.put(Integer.valueOf(flowId), flowData);
            if (!idIsExist) continue;
            this.outputData.getBussinessParams().setRowParams(i, null);
        }
        Datainterface temp = new Datainterface();
        temp.setBussinessParams(new BussinessParams());
        int rowParamsCount = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = rowParamsCount - 1; i >= 0; --i) {
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowparams == null || rowparams.getParam().length == 0) continue;
            param = Datainterface.getParam((Param[])rowparams.getParam(), (String)"flowid");
            flowId = param.getValue();
            rowparams.addParam("vbid", "-");
            rowparams.addParam("priority", "-");
            rowparams.addParam("boundCAR", ((TEFlowData)flowDataMap.get(Integer.valueOf(flowId))).getBoundCarId());
            rowparams.addParam("boundCoS", ((TEFlowData)flowDataMap.get(Integer.valueOf(flowId))).getBoundCosId());
            rowparams.addParam("boundShaping", ((TEFlowData)flowDataMap.get(Integer.valueOf(flowId))).getBoundShapingId());
            param = Datainterface.getParam((Param[])rowparams.getParam(), (String)"flowtype");
            int length = this.firstOperList.size();
            for (int j = 0; j < length; ++j) {
                Output[] tempOutput = ((Operation)this.firstOperList.get(j)).getOutput();
                int outputLength = tempOutput.length;
                for (int k = 0; k < outputLength; ++k) {
                    String tempId = tempOutput[k].getPart("flowid").getValue();
                    if (!flowId.equals(tempId)) continue;
                    this.setVlanParam(rowparams, tempOutput, k);
                }
            }
            temp.getBussinessParams().addRowParams(rowparams);
        }
        if (rowParamsCount > 0 && (errorCount = (tempRowParam = this.outputData.getBussinessParams().getRowParams(rowParamsCount - 1)).getRowErrorsCount()) > 0) {
            String errCode = tempRowParam.getRowErrors(0).getErrorMessage().getErrorcode();
            for (int z = tempRowParam.getRowErrorsCount() - 1; z >= 0; --z) {
                String tempErrCode = tempRowParam.getRowErrors(z).getErrorMessage().getErrorcode();
                if (errCode == null || !errCode.equals(tempErrCode) || z <= 0 || tempErrCode.equals("0")) continue;
                tempRowParam.removeRowErrors(tempRowParam.getRowErrors(z));
            }
            temp.getBussinessParams().addRowParams(tempRowParam);
        }
        this.outputData.setBussinessParams(temp.getBussinessParams());
    }

    protected static Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        int i;
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        ArrayList errorData = TEQueryFlowSuperBean.joinOperation(neid, subfunc, operationList, filterErrorCodeList);
        Operation operation = null;
        if (null == operationList || operationList.isEmpty()) {
            return null;
        }
        RowParams rowparams = null;
        Input input = null;
        Output output = null;
        boolean succ = false;
        boolean fault = false;
        boolean row_succ = false;
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        int len = operationList.size();
        block0: for (i = 0; i < len; ++i) {
            operation = (Operation)operationList.get(i);
            TEDataConverter.handleSpecialStr((Operation)operation);
            input = operation.getInput();
            if (operation.getOutputCount() == 0) {
                succ = true;
            }
            int size = operation.getOutputCount();
            for (int row = 0; row < size; ++row) {
                output = operation.getOutput(row);
                rowparams = new RowParams();
                row_succ = TEDataConverter.handleRowError((Output)output, filterErrorCodeList);
                if (row_succ) {
                    succ = true;
                    boolean flag = false;
                    int errorSize = output.getFaultCount();
                    for (int a = 0; a < errorSize; ++a) {
                        if (filterErrorCodeList.contains(Integer.valueOf(output.getFault(a).getCode()))) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue block0;
                    TEDataConverter.handleRowData((int)neid, (SubFunc)subfunc, (RowParams)rowparams, (Input)input, (Output)output);
                    flag = false;
                }
                outputData.getBussinessParams().addRowParams(rowparams);
                row_succ = false;
            }
        }
        if (null != errorData && !errorData.isEmpty()) {
            fault = true;
            rowparams = new RowParams();
            int size = errorData.size();
            for (i = 0; i < size; ++i) {
                rowparams.addRowErrors((RowErrors)errorData.get(i));
            }
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (succ && !fault) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (!succ && fault) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
        return outputData;
    }

    private static ArrayList joinOperation(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        Operation operation = null;
        Output curOutput = null;
        int len = 0;
        int faultCode = 0;
        if (null == operationList || operationList.isEmpty()) {
            return errorDataList;
        }
        len = operationList.size();
        for (int i = 0; i < len; ++i) {
            operation = (Operation)operationList.get(i);
            int ouputlen = operation.getOutputCount();
            for (int outputIndex = 0; outputIndex < ouputlen; ++outputIndex) {
                curOutput = operation.getOutput(outputIndex);
                faultCode = Integer.parseInt(curOutput.getFault(0).getCode());
                if (0 == faultCode || filterErrorCodeList.contains(faultCode)) continue;
                errorDataList.add(TEDataConverter.handleErrorData((int)neid, (SubFunc)subfunc, (Input)operation.getInput(), (Output)curOutput));
            }
        }
        return errorDataList;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterErrorCodeList = new ArrayList<Integer>(1);
        filterErrorCodeList.add(38662);
        filterErrorCodeList.add(39676);
        return filterErrorCodeList;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        final int flowNeid = neid;
        final Datainterface flowInputData = inputData;
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEQueryFlowSuperBean.this.addProtectionToString(flowNeid, flowInputData);
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String addProtectionToString(int neid, Datainterface inputData) {
        if (this.outputData == null || this.outputData.getBussinessParams() == null) {
            return "";
        }
        int rowCount = this.outputData.getBussinessParams().getRowParamsCount();
        StringBuffer strBuf = new StringBuffer();
        Param[] params1 = inputData.getBussinessParams().getRowParams(0).getParam();
        int neId = Integer.parseInt(Datainterface.getParam((Param[])params1, (String)"neId").getValue());
        StringBuffer filePath = new StringBuffer(30);
        filePath.append("ip").append(File.separator).append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append(File.separator).append("qos").append(File.separator).append("qosloginres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)neId, (StringBuffer)filePath);
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        String slotid = rParams[0].getParam("slotid").getValue();
        int slot = Integer.parseInt(slotid);
        strBuf.append(this.res.getString("board")).append(':').append(TEBoardUtil.getShelfBoardName((int)neid, (int)slot)).append(";");
        for (int i = 0; i < rowCount; ++i) {
            Param labelParam;
            Param[] params = this.outputData.getBussinessParams().getRowParams(i).getParam();
            String flowType = "-";
            if (Datainterface.getParam((Param[])params, (String)"flowtype") != null) {
                flowType = Datainterface.getParam((Param[])params, (String)"flowtype").getValue();
            }
            String vbid = "-";
            if (Datainterface.getParam((Param[])params, (String)"vbid") != null) {
                vbid = Datainterface.getParam((Param[])params, (String)"vbid").getValue();
            }
            String priority = "-";
            if (Datainterface.getParam((Param[])params, (String)"priority") != null) {
                priority = Datainterface.getParam((Param[])params, (String)"priority").getValue();
            }
            String lable = (labelParam = Datainterface.getParam((Param[])params, (String)"label")) == null ? "-" : labelParam.getValue();
            String portname = "";
            if (!"6".equals(flowType) && !"7".equals(flowType)) {
                int port = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"portid").getValue());
                portname = port > 32768 ? "VCTRUNK" + (port - 32768) : "port" + port;
            }
            String vlanID = "";
            if (Datainterface.getParam((Param[])params, (String)"vlanid") != null) {
                vlanID = Datainterface.getParam((Param[])params, (String)"vlanid").getValue();
            }
            if ("".equals(vlanID)) {
                if ("1".equals(flowType)) {
                    strBuf.append(this.res.getString("qostype_Qostype")).append(":").append(this.res.getString("port_flow")).append(",").append(this.res.getString("VB ID")).append(":").append(vbid).append(",").append(this.res.getString("Port_name")).append(":").append(portname).append(",").append(this.res.getString("flow_Pri")).append(":").append(priority).append(";");
                }
                if (!"2".equals(flowType)) continue;
                strBuf.append(this.res.getString("qostype_Qostype")).append(":").append(this.res.getString("port_vlan_flow")).append(",").append(this.res.getString("VB ID")).append(":").append(vbid).append(",").append(this.res.getString("Port_name")).append(":").append(portname).append(",").append(this.res.getString("flow_Pri")).append(":").append(priority).append(";");
                continue;
            }
            if ("1".equals(flowType)) {
                strBuf.append(this.res.getString("qostype_Qostype")).append(":").append(this.res.getString("port_flow")).append(",").append(this.res.getString("VB ID")).append(":").append(vbid).append(",").append(this.res.getString("Port_name")).append(":").append(portname).append(",").append(this.res.getString("VLAN ID")).append(":").append(vlanID).append(",").append(this.res.getString("flow_Pri")).append(":").append(priority).append(";");
            }
            if ("2".equals(flowType)) {
                strBuf.append(this.res.getString("qostype_Qostype")).append(":").append(this.res.getString("port_vlan_flow")).append(",").append(this.res.getString("VB ID")).append(":").append(vbid).append(",").append(this.res.getString("Port_name")).append(":").append(portname).append(",").append(this.res.getString("VLAN ID")).append(":").append(vlanID).append(",").append(this.res.getString("flow_Pri")).append(":").append(priority).append(";");
            }
            if (!"7".equals(flowType)) continue;
            strBuf.append(this.res.getString("qostype_Qostype")).append(':').append(this.res.getString("exp_label_flow")).append(",Label ID:").append(lable).append(',').append(this.res.getString("flow_Pri")).append(':').append(priority).append(';');
        }
        return strBuf.toString();
    }

    protected abstract List getTBEOperationList();

    protected abstract void setVlanParam(RowParams var1, Output[] var2, int var3);
}

