/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.qos;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TENewFlowBean
extends TENEExplorerBean {
    public TEResourceUtil res = null;

    public ArrayList getOperationNameList(int boardType, int flowType) {
        ArrayList<String> operationNameList = new ArrayList<String>();
        if (boardType == 927 || boardType == 1067) {
            switch (flowType) {
                case 1: {
                    operationNameList.add("NSCMD_ETHN_ADD_PORTFLOW");
                    break;
                }
                case 2: {
                    operationNameList.add("NSCMD_ETHN_ADD_PORTVLANFLOW");
                    break;
                }
                default: {
                    operationNameList = null;
                    break;
                }
            }
        } else {
            operationNameList = null;
        }
        return operationNameList;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
            RowParams rowParam = rowParams[0];
            int slotid = new Integer(rowParam.getParam("slotid").getValue());
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            int flowType = new Integer(rowParam.getParam("flowtype").getValue());
            this.operationList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid, (ArrayList)this.getOperationNameList(boardType, flowType));
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENewFlowBean.performBussinessProcess() fail!", (Throwable)e);
        }
        return this.outputData;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TENewFlowBean.this.addProtectionToString();
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String addProtectionToString() {
        StringBuffer strBuf = new StringBuffer();
        Param[] params = this.inputData.getBussinessParams().getRowParams(0).getParam();
        int neId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"neId").getValue());
        StringBuffer filePath = new StringBuffer();
        filePath.append("ip").append(File.separator).append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append(File.separator).append("qos").append(File.separator).append("qosloginres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)neId, (StringBuffer)filePath);
        RowParams[] rParams = this.inputData.getBussinessParams().getRowParams();
        String slotid = rParams[0].getParam("slotid").getValue();
        int slot = Integer.parseInt(slotid);
        strBuf.append(this.res.getString("board")).append(":").append(TEBoardUtil.getShelfBoardName((int)this.neid, (int)slot)).append(",");
        String flowType = Datainterface.getParam((Param[])params, (String)"flowType").getValue();
        int port = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"portid").getValue());
        String portname = port > 32768 ? "VCTRUNK" + (port - 32768) : "port" + port;
        Param vlanIDParam = Datainterface.getParam((Param[])params, (String)"vlanID");
        if (flowType.equals("1")) {
            strBuf.append(this.res.getString("qostype_Qostype")).append(":").append(this.res.getString("port_flow")).append(",").append(this.res.getString("Port_name")).append(":").append(portname);
        }
        if (flowType.equals("2")) {
            strBuf.append(this.res.getString("qostype_Qostype")).append(":").append(this.res.getString("port_vlan_flow")).append(",").append(this.res.getString("Port_name")).append(":").append(portname).append(",").append(this.res.getString("VLAN ID")).append(":").append(vlanIDParam.getValue());
        }
        return strBuf.toString();
    }
}

