/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.qos;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TENewCarBean
extends TENEExplorerBean {
    private TEResourceUtil res = null;
    private static final int TIME_OUT = 10;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            ArrayList<String> firestnameList = new ArrayList<String>();
            firestnameList.add("NSCMD_ETHN_CREATE_CAR");
            ArrayList firstOperList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid, firestnameList);
            int firstResult = this.sendMessage(neid, firstOperList);
            if (firstResult == 0) {
                Output firstOutput = ((Operation)firstOperList.get(0)).getOutput(0);
                if (firstOutput.getFault(0).getCode().equals("0")) {
                    ArrayList<String> secondNameList = new ArrayList<String>();
                    secondNameList.add("NSCMD_ETHN_SET_CAR_ENABLE");
                    secondNameList.add("NSCMD_ETHN_SET_CAR_PARA");
                    ArrayList secondOperList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid, secondNameList);
                    int secondResult = this.sendMessage(neid, secondOperList);
                    if (secondResult == 0) {
                        firstOperList.addAll(secondOperList);
                    } else {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)secondResult));
                    }
                }
                this.handleMessage(neid, firstOperList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)firstResult));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENewCarBean.performBussinessProcess() fail!", (Throwable)e);
        }
        return this.outputData;
    }

    public boolean structureSecondlyData(ArrayList parentOperationList, ArrayList childOperationList) {
        if (parentOperationList.size() == 0) {
            return false;
        }
        ArrayList<Operation> tempList = new ArrayList<Operation>();
        Operation parentOperation = (Operation)parentOperationList.get(0);
        Input input = parentOperation.getInput();
        String carid = input.getPart("carid").getValue();
        int length = childOperationList.size();
        for (int k = 0; k < length; ++k) {
            Operation childOperation = (Operation)((Operation)childOperationList.get(k)).clone();
            childOperation.getInput().setPartValue("carid", carid);
            tempList.add(childOperation);
        }
        childOperationList.clear();
        childOperationList.addAll(tempList);
        return true;
    }

    public int sendMessage(int neid, ArrayList operList) {
        int retCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, (List)operList, 10);
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    private String addProtectionToString(Datainterface inputData) {
        StringBuilder strBuf = new StringBuilder();
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        int neId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"neId").getValue());
        StringBuffer filePath = new StringBuffer();
        filePath.append("ip").append(File.separator).append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append(File.separator).append("qos").append(File.separator).append("qosloginres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)neId, (StringBuffer)filePath);
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        int slot = Integer.parseInt(rParams[0].getParam("slotid").getValue());
        strBuf.append(this.res.getString("board")).append(":").append(TEBoardUtil.getShelfBoardName((int)this.neid, (int)slot)).append(",");
        String cir = Datainterface.getParam((Param[])params, (String)"cir").getValue();
        String dcbs = Datainterface.getParam((Param[])params, (String)"dcbs").getValue();
        String carid = Datainterface.getParam((Param[])params, (String)"carid").getValue();
        String status = Datainterface.getParam((Param[])params, (String)"status").getValue();
        if (status.equals("0")) {
            strBuf.append(this.res.getString("carID")).append(":").append(carid).append(",").append(this.res.getString("car_Status")).append(":").append(this.res.getString("disable")).append(",").append(this.res.getString("car_Cir")).append(":").append(cir).append(",").append(this.res.getString("car_dcbs")).append(":").append(dcbs);
        } else if (status.equals("1")) {
            strBuf.append(this.res.getString("carID")).append(":").append(carid).append(",").append(this.res.getString("car_Status")).append(":").append(this.res.getString("enable")).append(",").append(this.res.getString("car_Cir")).append(":").append(cir).append(",").append(this.res.getString("car_dcbs")).append(":").append(dcbs);
        }
        return strBuf.toString();
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (retCode == 1090646019) {
                return;
            }
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(subfunc.getCode());
            loginfo.setLocation(ipAddress);
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                int userID = 0;
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
                loginfo.setUserID(userID);
            }
            loginfo.setOperateName(subfunc.getSubFuncDes(neid));
            loginfo.setOperateObject("");
            loginfo.setOperateDesc(this.addProtectionToString(inputData));
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            if (null != neObj) {
                loginfo.setOperateObject(neObj.getNEName());
            } else {
                loginfo.setOperateObject(String.valueOf(neid));
            }
            if (retCode == 0) {
                loginfo.setResult(0);
                loginfo.setErrCode(0);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)retCode));
                loginfoList.add(loginfo);
            } else if (retCode == 2 || retCode == 1) {
                loginfo.setResult(retCode);
                if (null == outputData.getBussinessParams() || outputData.getBussinessParams().getRowParamsCount() == 0) {
                    loginfo.setErrCode(retCode);
                }
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    if (rowErrors.length <= 0) continue;
                    loginfo.setErrCode(Integer.parseInt(rowErrors[0].getErrorMessage().getErrorcode()));
                    loginfo.setErrInfo(rowErrors[0].getErrorMessage().getErrorinfo());
                    loginfoList.add(loginfo);
                    break;
                }
            } else {
                loginfo.setResult(2);
                loginfo.setErrCode(retCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)retCode));
                loginfoList.add(loginfo);
            }
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }
}

