/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.portmirror;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;

public class TEQueryPortMirrorBean
extends TENEExplorerBean {
    private static final int VCTRUNK = 32768;
    private static final String INVAILEDNUM = "65535";
    private static final String CFGGETISNULL = "38662";
    int slotID = -1;
    private String operObj = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
            Param[] paramArr = rowParams[0].getParam();
            int len = paramArr.length;
            for (int i = 1; i < len; ++i) {
                String name = paramArr[i].getName();
                String value = paramArr[i].getValue();
                if (!name.equalsIgnoreCase("slotID")) continue;
                this.slotID = Integer.parseInt(value);
            }
            this.outputData = new Datainterface();
            this.operationList = this.convertToOperation(subFunc, inputData);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid);
            if (result == 0) {
                ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
                this.handleMessage(neid, this.operationList, subFunc, filterErrorCodeList);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private ArrayList convertToOperation(SubFunc subFunc, Datainterface inputData) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Param boardTypeParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"boardType");
        Param slotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
        int boardType = Integer.parseInt(boardTypeParam.getValue());
        ArrayList supportETHPort = null;
        supportETHPort = boardType == 1067 || boardType == 1557 || boardType == 2109 || boardType == 2110 || boardType == 2292 || boardType == 2272 || boardType == 3005 || boardType == 2217 || TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_CFG_PORT_MIRROR", "PORTMIRROR_SUPPORT_ETHMAC_AND_ETHVCPORT") ? TEConfigurationDataMgr.getInstance().getETHPort(this.neid, boardType) : TEConfigurationDataMgr.getInstance().getETHMACPort(this.neid, boardType);
        Operation oper = null;
        Input input = null;
        Part part = null;
        int len = supportETHPort.size();
        for (int i = 0; i < len; ++i) {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_GET_PORTMIRROR");
            input = oper.getInput();
            part = input.getPart("slotid");
            part.setValue(slotidParam.getValue());
            part = input.getPart("mirrorport");
            part.setValue("" + supportETHPort.get(i));
            operationList.add(oper);
        }
        return operationList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (null == this.outputData) {
            return;
        }
        RowParams rowParams = null;
        String upportid = null;
        String downportid = null;
        String mirrorport = null;
        for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
            rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if (0 == rowParams.getParamCount()) continue;
            upportid = rowParams.getParam("upportid").getValue();
            downportid = rowParams.getParam("downportid").getValue();
            if (upportid.equals(INVAILEDNUM) && downportid.equals(INVAILEDNUM)) {
                this.outputData.getBussinessParams().removeRowParams(i);
                continue;
            }
            mirrorport = rowParams.getParam("mirrorport").getValue();
            mirrorport = Integer.parseInt(mirrorport) > 32768 ? "VCTRUNK" + (Integer.parseInt(mirrorport) - 32768) : "PORT" + mirrorport;
            rowParams.getParam("mirrorport").setValue(mirrorport);
            upportid = upportid.equals(INVAILEDNUM) ? "" : (Integer.parseInt(upportid) > 32768 ? "VCTRUNK" + (Integer.parseInt(upportid) - 32768) : "PORT" + upportid);
            rowParams.getParam("upportid").setValue(upportid);
            downportid = downportid.equals(INVAILEDNUM) ? "" : (Integer.parseInt(downportid) > 32768 ? "VCTRUNK" + (Integer.parseInt(downportid) - 32768) : "PORT" + downportid);
            rowParams.getParam("downportid").setValue(downportid);
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> codeList = new ArrayList<Integer>();
        codeList.add(Integer.valueOf(CFGGETISNULL));
        codeList.add(41874);
        codeList.add(39170);
        return codeList;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEQueryPortMirrorBean.this.operationDescribtion();
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String operationDescribtion() {
        StringBuffer operDesc = new StringBuffer();
        TEConfigurationDataMgr ngwdmDataMgr = TEConfigurationDataMgr.getInstance();
        int boardType = ngwdmDataMgr.getBoard(this.neid, this.slotID).getBoardType();
        String boardName = ngwdmDataMgr.getBoardTypeName(this.neid, boardType);
        StringBuffer ngwdmFilePath = new StringBuffer(34);
        ngwdmFilePath.append("ip").append(File.separator).append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append(File.separator).append("portmirror").append(File.separator).append("ethernetInfo_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)ngwdmFilePath);
        operDesc.append(this.operObj).append('-').append(this.slotID).append('-').append(boardName).append(':').append(res.getString("mirrorport")).append(',').append(res.getString("upmirrorport")).append(',').append(res.getString("downmirrorport"));
        return operDesc.toString();
    }
}

