/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.portmirror;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TEGetSupportETHPort
extends TENEExplorerBean {
    private static final int NSCMD_ETHN_GET_VLANSWITCHLINK = 31443;
    private static final int NSCMD_ETHN_GET_VLANSWITCHLINK_EX = 34293;
    private static final int NSCMD_ETHN_GET_QINQLINK = 31458;
    private static final int NSCMD_ETHN_GET_QINQLINK_EX = 34298;
    private static final int NSCMD_ETHN_GET_LINKAGG = 34226;
    private static final int NSCMD_ETHN_GET_LINKAGG_EX = 34211;
    private static final int NSCMD_ETHN_GET_PORTMIRROR = 34194;
    private static final int NSCMD_ETHN_GET_LINK = 34289;
    private Set usedPortSet = new HashSet();
    private Set servicePortSet = new HashSet();

    public void convertToOutPutData(int neid, int slotid, ArrayList supportETHPort, String boardName) {
        this.outputData = new Datainterface();
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        if (null == supportETHPort) {
            return;
        }
        BussinessParams bussinessParams = new BussinessParams();
        RowParams rowparams = null;
        int portID = 0;
        boolean flag = true;
        int len = supportETHPort.size();
        for (int i = 0; i < len; ++i) {
            rowparams = new RowParams();
            portID = Integer.valueOf(supportETHPort.get(i).toString());
            rowparams.addParam("portid", String.valueOf(portID));
            if (flag) {
                rowparams.addParam("boardname", boardName);
            }
            flag = false;
            rowparams.addParam(new Param("subrackid", String.valueOf(TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)slotid))));
            rowparams.addParam(new Param("subrackname", TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid)));
            rowparams.addParam(new Param("showslotid", String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)neid, (int)slotid))));
            rowparams.addParam(new Param("mmirrorport", String.valueOf(!this.usedPortSet.contains(portID) && !this.servicePortSet.contains(portID))));
            rowparams.addParam(new Param("smirrorport", String.valueOf(!this.usedPortSet.contains(portID))));
            bussinessParams.addRowParams(rowparams);
        }
        this.outputData.setBussinessParams(bussinessParams);
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        Param boardTypeParam = Datainterface.getParam((Param[])this.inputData.getBussinessParams().getRowParams(0).getParam(), (String)"boardType");
        int boardType = Integer.parseInt(boardTypeParam.getValue());
        boardTypeParam = Datainterface.getParam((Param[])this.inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
        int slotid = Integer.parseInt(boardTypeParam.getValue());
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        ArrayList supportETHPort = cfgDataMgr.getETHMACPort(neid, boardType);
        supportETHPort.addAll(cfgDataMgr.getETHVCTrunkPort(neid, slotid, boardType));
        String boardName = cfgDataMgr.getBoard(neid, slotid).getBoardName();
        Operation operation = null;
        Output output = null;
        this.usedPortSet.clear();
        this.servicePortSet.clear();
        int m = operationList.size();
        block6: for (int i = 0; i < m; ++i) {
            operation = (Operation)operationList.get(i);
            switch (operation.getCmdid()) {
                case 34211: 
                case 34226: {
                    int n = operation.getOutputCount();
                    for (int j = 0; j < n; ++j) {
                        output = operation.getOutput(j);
                        if (!output.getFault(0).getCode().equals("0")) continue;
                        this.servicePortSet.add(Integer.valueOf(output.getPartValue("mainPort")));
                        int branchPortNum = Integer.parseInt(output.getPartValue("branchPortNum"));
                        if (branchPortNum <= 0) continue;
                        byte[] bValue = output.getPartValue("branchPort").getBytes();
                        int nCount = 6;
                        int nPos = 0;
                        int nParaSize = bValue.length;
                        while (nPos + nCount <= nParaSize) {
                            byte[] bTmp = new byte[4];
                            System.arraycopy(bValue, nPos + 2, bTmp, 0, 4);
                            this.servicePortSet.add(IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0));
                            nPos += nCount;
                        }
                    }
                    continue block6;
                }
                case 34194: {
                    int k;
                    int t = operation.getOutputCount();
                    for (k = 0; k < t; ++k) {
                        output = operation.getOutput(k);
                        if (!output.getFault(0).getCode().equals("0")) continue;
                        this.usedPortSet.add(Integer.valueOf(output.getPartValue("mirrorport")));
                        this.usedPortSet.add(Integer.valueOf(output.getPartValue("upportid")));
                        this.usedPortSet.add(Integer.valueOf(output.getPartValue("downportid")));
                    }
                    continue block6;
                }
                case 31443: 
                case 31458: 
                case 34293: 
                case 34298: {
                    int k;
                    int t = operation.getOutputCount();
                    for (k = 0; k < t; ++k) {
                        output = operation.getOutput(k);
                        if (!output.getFault(0).getCode().equals("0")) continue;
                        this.servicePortSet.add(Integer.valueOf(output.getPartValue("srcPort")));
                        this.servicePortSet.add(Integer.valueOf(output.getPartValue("snkPort")));
                    }
                    continue block6;
                }
                case 34289: {
                    int k;
                    int t = operation.getOutputCount();
                    for (k = 0; k < t; ++k) {
                        output = operation.getOutput(k);
                        if (!output.getFault(0).getCode().equals("0")) continue;
                        this.servicePortSet.add(Integer.valueOf(output.getPartValue("egressport")));
                    }
                    continue block6;
                }
            }
        }
        Collections.sort(supportETHPort);
        this.convertToOutPutData(neid, slotid, supportETHPort, boardName);
    }
}

