/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.portmirror;

import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEDeletePortMirror
extends TENEExplorerBean {
    private static final int PROTEMIRROR_NOT_EXIST_ERRORCODE = 38751;
    private static final int VCTRUNK = 32768;
    private List logInfoList = new ArrayList();
    private TEResourceUtil res = null;
    private TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterErrorCodeList = new ArrayList<Integer>();
        filterErrorCodeList.add(new Integer(38751));
        return filterErrorCodeList;
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData1) {
        try {
            if (outputData1.getErrorMessage().getErrorcode().equals(String.valueOf(1090646019))) {
                return;
            }
            TENE neObj = this.cfgDataMgr.getNE(neid);
            String operateObject = "";
            operateObject = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            String operateName = subfunc.getSubFuncDes(neid);
            int errorCode1 = Integer.parseInt(outputData1.getErrorMessage().getErrorcode());
            switch (errorCode1) {
                case 1090646019: {
                    break;
                }
                case 0: {
                    this.logSuccess(user, ipAddress, operateObject, operateName, errorCode1);
                    break;
                }
                case 1: {
                    this.logSuccess(user, ipAddress, operateObject, operateName, errorCode1);
                    this.logFail(user, ipAddress, operateObject, operateName);
                    break;
                }
                case 2: {
                    this.logFail(user, ipAddress, operateObject, operateName);
                    break;
                }
                default: {
                    this.logOther(user, ipAddress, operateObject, operateName, errorCode1);
                }
            }
            int size = this.logInfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)this.logInfoList.get(i)));
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void logSuccess(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        int userID = 0;
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            try {
                userID = Integer.parseInt(user);
            }
            catch (Exception e) {
                userID = 0;
            }
        }
        RowParams rowParams1 = null;
        int rowCount = this.inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < rowCount; ++i) {
            String desc = "";
            TELogInfo loginfo1 = new TELogInfo();
            loginfo1.setCmdID(this.subfunc.getCode());
            loginfo1.setLocation(ipAddress);
            loginfo1.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo1.setUserID(userID);
            loginfo1.setOperateObject(operateObject);
            loginfo1.setOperateName(operateName);
            rowParams1 = this.inputData.getBussinessParams().getRowParams(i);
            int slotid = Integer.parseInt(rowParams1.getParam("slotid").getValue());
            int bdType = this.cfgDataMgr.getBoardType(this.neid, slotid);
            String boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
            int mirrorport = Integer.parseInt(rowParams1.getParam("mirrorport").getValue());
            if (this.res == null) {
                StringBuffer filePath = new StringBuffer();
                filePath.append("ip").append(File.separator).append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("portmirror").append(File.separator).append("ethernetInfo_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
                this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
            }
            desc = operateObject + "-" + slotid + "-" + boardName + ":";
            desc = mirrorport > 32768 ? desc + this.res.getString("mirrorport") + ":VCTRUNK" + (mirrorport - 32768) : desc + this.res.getString("mirrorport") + ":PORT" + mirrorport;
            loginfo1.setOperateDesc(desc);
            loginfo1.setResult(0);
            loginfo1.setErrCode(0);
            loginfo1.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            this.logInfoList.add(loginfo1);
        }
    }

    private void logFail(String user, String ipAddress, String operateObject, String operateName) {
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowErrors[] rowErrors1 = this.outputData.getBussinessParams().getRowParams(i).getRowErrors();
            int size = rowErrors1.length;
            for (int j = 0; j < size; ++j) {
                int slotid = Integer.parseInt(rowErrors1[j].getParam("slotid").getValue());
                int bdType = this.cfgDataMgr.getBoardType(this.neid, slotid);
                String boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
                int mirrorport = Integer.parseInt(rowErrors1[j].getParam("mirrorport").getValue());
                String desc = operateObject + "-" + slotid + "-" + boardName + ":" + "PORT" + mirrorport;
                for (int k = this.logInfoList.size() - 1; k >= 0; --k) {
                    TELogInfo loginfo = (TELogInfo)this.logInfoList.get(k);
                    if (!loginfo.getOperateDesc().equalsIgnoreCase(desc)) continue;
                    this.logInfoList.remove(k);
                }
                TELogInfo loginfo1 = new TELogInfo();
                loginfo1.setCmdID(this.subfunc.getCode());
                loginfo1.setLocation(ipAddress);
                loginfo1.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo1.setOperateObject(operateObject);
                loginfo1.setOperateName(operateName);
                loginfo1.setOperateDesc(desc);
                loginfo1.setResult(2);
                loginfo1.setErrCode(Integer.parseInt(rowErrors1[j].getErrorMessage().getErrorcode()));
                loginfo1.setErrInfo(rowErrors1[i].getErrorMessage().getErrorinfo());
                this.logInfoList.add(loginfo1);
            }
        }
    }

    private void logOther(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        TELogInfo loginfo1 = new TELogInfo();
        loginfo1.setCmdID(this.subfunc.getCode());
        loginfo1.setLocation(ipAddress);
        loginfo1.setUserName(TESysManagerBean.getInstance().getSysUser());
        loginfo1.setOperateObject(operateObject);
        loginfo1.setOperateName(operateName);
        loginfo1.setOperateDesc(operateName);
        loginfo1.setResult(2);
        loginfo1.setErrCode(errorCode);
        loginfo1.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
        this.logInfoList.add(loginfo1);
    }
}

