/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.portmirror;

import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;

public class TECreatePortMirrorBean
extends TENEExplorerBean {
    int slotID = -1;
    int mirrorPort = -1;
    int upPort = -1;
    int downPort = -1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        Param[] paramArr = rowParams[0].getParam();
        int len = paramArr.length;
        for (int i = 1; i < len; ++i) {
            String name = paramArr[i].getName();
            String value = paramArr[i].getValue();
            if (name.equalsIgnoreCase("slotID")) {
                this.slotID = Integer.parseInt(value);
            }
            if (name.equalsIgnoreCase("mirrorport")) {
                this.mirrorPort = Integer.parseInt(value);
            }
            if (name.equalsIgnoreCase("upportid")) {
                this.upPort = Integer.parseInt(value);
            }
            if (!name.equalsIgnoreCase("downportid")) continue;
            this.downPort = Integer.parseInt(value);
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        final int portMirrorneid = neid;
        final int portMirrorslotID = this.slotID;
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TECreatePortMirrorBean.this.operationDescribtion(portMirrorneid, portMirrorslotID);
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String operationDescribtion(int neid, int slotID) {
        StringBuffer operDesc = new StringBuffer();
        String mirrorPortName = "";
        mirrorPortName = 32768 > this.mirrorPort ? "PORT" + this.mirrorPort : "VCTRUNK" + (this.mirrorPort - 32768);
        String upPortName = "";
        upPortName = this.upPort == -1 ? "/" : (32768 > this.upPort ? "PORT" + this.upPort : "VCTRUNK" + (this.upPort - 32768));
        String downPortName = "";
        downPortName = this.downPort == -1 ? "-" : (32768 > this.downPort ? "PORT" + this.downPort : "VCTRUNK" + (this.downPort - 32768));
        StringBuffer filePath = new StringBuffer(34);
        filePath.append("ip").append(File.separator).append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append(File.separator).append("portmirror").append(File.separator).append("ethernetInfo_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)neid, (StringBuffer)filePath);
        operDesc.append(TEBoardUtil.getShelfBoardName((int)neid, (int)slotID)).append(':').append(res.getString("mirrorport")).append(':').append(mirrorPortName).append(',').append(res.getString("upmirrorport")).append(':').append(upPortName).append(',').append(res.getString("downmirrorport")).append(':').append(downPortName);
        return operDesc.toString();
    }
}

