/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.mstp;

import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TESetPGBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String MSTP_RES = "res" + File.separator + "config" + File.separator + "ethprotocolconfig" + File.separator + "MSTP_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;
    private static final String INVALID_SLOTID = "255";

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        int i;
        TELogInfo setpgLog = null;
        int eCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
        int userID = 0;
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            try {
                userID = Integer.parseInt(user);
            }
            catch (Exception e) {
                userID = 0;
            }
        }
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        String strOperObj = "";
        strOperObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
        RowParams errorRowParams = null;
        RowParams rowparams = null;
        int tmpErrorCode = 0;
        int len = inputData.getBussinessParams().getRowParamsCount();
        for (i = 1; i < len; ++i) {
            setpgLog = new TELogInfo();
            rowparams = inputData.getBussinessParams().getRowParams(i);
            setpgLog.setOperateDesc(this.getDetailStr(rowparams));
            if (eCode != 0 && eCode != 2 && eCode != 1) {
                setpgLog.setResult(2);
                setpgLog.setErrCode(eCode);
                setpgLog.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)eCode));
            } else if (eCode == 0) {
                setpgLog.setResult(0);
                setpgLog.setErrCode(eCode);
                setpgLog.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)eCode));
            } else {
                int outputRowCount = outputData.getBussinessParams().getRowParamsCount();
                errorRowParams = outputData.getBussinessParams().getRowParams(outputRowCount - 1);
                tmpErrorCode = this.getOperResult(rowparams, errorRowParams);
                if (tmpErrorCode != 0) {
                    setpgLog.setResult(2);
                } else {
                    setpgLog.setResult(0);
                }
                setpgLog.setErrCode(tmpErrorCode);
                setpgLog.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)tmpErrorCode));
            }
            loginfoList.add(setpgLog);
        }
        int size = loginfoList.size();
        for (i = 0; i < size; ++i) {
            setpgLog = (TELogInfo)loginfoList.get(i);
            setpgLog.setCmdID(subfunc.getCode());
            setpgLog.setLocation(ipAddress);
            setpgLog.setUserID(userID);
            setpgLog.setUserName(TESysManagerBean.getInstance().getSysUser());
            setpgLog.setOperateName(subfunc.getSubFuncDes(neid));
            setpgLog.setOperateObject(strOperObj);
            TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
        }
    }

    public String getDetailStr(RowParams rowparams) {
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        this.resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)MSTP_RES);
        StringBuffer sb = new StringBuffer();
        Param param = null;
        int len = rowparams.getParamCount();
        for (int i = 1; i < len; ++i) {
            param = rowparams.getParam(i);
            String value = param.getValue();
            String name = param.getName();
            String tempStr = "";
            if ("portGroupID".equals(name)) {
                sb.append(this.resourceUtil.getString(name)).append(":").append(value).append(" ");
                continue;
            }
            if ("protocolType".equals(name)) {
                tempStr = "protocolType" + value;
                sb.append(this.resourceUtil.getString(name)).append(":").append(this.resourceUtil.getString(tempStr)).append(" ");
                continue;
            }
            if ("protocolEnable".equals(name)) {
                tempStr = "protocolEnable" + value;
                sb.append(this.resourceUtil.getString(name)).append(":").append(this.resourceUtil.getString(tempStr)).append(" ");
                continue;
            }
            if ("slotid".equals(name)) {
                String slotid = rowparams.getParam("slotid").getValue();
                int boardType = configurDataMgr.getBoard(this.neid, Integer.parseInt(slotid)).getBoardType();
                String subBaordid = rowparams.getParam("subSlotid").getValue();
                int port = Integer.parseInt(rowparams.getParam("port").getValue());
                if (INVALID_SLOTID.equals(subBaordid)) {
                    String portName = configurDataMgr.getPortName(this.neid, Integer.parseInt(slotid), boardType, port);
                    sb.append(TEBoardUtil.getShelfBoardName((int)this.neid, (int)Integer.parseInt(slotid))).append("-").append(portName).append(" ");
                    continue;
                }
                int subBoardType = configurDataMgr.getSubboardType(this.neid, Integer.parseInt(slotid), Integer.parseInt(subBaordid));
                String subBoardName = configurDataMgr.getBoardTypeName(this.neid, subBoardType);
                String portName = configurDataMgr.getPortName(this.neid, Integer.parseInt(slotid), subBoardType, port);
                sb.append(TEBoardUtil.getShelfBoardName((int)this.neid, (int)Integer.parseInt(slotid))).append("-").append(subBaordid).append("-").append(subBoardName).append("-").append(portName).append(" ");
                continue;
            }
            if (!"portProtocolEnable".equals(name)) continue;
            tempStr = "portProtocolEnable" + value;
            sb.append(this.resourceUtil.getString(name)).append(":").append(this.resourceUtil.getString(tempStr)).append(" ");
        }
        return sb.toString();
    }
}

