/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.mcsp.db;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginLog;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherMCSPMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEMCSPDbMgr {
    public static final String UNKNOWN = "UNKNOWN";
    private static final Logger LOGGER = TELogFactory.getNormalLogger();

    private TEMCSPDbMgr() {
    }

    public static TEEtherMCSPMOPO getEtherMCSPMOFromDB(int neID, int slotID, int pathID, TEErrInfoReturn errRet) {
        String STR_FUNC_NAME = "TEMCSPDbMgr.getEtherMCSPMOFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TEMCSPDbMgr.getEtherMCSPMOFromDB");
        if (null == errRet) {
            return null;
        }
        TEEtherMCSPMOPO moObject = null;
        TEDaoOperationResult dbOperResult = null;
        try {
            ArrayList<TEDaoNameValuePair> pair = new ArrayList<TEDaoNameValuePair>();
            pair.add(new TEDaoNameValuePair("Board", String.valueOf(slotID)));
            pair.add(new TEDaoNameValuePair("PathID", String.valueOf(pathID)));
            dbOperResult = TECommonDaoService.findByID((int)neID, (int[])new int[]{neID}, TEEtherMCSPMOPO.class, pair);
        }
        catch (Exception ex) {
            TEMCSPDbMgr.logExceptionOnGet(neID, ex);
            TEMCSPDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEMCSPDbMgr.getEtherMCSPMOFromDB");
            return moObject;
        }
        if (null == dbOperResult) {
            TEMCSPDbMgr.logNullErrorOnGet(neID);
            TEMCSPDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEMCSPDbMgr.getEtherMCSPMOFromDB");
            return moObject;
        }
        int retCode = dbOperResult.getResult();
        if (1090613273 == retCode) {
            TEMCSPDbMgr.logNullNEError(neID);
            TEMCSPDbMgr.setOperFail(neID, errRet, 1090596385);
            TEBeanPluginLog.logFuncEnd((String)"TEMCSPDbMgr.getEtherMCSPMOFromDB");
            return moObject;
        }
        if (0 == retCode) {
            List dataObj = dbOperResult.getData();
            if (null != dataObj && !dataObj.isEmpty()) {
                moObject = (TEEtherMCSPMOPO)dataObj.get(0);
            }
        } else {
            TEMCSPDbMgr.logRetCodeErrorOnGet(neID, retCode);
            TEMCSPDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEMCSPDbMgr.getEtherMCSPMOFromDB");
        return moObject;
    }

    public static List<TEEtherMCSPMOPO> getAllEtherMCSPMOFromDB(int neID, int slotID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEMCSPDbMgr.getAllEtherMCSPMOFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TEMCSPDbMgr.getAllEtherMCSPMOFromDB");
        if (null == errRet) {
            return new ArrayList<TEEtherMCSPMOPO>(0);
        }
        ArrayList<Object> moObject = new ArrayList<TEEtherMCSPMOPO>(0);
        TEDaoOperationResult dbResult = null;
        try {
            ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
            if (-1 != slotID) {
                criteria.add(new TEDaoNameValuePair("Board", String.valueOf(slotID)));
            }
            dbResult = TECommonDaoService.findByID((int)neID, (int[])new int[]{neID}, TEEtherMCSPMOPO.class, criteria);
        }
        catch (Exception e) {
            TEMCSPDbMgr.logExceptionOnGet(neID, e);
            TEMCSPDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEMCSPDbMgr.getAllEtherMCSPMOFromDB");
            return moObject;
        }
        if (null == dbResult) {
            TEMCSPDbMgr.logNullErrorOnGet(neID);
            TEMCSPDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEMCSPDbMgr.getAllEtherMCSPMOFromDB");
            return moObject;
        }
        int retCode = dbResult.getResult();
        if (1090613273 == retCode) {
            TEMCSPDbMgr.logNullNEError(neID);
            TEMCSPDbMgr.setOperFail(neID, errRet, 1090596385);
            TEBeanPluginLog.logFuncEnd((String)"TEMCSPDbMgr.getAllEtherMCSPMOFromDB");
            return moObject;
        }
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                moObject = new ArrayList(data.size());
                for (Object obj : data) {
                    moObject.add((TEEtherMCSPMOPO)obj);
                }
            }
        } else {
            TEMCSPDbMgr.logRetCodeErrorOnGet(neID, retCode);
            TEMCSPDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEMCSPDbMgr.getAllEtherMCSPMOFromDB");
        return moObject;
    }

    public static void createOrUpdateEtherMCSPMOToDB(int neID, TEEtherMCSPMOPO mcspMO, TEErrInfoReturn errRet, boolean updateFlag) {
        String FUNC_NAME = "TEMCSPDbMgr.createOrUpdateEtherMCSPMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEMCSPDbMgr.createOrUpdateEtherMCSPMOToDB");
        if (null == mcspMO) {
            return;
        }
        if (null == errRet) {
            return;
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = updateFlag ? TECommonDaoService.update((int)neID, (int[])new int[]{neID}, (Object)mcspMO) : TECommonDaoService.create((int)neID, (int[])new int[]{neID}, (Object)mcspMO);
        }
        catch (Exception e) {
            TEMCSPDbMgr.logExceptionErrorOnUpdate(neID, e);
            TEMCSPDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEMCSPDbMgr.createOrUpdateEtherMCSPMOToDB");
            return;
        }
        if (null == dbResult) {
            TEMCSPDbMgr.logNullErrorOnUpdate(neID);
            TEMCSPDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEMCSPDbMgr.createOrUpdateEtherMCSPMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEMCSPDbMgr.logRetCodeErrorOnUpdate(neID, retCode);
            TEMCSPDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEMCSPDbMgr.createOrUpdateEtherMCSPMOToDB");
    }

    public static void delMCSPMOToDB(int neID, TEEtherMCSPMOPO moObject, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEMCSPDbMgr.delMCSPMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEMCSPDbMgr.delMCSPMOToDB");
        if (null == moObject) {
            return;
        }
        if (null == errRet) {
            return;
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.delete((int)neID, (int[])new int[]{neID}, (Object)moObject);
        }
        catch (Exception e) {
            TEMCSPDbMgr.logExceptionErrorOnDel(neID, e);
            TEMCSPDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEMCSPDbMgr.delMCSPMOToDB");
            return;
        }
        if (null == dbResult) {
            TEMCSPDbMgr.logNullErrorOnDel(neID);
            TEMCSPDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEMCSPDbMgr.delMCSPMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEMCSPDbMgr.logRetCodeErrorOnDel(neID, retCode);
            TEMCSPDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEMCSPDbMgr.delMCSPMOToDB");
    }

    private static void setOperFail(int neID, TEErrInfoReturn rspErrRet, int retCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        rspErrRet.setResult(1090605056);
        rspErrRet.addErrInfo(TEMCSPDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, retCode).getErrList());
    }

    public static TEErrInfoReturn constructErrInfoReturn(int neID, int errorCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = UNKNOWN;
        if (null != ne) {
            neName = ne.getNEName();
        }
        return TEMCSPDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, errorCode);
    }

    public static TEErrInfoReturn constructErrInfoReturn(int[] objID, String[] objName, int retCode) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setObjName(TEMCSPDbMgr.getObjName(objName));
        errInfo.setErrorCode(retCode);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    public static String getObjName(String[] objName) {
        StringBuffer objNameBuffer = new StringBuffer();
        int len = objName.length;
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                objNameBuffer.append('-');
            }
            objNameBuffer.append(objName[i]);
        }
        return objNameBuffer.toString();
    }

    private static void logNullNEError(int neID) {
        LOGGER.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get mo from db device fail! neID:%d, retCode:%d", neID, retCode);
        LOGGER.error(tipStr);
    }

    private static void logNullErrorOnGet(int neID) {
        LOGGER.error("get mo from db fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionOnGet(int neID, Exception e) {
        LOGGER.error("get mo from db fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnUpdate(int neID, int retCode) {
        String tipStr = String.format("update mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        LOGGER.error(tipStr);
    }

    private static void logNullErrorOnUpdate(int neID) {
        LOGGER.error("update mo to db device fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionErrorOnUpdate(int neID, Exception e) {
        LOGGER.error("update mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logNullErrorOnDel(int neID) {
        LOGGER.error("delete mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnDel(int neID, Exception e) {
        LOGGER.error("delete mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnDel(int neID, int retCode) {
        String tipStr = String.format("delete mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        LOGGER.error(tipStr);
    }
}

