/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.lpt_v2r8c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.lpt.TEEVPL;
import com.huawei.nglct.nemgr.ip.ngwdm.lpt.TEIPUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.HashMap;

public class TEGetEplForLpt
extends TENEExplorerBean {
    private int slotID = -1;
    private int boardType = -1;
    private static final String SLOT_ID_PARAM = "slotid";
    private static final String VLAN_NULL = "65535";
    private static final int BOARDTYPE_EFT4 = 1066;
    private static final int NSCMD_ETHN_GET_VLANSWITCHLINK = 34293;
    private static final int NSCMD_ETHN_GET_LPTLINK_WBID = 34703;
    public static final int NSCMD_CFG_ETHN_GET_P2MP_LPT_WBID = 34696;
    private static final int NSCMD_CFG_GET_P2PLPT_HOLDOFFTIME_WBID = 34707;
    private static final int NSCMD_CFG_GET_VCTRUNK_LPT_CARRYMODE_WBID = 34709;
    private static final int VCTRUNK = 32768;
    private static final String DISABLE = "0";
    private static final String ENABLE = "1";
    private static final String DIRECTION_POSITIVE = "2";
    private static final String DIRECTION_REVERSE = "3";
    private static String NOVALUE = "-";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        Param param = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)SLOT_ID_PARAM);
        this.slotID = Integer.parseInt(param.getValue());
        this.boardType = TEConfigurationDataMgr.getInstance().getBoard(neid, this.slotID).getBoardType();
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subFunc) {
        int i;
        BussinessParams bussinessParams = new BussinessParams();
        this.outputData.setBussinessParams(bussinessParams);
        Operation operation = null;
        boolean hasFault = false;
        boolean hasSucc = false;
        ArrayList errList = new ArrayList();
        ArrayList funblockList = this.getEthBoardInfo(neid, this.slotID);
        ArrayList eplList = new ArrayList();
        HashMap<String, String> lptLinkList = new HashMap<String, String>();
        HashMap<String, String> ptmpList = new HashMap<String, String>();
        HashMap<String, String> lptDelayTimeList = new HashMap<String, String>();
        HashMap<String, String> lptCarryModeList = new HashMap<String, String>();
        int len = operationList.size();
        for (int index = 0; index < len; ++index) {
            operation = (Operation)operationList.get(index);
            int retcode = 0;
            switch (operation.getCmdid()) {
                case 34293: {
                    retcode = this.handleEPL(operation, eplList, errList);
                    break;
                }
                case 34703: {
                    retcode = this.handleLPTLink(operation, lptLinkList, errList);
                    break;
                }
                case 34696: {
                    retcode = this.handleLPTLink(operation, ptmpList, errList);
                    break;
                }
                case 34707: {
                    retcode = this.handleDelayTime(operation, lptDelayTimeList, errList);
                    break;
                }
                case 34709: {
                    retcode = this.handleLptCarryMode(operation, lptCarryModeList, errList);
                    break;
                }
            }
            if (false != retcode) continue;
            hasSucc = true;
        }
        if (errList.size() > 0) {
            hasFault = true;
            int errNum = errList.size();
            for (int errIndex = 0; errIndex < errNum; ++errIndex) {
                bussinessParams.addRowParams((RowParams)errList.get(errIndex));
            }
        }
        for (i = 0; i < funblockList.size(); ++i) {
            String[] ports = ((String)funblockList.get(i)).split("-");
            String portid = ports[0];
            String portName = ports[1];
            String returnName = portName;
            if (returnName.indexOf("PORT") < 0 && returnName.indexOf("VCTRUNK") < 0) continue;
            if (lptLinkList.containsKey(portid)) {
                this.handleOutput(portid, returnName, lptLinkList, lptDelayTimeList, lptCarryModeList, ptmpList, bussinessParams);
                continue;
            }
            if (null != this.isContainsObj(eplList, portid)) {
                this.handleOutput(portid, eplList, ptmpList, bussinessParams);
                continue;
            }
            if (returnName.indexOf("VCTRUNK") >= 0) continue;
            this.handleOutput(portid, returnName, ptmpList, bussinessParams);
        }
        errList.clear();
        funblockList.clear();
        eplList.clear();
        lptLinkList.clear();
        lptDelayTimeList.clear();
        lptCarryModeList.clear();
        this.outputData.setErrorMessage(new ErrorMessage());
        if (!hasFault) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (!hasSucc) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
        int m = this.outputData.getBussinessParams().getRowParamsCount();
        for (i = 0; i < m; ++i) {
            RowParams rp = this.outputData.getBussinessParams().getRowParams(i);
            int n = rp.getParamCount();
            for (int j = 0; j < n; ++j) {
                Param p = rp.getParam(j);
                if (p.getValue() != null) continue;
                p.setValue("");
            }
        }
    }

    private void parseVlanSwitchLink(Operation operation, ArrayList eplList) {
        Output output = null;
        TEEVPL link = null;
        RowParams errRow = null;
        int linkNum = operation.getOutputCount();
        for (int j = 0; j < linkNum; ++j) {
            output = operation.getOutput(j);
            errRow = TEIPUtils.handleRowError(output);
            if (errRow != null) continue;
            link = new TEEVPL();
            int partNum = output.getPartCount();
            for (int k = 0; k < partNum; ++k) {
                link.setPropValue(output.getPart(k));
            }
            link.direction = 0;
            link.linkType = 0;
            if (link.upLinkID > 0) {
                eplList.add(link);
                continue;
            }
            TELogFactory.getNormalLogger().error("parseVlanSwitchLink() invalid link=" + (Object)((Object)link));
        }
    }

    private int handleEPL(Operation operation, ArrayList eplList, ArrayList errList) {
        Output[] outputArr = operation.getOutput();
        Operation validOutputList = new Operation();
        int retCode = 2;
        if (1066 != this.boardType) {
            for (int j = 0; j < outputArr.length; ++j) {
                Output output = outputArr[j];
                retCode = new Integer(output.getFault()[0].getCode());
                RowParams errRow = TEIPUtils.handleRowError(output);
                if (errRow != null) {
                    errList.add(errRow);
                    continue;
                }
                String tmpPort = output.getPartValue("srcPort");
                String tempPort = output.getPartValue("snkPort");
                if (null == tmpPort || null == tempPort) continue;
                int srcPort = Integer.parseInt(tmpPort);
                int snkPort = Integer.parseInt(tempPort);
                if (!VLAN_NULL.equals(output.getPartValue("srcVlan")) || !VLAN_NULL.equals(output.getPartValue("snkVlan")) || 32768 < srcPort && 32768 < snkPort || 32768 > srcPort && 32768 > snkPort) continue;
                validOutputList.addOutput(output);
            }
            this.parseVlanSwitchLink(validOutputList, eplList);
        } else {
            retCode = 0;
            ArrayList allPorts = this.getEthBoardInfo(this.neid, this.slotID);
            String portid = "";
            for (int i = 0; i < allPorts.size(); ++i) {
                TEEVPL link = new TEEVPL();
                String[] ports = ((String)allPorts.get(i)).split("-");
                portid = ports[0];
                int portID = Integer.parseInt(portid);
                link.setPropValue("srcPort", portid, "int");
                if (32768 > portID) {
                    link.setPropValue("snkPort", portID + 32768 + "", "int");
                } else {
                    link.setPropValue("snkPort", portID - 32768 + "", "int");
                }
                link.direction = 0;
                link.linkType = 0;
                if (link.upLinkID <= 0) continue;
                eplList.add(link);
            }
        }
        return retCode;
    }

    private int handleLPTLink(Operation operation, HashMap lptLinkList, ArrayList errList) {
        Output[] outputArr = operation.getOutput();
        String port = "";
        String portNumber = "";
        String portList = "";
        int retCode = 2;
        int j = 0;
        int i = 0;
        while (j < outputArr.length) {
            Output output = outputArr[j];
            retCode = new Integer(output.getFault()[0].getCode());
            RowParams errRow = null;
            errRow = TEIPUtils.handleRowError(output);
            if (errRow != null) {
                errList.add(errRow);
            } else if (38662 != retCode) {
                port = output.getPartValue("port");
                portNumber = output.getPartValue("portNumber");
                portList = output.getPartValue("portList");
                if (!DISABLE.equals(portNumber)) {
                    lptLinkList.put(port, portList);
                }
            }
            ++j;
            i += 2;
        }
        return retCode;
    }

    private int handleDelayTime(Operation operation, HashMap lptDelayTimeList, ArrayList errList) {
        Output[] outputArr = operation.getOutput();
        String port = "";
        String delayTime = "";
        int retCode = 2;
        int j = 0;
        int i = 0;
        while (j < outputArr.length) {
            Output output = outputArr[j];
            retCode = new Integer(output.getFault()[0].getCode());
            RowParams errRow = null;
            errRow = TEIPUtils.handleRowError(output);
            if (errRow != null) {
                errList.add(errRow);
            } else if (38662 != retCode) {
                port = output.getPartValue("port");
                delayTime = output.getPartValue("delayTime");
                lptDelayTimeList.put(port, delayTime);
            }
            ++j;
            i += 2;
        }
        return retCode;
    }

    private int handleLptCarryMode(Operation operation, HashMap lptCarryModeList, ArrayList errList) {
        Output[] outputArr = operation.getOutput();
        String port = "";
        String carryMode = "";
        int retCode = 2;
        int j = 0;
        int i = 0;
        while (j < outputArr.length) {
            Output output = outputArr[j];
            retCode = new Integer(output.getFault()[0].getCode());
            RowParams errRow = null;
            errRow = TEIPUtils.handleRowError(output);
            if (errRow != null) {
                errList.add(errRow);
            } else if (38662 != retCode) {
                port = output.getPartValue("port");
                carryMode = output.getPartValue("carryMode");
                lptCarryModeList.put(port, carryMode);
            }
            ++j;
            i += 2;
        }
        return retCode;
    }

    private TEEVPL isContainsObj(ArrayList list, String port) {
        TEEVPL isContain = null;
        if (null == list || list.size() == 0) {
            return isContain;
        }
        for (int i = 0; i < list.size(); ++i) {
            TEEVPL link = (TEEVPL)((Object)list.get(i));
            if (!port.equals(String.valueOf(link.srcPort))) continue;
            isContain = link;
            break;
        }
        return isContain;
    }

    private ArrayList getEthBoardInfo(int neID, int slotID) {
        ArrayList<String> ports = new ArrayList<String>();
        int portNO = -1;
        String portName = "";
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        if (null == configurDataMgr.getBoard(neID, slotID)) {
            return ports;
        }
        int boardType = configurDataMgr.getBoard(neID, slotID).getBoardType();
        ArrayList macPortList = this.getMacPortList(neID, boardType);
        int len = macPortList.size();
        for (int i = 0; i < len; ++i) {
            portNO = Integer.parseInt(macPortList.get(i).toString());
            portName = TEConfigurationDataMgr.getMACName((int)portNO);
            ports.add(portNO + "-" + portName);
        }
        ArrayList vcPortList = configurDataMgr.getETHVCTrunkPort(neID, slotID, boardType);
        int len2 = vcPortList.size();
        for (int i = 0; i < len2; ++i) {
            portNO = Integer.parseInt(vcPortList.get(i).toString());
            portName = TEConfigurationDataMgr.getVCTrunkName((int)(portNO - 32768));
            ports.add(portNO + "-" + portName);
        }
        return ports;
    }

    private ArrayList getMacPortList(int neID, int boardType) {
        ArrayList allPortList = TEConfigurationDataMgr.getInstance().getETHMACPort(neID, boardType);
        ArrayList existPortList = this.getExistPortList(neID, allPortList);
        if (existPortList.isEmpty()) {
            return allPortList;
        }
        return existPortList;
    }

    private ArrayList getExistPortList(int neID, ArrayList portList1) {
        try {
            ArrayList<Object> operationList = new ArrayList<Object>();
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PORT");
            Input input = oper.getInput();
            Part tpart = input.getPart("slotID");
            tpart.setValue(String.valueOf(this.slotID));
            tpart = input.getPart("portID");
            int size = portList1.size();
            for (int i = 0; i < size; ++i) {
                tpart.setValue(String.valueOf((Integer)portList1.get(i)));
                operationList.add(oper.clone());
            }
            ArrayList<Integer> returnList = new ArrayList<Integer>();
            if (operationList.isEmpty()) {
                return returnList;
            }
            int result = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)10).retCode;
            if (result == 0) {
                int len = operationList.size();
                for (int j = 0; j < len; ++j) {
                    Operation oOper = (Operation)operationList.get(j);
                    if (!String.valueOf(0).equals(oOper.getOutput()[0].getFault()[0].getCode())) continue;
                    String portId = oOper.getOutput()[0].getPartValue("portID");
                    returnList.add(Integer.valueOf(portId));
                }
            }
            return returnList;
        }
        catch (Exception e) {
            return new ArrayList();
        }
    }

    private void handleOutput(String portid, String returnName, HashMap<String, String> lptLinkList, HashMap<String, String> lptDelayTimeList, HashMap<String, String> lptCarryModeList, HashMap<String, String> ptmpList, BussinessParams bussinessParams) {
        RowParams rowparams = new RowParams();
        Param param = null;
        String endPortid = "";
        String endPortName = "";
        String ptmpPortid = "";
        if (returnName.indexOf("VCTRUNK") < 0) {
            param = new Param("portid", portid);
            rowparams.addParam(param);
            param = new Param("port", returnName);
            rowparams.addParam(param);
            endPortid = lptLinkList.get(portid);
            endPortName = "VCTRUNK" + (Integer.parseInt(endPortid) - 32768);
            param = new Param("vctrunkid", endPortid);
            rowparams.addParam(param);
            ptmpPortid = ptmpList.get(portid);
            param = new Param("ptmpPort", ptmpPortid);
            rowparams.addParam(param);
            param = new Param("vcTrunk", endPortName);
            rowparams.addParam(param);
            param = new Param("portDlayTime", null == lptDelayTimeList.get(portid) ? NOVALUE : lptDelayTimeList.get(portid));
            rowparams.addParam(param);
            param = new Param("vcTrunkLateDelayTime", null == lptDelayTimeList.get(endPortid) ? NOVALUE : lptDelayTimeList.get(endPortid));
            rowparams.addParam(param);
            param = new Param("lptCarryMode", lptCarryModeList.get(endPortid));
            rowparams.addParam(param);
            param = new Param("direction", DIRECTION_POSITIVE);
            rowparams.addParam(param);
        } else {
            endPortid = lptLinkList.get(portid);
            endPortName = "PORT" + endPortid;
            param = new Param("portid", endPortid);
            rowparams.addParam(param);
            param = new Param("port", endPortName);
            rowparams.addParam(param);
            param = new Param("vctrunkid", portid);
            rowparams.addParam(param);
            param = new Param("vcTrunk", returnName);
            rowparams.addParam(param);
            ptmpPortid = ptmpList.get(portid);
            param = new Param("ptmpPort", ptmpPortid);
            rowparams.addParam(param);
            param = new Param("portDlayTime", null == lptDelayTimeList.get(endPortid) ? NOVALUE : lptDelayTimeList.get(endPortid));
            rowparams.addParam(param);
            param = new Param("vcTrunkLateDelayTime", null == lptDelayTimeList.get(portid) ? NOVALUE : lptDelayTimeList.get(portid));
            rowparams.addParam(param);
            param = new Param("lptCarryMode", lptCarryModeList.get(portid));
            rowparams.addParam(param);
            param = new Param("direction", DIRECTION_REVERSE);
            rowparams.addParam(param);
        }
        param = new Param("W32BRD_ATTR_LPTENABLE", ENABLE);
        rowparams.addParam(param);
        param = new Param("originEnableStatus", ENABLE);
        rowparams.addParam(param);
        bussinessParams.addRowParams(rowparams);
    }

    private void handleOutput(String portid, ArrayList eplList, HashMap<String, String> ptmpList, BussinessParams bussinessParams) {
        TEEVPL link = this.isContainsObj(eplList, portid);
        RowParams rowparams = new RowParams();
        Param param = null;
        String endPortid = "";
        String endPortName = "";
        if (32768 > link.srcPort) {
            endPortid = "" + link.snkPort;
            endPortName = "VCTRUNK" + (link.snkPort - 32768);
            param = new Param("portid", "" + link.srcPort);
            rowparams.addParam(param);
            param = new Param("port", "PORT" + link.srcPort);
            rowparams.addParam(param);
            param = new Param("vctrunkid", endPortid);
            rowparams.addParam(param);
            param = new Param("vcTrunk", endPortName);
            rowparams.addParam(param);
            link.direction = 2;
        } else {
            endPortid = "" + link.snkPort;
            endPortName = "PORT" + link.snkPort;
            param = new Param("portid", endPortid);
            rowparams.addParam(param);
            param = new Param("port", endPortName);
            rowparams.addParam(param);
            param = new Param("vctrunkid", "" + link.srcPort);
            rowparams.addParam(param);
            param = new Param("vcTrunk", "VCTRUNK" + (link.srcPort - 32768));
            rowparams.addParam(param);
            link.direction = 3;
        }
        param = new Param("portDlayTime", NOVALUE);
        rowparams.addParam(param);
        param = new Param("vcTrunkLateDelayTime", NOVALUE);
        rowparams.addParam(param);
        param = new Param("lptCarryMode", NOVALUE);
        rowparams.addParam(param);
        param = new Param("direction", "" + link.direction);
        rowparams.addParam(param);
        param = new Param("W32BRD_ATTR_LPTENABLE", DISABLE);
        rowparams.addParam(param);
        param = new Param("originEnableStatus", DISABLE);
        rowparams.addParam(param);
        param = new Param("ptmp", ptmpList.get(portid));
        rowparams.addParam(param);
        bussinessParams.addRowParams(rowparams);
    }

    private void handleOutput(String portid, String returnName, HashMap<String, String> ptmpList, BussinessParams bussinessParams) {
        RowParams rowparams = new RowParams();
        Param param = null;
        param = new Param("portid", "" + portid);
        rowparams.addParam(param);
        param = new Param("port", returnName);
        rowparams.addParam(param);
        param = new Param("portDlayTime", NOVALUE);
        rowparams.addParam(param);
        param = new Param("vctrunkid", NOVALUE);
        rowparams.addParam(param);
        param = new Param("vcTrunk", NOVALUE);
        rowparams.addParam(param);
        param = new Param("vcTrunkLateDelayTime", NOVALUE);
        rowparams.addParam(param);
        param = new Param("lptCarryMode", DIRECTION_POSITIVE);
        rowparams.addParam(param);
        param = new Param("direction", "4");
        rowparams.addParam(param);
        param = new Param("W32BRD_ATTR_LPTENABLE", NOVALUE);
        rowparams.addParam(param);
        param = new Param("originEnableStatus", DISABLE);
        rowparams.addParam(param);
        param = new Param("ptmp", ptmpList.get(portid));
        rowparams.addParam(param);
        bussinessParams.addRowParams(rowparams);
    }
}

