/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.lpt;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import org.slf4j.Logger;

public class TESetLPTThroughBean
extends TENEExplorerBean {
    private static final int NSCMD_ETHN_DEL_LPTLINK = 30763;
    private static final int NSCMD_ETHN_SET_LPTLINK = 30762;
    private static Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.operationList = this.convertToOperation(subFunc, inputData);
            int result = this.sendMessage(neid);
            this.outputData = new Datainterface();
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
        }
        catch (Exception e) {
            log.error("TESetLPTThroughBean.performBussinessProcess() fail!", (Throwable)e);
        }
        return this.outputData;
    }

    private ArrayList convertToOperation(SubFunc subFunc, Datainterface inputData) {
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = null;
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        String lptThrough = null;
        String direction = null;
        String port = null;
        String vcTrunkStr = null;
        String vcTrunk = null;
        String slotid = null;
        int len = businessparams.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowparams = businessparams.getRowParams(i);
            slotid = rowparams.getParam("slotid").getValue();
            lptThrough = rowparams.getParam("lptThrough").getValue();
            direction = rowparams.getParam("direction").getValue();
            port = rowparams.getParam("port").getValue();
            vcTrunkStr = rowparams.getParam("vcTrunk").getValue();
            vcTrunk = String.valueOf(Integer.parseInt(vcTrunkStr) + 32768);
            if (lptThrough.equals("0")) {
                operationList.add(this.setOperaion(slotid, port, "", 30763));
                operationList.add(this.setOperaion(slotid, "", vcTrunk, 30763));
                continue;
            }
            if (direction.equals("1")) {
                operationList.add(this.setOperaion(slotid, port, vcTrunk, 30762));
                operationList.add(this.setOperaion(slotid, vcTrunk, port, 30762));
                continue;
            }
            if (direction.equals("2")) {
                operationList.add(this.setOperaion(slotid, port, vcTrunk, 30762));
                continue;
            }
            operationList.add(this.setOperaion(slotid, vcTrunk, port, 30762));
        }
        return operationList;
    }

    private Operation setOperaion(String slotid, String port, String vcTrunk, int cmdCode) {
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (int)cmdCode);
            Input input = oper.getInput();
            if (30763 == cmdCode) {
                Part part = input.getPart("slotid");
                part.setValue(slotid);
                if (!port.equals("")) {
                    part = input.getPart("port");
                    part.setValue(port);
                } else {
                    part = input.getPart("vcTrunk");
                    part.setValue(vcTrunk);
                }
            } else if (30762 == cmdCode) {
                Part part = input.getPart("slotid");
                part.setValue(slotid);
                part = input.getPart("port");
                part.setValue(port);
                part = input.getPart("portNum");
                part.setValue("1");
                part = input.getPart("responPort");
                part.setValue(vcTrunk);
            }
        }
        catch (Exception e) {
            log.error("TESetLPTThroughBean:Parse QX fail!", (Throwable)e);
        }
        return oper;
    }
}

