/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.lpt;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;

public class TEIPUtils {
    static boolean isNoRecordError(String errCode) {
        return errCode.equals("38662") || errCode.equals(38900) || errCode.equals(39694) || errCode.equals(39686);
    }

    public static RowParams handleRowError(Output output) {
        RowParams errRow = null;
        String errCode = output.getFault(0).getCode();
        if (null != errCode && !"0".equals(errCode) && !TEIPUtils.isNoRecordError(errCode)) {
            errRow = new RowParams();
            RowErrors err = new RowErrors();
            ErrorMessage errMsg = new ErrorMessage();
            errMsg.setErrorcode(errCode);
            if (!errCode.equals("") && (output.getFault(0).getValue() == null || "".equals(output.getFault(0).getValue()))) {
                errMsg.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errCode)));
            } else {
                errMsg.setErrorinfo(output.getFault(0).getValue());
            }
            err.setErrorMessage(errMsg);
            Param errParam = new Param();
            errParam.setName("linkID");
            String errLinkID = "-1";
            Part part = null;
            int partNum = output.getPartCount();
            for (int partIndex = 0; partIndex < partNum; ++partIndex) {
                part = output.getPart(partIndex);
                if (!"linkID".equalsIgnoreCase(part.getName())) continue;
                if (null == part.getValue()) break;
                errLinkID = part.getValue();
                break;
            }
            errParam.setValue(errLinkID);
            errRow.addRowErrors(err);
        }
        return errRow;
    }

    public static String getMainPTLogInfo(StringBuffer strBuf, TEResourceUtil res, int neid, String slotid, String port, String mainCarryMode, String mainDelayTime) {
        String boardName = null;
        String portName = null;
        try {
            int wSlotid = Integer.parseInt(slotid);
            int wPort = Integer.parseInt(port);
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, wSlotid);
            boardName = TEBoardUtil.getShelfBoardName((int)neid, (int)wSlotid);
            portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, wSlotid, boardType, wPort);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("Slotid or PortID is not integer.\n");
            boardName = slotid;
            portName = port;
        }
        strBuf.append(res.getString("poolSlotId") + ":");
        strBuf.append(boardName).append(",");
        strBuf.append(res.getString("poolPortId") + ":");
        strBuf.append(portName);
        if (mainCarryMode != null) {
            strBuf.append(",");
            strBuf.append(res.getString("mainCarryMode") + ":").append(res.getString("mainCarryMode" + mainCarryMode));
        }
        if (mainDelayTime != null) {
            strBuf.append(",");
            strBuf.append(res.getString("mainDelayTime") + ":").append(mainDelayTime);
        }
        return strBuf.toString();
    }
}

